/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

class StdFormatter
extends SimpleFormatter {
    static final Level STDOUT = new StdOutErrLevel("STDOUT", Level.WARNING.intValue() + 53);
    static final Level STDERR = new StdOutErrLevel("STDERR", Level.SEVERE.intValue() + 53);
    private String lineSeparator = System.getProperty("line.separator");

    StdFormatter() {
    }

    public synchronized String format(LogRecord record) {
        if (!STDERR.getName().equals(record.getLoggerName()) && !STDOUT.getName().equals(record.getLoggerName())) {
            return super.format(record);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.lineSeparator);
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        return sb.toString();
    }

    private static class StdOutErrLevel
    extends Level {
        public StdOutErrLevel(String name, int value) {
            super(name, value);
        }
    }
}

