/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindIcon;
import freemind.modes.mindmapmode.MindMapNodeModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

class MindMapHTMLWriter {
    private Writer fileout;
    private static String el = System.getProperty("line.separator");
    private boolean writeFoldingCode;
    private boolean basedOnHeadings;
    private boolean exportIcons;

    MindMapHTMLWriter(Writer fileout) {
        this.fileout = fileout;
        this.exportIcons = false;
        this.writeFoldingCode = false;
        this.basedOnHeadings = this.getProperty("html_export_folding").equals("html_export_based_on_headings");
    }

    private static String convertSpecialChar(char c) {
        String cvt;
        switch (c) {
            case '\u00e4': {
                cvt = "&auml;";
                break;
            }
            case '\u00f6': {
                cvt = "&ouml;";
                break;
            }
            case '\u00fc': {
                cvt = "&uuml;";
                break;
            }
            case '\u00c4': {
                cvt = "&Auml;";
                break;
            }
            case '\u00d6': {
                cvt = "&Ouml;";
                break;
            }
            case '\u00dc': {
                cvt = "&Uuml;";
                break;
            }
            case '\u00df': {
                cvt = "&szlig;";
                break;
            }
            default: {
                cvt = "&#" + Integer.toString(c) + ";";
            }
        }
        return cvt;
    }

    private static String saveHTML_escapeUnicodeAndSpecialCharacters(String text) {
        int len = text.length();
        StringBuffer result = new StringBuffer(len);
        boolean previousSpace = false;
        boolean spaceOccured = false;
        for (int i = 0; i < len; ++i) {
            char myChar = text.charAt(i);
            char intValue = text.charAt(i);
            if (intValue >= '\u0080') {
                result.append(MindMapHTMLWriter.convertSpecialChar(myChar));
                continue;
            }
            spaceOccured = false;
            switch (myChar) {
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case ' ': {
                    spaceOccured = true;
                    if (previousSpace) {
                        result.append("&nbsp;");
                        break;
                    }
                    result.append(" ");
                    break;
                }
                case '\n': {
                    result.append("\n<br>\n");
                    break;
                }
                default: {
                    result.append(myChar);
                }
            }
            previousSpace = spaceOccured;
        }
        return result.toString();
    }

    void saveHTML(List mindMapNodes) throws IOException {
        this.fileout.write("<html>" + el + "<head>" + el);
        this.writeStyle();
        this.fileout.write(el + "</head>" + el + "<body>" + el);
        Iterator iterator = mindMapNodes.iterator();
        while (iterator.hasNext()) {
            MindMapNodeModel node = (MindMapNodeModel)iterator.next();
            this.saveHTML(node, "1", 0, true, true, 1);
        }
        this.fileout.write("</body>" + el);
        this.fileout.write("</html>" + el);
        this.fileout.close();
    }

    void saveHTML(MindMapNodeModel rootNodeOfBranch) throws IOException {
        String htmlExportFoldingOption = this.getProperty("html_export_folding");
        this.writeFoldingCode = htmlExportFoldingOption.equals("html_export_fold_currently_folded") && rootNodeOfBranch.hasFoldedStrictDescendant() || htmlExportFoldingOption.equals("html_export_fold_all");
        this.exportIcons = Resources.getInstance().getBoolProperty("export_icons_in_html");
        this.fileout.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">" + el + "<html>" + el + "<head>" + el);
        this.fileout.write("<title>" + MindMapHTMLWriter.saveHTML_escapeUnicodeAndSpecialCharacters(rootNodeOfBranch.getPlainTextContent().replace('\n', ' ')) + "</title>" + el);
        this.writeStyle();
        this.fileout.write(el + "</head>" + el + "<body>" + el);
        if (this.writeFoldingCode) {
            this.writeBodyWithFolding(rootNodeOfBranch);
        } else {
            this.saveHTML(rootNodeOfBranch, "1", 0, true, true, 1);
        }
        this.fileout.write("</body>" + el);
        this.fileout.write("</html>" + el);
        this.fileout.close();
    }

    private void writeBodyWithFolding(MindMapNodeModel rootNodeOfBranch) throws IOException {
        this.writeJavaScript();
        this.fileout.write("<SPAN class=\"foldspecial\" onclick=\"fold_document()\">All +</SPAN>" + el);
        this.fileout.write("<SPAN class=\"foldspecial\" onclick=\"unfold_document()\">All -</SPAN>" + el);
        this.saveHTML(rootNodeOfBranch, "1", 0, true, true, 1);
        this.fileout.write("<SCRIPT type=\"text/javascript\">" + el);
        this.fileout.write("fold_document();" + el);
        this.fileout.write("</SCRIPT>" + el);
    }

    private void writeJavaScript() throws IOException {
        this.fileout.write("" + el + "<script type=\"text/javascript\">" + el + "   // Here we implement folding. It works fine with MSIE5.5, MSIE6.0 and" + el + "   // Mozilla 0.9.6." + el + "" + el + "   if (document.layers) {" + el + "      //Netscape 4 specific code" + el + "      pre = 'document.';" + el + "      post = ''; }" + el + "   if (document.getElementById) {" + el + "      //Netscape 6 specific code" + el + "      pre = 'document.getElementById(\"';" + el + "      post = '\").style'; }" + el + "   if (document.all) {" + el + "      //IE4+ specific code" + el + "      pre = 'document.all.';" + el + "      post = '.style'; }" + el + "" + el + "function layer_exists(layer) {" + el + "   try {" + el + "      eval(pre + layer + post);" + el + "      return true; }" + el + "   catch (error) {" + el + "      return false; }}" + el + "" + el + "function show_layer(layer) {" + el + "   eval(pre + layer + post).position = 'relative'; " + el + "   eval(pre + layer + post).visibility = 'visible'; }" + el + "" + el + "function hide_layer(layer) {" + el + "   eval(pre + layer + post).visibility = 'hidden';" + el + "   eval(pre + layer + post).position = 'absolute'; }" + el + "" + el + "function hide_folder(folder) {" + el + "    hide_folding_layer(folder)" + el + "    show_layer('show'+folder);" + el + "" + el + "    scrollBy(0,0); // This is a work around to make it work in Browsers (Explorer, Mozilla)" + el + "}" + el + "" + el + "function show_folder(folder) {" + el + "    // Precondition: all subfolders are folded" + el + "" + el + "    show_layer('hide'+folder);" + el + "    hide_layer('show'+folder);" + el + "    show_layer('fold'+folder);" + el + "" + el + "    scrollBy(0,0); // This is a work around to make it work in Browsers (Explorer, Mozilla)" + el + "" + el + "    var i;" + el + "    for (i=1; layer_exists('fold'+folder+'_'+i); ++i) {" + el + "       show_layer('show'+folder+'_'+i); }" + el + "}" + el + "" + "function show_folder_completely(folder) {" + el + "    // Precondition: all subfolders are folded" + el + "" + el + "    show_layer('hide'+folder);" + el + "    hide_layer('show'+folder);" + el + "    show_layer('fold'+folder);" + el + "" + el + "    scrollBy(0,0); // This is a work around to make it work in Browsers (Explorer, Mozilla)" + el + "" + el + "    var i;" + el + "    for (i=1; layer_exists('fold'+folder+'_'+i); ++i) {" + el + "       show_folder_completely(folder+'_'+i); }" + el + "}" + el + "" + el + "" + el + "" + el + "function hide_folding_layer(folder) {" + el + "   var i;" + el + "   for (i=1; layer_exists('fold'+folder+'_'+i); ++i) {" + el + "       hide_folding_layer(folder+'_'+i); }" + el + "" + el + "   hide_layer('hide'+folder);" + el + "   hide_layer('show'+folder);" + el + "   hide_layer('fold'+folder);" + el + "" + el + "   scrollBy(0,0); // This is a work around to make it work in Browsers (Explorer, Mozilla)" + el + "}" + el + "" + el + "function fold_document() {" + el + "   var i;" + el + "   var folder = '1';" + el + "   for (i=1; layer_exists('fold'+folder+'_'+i); ++i) {" + el + "       hide_folder(folder+'_'+i); }" + el + "}" + el + "" + el + "function unfold_document() {" + el + "   var i;" + el + "   var folder = '1';" + el + "   for (i=1; layer_exists('fold'+folder+'_'+i); ++i) {" + el + "       show_folder_completely(folder+'_'+i); }" + el + "}" + el + "" + el + "</script>" + el);
    }

    private void writeStyle() throws IOException {
        this.fileout.write("<style type=\"text/css\">" + el);
        this.fileout.write("    li { list-style: none;  margin: 0; }" + el);
        this.fileout.write("    p { margin: 0; }" + el);
        if (this.writeFoldingCode) {
            this.fileout.write("    span.foldopened { color: white; font-size: xx-small;" + el + "    border-width: 1; font-family: monospace; padding: 0em 0.25em 0em 0.25em; background: #e0e0e0;" + el + "    VISIBILITY: visible;" + el + "    cursor:pointer; }" + el + "" + el + "" + el + "    span.foldclosed { color: #666666; font-size: xx-small;" + el + "    border-width: 1; font-family: monospace; padding: 0em 0.25em 0em 0.25em; background: #e0e0e0;" + el + "    VISIBILITY: hidden;" + el + "    cursor:pointer; }" + el + "" + el + "    span.foldspecial { color: #666666; font-size: xx-small; border-style: none solid solid none;" + el + "    border-color: #CCCCCC; border-width: 1; font-family: sans-serif; padding: 0em 0.1em 0em 0.1em; background: #e0e0e0;" + el + "    cursor:pointer; }" + el);
        }
        this.fileout.write(el + "    span.l { color: red; font-weight: bold; }" + el + "" + el + "    a.mapnode:link {text-decoration: none; color: black; }" + el + "    a.mapnode:visited {text-decoration: none; color: black; }" + el + "    a.mapnode:active {text-decoration: none; color: black; }" + el + "    a.mapnode:hover {text-decoration: none; color: black; background: #eeeee0; }" + el + "" + el + "</style>" + el + "<!-- ^ Position is not set to relative / absolute here because of Mozilla -->");
    }

    private int saveHTML(MindMapNodeModel model, String parentID, int lastChildNumber, boolean isRoot, boolean treatAsParagraph, int depth) throws IOException {
        String fontStyle;
        String link;
        boolean createFolding = model.isFolded();
        if (this.getProperty("html_export_folding").equals("html_export_fold_all")) {
            createFolding = model.hasChildren();
        }
        if (this.getProperty("html_export_folding").equals("html_export_no_folding") || this.basedOnHeadings || isRoot) {
            createFolding = false;
        }
        boolean heading = this.isHeading(model, depth);
        if (!treatAsParagraph && !this.basedOnHeadings) {
            this.fileout.write("<li>");
        } else if (heading) {
            this.fileout.write("<h" + depth + ">");
        } else if (!this.hasHtml(model)) {
            this.fileout.write("<p>");
        }
        String localParentID = parentID;
        if (createFolding) {
            localParentID = parentID + "_" + ++lastChildNumber;
            this.writeFoldingButtons(localParentID);
        }
        if ((link = model.getLink()) != null) {
            if (link.endsWith(".mm")) {
                link = link + ".html";
            }
            this.fileout.write("<a href=\"" + link + "\" target=\"_blank\"><span class=l>~</span>&nbsp;");
        }
        if (!(fontStyle = this.fontStyle(model)).equals("")) {
            this.fileout.write("<span style=\"" + fontStyle + "\">");
        }
        if (Resources.getInstance().getBoolProperty("export_icons_in_html")) {
            this.writeIcons(model);
        }
        this.writeModelContent(model);
        if (fontStyle != "") {
            this.fileout.write("</span>");
        }
        this.fileout.write(el);
        if (link != null) {
            this.fileout.write("</a>" + el);
        }
        if (heading) {
            this.fileout.write("</h" + depth + ">" + el);
        }
        boolean treatChildrenAsParagraph = false;
        ListIterator e = model.childrenUnfolded();
        while (e.hasNext()) {
            if (((MindMapNodeModel)e.next()).toString().length() <= 100) continue;
            treatChildrenAsParagraph = true;
            break;
        }
        if (this.getProperty("html_export_folding").equals("html_export_based_on_headings")) {
            e = model.childrenUnfolded();
            while (e.hasNext()) {
                MindMapNodeModel child = (MindMapNodeModel)e.next();
                lastChildNumber = this.saveHTML(child, parentID, lastChildNumber, false, treatChildrenAsParagraph, depth + 1);
            }
            return lastChildNumber;
        }
        if (model.hasChildren()) {
            if (this.getProperty("html_export_folding").equals("html_export_based_on_headings")) {
                e = model.childrenUnfolded();
                while (e.hasNext()) {
                    MindMapNodeModel child = (MindMapNodeModel)e.next();
                    lastChildNumber = this.saveHTML(child, parentID, lastChildNumber, false, treatChildrenAsParagraph, depth + 1);
                }
            } else if (createFolding) {
                this.fileout.write("<ul id=\"fold" + localParentID + "\" style=\"POSITION: relative; VISIBILITY: visible;\">");
                if (treatChildrenAsParagraph) {
                    this.fileout.write("<li>");
                }
                int localLastChildNumber = 0;
                ListIterator e2 = model.childrenUnfolded();
                while (e2.hasNext()) {
                    MindMapNodeModel child = (MindMapNodeModel)e2.next();
                    localLastChildNumber = this.saveHTML(child, localParentID, localLastChildNumber, false, treatChildrenAsParagraph, depth + 1);
                }
            } else {
                this.fileout.write("<ul>");
                if (treatChildrenAsParagraph) {
                    this.fileout.write("<li>");
                }
                e = model.childrenUnfolded();
                while (e.hasNext()) {
                    MindMapNodeModel child = (MindMapNodeModel)e.next();
                    lastChildNumber = this.saveHTML(child, parentID, lastChildNumber, false, treatChildrenAsParagraph, depth + 1);
                }
            }
            if (treatChildrenAsParagraph) {
                this.fileout.write("</li>");
            }
            this.fileout.write(el);
            this.fileout.write("</ul>");
        }
        if (!treatAsParagraph) {
            this.fileout.write(el + "</li>" + el);
        }
        return lastChildNumber;
    }

    private String fontStyle(MindMapNodeModel model) throws IOException {
        String fontStyle = "";
        if (model.getColor() != null) {
            fontStyle = fontStyle + "color: " + Tools.colorToXml(model.getColor()) + ";";
        }
        if (model.getFont() != null && model.getFont().getSize() != 0) {
            int defaultFontSize = Integer.parseInt(this.getProperty("defaultfontsize"));
            int procentSize = model.getFont().getSize() * 100 / defaultFontSize;
            if (procentSize != 100) {
                fontStyle = fontStyle + "font-size: " + procentSize + "%;";
            }
        }
        if (model.getFont() != null) {
            String fontFamily = model.getFont().getFamily();
            fontStyle = fontStyle + "font-family: " + fontFamily + ", sans-serif; ";
        }
        if (model.isItalic()) {
            fontStyle = fontStyle + "font-style: italic; ";
        }
        if (model.isBold()) {
            fontStyle = fontStyle + "font-weight: bold; ";
        }
        return fontStyle;
    }

    private void writeModelContent(MindMapNodeModel model) throws IOException {
        if (model.toString().matches(" *")) {
            this.fileout.write("&nbsp;");
        } else {
            String output = model.toString();
            if (HtmlTools.isHtmlNode(output)) {
                output = HtmlTools.extractHtmlBody(output);
                this.fileout.write(HtmlTools.unicodeToHTMLUnicodeEntity(output));
            } else {
                this.fileout.write(MindMapHTMLWriter.saveHTML_escapeUnicodeAndSpecialCharacters(model.toString()));
            }
        }
    }

    private void writeIcons(MindMapNodeModel model) throws IOException {
        for (int i = 0; i < model.getIcons().size(); ++i) {
            this.fileout.write("<img src=\"" + ((MindIcon)model.getIcons().get(i)).getIconFileName() + "\" alt=\"" + ((MindIcon)model.getIcons().get(i)).getDescription() + "\">");
        }
    }

    private void writeFoldingButtons(String localParentID) throws IOException {
        this.fileout.write("<span id=\"show" + localParentID + "\" class=\"foldclosed\" onClick=\"show_folder('" + localParentID + "')\" style=\"POSITION: absolute\">+</span> " + "<span id=\"hide" + localParentID + "\" class=\"foldopened\" onClick=\"hide_folder('" + localParentID + "')\">-</span>");
        this.fileout.write("\n");
    }

    private boolean isHeading(MindMapNodeModel model, int depth) {
        return this.basedOnHeadings && model.hasChildren() && depth <= 6 && !this.hasHtml(model);
    }

    boolean hasHtml(MindMapNodeModel model) {
        return model.getText().startsWith("<html>");
    }

    private String getProperty(String key) {
        return Resources.getInstance().getProperty(key);
    }
}

