/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.Controller;
import freemind.controller.actions.generated.instance.EdgeColorFormatAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.EdgeAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapEdgeModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import javax.swing.AbstractAction;

public class EdgeColorAction
extends AbstractAction
implements ActorXml {
    private final MindMapController controller;

    public EdgeColorAction(MindMapController controller) {
        super(controller.getText("edge_color"));
        this.controller = controller;
        controller.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    public void actionPerformed(ActionEvent e) {
        Color color = Controller.showCommonJColorChooserDialog(this.controller.getView().getSelected(), this.controller.getText("choose_edge_color"), this.controller.getSelected().getEdge().getColor());
        if (color == null) {
            return;
        }
        ListIterator it = this.controller.getSelecteds().listIterator();
        while (it.hasNext()) {
            MindMapNodeModel selected = (MindMapNodeModel)it.next();
            this.setEdgeColor(selected, color);
        }
    }

    public void setEdgeColor(MindMapNode node, Color color) {
        EdgeColorFormatAction doAction = this.createEdgeColorFormatAction(node, color);
        EdgeColorFormatAction undoAction = this.createEdgeColorFormatAction(node, ((EdgeAdapter)node.getEdge()).getRealColor());
        this.controller.getActionFactory().startTransaction(this.getClass().getName());
        this.controller.getActionFactory().executeAction(new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
        this.controller.getActionFactory().endTransaction(this.getClass().getName());
    }

    public void act(XmlAction action) {
        NodeAdapter node;
        Color oldColor;
        EdgeColorFormatAction edgeAction;
        Color color;
        if (action instanceof EdgeColorFormatAction && !Tools.safeEquals(color = Tools.xmlToColor((edgeAction = (EdgeColorFormatAction)action).getColor()), oldColor = ((EdgeAdapter)(node = this.controller.getNodeFromID(edgeAction.getNode())).getEdge()).getRealColor())) {
            ((MindMapEdgeModel)node.getEdge()).setColor(color);
            this.controller.nodeChanged(node);
        }
    }

    public EdgeColorFormatAction createEdgeColorFormatAction(MindMapNode node, Color color) {
        EdgeColorFormatAction edgeAction = new EdgeColorFormatAction();
        edgeAction.setNode(node.getObjectId(this.controller));
        if (color != null) {
            edgeAction.setColor(Tools.colorToXml(color));
        }
        return edgeAction;
    }

    public Class getDoActionClass() {
        return EdgeColorFormatAction.class;
    }
}

