/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.UndoXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Resources;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.xml.AbstractXmlAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class UndoAction
extends AbstractXmlAction
implements ActorXml {
    private MindMapController controller;
    private boolean isUndoAction;
    protected Vector actionPairList = new Vector();
    private long timeOfLastAdd = 0L;
    private boolean actionFrameStarted = false;
    private static final long TIME_TO_BEGIN_NEW_ACTION = 100L;
    protected static Logger logger;

    public UndoAction(MindMapController controller) {
        this(controller, controller.getText("undo"), new ImageIcon(controller.getResource("images/undo.png")), controller);
        this.controller = controller;
        if (logger == null) {
            logger = controller.getFrame().getLogger(this.getClass().toString());
        }
    }

    protected UndoAction(MindMapController adapter, String text, Icon icon, MindMapController mode) {
        super(text, icon, mode);
        this.controller = adapter;
        this.addActor(this);
        this.setEnabled(false);
        this.isUndoAction = false;
    }

    public boolean isUndoAction() {
        return this.isUndoAction;
    }

    protected void xmlActionPerformed(ActionEvent arg0) {
        if (this.actionPairList.size() > 0) {
            ActionPair pair = (ActionPair)this.actionPairList.get(0);
            this.informUndoPartner(pair);
            this.actionPairList.remove(0);
            this.undoDoAction(pair);
            if (this.actionPairList.size() == 0) {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    protected void informUndoPartner(ActionPair pair) {
        this.controller.redo.add(pair.reverse());
        this.controller.redo.setEnabled(true);
    }

    protected void undoDoAction(ActionPair pair) {
        String doActionString = this.controller.marshall(pair.getDoAction());
        String redoActionString = this.controller.marshall(pair.getUndoAction());
        UndoXmlAction undoAction = new UndoXmlAction();
        undoAction.setDescription(redoActionString);
        undoAction.setRemedia(doActionString);
        UndoXmlAction redoAction = new UndoXmlAction();
        redoAction.setDescription(doActionString);
        undoAction.setRemedia(redoActionString);
        this.isUndoAction = true;
        this.controller.getActionFactory().executeAction(new ActionPair((XmlAction)undoAction, (XmlAction)redoAction));
        this.isUndoAction = false;
    }

    public void act(XmlAction action) {
        UndoXmlAction undoAction = (UndoXmlAction)action;
        XmlAction doAction = this.controller.unMarshall(undoAction.getDescription());
        XmlAction redoAction = this.controller.unMarshall(undoAction.getRemedia());
        this.controller.getActionFactory().executeAction(new ActionPair(doAction, redoAction));
    }

    public Class getDoActionClass() {
        return UndoXmlAction.class;
    }

    public void setEnabled(boolean arg0) {
        if (arg0) {
            super.setEnabled(this.actionPairList.size() != 0);
        } else {
            super.setEnabled(false);
        }
    }

    public void add(ActionPair pair) {
        long currentTime = System.currentTimeMillis();
        if (this.actionPairList.size() > 0 && (this.actionFrameStarted || currentTime - this.timeOfLastAdd < 100L)) {
            CompoundAction remedia;
            CompoundAction action;
            ActionPair firstPair = (ActionPair)this.actionPairList.get(0);
            if (!(firstPair.getDoAction() instanceof CompoundAction) || !(firstPair.getUndoAction() instanceof CompoundAction)) {
                action = new CompoundAction();
                action.addChoice((Object)firstPair.getDoAction());
                remedia = new CompoundAction();
                remedia.addChoice((Object)firstPair.getUndoAction());
                this.actionPairList.remove(0);
                this.actionPairList.add(0, new ActionPair((XmlAction)action, (XmlAction)remedia));
                firstPair = (ActionPair)this.actionPairList.get(0);
            } else {
                action = (CompoundAction)firstPair.getDoAction();
                remedia = (CompoundAction)firstPair.getUndoAction();
            }
            action.addChoice((Object)pair.getDoAction());
            remedia.addAtChoice(0, (Object)pair.getUndoAction());
        } else {
            this.actionPairList.add(0, pair);
            int maxEntries = 100;
            try {
                maxEntries = new Integer(this.controller.getFrame().getProperty("undo_levels"));
            }
            catch (NumberFormatException e) {
                Resources.getInstance().logException(e);
            }
            while (this.actionPairList.size() > maxEntries) {
                this.actionPairList.remove(this.actionPairList.size() - 1);
            }
        }
        this.startActionFrame();
        this.timeOfLastAdd = currentTime;
    }

    private void startActionFrame() {
        if (!this.actionFrameStarted && EventQueue.isDispatchThread()) {
            this.actionFrameStarted = true;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    UndoAction.this.actionFrameStarted = false;
                }
            });
        }
    }

    public void clear() {
        this.actionPairList.clear();
    }

    public void print() {
        logger.info("Undo list:");
        int j = 0;
        Iterator i = this.actionPairList.iterator();
        while (i.hasNext()) {
            ActionPair pair = (ActionPair)i.next();
            logger.info("line " + j++ + " = " + this.controller.marshall(pair.getDoAction()));
        }
    }
}

