/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeComponent;
import com.lightdev.app.shtm.Util;
import javax.swing.JComboBox;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;

class AttributeComboBox
extends JComboBox
implements AttributeComponent {
    private Object attributeKey;
    private Object htmlAttributeKey;
    private String[] names;
    private int setValCount = 0;
    private int originalIndex = -2;

    public AttributeComboBox(String[] items, String[] names, Object key, Object htmlKey) {
        super(items);
        this.names = names;
        this.attributeKey = key;
        this.htmlAttributeKey = htmlKey;
    }

    public boolean setValue(AttributeSet a) {
        Object valObj;
        boolean success = false;
        if (this.attributeKey != null) {
            Object valObj2 = a.getAttribute(this.attributeKey);
            if (valObj2 == null && this.htmlAttributeKey != null) {
                valObj2 = a.getAttribute(this.htmlAttributeKey);
                if (valObj2 != null) {
                    this.setValue(valObj2);
                    success = true;
                }
            } else if (valObj2 == null && this.attributeKey.equals(CSS.Attribute.LIST_STYLE_TYPE)) {
                Object name = a.getAttribute(StyleConstants.NameAttribute);
                if (name != null && name.toString().equalsIgnoreCase(HTML.Tag.UL.toString())) {
                    this.setValue("disc");
                } else if (name != null && name.toString().equalsIgnoreCase(HTML.Tag.OL.toString())) {
                    this.setValue("decimal");
                }
            }
            if (valObj2 == null && this.htmlAttributeKey != null) {
                if (this.htmlAttributeKey.equals(HTML.Attribute.ALIGN) || this.htmlAttributeKey.equals(HTML.Attribute.VALIGN)) {
                    this.setValue(this.names[0]);
                }
            } else {
                this.setValue(valObj2);
                success = true;
            }
        } else if (this.htmlAttributeKey != null && (valObj = a.getAttribute(this.htmlAttributeKey)) != null) {
            this.setValue(valObj);
            success = true;
        }
        return success;
    }

    public void reset() {
        this.setValCount = 0;
        this.originalIndex = -2;
    }

    private void setValue(Object valObj) {
        if (valObj != null) {
            String valStr = valObj.toString();
            int i = 0;
            while (!valStr.equalsIgnoreCase(this.names[i])) {
                ++i;
            }
            this.setSelectedIndex(i);
            if (++this.setValCount < 2) {
                this.originalIndex = i;
            }
        }
    }

    public AttributeSet getValue() {
        SimpleAttributeSet a = new SimpleAttributeSet();
        int value = this.getSelectedIndex();
        if (this.originalIndex != value) {
            if (this.attributeKey != null) {
                Util.styleSheet().addCSSAttribute(a, (CSS.Attribute)this.attributeKey, this.names[value]);
            }
            if (this.htmlAttributeKey != null) {
                a.addAttribute(this.htmlAttributeKey, this.names[value]);
            }
        }
        return a;
    }

    public AttributeSet getValue(boolean includeUnchanged) {
        if (includeUnchanged) {
            SimpleAttributeSet a = new SimpleAttributeSet();
            int value = this.getSelectedIndex();
            if (this.attributeKey != null) {
                Util.styleSheet().addCSSAttribute(a, (CSS.Attribute)this.attributeKey, this.names[value]);
            }
            if (this.htmlAttributeKey != null) {
                a.addAttribute(this.htmlAttributeKey, this.names[value]);
            }
            return a;
        }
        return this.getValue();
    }
}

