/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.SHTMLAction;
import com.lightdev.app.shtm.SHTMLMenuBar;
import com.lightdev.app.shtm.TextResources;
import com.lightdev.app.shtm.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class DynamicResource {
    private static final String labelSuffix = "Label";
    private static final String actionSuffix = "Action";
    public static final String imageSuffix = "Image";
    public static final String toolTipSuffix = "Tip";
    public static final String selectedIconSuffix = "SelectedIcon";
    public static final String menuSeparatorKey = "-";
    private Hashtable menuItems = new Hashtable();
    private Hashtable commands = new Hashtable();
    private Hashtable menus = new Hashtable();
    public static final String IMAGE_EMPTY = "empty.gif";

    public void addAction(String cmd, Action action) {
        this.commands.put(cmd, action);
    }

    public SHTMLMenuBar createMenubar(TextResources resources, String name) {
        SHTMLMenuBar mb = new SHTMLMenuBar();
        String[] menuKeys = Util.tokenize(Util.getResourceString(resources, name), " ");
        for (int i = 0; i < menuKeys.length; ++i) {
            JMenu m = this.createMenu(resources, menuKeys[i]);
            if (m == null) continue;
            mb.add(m);
        }
        return mb;
    }

    public JMenu createMenu(TextResources resources, String key) {
        JMenu menu = null;
        String def = Util.getResourceString(resources, key);
        if (def == null) {
            def = "";
        }
        String[] itemKeys = Util.tokenize(def, " ");
        menu = new JMenu(Util.getResourceString(resources, key + labelSuffix));
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals(menuSeparatorKey)) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = this.createMenuItem(resources, itemKeys[i]);
            menu.add(mi);
        }
        menu.addMenuListener(new DynamicMenuListener());
        this.menus.put(key, menu);
        return menu;
    }

    public JPopupMenu createPopupMenu(TextResources resources, String key) {
        JPopupMenu menu = null;
        String def = Util.getResourceString(resources, key);
        if (def == null) {
            def = "";
        }
        String[] itemKeys = Util.tokenize(def, " ");
        menu = new JPopupMenu();
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals(menuSeparatorKey)) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = this.createMenuItem(resources, itemKeys[i]);
            menu.add(mi);
        }
        return menu;
    }

    public JMenu getMenu(String cmd) {
        return (JMenu)this.menus.get(cmd);
    }

    public JMenuItem createMenuItem(TextResources resources, String cmd) {
        JMenuItem mi = new JMenuItem(Util.getResourceString(resources, cmd + labelSuffix));
        String astr = Util.getResourceString(resources, cmd + actionSuffix);
        if (astr == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        Action a = this.getAction(astr);
        if (a != null) {
            Object aKey = a.getValue("AcceleratorKey");
            if (aKey != null) {
                mi.setAccelerator((KeyStroke)aKey);
            }
            mi.addActionListener(a);
            a.addPropertyChangeListener(this.createActionChangeListener(mi));
            Icon icon = (Icon)a.getValue("SmallIcon");
            if (icon != null) {
                mi.setHorizontalTextPosition(4);
                mi.setIcon(icon);
            }
            mi.setEnabled(a.isEnabled());
        } else {
            mi.setEnabled(false);
        }
        this.menuItems.put(cmd, mi);
        return mi;
    }

    public static String getResourceString(TextResources resources, String key) {
        try {
            if (resources != null) {
                return resources.getString(key);
            }
            System.err.println("SimplyHTML : Warning : resources are null.");
            new Throwable("Dummy").printStackTrace();
            return key;
        }
        catch (MissingResourceException mre) {
            System.err.println("SimplyHTML : Warning : resource is missing: " + key);
            return key;
        }
    }

    public Action getAction(String cmd) {
        return (Action)this.commands.get(cmd);
    }

    public Enumeration getActions() {
        return this.commands.elements();
    }

    private PropertyChangeListener createActionChangeListener(AbstractButton b) {
        return new ActionChangedListener(b);
    }

    public JMenuItem getMenuItem(String cmd) {
        return (JMenuItem)this.menuItems.get(cmd);
    }

    public static Icon getIconForCommand(TextResources resources, String cmd) {
        return DynamicResource.getIconForName(resources, cmd + imageSuffix);
    }

    public static Icon getIconForName(TextResources resources, String name) {
        ImageIcon icon = null;
        URL url = DynamicResource.getResource(resources, name);
        if (url != null) {
            icon = new ImageIcon(url);
        }
        return icon;
    }

    public static URL getResource(TextResources resources, String key) {
        String name = Util.getResourceString(resources, key);
        if (name != null) {
            URL url = DynamicResource.class.getResource(name);
            return url;
        }
        return null;
    }

    public JToolBar createToolBar(TextResources resources, String nm) {
        Dimension buttonSize = new Dimension(24, 24);
        Dimension separatorSize = new Dimension(3, 20);
        String[] itemKeys = Util.tokenize(Util.getResourceString(resources, nm), " ");
        JToolBar toolBar = new JToolBar();
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals(menuSeparatorKey)) {
                JSeparator separator = new JSeparator(1);
                toolBar.add(separator);
                continue;
            }
            Action action = this.getAction(itemKeys[i]);
            JButton newButton = toolBar.add(action);
            newButton.setMinimumSize(buttonSize);
            newButton.setPreferredSize(buttonSize);
            newButton.setMaximumSize(buttonSize);
            newButton.setFocusPainted(false);
        }
        return toolBar;
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton menuItem;

        ActionChangedListener(AbstractButton mi) {
            this.menuItem = mi;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                this.menuItem.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.menuItem.setEnabled(enabledState);
            }
        }
    }

    private class DynamicMenuListener
    implements MenuListener {
        public void menuSelected(MenuEvent e) {
            Component[] items = ((JMenu)e.getSource()).getMenuComponents();
            for (int i = 0; i < items.length; ++i) {
                Action action;
                if (items[i] instanceof JPopupMenu.Separator || !(items[i] instanceof JMenuItem) || !((action = DynamicResource.this.getAction(((JMenuItem)items[i]).getActionCommand())) instanceof SHTMLAction)) continue;
                ((SHTMLAction)action).update();
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }
}

