/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreLifecycleListener;
import com.frostwire.bittorrent.AzureusStarter;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.gnutella.downloader.CoreDownloaderFactoryImpl;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.limewire.io.IOUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

public final class FrostWireUtils {
    private static final boolean canShareTorrentMetaFiles() {
        if (!SharingSettings.DEFAULT_SHARED_TORRENTS_DIR.exists()) {
            SharingSettings.DEFAULT_SHARED_TORRENTS_DIR.mkdir();
        }
        return SharingSettings.SHARE_TORRENT_META_FILES.getValue() && SharingSettings.DEFAULT_SHARED_TORRENTS_DIR.exists() && SharingSettings.DEFAULT_SHARED_TORRENTS_DIR.isDirectory() && SharingSettings.DEFAULT_SHARED_TORRENTS_DIR.canWrite();
    }

    public static final boolean checkMD5(File file, String string) throws Exception {
        if (string == null) {
            throw new Exception("Expected MD5 is null");
        }
        if (string.length() != 32) {
            throw new Exception("Invalid Expected MD5, not 32 chars long");
        }
        return FrostWireUtils.getMD5(file).trim().equalsIgnoreCase(string.trim());
    }

    public static final void deleteFolderRecursively(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray.length > 0) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    FrostWireUtils.deleteFolderRecursively(file2);
                    continue;
                }
                file2.delete();
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] downloadHttpFile(String string) {
        short s;
        HttpURLConnection httpURLConnection = null;
        byte[] byArray = null;
        try {
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            s = (short)httpURLConnection.getResponseCode();
        }
        catch (Exception exception) {
            return null;
        }
        if (s == 200) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream(), 1024);
                int n = httpURLConnection.getContentLength();
                byArray = new byte[n];
                bufferedInputStream.read(byArray);
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                byArray = null;
            }
            finally {
                httpURLConnection.disconnect();
            }
        } else if (s >= 300 && s <= 399 && httpURLConnection.getHeaderField("Location") != null) {
            string = httpURLConnection.getHeaderField("Location").trim();
            httpURLConnection.disconnect();
            byArray = FrostWireUtils.downloadHttpFile(string);
        }
        return byArray;
    }

    public static final BTMetaInfo downloadTorrentFile(String string) throws IOException {
        return FrostWireUtils.downloadTorrentFile(string, null);
    }

    public static final BTMetaInfo downloadTorrentFile(String string, File file) throws IOException {
        BTMetaInfo bTMetaInfo = null;
        byte[] byArray = FrostWireUtils.downloadHttpFile(string);
        try {
            bTMetaInfo = BTMetaInfo.readFromBytes(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file != null && byArray != null && byArray.length > 0) {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file, false);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        return bTMetaInfo;
    }

    private static CoreDownloaderFactoryImpl getCoreDownloaderFactory() {
        CoreDownloaderFactoryImpl coreDownloaderFactoryImpl = null;
        try {
            coreDownloaderFactoryImpl = (CoreDownloaderFactoryImpl)GuiCoreMediator.getDownloadManager().getCoreDownloaderFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return coreDownloaderFactoryImpl;
    }

    public static final String getInstallationFolder() {
        Properties properties = System.getProperties();
        return properties.getProperty("user.dir");
    }

    public static final String getMD5(File file) throws Exception {
        int n;
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = new byte[65536];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        String string = new BigInteger(1, messageDigest.digest()).toString(16);
        if (string.length() < 32) {
            int n2 = 32 - string.length();
            for (int i = 0; i < n2; ++i) {
                string = "0" + string;
            }
        }
        System.out.println("MD5: " + string);
        return string;
    }

    public static final File getPreferencesFolder() {
        return LimeWireUtils.getRequestedUserSettingsLocation();
    }

    public static void main(String[] stringArray) throws Exception {
        AzureusStarter.start();
        AzureusCore azureusCore = AzureusStarter.getAzureusCore();
        FrostWireUtils.waitForAzureusCoreToStart();
        azureusCore.getGlobalManager().resumeDownloads();
        FrostWireUtils.downloadTorrentFile("http://dl.frostwire.com/torrents/hostiles/hostiles.txt.2.zip.torrent", new File(SharingUtils.APPLICATION_SPECIAL_SHARE, "hostiles.txt.2.zip.torrent"));
        DownloadManager downloadManager = FrostWireUtils.startTorrentDownload(SharingUtils.APPLICATION_SPECIAL_SHARE + File.separator + "hostiles.txt.2.zip.torrent", CommonUtils.getUserSettingsDir().getAbsolutePath(), new DownloadManagerListener(){

            public void completionChanged(DownloadManager downloadManager, boolean bl) {
                System.out.println("completionChanged: completed:" + bl);
            }

            public void downloadComplete(DownloadManager downloadManager) {
                System.out.println("downloadComplete()!");
            }

            public void filePriorityChanged(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
                System.out.println("filePriorityChanged() " + diskManagerFileInfo.getIndex());
            }

            public void positionChanged(DownloadManager downloadManager, int n, int n2) {
                System.out.println("positionChanged() oldPos:" + n + " newPos:" + n2);
            }

            public void stateChanged(DownloadManager downloadManager, int n) {
                System.out.println("State Changed (" + n + ")");
                if (n == 60) {
                    System.out.println("SEEDING");
                } else if (n == 65) {
                    System.out.println("STOPPING");
                } else if (n == 70) {
                    System.out.println("STOPPED");
                    System.out.println("Trying to restart...");
                    downloadManager.startDownload();
                } else if (n == 100) {
                    System.out.println("ERROR");
                    System.out.println(downloadManager.getErrorDetails());
                } else if (n == 40 && downloadManager.getDiskManager().getPercentDone() < 1000) {
                    System.out.println("Ready but getPercentage() < 1000 [" + downloadManager.getDiskManager().getPercentDone() + "]");
                    downloadManager.startDownload();
                } else if (n == 40) {
                    System.out.println("Ready - getPercentage()=" + downloadManager.getDiskManager().getPercentDone());
                    System.out.println(downloadManager.getSaveLocation().getAbsolutePath());
                    downloadManager.startDownload();
                }
            }
        });
        downloadManager.addDiskListener(new DownloadManagerDiskListener(){

            public void diskManagerAdded(DiskManager diskManager) {
                System.out.print("Added a diskManager: " + diskManager.getNbPieces() + " pieces -> ");
                FrostWireUtils.printDiskManagerPieces(diskManager);
            }

            public void diskManagerRemoved(DiskManager diskManager) {
                System.out.print("Removed a diskManager: " + diskManager.getNbPieces() + " pieces -> ");
                FrostWireUtils.printDiskManagerPieces(diskManager);
            }
        });
    }

    public static void printDiskManagerPieces(DiskManager diskManager) {
        DiskManagerPiece[] diskManagerPieceArray;
        if (diskManager == null) {
            return;
        }
        for (DiskManagerPiece diskManagerPiece : diskManagerPieceArray = diskManager.getPieces()) {
            System.out.print(diskManagerPiece.isDone() ? "1" : "0");
        }
        System.out.println();
    }

    public static void printDownloadManagerStatus(DownloadManager downloadManager) {
        if (downloadManager == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Completed:");
        DownloadManagerStats downloadManagerStats = downloadManager.getStats();
        int n = downloadManagerStats.getCompleted();
        stringBuffer.append(n / 10);
        stringBuffer.append('.');
        stringBuffer.append(n % 10);
        stringBuffer.append('%');
        stringBuffer.append(" Seeds:");
        stringBuffer.append(downloadManager.getNbSeeds());
        stringBuffer.append(" Peers:");
        stringBuffer.append(downloadManager.getNbPeers());
        stringBuffer.append(" Downloaded:");
        stringBuffer.append(DisplayFormatters.formatDownloaded(downloadManagerStats));
        stringBuffer.append(" Uploaded:");
        stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtc(downloadManagerStats.getTotalDataBytesSent()));
        stringBuffer.append(" DSpeed:");
        stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(downloadManagerStats.getDataReceiveRate()));
        stringBuffer.append(" USpeed:");
        stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(downloadManagerStats.getDataSendRate()));
        stringBuffer.append(" TrackerStatus:");
        stringBuffer.append(downloadManager.getTrackerStatus());
        while (stringBuffer.length() < 80) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(" TO:");
        stringBuffer.append(downloadManager.getSaveLocation().getAbsolutePath());
        System.out.println(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static final void shareTorrent(BTMetaInfo bTMetaInfo, byte[] byArray) {
        if (!FrostWireUtils.canShareTorrentMetaFiles()) {
            return;
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            File file = new File(SharingSettings.DEFAULT_SHARED_TORRENTS_DIR, bTMetaInfo.getName().concat(".torrent"));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            FrostWireUtils.verifySharedTorrentFolderCorrecteness();
        }
        catch (Exception exception) {
            IOUtils.close(bufferedOutputStream);
            catch (Throwable throwable) {
                IOUtils.close(bufferedOutputStream);
                throw throwable;
            }
        }
        IOUtils.close(bufferedOutputStream);
    }

    public static final void shareTorrent(File file) {
        if (!FrostWireUtils.canShareTorrentMetaFiles()) {
            return;
        }
        File file2 = new File(SharingSettings.DEFAULT_SHARED_TORRENTS_DIR, file.getName());
        FileUtils.copy(file, file2);
        FrostWireUtils.verifySharedTorrentFolderCorrecteness();
    }

    public static final DownloadManager startTorrentDownload(String string, String string2, DownloadManagerListener downloadManagerListener) throws Exception {
        FrostWireUtils.waitForAzureusCoreToStart();
        DownloadManager downloadManager = AzureusStarter.getAzureusCore().getGlobalManager().addDownloadManager(string, string2);
        downloadManager.addListener(downloadManagerListener);
        downloadManager.initialize();
        return downloadManager;
    }

    public static final void unzip(File file, File file2) throws Exception {
        ZipEntry zipEntry;
        int n = 2048;
        BufferedOutputStream bufferedOutputStream = null;
        File file3 = new File(file2.getCanonicalPath(), file.getName());
        if (file3.exists()) {
            file3.delete();
        }
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n2;
            byte[] byArray = new byte[n];
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2.getPath() + "/" + zipEntry.getName()), n);
            while ((n2 = zipInputStream.read(byArray, 0, n)) != -1) {
                bufferedOutputStream.write(byArray, 0, n2);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        zipInputStream.close();
    }

    public static final void verifySharedTorrentFolderCorrecteness() {
        File[] fileArray;
        FrostWireUtils.canShareTorrentMetaFiles();
        if (SharingSettings.SHARE_TORRENT_META_FILES.getValue()) {
            GuiCoreMediator.getFileManager().addSharedFolder(SharingSettings.DEFAULT_SHARED_TORRENTS_DIR);
        }
        if ((fileArray = SharingSettings.DEFAULT_SHARED_TORRENTS_DIR.listFiles()) != null && fileArray.length > 0) {
            for (File file : fileArray) {
                if (SharingSettings.SHARE_TORRENT_META_FILES.getValue()) {
                    GuiCoreMediator.getFileManager().addFileAlways(file);
                    continue;
                }
                GuiCoreMediator.getFileManager().stopSharingFile(file);
            }
        }
    }

    public static final void waitForAzureusCoreToStart() throws InterruptedException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        AzureusStarter.getAzureusCore().addLifecycleListener(new AzureusCoreLifecycleListener(){

            public void componentCreated(AzureusCore azureusCore, AzureusCoreComponent azureusCoreComponent) {
            }

            public boolean requiresPluginInitCompleteBeforeStartedEvent() {
                return false;
            }

            public boolean restartRequested(AzureusCore azureusCore) throws AzureusCoreException {
                return false;
            }

            public void started(AzureusCore azureusCore) {
                countDownLatch.countDown();
            }

            public void stopped(AzureusCore azureusCore) {
            }

            public void stopping(AzureusCore azureusCore) {
            }

            public boolean stopRequested(AzureusCore azureusCore) throws AzureusCoreException {
                return false;
            }

            public boolean syncInvokeRequired() {
                return false;
            }
        });
        if (!AzureusStarter.getAzureusCore().isStarted()) {
            System.out.println("FrostWireUtils.waitForAzureusCoreToStart() - Waiting for azureus core...");
            countDownLatch.await();
            System.out.println("FrostWireUtils.waitForAzureusCoreToStart() - Azureus core has started, let's do this.");
        }
    }
}

