/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.audio;

import com.limegroup.gnutella.gui.mp3.AudioSource;
import com.limegroup.gnutella.gui.mp3.PlayerState;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.Player;

public final class AuxMP3Player
implements Runnable {
    private Thread playerThread;
    private Player player;
    private static AuxMP3Player INSTANCE = null;
    private PlayerState state = PlayerState.STOPPED;
    private Object playerLock = new Object();

    private AuxMP3Player() {
    }

    public static final AuxMP3Player getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AuxMP3Player();
        }
        return INSTANCE;
    }

    private final void setSong(AudioSource audioSource) throws Exception {
        if (INSTANCE != null && this.player != null) {
            this.player.close();
            this.player = null;
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(audioSource.getFile()));
            this.player = new Player(bufferedInputStream, FactoryRegistry.systemRegistry().createAudioDevice());
        }
        catch (Exception exception) {
            this.player = null;
            throw exception;
        }
    }

    public final void tryPlaying(AudioSource audioSource) throws Exception {
        this.state = PlayerState.OPENING;
        this.setSong(audioSource);
        this.playerThread = new Thread(this);
        this.playerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        if (this.state == PlayerState.PLAYING || INSTANCE == null || this.player == null) {
            return;
        }
        try {
            this.state = PlayerState.PLAYING;
            this.player.play(Integer.MAX_VALUE);
            this.state = PlayerState.STOPPED;
        }
        catch (Exception exception) {
            this.state = PlayerState.STOPPED;
            this.player.close();
        }
        finally {
            this.player.close();
            this.player = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void stop() {
        if (this.state != PlayerState.PLAYING) {
            return;
        }
        Object object = this.playerLock;
        synchronized (object) {
            if (this.player != null) {
                this.player.close();
                this.player = null;
                this.state = PlayerState.STOPPED;
            }
        }
    }
}

