/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleListener;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gudy.azureus2.core3.util.SystemProperties;

public final class AzureusStarter {
    private static final Log LOG = LogFactory.getLog(AzureusStarter.class);
    private static AzureusCore AZUREUS_CORE;

    public static final void start() {
        AzureusStarter.azureusInit();
    }

    public static AzureusCore getAzureusCore() {
        if (AZUREUS_CORE != null && AZUREUS_CORE.isStarted()) {
            return AZUREUS_CORE;
        }
        AzureusStarter.azureusInit();
        return AZUREUS_CORE;
    }

    private static void azureusInit() {
        if (AZUREUS_CORE != null && AZUREUS_CORE.isStarted()) {
            LOG.debug("azureusInit(): core already started. skipping.");
            return;
        }
        if (!AzureusCoreFactory.isCoreAvailable()) {
            SystemProperties.APPLICATION_NAME = "azureus";
            SystemProperties.setUserPath(LimeWireUtils.getRequestedUserSettingsLocation() + File.separator + "azureus" + File.separator);
            AZUREUS_CORE = AzureusCoreFactory.create();
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            AZUREUS_CORE.addLifecycleListener(new AzureusCoreLifecycleListener(){

                public boolean syncInvokeRequired() {
                    return false;
                }

                public void stopping(AzureusCore azureusCore) {
                    azureusCore.getGlobalManager().pauseDownloads();
                }

                public void stopped(AzureusCore azureusCore) {
                }

                public boolean stopRequested(AzureusCore azureusCore) throws AzureusCoreException {
                    return false;
                }

                public void started(AzureusCore azureusCore) {
                    countDownLatch.countDown();
                }

                public boolean restartRequested(AzureusCore azureusCore) throws AzureusCoreException {
                    return false;
                }

                public boolean requiresPluginInitCompleteBeforeStartedEvent() {
                    return false;
                }

                public void componentCreated(AzureusCore azureusCore, AzureusCoreComponent azureusCoreComponent) {
                }
            });
            AZUREUS_CORE.start();
            AZUREUS_CORE.getGlobalManager().resumeDownloads();
            LOG.debug("azureusInit(): core.start() waiting...");
            try {
                countDownLatch.await();
                LOG.debug("azureusInit(): core started...");
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

