/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.sponsors;

import com.frostwire.gnutella.gui.sponsors.SponsorBanner;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BannerContainer
extends JPanel {
    private CardLayout layout = new CardLayout();
    private HashSet<SponsorBanner> banners;
    private Timer bannerSwitcher;
    private Timer bannerRefresher;
    private SponsorBanner currentBanner;
    private int DEFAULT_BANNER_REFRESH_RATE = 10;
    private long lastTimeSwitched = 0L;

    public BannerContainer() {
        this.setLayout(this.layout);
        this.refreshBanners();
        this.setupMouseListeners();
    }

    public BannerContainer(HashSet<SponsorBanner> hashSet) {
        this.setLayout(this.layout);
        this.setBanners(hashSet);
        this.setupMouseListeners();
        this.setupBannerRefreshTask(this.DEFAULT_BANNER_REFRESH_RATE);
    }

    public void setupBannerRefreshTask(int n) {
        if (n == -1) {
            if (this.bannerRefresher != null) {
                this.bannerRefresher.cancel();
            }
            this.bannerRefresher = null;
            return;
        }
        n *= 1000;
        if (this.bannerRefresher != null) {
            this.bannerRefresher.cancel();
            this.bannerRefresher = null;
        }
        this.bannerRefresher = new Timer(true);
        this.bannerRefresher.scheduleAtFixedRate((TimerTask)new BannersRefreshTask(this), n, (long)n);
    }

    private void setupMouseListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BannerContainer.this.lastTimeSwitched = 0L;
                BannerContainer.this.switchBanner();
            }
        });
    }

    public void removeAllBanners() {
        if (this.banners != null && this.getComponentCount() > 0) {
            this.bannerSwitcher.cancel();
            this.removeAll();
        }
    }

    public void setBanners(HashSet<SponsorBanner> hashSet) {
        this.banners = null;
        this.banners = hashSet;
        Iterator<SponsorBanner> iterator = this.banners.iterator();
        if (this.bannerSwitcher != null) {
            this.bannerSwitcher.cancel();
            this.bannerSwitcher.purge();
        }
        this.bannerSwitcher = new Timer(true);
        while (iterator.hasNext()) {
            SponsorBanner sponsorBanner = iterator.next();
            this.add((Component)sponsorBanner, sponsorBanner.getImageSrc());
        }
        this.repaint();
        this.lastTimeSwitched = Calendar.getInstance().getTimeInMillis();
        this.bannerSwitcher.scheduleAtFixedRate((TimerTask)new BannerSwitchTask(this), 0L, 5000L);
    }

    public void refreshBanners() {
        this.removeAllBanners();
        this.setBanners(new SponsorBanner().getBannersFromServer(this));
    }

    public SponsorBanner getCurrentShownBanner() {
        for (SponsorBanner sponsorBanner : this.banners) {
            if (!sponsorBanner.isShowing()) continue;
            return sponsorBanner;
        }
        return null;
    }

    public void switchBanner() {
        long l;
        SponsorBanner sponsorBanner = this.getCurrentShownBanner();
        if (sponsorBanner == null) {
            return;
        }
        long l2 = (long)sponsorBanner.getDuration() * 1000L;
        long l3 = Calendar.getInstance().getTimeInMillis();
        if (l3 > (l = this.lastTimeSwitched + l2)) {
            this.lastTimeSwitched = l3;
            this.layout.next(this);
            this.repaint();
        }
    }

    private class BannersRefreshTask
    extends TimerTask {
        private BannerContainer container;

        public BannersRefreshTask(BannerContainer bannerContainer2) {
            this.container = bannerContainer2;
        }

        public void run() {
            this.container.refreshBanners();
        }
    }

    private class BannerSwitchTask
    extends TimerTask {
        private BannerContainer container;

        public BannerSwitchTask(BannerContainer bannerContainer2) {
            this.container = bannerContainer2;
        }

        public void run() {
            this.container.switchBanner();
        }
    }
}

