/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.httpconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.xml.sax.InputSource;

public class HttpURLFWGetSource
implements Runnable {
    private String _server = "";
    private int _port = 0;
    private String _agent = "";
    private boolean _connected = false;
    private String _sourceReaded = "";
    private InputSource _xmlSource = null;
    private boolean complete = false;
    static final int BUFSIZE = 8;

    public static void main(String[] stringArray) {
    }

    public HttpURLFWGetSource(String string, int n, String string2) {
        this.setServer(string);
        this.setPort(n);
        this.setAgent(string2);
    }

    public void run() {
        try {
            SocketChannel socketChannel = this.createSocketChannel(this.getServer(), this.getPort());
            String string = null;
            while (!socketChannel.finishConnect()) {
                Thread.sleep(100L);
                System.out.println("HttpURLFWGetSource - Waiting reply from " + this.getServer() + "...");
            }
            System.out.println("HttpURLFWGetSource - Connected successfully to : " + socketChannel.socket() + "!!");
            this.setConnected(true);
            socketChannel.configureBlocking(true);
            Socket socket = socketChannel.socket();
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            InputSource inputSource = null;
            inputSource = new InputSource(inputStream);
            this.setXMLSource(inputSource);
            ByteReaderFT byteReaderFT = new ByteReaderFT(inputStream);
            String string2 = "User-Agent: " + this.getAgent() + "\r\n";
            String string3 = "Host: " + this.getServer() + "\r\n";
            outputStream.write("GET / HTTP/1.1\r\n".getBytes());
            outputStream.write(string3.getBytes());
            outputStream.write(string2.getBytes());
            outputStream.write("\r\n".getBytes());
            System.out.println("HttpURLFWGetSource - 2nd part. Connected, Reading answer from server...");
            boolean bl = false;
            String string4 = "";
            while ((string = byteReaderFT.readLine()) != null && !string.equals("")) {
            }
            string = byteReaderFT.readLine();
            while (socket.isConnected() && !string.equals("0")) {
                outputStream.write("HTTP/1.1 200 OK \r\n".getBytes());
                outputStream.write("\r\n".getBytes());
                while ((string = byteReaderFT.readLine()) != null && !string.equals("0")) {
                    if (string.startsWith("<?")) {
                        bl = true;
                    }
                    if (bl) {
                        string4 = string4 + string + "\n";
                    }
                    if (!string.equals("0")) continue;
                    socket.close();
                }
            }
            this.setComplete(true);
            this.setSourceReaded(string4);
        }
        catch (SocketException socketException) {
            System.out.println("HttpURLFWGetSource - Cancelled: " + socketException.getMessage());
            this.setComplete(true);
        }
        catch (IOException iOException) {
            System.out.println("HttpURLFWGetSource - Some problem happened with input output!\nDetails as follow:" + iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            System.out.println("HttpURLFWGetSource - Request for " + this.getServer() + " timed out!");
            this.setComplete(true);
        }
    }

    public int IntegerValueOf(String string) {
        try {
            int n = new Integer(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    SocketChannel createSocketChannel(String string, int n) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        socketChannel.connect(new InetSocketAddress(string, n));
        return socketChannel;
    }

    public void writeMessage(SocketChannel socketChannel, String string) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(string.getBytes());
        int n = socketChannel.write(byteBuffer);
        if (n == 0) {
            System.out.println("HttpURLFWGetSource DEBUG: No bytes written!");
        }
    }

    public String decode(ByteBuffer byteBuffer) throws CharacterCodingException {
        Charset charset = Charset.forName("us-ascii");
        CharsetDecoder charsetDecoder = charset.newDecoder();
        CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
        String string = charBuffer.toString();
        return string;
    }

    public void setPort(int n) {
        this._port = n;
    }

    public int getPort() {
        return this._port;
    }

    public void setServer(String string) {
        this._server = string;
    }

    public String getServer() {
        return this._server;
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setAgent(String string) {
        this._agent = string;
    }

    public String getAgent() {
        return this._agent;
    }

    public void setConnected(boolean bl) {
        this._connected = bl;
    }

    public boolean isConnected() {
        return this._connected;
    }

    public void setSourceReaded(String string) {
        this._sourceReaded = string;
    }

    public String getSourceReaded() {
        return this._sourceReaded;
    }

    public void setXMLSource(InputSource inputSource) {
        this._xmlSource = inputSource;
    }

    public InputSource getXMLSource() {
        return this._xmlSource;
    }

    public class ChannelCallback {
        private SocketChannel channel;
        private StringBuffer buffer;

        public ChannelCallback(SocketChannel socketChannel) {
            this.channel = socketChannel;
            this.buffer = new StringBuffer();
        }

        public void execute() throws IOException {
            HttpURLFWGetSource.this.writeMessage(this.channel, this.buffer.toString());
            this.buffer = new StringBuffer();
        }

        public SocketChannel getChannel() {
            return this.channel;
        }

        public void append(String string) {
            this.buffer.append(string);
        }
    }

    class ByteReaderFT {
        private static final byte R = 13;
        private static final byte N = 10;
        private InputStream _istream;

        public ByteReaderFT(InputStream inputStream) {
            this._istream = inputStream;
        }

        public void close() {
            try {
                this._istream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public int read() {
            int n = -1;
            if (this._istream == null) {
                return n;
            }
            try {
                n = this._istream.read();
            }
            catch (IOException iOException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return n;
        }

        public int read(byte[] byArray) {
            int n = -1;
            if (this._istream == null) {
                return n;
            }
            try {
                n = this._istream.read(byArray);
            }
            catch (IOException iOException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) {
            int n3 = -1;
            if (this._istream == null) {
                return n3;
            }
            try {
                n3 = this._istream.read(byArray, n, n2);
            }
            catch (IOException iOException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return n3;
        }

        public String readLine() throws IOException {
            if (this._istream == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n = -1;
            boolean bl = true;
            do {
                try {
                    n = this._istream.read();
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IOException("aiooe.");
                }
                switch (n) {
                    case 10: {
                        bl = false;
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case -1: {
                        return null;
                    }
                    default: {
                        stringBuilder.append((char)n);
                    }
                }
            } while (bl);
            return stringBuilder.toString();
        }
    }
}

