/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.models;

import com.frostwire.plugins.models.MetaPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Plugin
extends MetaPlugin {
    private Thread interpreterThread;
    private PythonInterpreter interpreter;
    private PyObject pyObject;

    public void copyAttributes(Plugin plugin) {
        if (plugin == null) {
            System.out.println("Plugin.copyAttributes() - No attributes were copied, source plugin null");
            return;
        }
        this.setAuthor(plugin.getAuthor());
        this.setDownloadURL(plugin.getDownloadURL());
        this.setInterpreterThread(plugin.getInterpreterThread());
        this.setLastFrostWireVersionSupported(plugin.getLastFrostWireVersionSupported());
        this.setMD5Hash(plugin.getMD5Hash());
        this.setMinimumFrostWireVersionSupported(plugin.getMinimumFrostWireVersionSupported());
        this.setName(plugin.getName());
        this.setOrganization(plugin.getOrganization());
        this.setPythonInterpreter(plugin.getPythonInterpreter());
        this.setTitle(plugin.getTitle());
        this.setVersion(plugin.getVersion());
        this.setWebsite(plugin.getWebsite());
        System.out.println("Plugin.copyAttributes() - Attributes copied");
    }

    public Thread getInterpreterThread() {
        return this.interpreterThread;
    }

    public void setInterpreterThread(Thread thread) {
        this.interpreterThread = thread;
    }

    public PythonInterpreter getPythonInterpreter() {
        return this.interpreter;
    }

    public void setPythonInterpreter(PythonInterpreter pythonInterpreter) {
        this.interpreter = pythonInterpreter;
    }

    public PyObject getPyObject() {
        return this.pyObject;
    }

    public void setPyObject(PyObject pyObject) {
        this.pyObject = pyObject;
    }

    public static Plugin loadFromFile(String string) {
        block7: {
            ZipEntry zipEntry;
            ZipFile zipFile;
            ZipInputStream zipInputStream;
            File file = new File(string);
            if (!file.exists()) {
                return null;
            }
            try {
                zipInputStream = new ZipInputStream(new FileInputStream(file));
                zipFile = new ZipFile(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            do {
                try {
                    zipEntry = zipInputStream.getNextEntry();
                }
                catch (IOException iOException) {
                    break block7;
                }
                if (zipEntry == null) break block7;
            } while (!zipEntry.getName().endsWith("meta.xml"));
            PluginMetaContentHandler pluginMetaContentHandler = new PluginMetaContentHandler(zipEntry, zipFile);
            pluginMetaContentHandler.parse();
            Plugin plugin = pluginMetaContentHandler.getPlugin();
            plugin.setSize((int)new File(string).length());
            return pluginMetaContentHandler.getPlugin();
        }
        return null;
    }

    public boolean isValid() {
        boolean bl = super.isValid();
        return bl;
    }

    private static final class PluginMetaContentHandler
    implements ContentHandler {
        private ZipEntry metaFile;
        private ZipFile zipFile;
        private XMLReader rdr;
        private Plugin plugin;

        public PluginMetaContentHandler(ZipEntry zipEntry, ZipFile zipFile) {
            this.metaFile = zipEntry;
            this.zipFile = zipFile;
            this.plugin = null;
            try {
                this.rdr = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
                this.rdr.setContentHandler(this);
            }
            catch (SAXException sAXException) {
                System.out.println("PluginMetaContentHandler() SAXException " + sAXException.toString());
            }
        }

        public void parse() {
            if (this.metaFile == null) {
                this.plugin = null;
                return;
            }
            try {
                this.rdr.parse(new InputSource(this.zipFile.getInputStream(this.metaFile)));
                this.zipFile.close();
            }
            catch (IOException iOException) {
                System.out.println("PluginMetaContentHandler.parse() IOException " + iOException.toString());
            }
            catch (SAXException sAXException) {
                System.out.println("PluginMetaContentHandler.parse() SAXException " + sAXException.toString());
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equalsIgnoreCase("plugin")) {
                this.plugin = this.tryLoadingPluginFromAttributes(attributes);
            }
        }

        private String tryGettingAttribute(Attributes attributes, String string) {
            return attributes.getValue(string) != null ? attributes.getValue(string) : null;
        }

        private Plugin tryLoadingPluginFromAttributes(Attributes attributes) {
            this.plugin = new Plugin();
            this.plugin.setName(this.tryGettingAttribute(attributes, "name"));
            this.plugin.setTitle(this.tryGettingAttribute(attributes, "title"));
            this.plugin.setAuthor(this.tryGettingAttribute(attributes, "author"));
            this.plugin.setOrganization(this.tryGettingAttribute(attributes, "organization"));
            this.plugin.setVersion(this.tryGettingAttribute(attributes, "version"));
            this.plugin.setMinimumFrostWireVersionSupported(this.tryGettingAttribute(attributes, "minimumFrostWireVersion"));
            this.plugin.setLastFrostWireVersionSupported(this.tryGettingAttribute(attributes, "lastFrostWireVersion"));
            this.plugin.setWebsite(this.tryGettingAttribute(attributes, "website"));
            this.plugin.setDownloadURL(this.tryGettingAttribute(attributes, "downloadURL"));
            return this.plugin;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }
    }
}

