/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.tests;

import com.frostwire.plugins.models.PluginDownloader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import junit.framework.TestCase;

public class PluginDownloaderTest
extends TestCase
implements Observer {
    private PluginDownloader downloader;
    private Thread worker;

    public void update(Observable observable, Object object) {
        PluginDownloader pluginDownloader = (PluginDownloader)observable;
        PluginDownloader.DownloadState downloadState = (PluginDownloader.DownloadState)((Object)object);
        if (downloadState == PluginDownloader.DownloadState.CONNECTION_ESTABLISHED) {
            System.out.println(pluginDownloader.getPluginShortName() + " downloader has established a connection");
        }
        if (downloadState == PluginDownloader.DownloadState.CONTENT_LENGTH_SET) {
            System.out.println(pluginDownloader.getPluginShortName() + " is about to download " + pluginDownloader.getContentLength() + " bytes");
        }
        if (downloadState == PluginDownloader.DownloadState.DOWNLOADED_CHUNK) {
            System.out.println(pluginDownloader.getPluginShortName() + " has downloaded " + pluginDownloader.getDownloadedBytes() + " bytes");
        }
        if (downloadState == PluginDownloader.DownloadState.FINISHED_DOWNLOADING) {
            System.out.println(pluginDownloader.getPluginShortName() + " has ended.");
        }
    }

    public PluginDownloaderTest(String string) {
        super(string);
    }

    public void setUp() {
        HashSet<Observer> hashSet = new HashSet<Observer>();
        hashSet.add(this);
        this.downloader = new PluginDownloader("brooklyn", "http://newyork1.frostwire.com/frostwire/4.17.2/frostwire-4.17.2.dmg", hashSet);
    }

    public void testSimpleDownload() {
        try {
            this.downloader.connect();
            PluginDownloader.PluginDownloaderWorker pluginDownloaderWorker = this.downloader.startDownload();
            while (pluginDownloaderWorker.isAlive()) {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

