/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.updates;

import com.aelitis.azureus.core.AzureusCoreException;
import com.frostwire.FrostWireUtils;
import com.frostwire.bittorrent.AzureusStarter;
import com.frostwire.updates.HostilesMetaData;
import com.frostwire.updates.UpdateMessage;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.library.SharingUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.limewire.io.InvalidDataException;

public final class HostilesUpdater
implements DownloadManagerListener {
    private static int TORRENT_DOWNLOAD_THREAD_MAX_MINUTES = 10;
    private static HostilesUpdater INSTANCE = null;
    private UpdateMessage _updateMessage = null;
    private HostilesMetaData _hostilesMetaData = null;
    private boolean _alreadyPostProcessed = false;
    private DownloadManager _manager = null;
    private CountDownLatch _processingLatch = new CountDownLatch(1);

    private HostilesUpdater() {
    }

    public static HostilesUpdater getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HostilesUpdater();
        }
        return INSTANCE;
    }

    public void processMessage(UpdateMessage updateMessage) {
        if (this.isMessageInvalid(updateMessage)) {
            return;
        }
        this._updateMessage = updateMessage;
        if (this.alreadyHaveValidHostilesTxt()) {
            try {
                this.deleteOlderHostiles();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            return;
        }
        this.checkHostilesMetaData();
        this.startDownloadAndWait(TORRENT_DOWNLOAD_THREAD_MAX_MINUTES);
    }

    private boolean alreadyHaveValidHostilesTxt() {
        try {
            File file = new File(this.getHostilesTxtPath());
            if (!file.exists()) {
                throw new Exception("HostilesUpdater.alreadyHaveValidHostilesTxt(): Had no hostiles.txt - start from scratch");
            }
            if (FrostWireUtils.checkMD5(file, this._updateMessage.getRemoteMD5())) {
                System.out.println("HostilesUpdater.alreadyHaveValidHostilesTxt() - Done. We have a good hostiles.txt already");
                return true;
            }
            file.delete();
            file.deleteOnExit();
            throw new Exception("HostilesUpdater.alreadyHaveValidHostilesTxt() - hostiles.txt is old or invalid");
        }
        catch (Exception exception) {
            this._hostilesMetaData = this.initHostilesMetaData(this._updateMessage);
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_INITIATED);
            return false;
        }
    }

    private void checkHostilesMetaData() {
        try {
            if (this._hostilesMetaData == null) {
                this._hostilesMetaData = this.getLastHostilesMetaData();
                if (this._hostilesMetaData == null) {
                    throw new InvalidDataException("HostilesUpdater.checkHostilesMetaData(): We had no hostiles.dat");
                }
            }
            if (this._hostilesMetaData.get_status() == HostilesMetaData.STATUS_ERRORED) {
                throw new InvalidDataException("HostilesUpdater.checkHostilesMetaData(): Something went wrong the last time");
            }
            if (!this._hostilesMetaData.get_md5().equals(this._updateMessage.getRemoteMD5())) {
                throw new InvalidDataException("HostilesUpdater.checkHostilesMetaData(): Had a good metadata but it was out of date");
            }
        }
        catch (InvalidDataException invalidDataException) {
            System.out.println("HostilesUpdater.processMessage() " + invalidDataException.getMessage());
            this._hostilesMetaData = this.initHostilesMetaData(this._updateMessage);
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_INITIATED);
        }
    }

    private final void startDownloadAndWait(int n) {
        try {
            this.downloadHostiles(this._hostilesMetaData);
            if (this._alreadyPostProcessed) {
                return;
            }
            if (this._manager != null && this._manager.getState() == 70) {
                return;
            }
            if (this._manager.getState() == 60) {
                this.postProcessMessage(true);
                return;
            }
            this._processingLatch.await();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
            this.notifyHostileUpdaterWorkerThread();
            return;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
            this.notifyHostileUpdaterWorkerThread();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
            this.notifyHostileUpdaterWorkerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void postProcessMessage(boolean bl) {
        try {
            File file;
            File file2;
            block21: {
                file2 = new File(this.getAppSpecialShareFolder(), "hostiles.txt." + this._hostilesMetaData.get_version() + ".zip");
                if (this._hostilesMetaData == null) {
                    throw new InvalidDataException("No HostilesMedataData available");
                }
                file = new File(this.getHostilesTxtPath());
                boolean bl2 = true;
                if (file.exists() && !FrostWireUtils.checkMD5(file, this._hostilesMetaData.get_md5())) {
                    file.delete();
                    bl2 = false;
                }
                try {
                    this.deleteOlderHostiles();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!bl2 || !file.exists()) {
                    try {
                        FrostWireUtils.unzip(file2, FrostWireUtils.getPreferencesFolder());
                    }
                    catch (Exception exception) {
                        this._manager.stopIt(100, true, true);
                        exception.printStackTrace();
                        file2.delete();
                        this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
                        if (!bl) break block21;
                        this._alreadyPostProcessed = true;
                        this.notifyHostileUpdaterWorkerThread();
                        if (bl) {
                            this._alreadyPostProcessed = true;
                            this.notifyHostileUpdaterWorkerThread();
                        }
                        return;
                    }
                }
            }
            if (!file.exists()) {
                throw new IOException("Zip file " + file.getAbsolutePath() + " doesn't exist");
            }
            if (!FrostWireUtils.checkMD5(file, this._hostilesMetaData.get_md5())) {
                file2.delete();
                file.delete();
                this._manager.stopIt(100, true, true);
                throw new InvalidDataException("MD5 of unzipped file does not coincide with " + this._hostilesMetaData.get_md5());
            }
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_PROCESSED);
            System.out.println("IPFilter has black listed hosts? (before) " + GuiCoreMediator.getIpFilter().hasBlacklistedHosts());
            GuiCoreMediator.getIpFilter().forceRefreshHosts();
            System.out.println("IPFilter has black listed hosts? (after) " + GuiCoreMediator.getIpFilter().hasBlacklistedHosts());
        }
        catch (InvalidDataException invalidDataException) {
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
        }
        catch (IOException iOException) {
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
            System.out.println("Unzip FAIL! " + iOException.getMessage());
        }
        catch (Exception exception) {
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
        }
        finally {
            if (bl) {
                this._alreadyPostProcessed = true;
                this.notifyHostileUpdaterWorkerThread();
            }
        }
    }

    private final void downloadHostiles(HostilesMetaData hostilesMetaData) throws Exception {
        File file = this.getAppSpecialShareFolder();
        File file2 = new File(this.getAppSpecialShareFolder() + File.separator + "hostiles.txt." + hostilesMetaData.get_version() + ".zip.torrent");
        if (!file.exists()) {
            file.mkdir();
            file.setWritable(true);
        }
        if (!file2.exists()) {
            FrostWireUtils.downloadTorrentFile(hostilesMetaData.get_torrentURL(), file2);
        }
        assert (file2.exists());
        String string = this.getAppSpecialShareFolder().getAbsolutePath();
        this._hostilesMetaData.set_torrent_file_save_location(file2.getAbsolutePath());
        this._hostilesMetaData.set_torrent_data_save_location(string);
        this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_DOWNLOADING);
        File file3 = new File(string + File.separator + "hostiles.txt." + hostilesMetaData.get_version() + ".zip");
        if (file3.exists() && file3.isFile()) {
            try {
                this.postProcessMessage(false);
                this.notifyHostileUpdaterWorkerThread();
            }
            catch (Exception exception) {
                file3.delete();
                this._manager = FrostWireUtils.startTorrentDownload(file2.getAbsolutePath(), string, this);
            }
        } else {
            this._manager = FrostWireUtils.startTorrentDownload(file2.getAbsolutePath(), string, this);
        }
    }

    private boolean isMessageInvalid(UpdateMessage updateMessage) {
        return updateMessage == null || updateMessage.getVersion() == null || updateMessage.getVersion().equals("") || updateMessage.getTorrent() == null || updateMessage.getTorrent().equals("") || updateMessage.getRemoteMD5() == null || updateMessage.getRemoteMD5().equals("");
    }

    public final String getHostilesTxtPath() {
        return FrostWireUtils.getPreferencesFolder() + File.separator + "hostiles.txt";
    }

    private final String getHostilesDatPath() throws IOException {
        return FrostWireUtils.getPreferencesFolder().getCanonicalPath() + File.separator + "hostiles.dat";
    }

    private final File getAppSpecialShareFolder() throws IOException {
        return SharingUtils.APPLICATION_SPECIAL_SHARE;
    }

    private final HostilesMetaData getLastHostilesMetaData() {
        HostilesMetaData hostilesMetaData = null;
        try {
            File file = new File(this.getHostilesDatPath());
            if (!file.exists()) {
                return null;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            hostilesMetaData = (HostilesMetaData)objectInputStream.readObject();
            if (hostilesMetaData == null) {
                return null;
            }
            System.out.println(hostilesMetaData);
            if (!hostilesMetaData.is_valid()) {
                if (file.exists()) {
                    file.delete();
                }
                hostilesMetaData.set_status(HostilesMetaData.STATUS_ERRORED);
                return hostilesMetaData;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return hostilesMetaData;
    }

    private final HostilesMetaData initHostilesMetaData(UpdateMessage updateMessage) {
        HostilesMetaData hostilesMetaData = new HostilesMetaData();
        hostilesMetaData.set_date(Calendar.getInstance().getTimeInMillis());
        hostilesMetaData.set_md5(updateMessage.getRemoteMD5());
        hostilesMetaData.set_status(HostilesMetaData.STATUS_INITIATED);
        hostilesMetaData.set_torrentURL(updateMessage.getTorrent());
        hostilesMetaData.set_version(updateMessage.getVersion());
        this._hostilesMetaData = hostilesMetaData;
        return hostilesMetaData;
    }

    private final void saveHostilesMetaData(HostilesMetaData hostilesMetaData, Byte by) {
        try {
            String string = this.getHostilesDatPath();
            hostilesMetaData.set_status(by);
            hostilesMetaData.set_date(System.currentTimeMillis());
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(hostilesMetaData);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final void deleteOlderHostiles() throws InvalidDataException, IOException, AzureusCoreException, GlobalManagerDownloadRemovalVetoException {
        File[] fileArray;
        if (this._updateMessage == null) {
            throw new InvalidDataException("There no UpdateMessage to know which is the newest hostiles file.");
        }
        if (this._hostilesMetaData == null) {
            this.checkHostilesMetaData();
        }
        File file = this.getAppSpecialShareFolder();
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.getName().startsWith("hostiles.txt") || file2.getName().endsWith(this._hostilesMetaData.get_version() + ".zip.torrent") || file2.getName().equals("hostiles.txt." + this._hostilesMetaData.get_version() + ".zip")) continue;
            if (file2.isDirectory()) {
                FrostWireUtils.deleteFolderRecursively(file2);
            } else {
                List list = AzureusStarter.getAzureusCore().getGlobalManager().getDownloadManagers();
                for (DownloadManager downloadManager : list) {
                    if (!downloadManager.getSaveLocation().equals(file2)) continue;
                    downloadManager.stopIt(71, true, true);
                    AzureusStarter.getAzureusCore().getGlobalManager().removeDownloadManager(downloadManager);
                }
                file2.delete();
            }
            System.out.println("HostilesUpdater.deleteOlderHostiles(): Deleted " + file2.getName());
        }
    }

    private final void notifyHostileUpdaterWorkerThread() {
        this._alreadyPostProcessed = true;
        if (this._processingLatch != null) {
            this._processingLatch.countDown();
        }
    }

    public void completionChanged(DownloadManager downloadManager, boolean bl) {
    }

    private void restartDownloadManagerDownload(DownloadManager downloadManager) throws IOException {
        try {
            String string = this.getAppSpecialShareFolder().getAbsolutePath() + File.separator + "hostiles.txt." + this._hostilesMetaData.get_version() + ".zip.torrent";
            String string2 = this._hostilesMetaData.get_torrent_file_save_location();
            downloadManager.stopIt(75, false, true);
            AzureusStarter.getAzureusCore().getGlobalManager().removeDownloadManager(downloadManager);
            downloadManager = AzureusStarter.getAzureusCore().getGlobalManager().addDownloadManager(string, string2);
            downloadManager.initialize();
        }
        catch (GlobalManagerDownloadRemovalVetoException globalManagerDownloadRemovalVetoException) {
            globalManagerDownloadRemovalVetoException.printStackTrace();
        }
    }

    public void filePriorityChanged(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
    }

    public void positionChanged(DownloadManager downloadManager, int n, int n2) {
    }

    public void stateChanged(DownloadManager downloadManager, int n) {
        if (this._manager == null && downloadManager != null) {
            this._manager = downloadManager;
        }
        FrostWireUtils.printDiskManagerPieces(downloadManager.getDiskManager());
        FrostWireUtils.printDownloadManagerStatus(downloadManager);
        System.out.println("HostilesUpdater.stateChanged() - " + n);
        if (n == 70) {
            try {
                this.restartDownloadManagerDownload(downloadManager);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (n == 100) {
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
            System.out.println(this._manager.getErrorDetails());
            System.out.println("HostilesUpdater: Restarting Download Manager");
            try {
                this.restartDownloadManagerDownload(downloadManager);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_INITIATED);
        } else if (n == 50) {
            System.out.println("stateChanged(STATE_DOWNLOADING)");
        } else if (n == 40) {
            System.out.println("stateChanged(STATE_READY)");
            downloadManager.startDownload();
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_DOWNLOADING);
        }
    }

    public void downloadComplete(DownloadManager downloadManager) {
        System.out.println("HostilesUpdater.downloadComplete()!!!!");
        FrostWireUtils.printDownloadManagerStatus(this._manager);
        File file = null;
        try {
            file = new File(this.getAppSpecialShareFolder(), "hostiles.txt." + this._hostilesMetaData.get_version() + ".zip");
            if (file.exists()) {
                this.postProcessMessage(true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
        }
    }
}

