/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.updates;

import com.frostwire.updates.UpdateManager;
import com.limegroup.gnutella.security.SHA1;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;

public final class UpdateMessage
implements Serializable {
    private int _hashCode = -1;
    public static final long serialVersionUID = 44L;
    private String _message;
    private String _url;
    private String _messageType;
    private String _version = null;
    private Date _expiration = null;
    private String _torrent = null;
    private String _os = null;
    private String _showOnce = "false";
    private String _src = "";
    private boolean _intro = false;
    private String _lang = "en";
    private String _md5 = "";

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String string) {
        this._message = string;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String string) {
        this._url = string;
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String string) {
        this._src = string;
    }

    public void setIntro(boolean bl) {
        this._intro = bl;
    }

    public boolean isIntro() {
        return this._intro;
    }

    public String getLanguage() {
        return this._lang;
    }

    public void setLanguage(String string) {
        this._lang = string;
    }

    public String getRemoteMD5() {
        return this._md5;
    }

    public void setRemoteMD5(String string) {
        this._md5 = string.toUpperCase();
    }

    public String getMessageType() {
        return this._messageType;
    }

    public String getOs() {
        return this._os;
    }

    public void setOs(String string) {
        this._os = null;
        if (string != null) {
            if ((string = string.trim()).equalsIgnoreCase("windows") || string.equalsIgnoreCase("linux") || string.equalsIgnoreCase("mac")) {
                this._os = string.toLowerCase();
            } else if (string.equals("*")) {
                this._os = null;
            }
        }
    }

    public String getTorrent() {
        return this._torrent;
    }

    public void setTorrent(String string) {
        this._torrent = string;
    }

    public void setMessageType(String string) {
        boolean bl;
        String string2 = string.toLowerCase().trim();
        boolean bl2 = bl = string2.equals("update") || string2.equals("announcement") || string2.equals("overlay") || string2.equals("hostiles") || string2.equals("chat_server");
        if (string == null || !bl) {
            this._messageType = new String("update");
            return;
        }
        this._messageType = string.toLowerCase();
    }

    public Date getExpiration() {
        return this._expiration;
    }

    public void setExpiration(Date date) {
        this._expiration = date;
    }

    public void setExpiration(String string) {
        if (string == null || string.equals("0")) {
            this._expiration = null;
            return;
        }
        try {
            this._expiration = new Date(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Expiration passed cannot be converted to a long");
            this._expiration = null;
        }
    }

    public boolean hasExpired() {
        if (this.getExpiration() == null) {
            return false;
        }
        long l = UpdateManager.getInstance().getServerTime().getTime();
        long l2 = this._expiration.getTime();
        return l2 < l;
    }

    public String getVersion() {
        if (this._version != null && this._version.equals("")) {
            this._version = null;
        }
        return this._version;
    }

    public void setVersion(String string) {
        this._version = string;
    }

    public boolean isShownOnce() {
        return this._showOnce.equalsIgnoreCase("true");
    }

    public void setShowOnce(String string) {
        if (string != null) {
            this._showOnce = string;
        }
    }

    public UpdateMessage(String string, String string2) {
        this.setMessageType(string);
        this.setMessage(string2);
    }

    public boolean equals(Object object) {
        return object.hashCode() == this.hashCode() && this.isIntro() == ((UpdateMessage)object).isIntro();
    }

    public int hashCode() {
        if (this._hashCode <= 0) {
            SHA1 sHA1 = new SHA1();
            String string = this._message + this._url + this._messageType + this._version + this._torrent + this._os + this._showOnce;
            sHA1.update(string.getBytes());
            byte[] byArray = sHA1.digest();
            this._hashCode = 0;
            for (byte by : byArray) {
                this._hashCode += Math.abs(by);
            }
        }
        return this._hashCode;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append("UpdateMessage @" + String.valueOf(super.hashCode()));
        stringBuffer.append("{");
        stringBuffer.append("_hashCode : " + String.valueOf(this.hashCode()) + ", \n");
        stringBuffer.append("_message : " + this.getMessage() + ", \n");
        stringBuffer.append("_url : " + this.getUrl() + ", \n");
        stringBuffer.append("_messageType : " + this.getMessageType() + ", \n");
        stringBuffer.append("_version : " + this.getVersion() + ", \n");
        stringBuffer.append("_expiration : " + String.valueOf(this.getExpiration()) + ", \n");
        stringBuffer.append("_torrent : " + this.getTorrent() + ", \n");
        stringBuffer.append("_os : " + this.getOs() + ", \n");
        stringBuffer.append("_language : " + this.getLanguage() + ", \n");
        stringBuffer.append("_applanguage : " + ApplicationSettings.getLanguage() + ", \n");
        stringBuffer.append("_showOnce : " + this.isShownOnce() + ", \n");
        stringBuffer.append("_isIntro : " + this.isIntro() + ", \n");
        stringBuffer.append("_md5 : " + this.getRemoteMD5() + ", \n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

