/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.updates;

import com.frostwire.gnutella.gui.actions.BuyAction;
import com.frostwire.httpconnection.HttpURLFWConnection;
import com.frostwire.updates.HostilesUpdater;
import com.frostwire.updates.UpdateManager;
import com.frostwire.updates.UpdateMessage;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import org.limewire.util.OSUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdateMessageReader
implements ContentHandler {
    public HashSet<UpdateMessage> _announcements = null;
    public UpdateMessage _bufferMessage = null;
    private Thread _hostileUpdaterWorkerThread;
    public boolean _introloaded = false;
    public boolean _otherloaded = false;
    public LinkedList<UpdateMessage> _overlays = null;
    public UpdateMessage _updateMessage = null;
    public String _updateURL = "http://update.frostwire.com";
    public String _updateServer = "";
    private HostilesUpdater HOSTILES_UPDATER = null;

    public void addAnnouncement(UpdateMessage updateMessage) {
        if (this._announcements == null) {
            this._announcements = new HashSet();
        }
        if (updateMessage.getMessageType().equals("announcement") && !updateMessage.hasExpired()) {
            this._announcements.add(updateMessage);
        }
    }

    public void addOverlay(UpdateMessage updateMessage) {
        if (updateMessage != null && updateMessage.getMessageType().equals("overlay")) {
            if (this._overlays == null) {
                this._overlays = new LinkedList();
            }
            if (!this._overlays.isEmpty()) {
                for (UpdateMessage updateMessage2 : this._overlays) {
                    if (updateMessage2.isIntro() != updateMessage.isIntro()) continue;
                    this._overlays.remove(updateMessage2);
                    this._overlays.add(updateMessage);
                    return;
                }
            }
            this._overlays.add(updateMessage);
        } else {
            System.out.println("UpdateManager.addOverlay() - The message given wasn't good.");
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!this.isMessageForMe(this._bufferMessage)) {
            this._bufferMessage = null;
            return;
        }
        if (this._bufferMessage != null && string2.equalsIgnoreCase("message")) {
            if (this._bufferMessage.getMessageType().equalsIgnoreCase("update")) {
                this.setUpdateMessage(this._bufferMessage);
            } else if (this._bufferMessage.getMessageType().equalsIgnoreCase("announcement")) {
                this.addAnnouncement(this._bufferMessage);
            } else if (this._bufferMessage.getMessageType().equalsIgnoreCase("overlay")) {
                this.addOverlay(this._bufferMessage);
            } else if (this._bufferMessage.getMessageType().equalsIgnoreCase("hostiles") && FilterSettings.USE_NETWORK_FILTER.getValue()) {
                this.HOSTILES_UPDATER = HostilesUpdater.getInstance();
                class HostileUpdaterWorker
                implements Runnable {
                    private UpdateMessage _hostilesMessage;

                    public HostileUpdaterWorker(UpdateMessage updateMessage) {
                        this._hostilesMessage = updateMessage;
                    }

                    public void run() {
                        UpdateMessageReader.this.HOSTILES_UPDATER.processMessage(this._hostilesMessage);
                        System.out.println("HostileUpdaterWorker ending now.");
                    }
                }
                HostileUpdaterWorker hostileUpdaterWorker = new HostileUpdaterWorker(this._bufferMessage);
                this._hostileUpdaterWorkerThread = new Thread((Runnable)hostileUpdaterWorker, "HostileUpdater Worker");
                this._hostileUpdaterWorkerThread.start();
                System.out.println("HostileUpdaterWorker starting now.");
            }
            this._bufferMessage = null;
        }
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    public HashSet<UpdateMessage> getAnnouncements() {
        return this._announcements;
    }

    public LinkedList<UpdateMessage> getOverlays() {
        return this._overlays;
    }

    public UpdateMessage getUpdateMessage() {
        return this._updateMessage;
    }

    public String getUpdateURL() {
        return this._updateURL;
    }

    public boolean hasAnnouncements() {
        return this._announcements != null && this._announcements.size() > 0;
    }

    public boolean hasOverlays() {
        return this._overlays != null && this._overlays.size() > 0;
    }

    public boolean hasUpdateMessage() {
        return this._updateMessage != null;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public boolean isIntroLoaded() {
        return this._introloaded;
    }

    private boolean isMessageEligibleForMyLang(UpdateMessage updateMessage) {
        String string = updateMessage.getLanguage();
        if (string == null) {
            return true;
        }
        String string2 = ApplicationSettings.getLanguage().toLowerCase();
        if (string.length() == 2) {
            return string2.toLowerCase().startsWith(string.toLowerCase());
        }
        if (string.endsWith("*")) {
            string2 = ApplicationSettings.getLanguage().substring(0, 2);
            string = string.substring(0, string.indexOf("*"));
        }
        return string.equalsIgnoreCase(string2);
    }

    private boolean isMessageEligibleForMyOs(UpdateMessage updateMessage) {
        if (updateMessage.getOs() == null) {
            return true;
        }
        boolean bl = updateMessage.getOs().equals("mac") && OSUtils.isMacOSX();
        boolean bl2 = updateMessage.getOs().equals("windows") && (OSUtils.isWindows() || OSUtils.isWindowsXP() || OSUtils.isWindowsNT() || OSUtils.isWindows98() || OSUtils.isWindows95() || OSUtils.isWindowsMe() || OSUtils.isWindowsVista());
        boolean bl3 = updateMessage.getOs().equals("linux") && OSUtils.isLinux();
        return bl || bl2 || bl3;
    }

    private boolean isMessageEligibleForMyVersion(UpdateMessage updateMessage) {
        if (updateMessage.getVersion() == null || updateMessage.getMessageType().equalsIgnoreCase("update")) {
            return true;
        }
        return !UpdateManager.isFrostWireOld(updateMessage.getVersion());
    }

    private boolean isMessageForMe(UpdateMessage updateMessage) {
        if (updateMessage == null) {
            return false;
        }
        return this.isMessageEligibleForMyOs(updateMessage) && this.isMessageEligibleForMyLang(updateMessage) && this.isMessageEligibleForMyVersion(updateMessage);
    }

    public boolean isOtherLoaded() {
        return this._otherloaded;
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void readUpdateFile() {
        HttpURLConnection httpURLConnection = null;
        InputSource inputSource = null;
        try {
            String string = "FrostWire/" + OSUtils.getOS() + "/" + LimeWireUtils.getLimeWireVersion();
            httpURLConnection = (HttpURLConnection)new URL(this.getUpdateURL()).openConnection();
            String string2 = this.getUpdateURL();
            System.out.println("Reading update file from " + string2);
            httpURLConnection.setRequestProperty("User-Agent", string);
            httpURLConnection.setRequestProperty("Connection", "close");
            httpURLConnection.setReadTimeout(10000);
            if (httpURLConnection.getResponseCode() >= 400) {
                httpURLConnection.disconnect();
                return;
            }
            inputSource = new InputSource(httpURLConnection.getInputStream());
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
            xMLReader.setContentHandler(this);
            xMLReader.parse(inputSource);
            httpURLConnection.getInputStream().close();
            httpURLConnection.disconnect();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            System.out.println("UpdateMessageReadre.readUpdateFile() Socket Timeout Exeception " + socketTimeoutException.toString());
        }
        catch (IOException iOException) {
            System.out.println("UpdateMessageReader.readUpdateFile() IO exception " + iOException.toString());
        }
        catch (SAXException sAXException) {
            System.out.println("UpdateMessageReader.readUpdateFile() SAX exception " + sAXException.toString());
        }
    }

    public void readUpdateFileNonBlocking() {
        Object var1_1 = null;
        Object var2_2 = null;
        try {
            String string = "FrostWire/" + OSUtils.getOS() + "/" + LimeWireUtils.getLimeWireVersion();
            HttpURLFWConnection httpURLFWConnection = new HttpURLFWConnection();
            this._updateServer = this._updateURL.substring(7);
            boolean bl = httpURLFWConnection.updateHttpTask(this._updateServer, string);
            if (!bl) {
                return;
            }
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
            xMLReader.setContentHandler(this);
            xMLReader.parse(this._updateURL);
        }
        catch (IOException iOException) {
            System.out.println("UpdateMessageReader.readUpdateFile() IO exception " + iOException.toString());
        }
        catch (SAXException sAXException) {
            System.out.println("UpdateMessageReader.readUpdateFile() SAX exception " + sAXException.toString());
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    public void setUpdateMessage(UpdateMessage updateMessage) {
        if (this._updateMessage == null && updateMessage != null && updateMessage.getMessageType().equals("update")) {
            this._updateMessage = updateMessage;
        }
    }

    public void setUpdateURL(String string) {
        this._updateURL = string == null ? "http://update.frostwire.com" : string;
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equalsIgnoreCase("update")) {
            UpdateManager.getInstance().setServerTime(attributes.getValue("time"));
            if (attributes.getValue("buyUrl") != null) {
                BuyAction.setRedirectUrl(attributes.getValue("buyUrl"));
            }
        } else if (string2.equalsIgnoreCase("message")) {
            String string4 = attributes.getValue("type");
            String string5 = attributes.getValue("value");
            String string6 = attributes.getValue("url");
            String string7 = attributes.getValue("torrent");
            String string8 = attributes.getValue("os");
            String string9 = attributes.getValue("showOnce");
            String string10 = attributes.getValue("version");
            String string11 = attributes.getValue("src");
            this._bufferMessage = new UpdateMessage(string4, string5);
            this._bufferMessage.setUrl(string6);
            this._bufferMessage.setTorrent(string7);
            this._bufferMessage.setOs(string8);
            this._bufferMessage.setShowOnce(string9);
            this._bufferMessage.setVersion(string10);
            if (this._bufferMessage.getMessageType().equalsIgnoreCase("announcement")) {
                this._bufferMessage.setExpiration(attributes.getValue("expiration"));
            }
            if (this._bufferMessage.getMessageType().equalsIgnoreCase("chat_server")) {
                ChatSettings.CHAT_SERVER.setValue(string5);
                ChatSettings.instance().save();
            }
            if (this._bufferMessage.getMessageType().equalsIgnoreCase("overlay")) {
                this._bufferMessage.setSrc(string11);
                if (attributes.getValue("intro") != null && (attributes.getValue("intro").equals("1") || attributes.getValue("intro").equalsIgnoreCase("true") || attributes.getValue("intro").equalsIgnoreCase("yes"))) {
                    this._bufferMessage.setIntro(true);
                } else {
                    this._bufferMessage.setIntro(false);
                }
                if (attributes.getValue("language") != null) {
                    this._bufferMessage.setLanguage(attributes.getValue("language"));
                }
                if (attributes.getValue("md5") != null) {
                    this._bufferMessage.setRemoteMD5(attributes.getValue("md5"));
                }
            }
            if (this._bufferMessage.getMessageType().equalsIgnoreCase("hostiles") && attributes.getValue("md5") != null) {
                this._bufferMessage.setRemoteMD5(attributes.getValue("md5"));
            }
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }
}

