/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import org.limewire.collection.LongInterval;
import org.limewire.collection.Range;

public class BTInterval
extends LongInterval {
    private static final long serialVersionUID = 6565199693843714608L;
    private final int blockId;
    private int hashCode;

    public BTInterval(long l, long l2, int n) {
        super(l, l2);
        if (n < 0) {
            throw new IllegalArgumentException("negative id");
        }
        this.blockId = n;
    }

    public BTInterval(Range range, int n) {
        this(range.getLow(), range.getHigh(), n);
    }

    public BTInterval(long l, int n) {
        super(l);
        this.blockId = n;
    }

    public int getId() {
        return this.blockId;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BTInterval)) {
            return false;
        }
        BTInterval bTInterval = (BTInterval)object;
        if (this.getId() != bTInterval.getId()) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 17 * this.getId();
            this.hashCode = (int)((long)this.hashCode * (37L + this.getLow()));
            this.hashCode = (int)((long)this.hashCode * (37L + this.getHigh()));
        }
        return this.hashCode;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public String toString() {
        return this.getId() + ":" + super.toString();
    }

    public int get32BitLow() {
        return BTInterval.get32Bit(this.getLow());
    }

    public int get32BitHigh() {
        return BTInterval.get32Bit(this.getHigh());
    }

    public int get32BitLength() {
        long l = this.getHigh() - this.getLow() + 1L;
        return BTInterval.get32Bit(l);
    }

    private static int get32Bit(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE + (int)(l - Integer.MAX_VALUE);
        }
        return (int)l;
    }
}

