/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTChannelWriter;
import com.limegroup.bittorrent.PieceSendListener;
import com.limegroup.bittorrent.messages.BTMessage;
import com.limegroup.gnutella.BandwidthManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Periodic;
import org.limewire.nio.channel.DelayedBufferWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.channel.ThrottleWriter;
import org.limewire.nio.observer.IOErrorObserver;
import org.limewire.nio.timeout.StalledUploadWatchdog;
import org.limewire.util.BufferUtils;

public class BTMessageWriter
implements BTChannelWriter {
    private static final Log LOG = LogFactory.getLog(BTMessageWriter.class);
    private static final long MAX_PIECE_SEND_TIME = 60000L;
    private static final ByteBuffer KEEP_ALIVE = ByteBuffer.allocate(4).asReadOnlyBuffer();
    private final ByteBuffer myKeepAlive = KEEP_ALIVE.duplicate();
    private InterestWritableByteChannel _channel;
    private final ByteBuffer[] _out = new ByteBuffer[2];
    private final LinkedList<BTMessage> _queue = new LinkedList();
    private final IOErrorObserver ioxObserver;
    private final PieceSendListener pieceListener;
    private volatile boolean shutdown;
    private BTMessage currentMessage;
    private boolean needsFlush;
    private DelayedBufferWriter delayer;
    private StalledUploadWatchdog watchdog;
    private Periodic keepAliveSender;
    private int keepAliveInterval;
    private volatile ScheduledExecutorService scheduler;

    public BTMessageWriter(IOErrorObserver iOErrorObserver, PieceSendListener pieceSendListener) {
        this.ioxObserver = iOErrorObserver;
        this.pieceListener = pieceSendListener;
        this._out[0] = ByteBuffer.allocate(5);
        this._out[1] = BufferUtils.getEmptyBuffer();
        this.myKeepAlive.flip();
    }

    public void init(ScheduledExecutorService scheduledExecutorService, int n, BandwidthManager bandwidthManager) {
        ThrottleWriter throttleWriter = new ThrottleWriter(bandwidthManager.getWriteThrottle());
        this.delayer = new DelayedBufferWriter(1400, 3000L);
        this._channel = throttleWriter;
        this.delayer.setWriteChannel(throttleWriter);
        this.keepAliveSender = new Periodic(new Runnable(){

            public void run() {
                BTMessageWriter.this.sendKeepAlive();
            }
        }, scheduledExecutorService);
        this.keepAliveInterval = n;
        this.keepAliveSender.rescheduleIfLater(n);
        this.scheduler = scheduledExecutorService;
    }

    public boolean handleWrite() throws IOException {
        if (this.shutdown) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("entering handleWrite call to " + this);
        }
        int n = 0;
        while (true) {
            if (this.myKeepAlive.hasRemaining()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("sending a keepalive on " + this);
                }
                n += this.delayer.write(this.myKeepAlive);
                if (this.myKeepAlive.hasRemaining()) {
                    return true;
                }
                this.needsFlush = true;
            }
            if (this._out[1].remaining() == 0) {
                this.currentMessage = null;
                this._out[1] = BufferUtils.getEmptyBuffer();
                if (!this.sendNextMessage()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("no more messages to send on " + this + " needs flush " + this.needsFlush);
                    }
                    if (this.needsFlush) {
                        this.needsFlush = !this.delayer.flush();
                    }
                    this.delayer.interestWrite(this, this.needsFlush);
                    return false;
                }
            }
            n = this.delayer.write(this._out[0]);
            n += this.delayer.write(this._out[1]);
            if (!this._out[1].hasRemaining()) {
                this.messageSent(this.currentMessage);
            }
            if (n <= 0) break;
            this.count(n);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("wrote " + n + " bytes");
        }
        return true;
    }

    private void sendKeepAlive() {
        if (this._queue.isEmpty() && this._out[1] == null) {
            this.myKeepAlive.clear();
            this.delayer.interestWrite(this, true);
        }
    }

    public void enqueue(BTMessage bTMessage) {
        this.keepAliveSender.rescheduleIfLater(this.keepAliveInterval);
        this._queue.addLast(bTMessage);
        this.messageArrived(bTMessage);
        if (LOG.isDebugEnabled()) {
            LOG.debug("enqueing message of type " + bTMessage.getType() + " to " + this + " : " + bTMessage.toString());
        }
        if (this.myKeepAlive.remaining() == 4) {
            this.myKeepAlive.limit(0);
        }
        this.delayer.interestWrite(this, true);
    }

    private void messageArrived(BTMessage bTMessage) {
        if (this.isPiece(bTMessage)) {
            if (this.watchdog == null) {
                assert (this.scheduler != null) : "message arrived before writer inited";
                this.watchdog = new StalledUploadWatchdog(60000L, this.scheduler);
            }
            this.watchdog.activate(this);
        }
    }

    private void messageSent(BTMessage bTMessage) {
        if (bTMessage.isUrgent()) {
            this.needsFlush = true;
        }
        if (this.isPiece(bTMessage)) {
            this.watchdog.deactivate();
            this.pieceListener.pieceSent();
        }
    }

    private boolean isPiece(BTMessage bTMessage) {
        return bTMessage.getType() == 7;
    }

    public void handleIOException(IOException iOException) {
        this.ioxObserver.handleIOException(iOException);
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.keepAliveSender.unschedule();
        if (this.watchdog != null) {
            this.watchdog.deactivate();
        }
        this.ioxObserver.shutdown();
    }

    public void setWriteChannel(InterestWritableByteChannel interestWritableByteChannel) {
        this._channel = interestWritableByteChannel;
        this.delayer.setWriteChannel(interestWritableByteChannel);
    }

    public InterestWritableByteChannel getWriteChannel() {
        return this._channel;
    }

    private void count(int n) {
        this.pieceListener.wroteBytes(n);
    }

    private boolean sendNextMessage() {
        if (this._queue.isEmpty()) {
            return false;
        }
        this.currentMessage = this._queue.removeFirst();
        if (LOG.isDebugEnabled()) {
            LOG.debug("sending message " + this.currentMessage + " on " + this);
        }
        this._out[1] = this.currentMessage.getPayload();
        this._out[0].clear();
        this._out[0].order(ByteOrder.BIG_ENDIAN);
        this._out[0].putInt(this._out[1].remaining() + 1);
        this._out[0].put(this.currentMessage.getType());
        this._out[0].flip();
        return true;
    }

    public String toString() {
        return "BTMessageWriter for " + this.pieceListener;
    }
}

