/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTData;
import com.limegroup.bittorrent.TorrentFile;
import com.limegroup.bittorrent.ValueException;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.downloader.serial.TorrentFileSystemMemento;
import com.limegroup.gnutella.downloader.serial.TorrentFileSystemMementoImpl;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.limewire.collection.MultiCollection;
import org.limewire.util.Base32;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorrentFileSystem {
    private final String _name;
    private final long _totalSize;
    private final List<TorrentFile> _files;
    private final List<TorrentFile> _unmodFiles;
    private final Collection<File> _folders = new HashSet<File>();
    private Collection<File> _filesAndFolders;
    private final File _incompleteFile;
    private File _completeFile;

    public TorrentFileSystem(TorrentFileSystemMemento torrentFileSystemMemento) {
        this._name = torrentFileSystemMemento.getName();
        this._totalSize = torrentFileSystemMemento.getTotalSize();
        this._files = torrentFileSystemMemento.getFiles();
        this._unmodFiles = Collections.unmodifiableList(this._files);
        this._folders.addAll(torrentFileSystemMemento.getFolders());
        this._incompleteFile = torrentFileSystemMemento.getIncompleteFile();
        this._completeFile = torrentFileSystemMemento.getCompleteFile();
    }

    TorrentFileSystem(BTData bTData, int n, long l, byte[] byArray) throws IOException {
        this._name = CommonUtils.convertFileName(bTData.getName());
        if (this._name.length() == 0) {
            throw new ValueException("bad torrent name");
        }
        this._incompleteFile = new File(SharingSettings.INCOMPLETE_DIRECTORY.getValue(), Base32.encode(byArray) + File.separator + this._name);
        this._completeFile = new File(SharingSettings.getSaveDirectory(this._name), this._name);
        if (!FileUtils.isReallyParent(SharingSettings.getSaveDirectory(this._name), this._completeFile)) {
            throw new SaveLocationException(1, this._completeFile);
        }
        if (bTData.getFiles() != null) {
            List<BTData.BTFileData> list = bTData.getFiles();
            ArrayList<TorrentFile> arrayList = new ArrayList<TorrentFile>(list.size());
            for (BTData.BTFileData bTFileData : list) {
                TorrentFile torrentFile = new TorrentFile(bTFileData.getLength(), new File(this._completeFile, bTFileData.getPath()).getAbsolutePath());
                if (!FileUtils.isReallyInParentPath(this._completeFile, torrentFile)) {
                    throw new SaveLocationException(1, torrentFile);
                }
                arrayList.add(torrentFile);
            }
            if (list.size() == 0) {
                throw new ValueException("bad metainfo, no files!");
            }
            long l2 = 0L;
            for (TorrentFile object : arrayList) {
                object.setBegin((int)(l2 / l));
                object.setEnd((int)((l2 += object.length()) / l));
            }
            this._files = arrayList;
            if (bTData.getFolders() != null) {
                for (String string : bTData.getFolders()) {
                    this._folders.add(new File(this._completeFile, string));
                }
            }
            this._folders.add(this._completeFile);
        } else {
            TorrentFile torrentFile = new TorrentFile(bTData.getLength(), this._completeFile.getAbsolutePath());
            torrentFile.setBegin(0);
            torrentFile.setEnd(n);
            this._files = new ArrayList<TorrentFile>(1);
            this._files.add(torrentFile);
        }
        this._unmodFiles = Collections.unmodifiableList(this._files);
        this._totalSize = TorrentFileSystem.calculateTotalSize(this._files);
        if (this._totalSize <= 0L) {
            throw new ValueException("invalid size " + this._totalSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorrentFileSystemMemento toMemento() {
        HashSet<File> hashSet;
        ArrayList<TorrentFile> arrayList;
        TorrentFileSystemMementoImpl torrentFileSystemMementoImpl = new TorrentFileSystemMementoImpl();
        torrentFileSystemMementoImpl.setCompleteFile(this._completeFile);
        TorrentFileSystem torrentFileSystem = this;
        synchronized (torrentFileSystem) {
            arrayList = new ArrayList<TorrentFile>(this._files);
            hashSet = new HashSet<File>(this._folders);
        }
        torrentFileSystemMementoImpl.setFiles(arrayList);
        torrentFileSystemMementoImpl.setFolders(hashSet);
        torrentFileSystemMementoImpl.setIncompleteFile(this._incompleteFile);
        torrentFileSystemMementoImpl.setName(this._name);
        torrentFileSystemMementoImpl.setTotalSize(this._totalSize);
        return torrentFileSystemMementoImpl;
    }

    public long getTotalSize() {
        return this._totalSize;
    }

    public String getName() {
        return this._name;
    }

    public List<TorrentFile> getIncompleteFiles() {
        ArrayList<TorrentFile> arrayList = new ArrayList<TorrentFile>(this._files);
        this.updateReferences(this._incompleteFile, arrayList);
        return arrayList;
    }

    public List<TorrentFile> getFiles() {
        return this._unmodFiles;
    }

    public Collection<File> getFilesAndFolders() {
        if (this._filesAndFolders == null) {
            this._filesAndFolders = new MultiCollection<File>((Collection<File>)this._unmodFiles, Collections.unmodifiableCollection(this._folders));
        }
        return this._filesAndFolders;
    }

    public boolean conflicts(File file) {
        return this.getFilesAndFolders().contains(file);
    }

    public boolean conflictsIncomplete(File file) {
        return this.getBaseFile().getParentFile().equals(file);
    }

    public File getBaseFile() {
        return this._incompleteFile;
    }

    public File getCompleteFile() {
        return this._completeFile;
    }

    public void setCompleteFile(File file) {
        this.updateReferences(file, this._files);
        this.updateFolderReferences(file);
        this._completeFile = file;
    }

    private void updateReferences(File file, List<TorrentFile> list) {
        int n = this._completeFile.getAbsolutePath().length();
        String string = file.getAbsolutePath();
        for (int i = 0; i < list.size(); ++i) {
            TorrentFile torrentFile = list.get(i);
            TorrentFile torrentFile2 = new TorrentFile(torrentFile.length(), string + torrentFile.getPath().substring(n));
            torrentFile2.setBegin(torrentFile.getBegin());
            torrentFile2.setEnd(torrentFile.getEnd());
            list.set(i, torrentFile2);
        }
    }

    private synchronized void updateFolderReferences(File file) {
        int n = this._completeFile.getAbsolutePath().length();
        String string = file.getAbsolutePath();
        HashSet<File> hashSet = new HashSet<File>(this._folders.size());
        for (File file2 : this._folders) {
            hashSet.add(new File(string + file2.getPath().substring(n)));
        }
        this._folders.clear();
        this._folders.addAll(hashSet);
    }

    void moveToCompleteFolder() {
        File file = this._incompleteFile.getParentFile();
        boolean bl = this._incompleteFile.renameTo(this._completeFile);
        if (!bl && (bl = FileUtils.copy(this._incompleteFile, this._completeFile))) {
            this._incompleteFile.delete();
        }
        if (bl) {
            FileUtils.deleteRecursive(file);
        }
    }

    private static long calculateTotalSize(List<TorrentFile> list) {
        long l = 0L;
        for (TorrentFile torrentFile : list) {
            l += ((File)torrentFile).length();
        }
        return l;
    }
}

