/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.Torrent;
import com.limegroup.bittorrent.TorrentEvent;
import com.limegroup.bittorrent.TorrentEventListener;
import com.limegroup.bittorrent.TorrentFileSystem;
import com.limegroup.bittorrent.handshaking.IncomingConnectionHandler;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.EventDispatcher;
import java.io.File;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.net.ConnectionAcceptor;
import org.limewire.net.ConnectionDispatcher;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.util.FileLocker;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class TorrentManager
implements FileLocker,
ConnectionAcceptor,
TorrentEventListener,
EventDispatcher<TorrentEvent, TorrentEventListener> {
    private static final Log LOG = LogFactory.getLog(TorrentManager.class);
    private final Set<ManagedTorrent> _active = new HashSet<ManagedTorrent>();
    private final Set<ManagedTorrent> _seeding = new HashSet<ManagedTorrent>();
    private final Set<ManagedTorrent> _starting = new HashSet<ManagedTorrent>();
    private final List<TorrentEventListener> listeners = new CopyOnWriteArrayList<TorrentEventListener>();
    private final FileManager fileManager;
    private final ScheduledExecutorService threadPool;
    private final IncomingConnectionHandler incomingConnectionHandler;

    @Inject
    public TorrentManager(FileManager fileManager, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, IncomingConnectionHandler incomingConnectionHandler) {
        this.incomingConnectionHandler = incomingConnectionHandler;
        this.fileManager = fileManager;
        this.threadPool = scheduledExecutorService;
        this.listeners.add(this);
    }

    public void initialize(ConnectionDispatcher connectionDispatcher) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("initializing TorrentManager");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\u0013');
        stringBuilder.append("BitTorrent");
        connectionDispatcher.addConnectionAcceptor(this, false, stringBuilder.toString());
        FileUtils.addFileLocker(this);
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    private static int getMaxActiveTorrents() {
        if (OSUtils.isWindows() && !OSUtils.isGoodWindows()) {
            return 1;
        }
        int n = ConnectionSettings.CONNECTION_SPEED.getValue();
        if (n <= 56) {
            return 1;
        }
        if (n <= 350) {
            return 3;
        }
        if (n <= 1000) {
            return 3;
        }
        return 5;
    }

    public static int getMaxTorrentConnections() {
        if (OSUtils.isWindows() && !OSUtils.isGoodWindows()) {
            return 30;
        }
        if (ConnectionSettings.CONNECTION_SPEED.getValue() <= 56) {
            return 40;
        }
        return 150;
    }

    @Override
    public void addEventListener(TorrentEventListener torrentEventListener) {
        if (!this.listeners.add(torrentEventListener)) {
            throw new IllegalArgumentException("listener " + torrentEventListener + " already registered");
        }
    }

    @Override
    public void removeEventListener(TorrentEventListener torrentEventListener) {
        this.listeners.remove(torrentEventListener);
    }

    @Override
    public void dispatchEvent(TorrentEvent torrentEvent) {
        for (TorrentEventListener torrentEventListener : this.listeners) {
            if (torrentEventListener == torrentEvent.getSource()) continue;
            torrentEventListener.handleTorrentEvent(torrentEvent);
        }
    }

    @Override
    public void handleTorrentEvent(TorrentEvent torrentEvent) {
        if (torrentEvent.getSource() == this) {
            return;
        }
        ManagedTorrent managedTorrent = torrentEvent.getTorrent();
        switch (torrentEvent.getType()) {
            case STARTING: {
                this.torrentStarting(managedTorrent);
                break;
            }
            case STARTED: {
                this.torrentStarted(managedTorrent);
                break;
            }
            case DOWNLOADING: {
                this.shareTorrent(managedTorrent);
                break;
            }
            case STOPPED: {
                this.torrentStopped(managedTorrent);
                break;
            }
            case COMPLETE: {
                this.torrentComplete(managedTorrent);
                break;
            }
        }
    }

    public synchronized ManagedTorrent getTorrentForHash(byte[] byArray) {
        for (ManagedTorrent managedTorrent : this._active) {
            if (!Arrays.equals(managedTorrent.getInfoHash(), byArray)) continue;
            return managedTorrent;
        }
        return null;
    }

    @Override
    public void acceptConnection(String string, Socket socket) {
        this.incomingConnectionHandler.handleIncoming((AbstractNBSocket)socket, this);
    }

    private synchronized void torrentComplete(ManagedTorrent managedTorrent) {
        assert (this._active.contains(managedTorrent));
        this._seeding.add(managedTorrent);
    }

    private synchronized void torrentStarting(ManagedTorrent managedTorrent) {
        this._starting.add(managedTorrent);
    }

    private synchronized void torrentStarted(ManagedTorrent managedTorrent) {
        if (this._starting.contains(managedTorrent)) {
            this._starting.remove(managedTorrent);
        }
        if (this._seeding.remove(managedTorrent)) {
            this._active.remove(managedTorrent);
        }
        if (this._active.size() >= TorrentManager.getMaxActiveTorrents()) {
            ManagedTorrent managedTorrent2 = null;
            for (ManagedTorrent managedTorrent3 : this._seeding) {
                if (managedTorrent2 != null && !(managedTorrent3.getRatio() > managedTorrent2.getRatio())) continue;
                managedTorrent2 = managedTorrent3;
            }
            if (managedTorrent2 != null) {
                managedTorrent2.stop();
            }
        }
        this._active.add(managedTorrent);
    }

    private synchronized void torrentStopped(ManagedTorrent managedTorrent) {
        this._active.remove(managedTorrent);
        this.unshareTorrent(managedTorrent, this._seeding.remove(managedTorrent));
    }

    public synchronized boolean allowNewTorrent() {
        return this._starting.size() + this._active.size() - this._seeding.size() < TorrentManager.getMaxActiveTorrents();
    }

    public synchronized int getNumActiveTorrents() {
        return this._active.size();
    }

    synchronized boolean hasNonSeeding() {
        return this._active.size() > this._seeding.size();
    }

    @Override
    public boolean releaseLock(File file) {
        return this.killTorrentForFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean killTorrentForFile(File file) {
        ManagedTorrent managedTorrent = null;
        TorrentManager torrentManager = this;
        synchronized (torrentManager) {
            for (ManagedTorrent managedTorrent2 : this._active) {
                TorrentFileSystem torrentFileSystem = managedTorrent2.getMetaInfo().getFileSystem();
                if (!torrentFileSystem.conflicts(file) && !torrentFileSystem.conflictsIncomplete(file)) continue;
                managedTorrent = managedTorrent2;
                break;
            }
        }
        if (managedTorrent != null) {
            managedTorrent.stop();
            return true;
        }
        return false;
    }

    private synchronized void shareTorrent(ManagedTorrent managedTorrent) {
        if (!SharingSettings.SHARE_TORRENT_META_FILES.getValue() || managedTorrent.getMetaInfo().isPrivate()) {
            return;
        }
        final File file = this.getSharedTorrentMetaDataFile(managedTorrent.getMetaInfo());
        Runnable runnable = new Runnable(){

            public void run() {
                if (SharingUtils.isFilePhysicallyShareable(file)) {
                    TorrentManager.this.fileManager.addFileForSession(file);
                }
            }
        };
        this.threadPool.execute(runnable);
    }

    private synchronized void unshareTorrent(ManagedTorrent managedTorrent, boolean bl) {
        final File file = this.getSharedTorrentMetaDataFile(managedTorrent.getMetaInfo());
        final boolean bl2 = bl || managedTorrent.getState().equals((Object)Torrent.TorrentState.TRACKER_FAILURE);
        Runnable runnable = new Runnable(){

            public void run() {
                FileDesc fileDesc = TorrentManager.this.fileManager.stopSharingFile(file);
                if (fileDesc != null && bl2) {
                    FileUtils.delete(fileDesc.getFile(), false);
                } else {
                    file.setLastModified(System.currentTimeMillis());
                }
            }
        };
        this.threadPool.execute(runnable);
    }

    public File getSharedTorrentMetaDataFile(BTMetaInfo bTMetaInfo) {
        String string = bTMetaInfo.getFileSystem().getName().concat(".torrent");
        File file = new File(SharingUtils.APPLICATION_SPECIAL_SHARE, string);
        return file;
    }
}

