/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.disk;

import com.limegroup.bittorrent.disk.RAFDiskController;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MMDiskController<F extends File>
extends RAFDiskController<F> {
    private static final Log LOG = LogFactory.getLog(MMDiskController.class);
    private Map<RandomAccessFile, MappedByteBuffer> bufMap;

    @Override
    public synchronized List<F> open(List<F> list, boolean bl, boolean bl2) throws IOException {
        List<F> list2 = super.open(list, bl, bl2);
        this.bufMap = new HashMap<RandomAccessFile, MappedByteBuffer>(list.size());
        for (int i = 0; i < this._fos.length; ++i) {
            if (((File)this._files.get(i)).length() >= Integer.MAX_VALUE) continue;
            try {
                this.bufMap.put(this._fos[i], this._fos[i].getChannel().map(bl ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, ((File)this._files.get(i)).length()));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("mapped " + this._files.get(i));
                continue;
            }
            catch (IOException iOException) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("didn't map " + this._files.get(i), iOException);
            }
        }
        return list2;
    }

    @Override
    protected void writeImpl(RandomAccessFile randomAccessFile, long l, byte[] byArray, int n, int n2) throws IOException {
        MappedByteBuffer mappedByteBuffer = this.getBuf(randomAccessFile);
        if (mappedByteBuffer == null) {
            super.writeImpl(randomAccessFile, l, byArray, n, n2);
            return;
        }
        mappedByteBuffer.position((int)l);
        mappedByteBuffer.put(byArray, n, n2);
    }

    @Override
    protected int readImpl(RandomAccessFile randomAccessFile, long l, byte[] byArray, int n, int n2) throws IOException {
        MappedByteBuffer mappedByteBuffer = this.getBuf(randomAccessFile);
        if (mappedByteBuffer == null) {
            return super.readImpl(randomAccessFile, l, byArray, n, n2);
        }
        mappedByteBuffer.position((int)l);
        mappedByteBuffer.get(byArray, n, n2);
        return mappedByteBuffer.position() - (int)l;
    }

    private synchronized MappedByteBuffer getBuf(RandomAccessFile randomAccessFile) {
        return this.bufMap.get(randomAccessFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        LOG.debug("closing...");
        boolean bl = false;
        try {
            if (this.bufMap != null) {
                boolean bl2 = true;
                for (MappedByteBuffer mappedByteBuffer : this.bufMap.values()) {
                    this.safeForce(mappedByteBuffer);
                    bl2 = bl2 && MMDiskController.clean(mappedByteBuffer);
                }
                bl = bl2;
            }
        }
        finally {
            if (this.bufMap != null) {
                this.bufMap.clear();
            }
            if (!bl) {
                System.gc();
            }
            super.close();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.bufMap == null) {
            return;
        }
        for (MappedByteBuffer mappedByteBuffer : this.bufMap.values()) {
            mappedByteBuffer.force();
        }
        super.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized RandomAccessFile setReadOnly(RandomAccessFile randomAccessFile, String string) throws IOException {
        MappedByteBuffer mappedByteBuffer = this.bufMap.remove(randomAccessFile);
        try {
            this.safeForce(mappedByteBuffer);
        }
        finally {
            if (!MMDiskController.clean(mappedByteBuffer)) {
                mappedByteBuffer = null;
                System.gc();
            }
        }
        randomAccessFile = super.setReadOnly(randomAccessFile, string);
        mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, randomAccessFile.length());
        this.bufMap.put(randomAccessFile, mappedByteBuffer);
        return randomAccessFile;
    }

    private void safeForce(MappedByteBuffer mappedByteBuffer) {
        try {
            mappedByteBuffer.force();
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                return;
            }
            RuntimeException runtimeException = exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
            throw runtimeException;
        }
    }

    public static boolean clean(final Object object) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Method method = object.getClass().getMethod("cleaner", new Class[0]);
                    if (method == null) {
                        return false;
                    }
                    method.setAccessible(true);
                    Object object2 = method.invoke(object, new Object[0]);
                    if (object2 == null) {
                        return false;
                    }
                    Method method2 = object2.getClass().getMethod("clean", new Class[0]);
                    method2.invoke(object2, new Object[0]);
                    return true;
                }
                catch (SecurityException securityException) {
                    LOG.warn("security", securityException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    LOG.warn("invocation", invocationTargetException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    LOG.warn("no method", noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOG.warn("illegal access", illegalAccessException);
                }
                return false;
            }
        });
    }
}

