/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.gui;

import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.TorrentEvent;
import com.limegroup.bittorrent.TorrentEventListener;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.util.EventDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorrentUploadCanceller
implements TorrentEventListener {
    private final EventDispatcher<TorrentEvent, TorrentEventListener> dispatcher;

    public static void createAndRegister(EventDispatcher<TorrentEvent, TorrentEventListener> eventDispatcher) {
        TorrentUploadCanceller torrentUploadCanceller = new TorrentUploadCanceller(eventDispatcher);
        eventDispatcher.addEventListener(torrentUploadCanceller);
    }

    private TorrentUploadCanceller(EventDispatcher<TorrentEvent, TorrentEventListener> eventDispatcher) {
        this.dispatcher = eventDispatcher;
    }

    @Override
    public void handleTorrentEvent(TorrentEvent torrentEvent) {
        if (torrentEvent.getType() != TorrentEvent.Type.STOP_REQUESTED) {
            return;
        }
        ManagedTorrent managedTorrent = torrentEvent.getTorrent();
        if (!managedTorrent.isActive()) {
            return;
        }
        boolean bl = true;
        if (!managedTorrent.isComplete()) {
            bl = GUIMediator.showYesNoMessage(I18n.tr("If you stop this upload, the torrent download will stop. Are you sure you want to do this?"), QuestionsHandler.TORRENT_STOP_UPLOAD, DialogOption.NO) == DialogOption.YES;
        } else if (managedTorrent.getRatio() < 1.0f) {
            boolean bl2 = bl = GUIMediator.showYesNoMessage(I18n.tr("This upload is a torrent and it hasn't seeded enough. You should let it upload some more. Are you sure you want to stop it?"), QuestionsHandler.TORRENT_SEED_MORE, DialogOption.NO) == DialogOption.YES;
        }
        if (bl && managedTorrent.isActive()) {
            this.dispatcher.dispatchEvent(new TorrentEvent(this, TorrentEvent.Type.STOP_APPROVED, managedTorrent));
        }
    }
}

