/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.gui.options.panes;

import com.limegroup.bittorrent.settings.BittorrentSettings;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.Line;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.limewire.collection.MultiIterable;
import org.limewire.i18n.I18nMarker;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.Setting;

public class BittorrentPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("BitTorrent Settings");
    public static final String LABEL = I18n.tr("You can choose whether or not FrostWire should manage your BitTorrent protocol settings. It is highly recommended that FrostWire manage these settings. Invalid or inappropriate values may cause severe performance and/or memory problems.");
    private final JCheckBox AUTO_CHECK_BOX = new JCheckBox();
    private WholeNumberField maxUploadsField = new SizedWholeNumberField(4);
    private WholeNumberField minUploadsField = new SizedWholeNumberField(4);
    private final JCheckBox FLUSH_CHECK_BOX = new JCheckBox();
    private final JCheckBox MMAP_CHECK_BOX = new JCheckBox();
    private Map<IntSetting, WholeNumberField> intSettingsMap = new HashMap<IntSetting, WholeNumberField>();
    private Map<BooleanSetting, JCheckBox> boolSettingsMap = new HashMap<BooleanSetting, JCheckBox>();
    private Iterable<Setting> settings = new MultiIterable<BooleanSetting>((Iterable<BooleanSetting>)this.intSettingsMap.keySet(), (Iterable<BooleanSetting>)this.boolSettingsMap.keySet());

    public BittorrentPaneItem() {
        super(TITLE, LABEL);
        this.AUTO_CHECK_BOX.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                boolean bl2 = bl = !BittorrentPaneItem.this.AUTO_CHECK_BOX.isSelected();
                if (bl) {
                    GUIMediator.showWarning(I18n.tr("Invalid or inappropriate custom values may cause severe performance and/or memory problems. Unless you really know what you're doing, it is highly recommended that you let FrostWire manage these settings."), QuestionsHandler.BITTORRENT_CUSTOM_SETTINGS);
                }
                BittorrentPaneItem.this.updateControls(bl);
            }
        });
        BoxPanel boxPanel = new BoxPanel();
        LabeledComponent labeledComponent = new LabeledComponent(I18nMarker.marktr("Let FrostWire manage my BitTorrent settings. (Recommended)"), this.AUTO_CHECK_BOX, 120, 10);
        boxPanel.add(labeledComponent.getComponent());
        boxPanel.addLineGap();
        boxPanel.add(this.createSeparator(labeledComponent.getComponent()));
        boxPanel.addLineGap();
        labeledComponent = new LabeledComponent(I18nMarker.marktr("Maximum uploads per torrent"), this.maxUploadsField, 120, 10);
        boxPanel.add(labeledComponent.getComponent());
        boxPanel.addVerticalComponentGap();
        labeledComponent = new LabeledComponent(I18nMarker.marktr("Minimum uploads per torrent"), this.minUploadsField, 120, 10);
        boxPanel.add(labeledComponent.getComponent());
        boxPanel.addVerticalComponentGap();
        labeledComponent = new LabeledComponent(I18nMarker.marktr("Safe chunk verification"), this.FLUSH_CHECK_BOX, 120, 10);
        boxPanel.add(labeledComponent.getComponent());
        boxPanel.addVerticalComponentGap();
        labeledComponent = new LabeledComponent(I18nMarker.marktr("Experimental disk access"), this.MMAP_CHECK_BOX, 120, 10);
        boxPanel.add(labeledComponent.getComponent());
        this.intSettingsMap.put(BittorrentSettings.TORRENT_MAX_UPLOADS, this.maxUploadsField);
        this.intSettingsMap.put(BittorrentSettings.TORRENT_MIN_UPLOADS, this.minUploadsField);
        this.boolSettingsMap.put(BittorrentSettings.TORRENT_FLUSH_VERIRY, this.FLUSH_CHECK_BOX);
        this.boolSettingsMap.put(BittorrentSettings.TORRENT_USE_MMAP, this.MMAP_CHECK_BOX);
        this.add(boxPanel);
    }

    private Component createSeparator(Component component) {
        Line line = new Line();
        line.setMinimumSize(new Dimension(component.getPreferredSize().width, 1));
        line.setPreferredSize(new Dimension(component.getPreferredSize().width, 1));
        line.setMaximumSize(new Dimension(component.getPreferredSize().width, 1));
        BoxPanel boxPanel = new BoxPanel(0);
        boxPanel.add(Box.createHorizontalGlue());
        boxPanel.add(line);
        return boxPanel;
    }

    private void updateControls(boolean bl) {
        this.maxUploadsField.setEnabled(bl);
        this.minUploadsField.setEnabled(bl);
        this.FLUSH_CHECK_BOX.setEnabled(bl);
        this.MMAP_CHECK_BOX.setEnabled(bl);
    }

    public boolean applyOptions() throws IOException {
        BittorrentSettings.AUTOMATIC_SETTINGS.setValue(this.AUTO_CHECK_BOX.isSelected());
        if (this.AUTO_CHECK_BOX.isSelected()) {
            for (Setting setting : this.settings) {
                setting.revertToDefault();
            }
        } else {
            for (IntSetting setting : this.intSettingsMap.keySet()) {
                setting.setValue(this.intSettingsMap.get(setting).getValue());
            }
            for (BooleanSetting booleanSetting : this.boolSettingsMap.keySet()) {
                booleanSetting.setValue(this.boolSettingsMap.get(booleanSetting).isSelected());
            }
        }
        return false;
    }

    public void initOptions() {
        boolean bl = BittorrentSettings.AUTOMATIC_SETTINGS.getValue();
        this.AUTO_CHECK_BOX.setSelected(bl);
        for (Map.Entry<IntSetting, WholeNumberField> entry : this.intSettingsMap.entrySet()) {
            entry.getValue().setValue(entry.getKey().getValue());
        }
        for (Map.Entry<Setting, JComponent> entry : this.boolSettingsMap.entrySet()) {
            ((JCheckBox)entry.getValue()).setSelected(((BooleanSetting)entry.getKey()).getValue());
        }
        this.updateControls(!bl);
    }

    public boolean isDirty() {
        if (this.AUTO_CHECK_BOX.isSelected() != BittorrentSettings.AUTOMATIC_SETTINGS.getValue()) {
            return false;
        }
        for (IntSetting setting : this.intSettingsMap.keySet()) {
            if (setting.getValue() == this.intSettingsMap.get(setting).getValue()) continue;
            return true;
        }
        for (BooleanSetting booleanSetting : this.boolSettingsMap.keySet()) {
            if (booleanSetting.getValue() == this.boolSettingsMap.get(booleanSetting).isSelected()) continue;
            return true;
        }
        return false;
    }
}

