/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.messages;

import com.limegroup.bittorrent.messages.BTMessage;
import com.limegroup.bittorrent.messages.BadBTMessageException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BTHave
extends BTMessage {
    private ByteBuffer _payload = null;
    private final int _pieceNum;

    public BTHave(int n) {
        super((byte)4);
        this._pieceNum = n;
    }

    public static BTHave readMessage(ByteBuffer byteBuffer) throws BadBTMessageException {
        if (byteBuffer.remaining() < 4) {
            throw new BadBTMessageException();
        }
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        int n = byteBuffer.getInt();
        if (n < 0) {
            throw new BadBTMessageException("invalid piece number in have message: " + n);
        }
        return new BTHave(n);
    }

    public int getPieceNum() {
        return this._pieceNum;
    }

    public ByteBuffer getPayload() {
        if (this._payload == null) {
            this._payload = ByteBuffer.allocate(4);
            this._payload.order(ByteOrder.BIG_ENDIAN);
            this._payload.putInt(this._pieceNum);
            this._payload = this._payload.asReadOnlyBuffer();
        }
        this._payload.clear();
        return this._payload;
    }

    public String toString() {
        return "BTHave (" + this._pieceNum + ")";
    }
}

