/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.reader;

import com.limegroup.bittorrent.BTInterval;
import com.limegroup.bittorrent.BTPiece;
import com.limegroup.bittorrent.messages.BadBTMessageException;
import com.limegroup.bittorrent.reader.BTDataSource;
import com.limegroup.bittorrent.reader.BTReadMessageState;
import com.limegroup.bittorrent.reader.ReaderData;
import org.limewire.collection.NECallable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PieceState
extends BTReadMessageState
implements NECallable<BTPiece> {
    private final int length;
    private final BTDataSource buf;
    private int chunkId = -1;
    private long offset = -1L;
    private long currentOffset;
    private BTInterval complete;
    private boolean welcome;
    private boolean writeExpected;

    PieceState(ReaderData readerData) {
        super(readerData);
        this.length = readerData.getLength();
        this.buf = readerData.getDataSource();
    }

    @Override
    public BTReadMessageState addData() throws BadBTMessageException {
        int n;
        if (this.writeExpected) {
            return null;
        }
        if (this.length < 9) {
            throw new BadBTMessageException("piece too short");
        }
        if (this.buf.size() < 4 && (this.chunkId < 0 || this.offset < 0L)) {
            return null;
        }
        if (this.chunkId < 0) {
            long l = this.buf.getInt();
            if (l > Integer.MAX_VALUE) {
                throw new BadBTMessageException("unsupported bit chunk id");
            }
            this.chunkId = (int)l;
            return this;
        }
        if (this.offset < 0L) {
            this.currentOffset = this.offset = this.buf.getInt();
            this.complete = new BTInterval(this.offset, this.offset + (long)this.length - 9L, this.chunkId);
            this.welcome = this.readerState.getHandler().startReceivingPiece(this.complete);
        }
        if ((n = this.getAmountLeft()) == 0) {
            return null;
        }
        if (this.welcome) {
            if (!this.writeExpected) {
                this.writeExpected = true;
                this.readerState.getHandler().handlePiece(this);
            }
        } else {
            this.buf.discard(n);
            this.currentOffset += (long)n;
            n = 0;
        }
        if (this.currentOffset + (long)n == this.complete.getHigh() + 1L) {
            this.readerState.getHandler().finishReceivingPiece();
            if (!this.writeExpected) {
                return this.readerState.getEntryState();
            }
        }
        return null;
    }

    public String toString() {
        return "Piece " + this.complete + " offset " + this.currentOffset + " welcome " + this.welcome + " write expected " + this.writeExpected;
    }

    private int getAmountLeft() {
        return (int)Math.min((long)this.buf.size(), this.complete.getHigh() - this.currentOffset + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BTPiece call() {
        ReaderData readerData = this.readerState;
        synchronized (readerData) {
            assert (this.writeExpected);
            this.writeExpected = false;
            int n = this.getAmountLeft();
            BTInterval bTInterval = new BTInterval(this.currentOffset, this.currentOffset + (long)n - 1L, this.chunkId);
            this.currentOffset += (long)n;
            this.readerState.getHandler().readBytes(n);
            byte[] byArray = new byte[n];
            this.buf.get(byArray);
            this.readerState.getPieceListener().dataConsumed(this.currentOffset > this.complete.getHigh());
            return new ReceivedPiece(bTInterval, byArray);
        }
    }

    private static class ReceivedPiece
    implements BTPiece {
        private final BTInterval interval;
        private final byte[] data;

        ReceivedPiece(BTInterval bTInterval, byte[] byArray) {
            this.interval = bTInterval;
            this.data = byArray;
        }

        public BTInterval getInterval() {
            return this.interval;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

