/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.BrowseHostHandlerManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.PushedSocketHandlerRegistry;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.messages.MessageFactory;
import java.io.IOException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.http.SocketWrappingHttpClient;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.net.SocketsManager;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class BrowseHostHandlerManagerImpl
implements BrowseHostHandlerManager {
    private static final Log LOG = LogFactory.getLog(BrowseHostHandlerManagerImpl.class);
    private final Map<GUID, BrowseHostHandler.PushRequestDetails> _pushedHosts = new HashMap<GUID, BrowseHostHandler.PushRequestDetails>();
    private final Provider<ActivityCallback> activityCallback;
    private final SocketsManager socketsManager;
    private final Provider<PushDownloadManager> pushDownloadManager;
    private final Provider<ReplyHandler> forMeReplyHandler;
    private final ScheduledExecutorService backgroundExecutor;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final MessageFactory messageFactory;
    private Provider<SocketWrappingHttpClient> clientProvider;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public BrowseHostHandlerManagerImpl(@Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<ActivityCallback> provider, SocketsManager socketsManager, Provider<PushDownloadManager> provider2, @Named(value="forMeReplyHandler") Provider<ReplyHandler> provider3, MessageFactory messageFactory, RemoteFileDescFactory remoteFileDescFactory, Provider<SocketWrappingHttpClient> provider4, NetworkInstanceUtils networkInstanceUtils) {
        this.activityCallback = provider;
        this.socketsManager = socketsManager;
        this.pushDownloadManager = provider2;
        this.forMeReplyHandler = provider3;
        this.messageFactory = messageFactory;
        this.backgroundExecutor = scheduledExecutorService;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.clientProvider = provider4;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public void initialize() {
        this.backgroundExecutor.scheduleWithFixedDelay(new Expirer(), 0L, 5000L, TimeUnit.MILLISECONDS);
    }

    @Inject
    public void register(PushedSocketHandlerRegistry pushedSocketHandlerRegistry) {
        pushedSocketHandlerRegistry.register(this);
    }

    @Override
    public BrowseHostHandler createBrowseHostHandler(GUID gUID, GUID gUID2) {
        return new BrowseHostHandler(gUID, gUID2, new BrowseHostHandlerManager.BrowseHostCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void putInfo(GUID gUID, BrowseHostHandler.PushRequestDetails pushRequestDetails) {
                Map map = BrowseHostHandlerManagerImpl.this._pushedHosts;
                synchronized (map) {
                    BrowseHostHandlerManagerImpl.this._pushedHosts.put(gUID, pushRequestDetails);
                }
            }
        }, this.activityCallback.get(), this.socketsManager, this.pushDownloadManager, this.forMeReplyHandler, this.messageFactory, this.remoteFileDescFactory, this.clientProvider, this.networkInstanceUtils);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptPushedSocket(String string, int n, byte[] byArray, Socket socket) {
        GUID gUID = new GUID(byArray);
        boolean bl = false;
        LOG.trace("BHH.handlePush(): entered.");
        BrowseHostHandler.PushRequestDetails pushRequestDetails = null;
        Object object = this._pushedHosts;
        synchronized (object) {
            pushRequestDetails = this._pushedHosts.remove(gUID);
        }
        if (pushRequestDetails != null) {
            object = pushRequestDetails;
            ThreadExecutor.startThread(new Runnable((BrowseHostHandler.PushRequestDetails)object, socket){
                final /* synthetic */ BrowseHostHandler.PushRequestDetails val$finalPRD;
                final /* synthetic */ Socket val$socket;
                {
                    this.val$finalPRD = pushRequestDetails;
                    this.val$socket = socket;
                }

                public void run() {
                    try {
                        this.val$finalPRD.getBrowseHostHandler().browseHost(this.val$socket);
                    }
                    catch (IOException iOException) {
                        LOG.debug("error while push transfer", iOException);
                        this.val$finalPRD.getBrowseHostHandler().failed();
                    }
                    catch (HttpException httpException) {
                        LOG.debug("error while push transfer", httpException);
                        this.val$finalPRD.getBrowseHostHandler().failed();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        LOG.debug("error while push transfer", uRISyntaxException);
                        this.val$finalPRD.getBrowseHostHandler().failed();
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.debug("error while push transfer", interruptedException);
                        this.val$finalPRD.getBrowseHostHandler().failed();
                    }
                }
            }, "BrowseHost");
            bl = true;
        } else {
            LOG.debug("BHH.handlePush(): no matching BHH.");
        }
        LOG.trace("BHH.handlePush(): returning.");
        return bl;
    }

    private class Expirer
    implements Runnable {
        private Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HashSet<GUID> hashSet = new HashSet<GUID>();
                Map map = BrowseHostHandlerManagerImpl.this._pushedHosts;
                synchronized (map) {
                    for (GUID gUID : BrowseHostHandlerManagerImpl.this._pushedHosts.keySet()) {
                        BrowseHostHandler.PushRequestDetails pushRequestDetails = (BrowseHostHandler.PushRequestDetails)BrowseHostHandlerManagerImpl.this._pushedHosts.get(gUID);
                        if (pushRequestDetails == null || !pushRequestDetails.isExpired()) continue;
                        LOG.debug("Expirer.run(): expiring a badboy.");
                        hashSet.add(gUID);
                        pushRequestDetails.getBrowseHostHandler().failed();
                    }
                    for (GUID gUID : hashSet) {
                        BrowseHostHandlerManagerImpl.this._pushedHosts.remove(gUID);
                    }
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
            }
        }
    }
}

