/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Provider;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BypassedResultsCache {
    static int MAX_BYPASSED_RESULTS = 150;
    private final Provider<? extends ActivityCallback> _callback;
    private final DownloadManager _downloadManager;
    private final Map<GUID, Set<GUESSEndpoint>> _bypassedResults = Collections.synchronizedMap(new HashMap());

    public BypassedResultsCache(Provider<? extends ActivityCallback> provider, DownloadManager downloadManager) {
        this._callback = provider;
        this._downloadManager = downloadManager;
    }

    void queryKilled(GUID gUID) {
        if (!this._downloadManager.isGuidForQueryDownloading(gUID)) {
            this._bypassedResults.remove(gUID);
        }
    }

    void downloadFinished(GUID gUID) {
        if (!this.isGUIDOfInterest(gUID)) {
            this._bypassedResults.remove(gUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<GUESSEndpoint> getQueryLocs(GUID gUID) {
        HashSet<GUESSEndpoint> hashSet = new HashSet<GUESSEndpoint>();
        Map<GUID, Set<GUESSEndpoint>> map = this._bypassedResults;
        synchronized (map) {
            Set<GUESSEndpoint> set = this._bypassedResults.get(gUID);
            if (set != null) {
                hashSet.addAll(set);
            }
        }
        return hashSet;
    }

    private boolean isGUIDOfInterest(GUID gUID) {
        return this._callback.get().isQueryAlive(gUID) || this._downloadManager.isGuidForQueryDownloading(gUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBypassedSource(GUID gUID, GUESSEndpoint gUESSEndpoint) {
        if (!this.isGUIDOfInterest(gUID)) {
            return false;
        }
        Map<GUID, Set<GUESSEndpoint>> map = this._bypassedResults;
        synchronized (map) {
            Set<GUESSEndpoint> set = this._bypassedResults.get(gUID);
            if (set == null) {
                set = new HashSet<GUESSEndpoint>();
                this._bypassedResults.put(gUID, set);
            }
            if (set.size() < MAX_BYPASSED_RESULTS) {
                return set.add(gUESSEndpoint);
            }
            return false;
        }
    }
}

