/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.NodeAssigner;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.connection.Connection;
import com.limegroup.gnutella.connection.ConnectionCheckerManager;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.ConnectionLifecycleListener;
import com.limegroup.gnutella.connection.GnetConnectObserver;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.connection.RoutedConnectionFactory;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeStatus;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.settings.UltrapeerSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.util.StrictIpPortSet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableForSize;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.net.ConnectionDispatcher;
import org.limewire.net.SocketsManager;
import org.limewire.util.SystemUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ConnectionManagerImpl
implements ConnectionManager {
    private static final Log LOG = LogFactory.getLog(ConnectionManagerImpl.class);
    private static final int MINIMUM_IDLE_TIME = 1800000;
    static final int MAX_UDP_CONNECT_BACK_ATTEMPTS = 15;
    static final int MAX_TCP_CONNECT_BACK_ATTEMPTS = 10;
    @InspectionPoint(value="leaf connections")
    private final Inspectable LEAF = new LegacyConnectionStats(true);
    @InspectionPoint(value="ultrapeer connections")
    private final Inspectable UP = new LegacyConnectionStats(false);
    @InspectablePrimitive(value="last disconnect time")
    private volatile long _disconnectTime = -1L;
    @InspectablePrimitive(value="last connect time")
    private volatile long _connectTime = Long.MAX_VALUE;
    @InspectablePrimitive(value="last time preferred reached")
    private volatile long _lastFullConnectTime;
    @InspectablePrimitive(value="begin of automatic connect")
    private volatile long _automaticConnectTime = 0L;
    @InspectablePrimitive(value="automatically connecting")
    private volatile boolean _automaticallyConnecting;
    @InspectablePrimitive(value="last successful connection")
    private volatile long _lastSuccessfulConnect = 0L;
    @InspectablePrimitive(value="last internet check")
    private volatile long _lastConnectionCheck = 0L;
    @InspectablePrimitive(value="connection attempts")
    private volatile int _connectionAttempts;
    @InspectablePrimitive(value="preferred connections")
    private volatile int _preferredConnections = -1;
    @InspectablePrimitive(value="number tcp connectbacks")
    private volatile int numTCPConnectBacksLeft;
    @InspectablePrimitive(value="number udp connectbacks")
    private volatile int numUDPConnectBacksLeft;
    private final List<ConnectionFetcher> _fetchers = new ArrayList<ConnectionFetcher>();
    @InspectableForSize(value="number of skipped class C networks")
    private final Map<Integer, List<Endpoint>> classCNetworks = new HashMap<Integer, List<Endpoint>>();
    private final List<RoutedConnection> _initializingFetchedConnections = new ArrayList<RoutedConnection>();
    private ConnectionFetcher _dedicatedPrefFetcher;
    private volatile boolean _needPref = true;
    private boolean _needPrefInterrupterScheduled = false;
    private volatile List<RoutedConnection> _connections = Collections.emptyList();
    private volatile List<RoutedConnection> _initializedConnections = Collections.emptyList();
    private volatile List<RoutedConnection> _initializedClientConnections = Collections.emptyList();
    private volatile int _shieldedConnections = 0;
    private volatile int _nonLimeWireLeaves = 0;
    private volatile int _nonLimeWirePeers = 0;
    private volatile int _localeMatchingPeers = 0;
    @InspectablePrimitive(value="leaf tries")
    private volatile int _leafTries;
    @InspectablePrimitive(value="demotion limit")
    private volatile int _demotionLimit = 0;
    private volatile float _measuredUpstreamBandwidth = 0.0f;
    private volatile float _measuredDownstreamBandwidth = 0.0f;
    private final CopyOnWriteArrayList<ConnectionLifecycleListener> connectionLifeCycleListeners = new CopyOnWriteArrayList();
    private final Version lastGoodVersion;
    private final NetworkManager networkManager;
    private final Provider<HostCatcher> hostCatcher;
    private final Provider<ConnectionDispatcher> connectionDispatcher;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<SimppManager> simppManager;
    private final CapabilitiesVMFactory capabilitiesVMFactory;
    private final RoutedConnectionFactory managedConnectionFactory;
    private final Provider<QueryUnicaster> queryUnicaster;
    private final SocketsManager socketsManager;
    private final ConnectionServices connectionServices;
    private final Provider<NodeAssigner> nodeAssigner;
    private final Provider<IPFilter> ipFilter;
    private final ConnectionCheckerManager connectionCheckerManager;
    private final PingRequestFactory pingRequestFactory;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public ConnectionManagerImpl(NetworkManager networkManager, Provider<HostCatcher> provider, @Named(value="global") Provider<ConnectionDispatcher> provider2, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<SimppManager> provider3, CapabilitiesVMFactory capabilitiesVMFactory, RoutedConnectionFactory routedConnectionFactory, Provider<MessageRouter> provider4, Provider<QueryUnicaster> provider5, SocketsManager socketsManager, ConnectionServices connectionServices, Provider<NodeAssigner> provider6, Provider<IPFilter> provider7, ConnectionCheckerManager connectionCheckerManager, PingRequestFactory pingRequestFactory, NetworkInstanceUtils networkInstanceUtils) {
        this.networkManager = networkManager;
        this.hostCatcher = provider;
        this.connectionDispatcher = provider2;
        this.backgroundExecutor = scheduledExecutorService;
        this.simppManager = provider3;
        this.capabilitiesVMFactory = capabilitiesVMFactory;
        this.managedConnectionFactory = routedConnectionFactory;
        this.queryUnicaster = provider5;
        this.socketsManager = socketsManager;
        this.connectionServices = connectionServices;
        this.nodeAssigner = provider6;
        this.ipFilter = provider7;
        this.connectionCheckerManager = connectionCheckerManager;
        this.pingRequestFactory = pingRequestFactory;
        this.networkInstanceUtils = networkInstanceUtils;
        Version version = null;
        try {
            version = new Version("4.14.0");
        }
        catch (VersionFormatException versionFormatException) {
            // empty catch block
        }
        this.lastGoodVersion = version;
    }

    @Override
    public void initialize() {
        this.connectionDispatcher.get().addConnectionAcceptor(this, false, "GNUTELLA", "LIMEWIRE", "FROSTWIRE");
        if (SystemUtils.supportsIdleTime()) {
            this.backgroundExecutor.scheduleWithFixedDelay(new Runnable(){

                public void run() {
                    ConnectionManagerImpl.this.setPreferredConnections();
                }
            }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
        this.addEventListener(new ConnectionLifecycleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent connectionLifecycleEvent) {
                if (connectionLifecycleEvent.isConnectedEvent()) {
                    ArrayList arrayList = new ArrayList();
                    ConnectionManagerImpl connectionManagerImpl = ConnectionManagerImpl.this;
                    synchronized (connectionManagerImpl) {
                        for (List list : ConnectionManagerImpl.this.classCNetworks.values()) {
                            arrayList.addAll(list);
                            list.clear();
                        }
                    }
                    for (Object object : arrayList) {
                        ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).add((Endpoint)object, false);
                    }
                }
            }
        });
    }

    @Override
    public void createConnectionAsynchronously(String string, int n, SocketsManager.ConnectType connectType) {
        RoutedConnection routedConnection = this.managedConnectionFactory.createRoutedConnection(string, n, connectType);
        try {
            this.initializeExternallyGeneratedConnection(routedConnection, new IncomingGNetObserver(routedConnection));
        }
        catch (IOException iOException) {
            routedConnection.close();
        }
    }

    @Override
    public void acceptConnection(String string, Socket socket) {
        if (string.equals("GNUTELLA") || ConnectionSettings.CONNECT_STRING.isDefault() && (string.equals("LIMEWIRE") || string.equals("FROSTWIRE"))) {
            this.acceptConnection(socket);
        }
    }

    @Override
    public void acceptConnection(Socket socket) {
        RoutedConnection routedConnection = this.managedConnectionFactory.createRoutedConnection(socket);
        IncomingGNetObserver incomingGNetObserver = new IncomingGNetObserver(routedConnection);
        try {
            this.initializeExternallyGeneratedConnection(routedConnection, incomingGNetObserver);
        }
        catch (IOException iOException) {
            routedConnection.close();
            return;
        }
    }

    @Override
    public synchronized void remove(RoutedConnection routedConnection) {
        if (!ConnectionSettings.REMOVE_ENABLED.getValue()) {
            return;
        }
        this.removeInternal(routedConnection);
        this.adjustConnectionFetchers();
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public boolean isSupernode() {
        return this.isActiveSupernode() || this.isSupernodeCapable();
    }

    @Override
    public boolean isSupernodeCapable() {
        return !this.networkInstanceUtils.isPrivate() && UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.getValue() && !this.isShieldedLeaf() && !UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue() && !this.isBehindProxy() && this.minConnectTimePassed();
    }

    private boolean minConnectTimePassed() {
        if (!UltrapeerSettings.NEED_MIN_CONNECT_TIME.getValue()) {
            return true;
        }
        return Math.max(0L, System.currentTimeMillis() - this._connectTime) / 1000L >= (long)UltrapeerSettings.MIN_CONNECT_TIME.getValue();
    }

    @Override
    public boolean isBehindProxy() {
        return ConnectionSettings.CONNECTION_METHOD.getValue() != 0;
    }

    @Override
    public boolean isActiveSupernode() {
        return !this.isShieldedLeaf() && (this._initializedClientConnections.size() > 0 || this._initializedConnections.size() > 0);
    }

    @Override
    public boolean isShieldedLeaf() {
        return this._shieldedConnections != 0;
    }

    @Override
    public boolean hasSupernodeClientConnection() {
        return this.getNumInitializedClientConnections() > 0;
    }

    @Override
    public boolean hasFreeSlots() {
        return this.isSupernode() && (this.hasFreeUltrapeerSlots() || this.hasFreeLeafSlots());
    }

    private boolean hasFreeUltrapeerSlots() {
        return this.getNumFreeNonLeafSlots() > 0;
    }

    private boolean hasFreeLeafSlots() {
        return this.getNumFreeLeafSlots() > 0;
    }

    @Override
    public boolean isConnectedTo(String string) {
        for (RoutedConnection routedConnection : this.getConnections()) {
            if (!routedConnection.getAddress().equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectingTo(IpPort ipPort) {
        ConnectionManagerImpl connectionManagerImpl = this;
        synchronized (connectionManagerImpl) {
            for (ConnectionFetcher object : this._fetchers) {
                IpPort ipPort2 = object.getIpPort();
                if (ipPort2 == null || !ipPort.getAddress().equals(ipPort2.getAddress()) || ipPort.getPort() != ipPort2.getPort()) continue;
                return true;
            }
            for (RoutedConnection routedConnection : this._initializingFetchedConnections) {
                if (!ipPort.getAddress().equals(routedConnection.getAddress()) || ipPort.getPort() != routedConnection.getPort()) continue;
                return true;
            }
            return false;
        }
    }

    private boolean attemptClassC(Endpoint endpoint) {
        if (!ConnectionSettings.FILTER_CLASS_C.getValue()) {
            return false;
        }
        List<Endpoint> list = this.classCNetworks.get(NetworkUtils.getClassC(endpoint.getInetAddress()));
        if (list == null) {
            return false;
        }
        list.add(endpoint);
        return true;
    }

    @Override
    public int getNumConnections() {
        return this._connections.size();
    }

    @Override
    public int getNumInitializedConnections() {
        return this._initializedConnections.size();
    }

    @Override
    public int getNumInitializedClientConnections() {
        return this._initializedClientConnections.size();
    }

    @Override
    public int getNumClientSupernodeConnections() {
        return this._shieldedConnections;
    }

    @Override
    public synchronized int getNumUltrapeerConnections() {
        return this.ultrapeerToUltrapeerConnections();
    }

    @Override
    public synchronized int getNumOldConnections() {
        return this.oldConnections();
    }

    @Override
    public int getNumFreeLeafSlots() {
        if (this.isSupernode()) {
            return UltrapeerSettings.MAX_LEAVES.getValue() - this.getNumInitializedClientConnections();
        }
        return 0;
    }

    @Override
    public int getNumFreeLimeWireLeafSlots() {
        return Math.max(0, this.getNumFreeLeafSlots() - Math.max(0, 2 - this._nonLimeWireLeaves));
    }

    @Override
    public int getNumFreeNonLeafSlots() {
        return this._preferredConnections - this.getNumInitializedConnections();
    }

    @Override
    public int getNumFreeLimeWireNonLeafSlots() {
        return Math.max(0, this.getNumFreeNonLeafSlots() - Math.max(0, (int)(ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections) - this._nonLimeWirePeers) - this.getNumLimeWireLocalePrefSlots());
    }

    @Override
    public boolean isLocaleMatched() {
        return !ConnectionSettings.USE_LOCALE_PREF.getValue() || this._localeMatchingPeers != 0;
    }

    @Override
    public int getNumLimeWireLocalePrefSlots() {
        return Math.max(0, ConnectionSettings.NUM_LOCALE_PREF.getValue() - this._localeMatchingPeers);
    }

    @Override
    public boolean isFullyConnected() {
        return this._initializedConnections.size() >= this._preferredConnections;
    }

    @Override
    public boolean isConnected() {
        return this._initializedClientConnections.size() > 0 || this._initializedConnections.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnecting() {
        if (this._disconnectTime != 0L) {
            return false;
        }
        if (this.isConnected()) {
            return false;
        }
        ConnectionManagerImpl connectionManagerImpl = this;
        synchronized (connectionManagerImpl) {
            return this._fetchers.size() != 0 || this._initializingFetchedConnections.size() != 0;
        }
    }

    @Override
    public void measureBandwidth() {
        float f = 0.0f;
        float f2 = 0.0f;
        for (RoutedConnection routedConnection : this.getInitializedConnections()) {
            routedConnection.measureBandwidth();
            f += routedConnection.getMeasuredUpstreamBandwidth();
            f2 += routedConnection.getMeasuredDownstreamBandwidth();
        }
        this._measuredUpstreamBandwidth = f;
        this._measuredDownstreamBandwidth = f2;
    }

    @Override
    public float getMeasuredUpstreamBandwidth() {
        return this._measuredUpstreamBandwidth;
    }

    @Override
    public float getMeasuredDownstreamBandwidth() {
        return this._measuredDownstreamBandwidth;
    }

    private HandshakeStatus allowConnection(RoutedConnection routedConnection) {
        if (!routedConnection.getConnectionCapabilities().receivedHeaders()) {
            return HandshakeStatus.NO_HEADERS;
        }
        return this.allowConnection(routedConnection.getConnectionCapabilities().getHeadersRead(), false);
    }

    @Override
    public HandshakeStatus allowConnectionAsLeaf(HandshakeResponse handshakeResponse) {
        return this.allowConnection(handshakeResponse, true);
    }

    @Override
    public HandshakeStatus allowConnection(HandshakeResponse handshakeResponse) {
        return this.allowConnection(handshakeResponse, !handshakeResponse.isUltrapeer());
    }

    @Override
    public boolean allowAnyConnection() {
        if (this.isShieldedLeaf()) {
            return false;
        }
        return this.getNumInitializedConnections() < this._preferredConnections || this.isSupernode() && this.getNumInitializedClientConnections() < UltrapeerSettings.MAX_LEAVES.getValue();
    }

    @Override
    public HandshakeStatus allowConnection(HandshakeResponse handshakeResponse, boolean bl) {
        if (!ConnectionSettings.PREFERENCING_ACTIVE.getValue()) {
            return HandshakeStatus.OK;
        }
        if (!handshakeResponse.isLeaf() && !handshakeResponse.isUltrapeer()) {
            return HandshakeStatus.NO_X_ULTRAPEER;
        }
        int n = ConnectionSettings.LIME_ATTEMPTS.getValue();
        if (!ConnectionSettings.ALLOW_WHILE_DISCONNECTED.getValue() && this._preferredConnections <= 0) {
            return HandshakeStatus.DISCONNECTED;
        }
        if (this.isShieldedLeaf() || !this.isSupernode()) {
            if (!handshakeResponse.isUltrapeer()) {
                System.out.println("ConnectionManagerImpl.allowConnection() - Sorry remote leaf, I'm a leaf too");
                return HandshakeStatus.WE_ARE_LEAVES;
            }
            if (!handshakeResponse.isGoodUltrapeer()) {
                System.out.println("ConnectionManagerImpl.allowConnection() - Sorry, not a Good Ultrapper (high intra-ultra peer + lime or frost)");
                return HandshakeStatus.NOT_GOOD_UP;
            }
            if (this._connectionAttempts < n && !handshakeResponse.isLimeWire()) {
                return HandshakeStatus.STARTING_LIMEWIRE;
            }
            if (this._shieldedConnections < this._preferredConnections) {
                if (this.checkLocale(handshakeResponse.getLocalePref())) {
                    this._needPref = false;
                }
                if (this.isIdle()) {
                    if (handshakeResponse.isLimeWire()) {
                        return HandshakeStatus.OK;
                    }
                    return HandshakeStatus.IDLE_LIMEWIRE;
                }
                return HandshakeStatus.OK;
            }
            if (this._needPref && this.checkLocale(handshakeResponse.getLocalePref())) {
                this._needPref = false;
                return HandshakeStatus.OK;
            }
            return HandshakeStatus.TOO_MANY_UPS;
        }
        if (handshakeResponse.isLeaf() || bl) {
            if (this.isShieldedLeaf() || !this.isSupernode()) {
                return HandshakeStatus.WE_ARE_LEAVES;
            }
            if (!ConnectionManagerImpl.allowUltrapeer2LeafConnection(handshakeResponse)) {
                return HandshakeStatus.NOT_ALLOWED_LEAF;
            }
            int n2 = this.getNumInitializedClientConnections();
            int n3 = this._nonLimeWireLeaves;
            if (!handshakeResponse.isLimeWire() && n2 < UltrapeerSettings.MAX_LEAVES.getValue() && n3 < 2) {
                return HandshakeStatus.OK;
            }
            if (!handshakeResponse.isGoodLeaf()) {
                return HandshakeStatus.NOT_GOOD_LEAF;
            }
            if (n2 + Math.max(0, 2 - n3) < UltrapeerSettings.MAX_LEAVES.getValue()) {
                return HandshakeStatus.OK;
            }
            return HandshakeStatus.TOO_MANY_LEAF;
        }
        if (handshakeResponse.isUltrapeer()) {
            int n4 = this.getNumInitializedConnections();
            int n5 = this._nonLimeWirePeers;
            int n6 = 0;
            if (!this.allowUltrapeer2UltrapeerConnection(handshakeResponse)) {
                return HandshakeStatus.NOT_ALLOWED_UP;
            }
            if (ConnectionSettings.USE_LOCALE_PREF.getValue()) {
                if (this.checkLocale(handshakeResponse.getLocalePref()) && this._localeMatchingPeers < ConnectionSettings.NUM_LOCALE_PREF.getValue()) {
                    return HandshakeStatus.OK;
                }
                n6 = this.getNumLimeWireLocalePrefSlots();
            }
            if (!handshakeResponse.isLimeWire()) {
                double d = (double)n5 / (double)this._preferredConnections;
                if (d < (double)ConnectionSettings.MIN_NON_LIME_PEERS.getValue()) {
                    return HandshakeStatus.OK;
                }
                if (!handshakeResponse.isGoodUltrapeer()) {
                    return HandshakeStatus.NOT_GOOD_UP;
                }
                if (d < (double)ConnectionSettings.MAX_NON_LIME_PEERS.getValue()) {
                    return HandshakeStatus.OK;
                }
                return HandshakeStatus.NON_LIME_RATIO;
            }
            int n7 = (int)(ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections);
            if (!handshakeResponse.isGoodUltrapeer()) {
                return HandshakeStatus.NOT_GOOD_UP;
            }
            if (n4 + Math.max(0, n7 - n5) + n6 < this._preferredConnections) {
                return HandshakeStatus.OK;
            }
            return HandshakeStatus.NO_LIME_SLOTS;
        }
        return HandshakeStatus.UNKNOWN;
    }

    boolean allowUltrapeer2UltrapeerConnection(HandshakeResponse handshakeResponse) {
        if (handshakeResponse.isLimeWire()) {
            return handshakeResponse.getLimeVersion() == null || handshakeResponse.getLimeVersion().compareTo(this.lastGoodVersion) >= 0;
        }
        String string = handshakeResponse.getUserAgent();
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        String[] stringArray = ConnectionSettings.EVIL_HOSTS.getValue();
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.indexOf(stringArray[i]) == -1) continue;
            return false;
        }
        return true;
    }

    static boolean allowUltrapeer2LeafConnection(HandshakeResponse handshakeResponse) {
        if (handshakeResponse.isLimeWire()) {
            return true;
        }
        String string = handshakeResponse.getUserAgent();
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        String[] stringArray = ConnectionSettings.EVIL_HOSTS.getValue();
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.indexOf(stringArray[i]) == -1) continue;
            return false;
        }
        return true;
    }

    private int ultrapeerToUltrapeerConnections() {
        int n = 0;
        for (RoutedConnection routedConnection : this._initializedConnections) {
            if (!routedConnection.getConnectionCapabilities().isSupernodeSupernodeConnection()) continue;
            ++n;
        }
        return n;
    }

    private int oldConnections() {
        int n = 0;
        for (RoutedConnection routedConnection : this._initializedConnections) {
            if (routedConnection.getConnectionCapabilities().isSupernodeConnection()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean supernodeNeeded() {
        return (double)this.getNumInitializedClientConnections() >= (double)UltrapeerSettings.MAX_LEAVES.getValue() * 0.9;
    }

    @Override
    public List<RoutedConnection> getInitializedConnections() {
        return this._initializedConnections;
    }

    @Override
    public List<RoutedConnection> getInitializedConnectionsMatchLocale(String string) {
        LinkedList<RoutedConnection> linkedList = new LinkedList<RoutedConnection>();
        for (RoutedConnection routedConnection : this._initializedConnections) {
            if (!string.equals(routedConnection.getLocalePref())) continue;
            linkedList.add(routedConnection);
        }
        return linkedList;
    }

    @Override
    public List<RoutedConnection> getInitializedClientConnections() {
        return this._initializedClientConnections;
    }

    @Override
    public List<RoutedConnection> getInitializedClientConnectionsMatchLocale(String string) {
        LinkedList<RoutedConnection> linkedList = new LinkedList<RoutedConnection>();
        for (RoutedConnection routedConnection : this._initializedClientConnections) {
            if (!string.equals(routedConnection.getLocalePref())) continue;
            linkedList.add(routedConnection);
        }
        return linkedList;
    }

    @Override
    public List<RoutedConnection> getConnections() {
        return this._connections;
    }

    @Override
    public Set<Connectable> getPushProxies() {
        if (this.isShieldedLeaf()) {
            StrictIpPortSet<Connectable> strictIpPortSet = new StrictIpPortSet<Connectable>();
            for (RoutedConnection routedConnection : this.getInitializedConnections()) {
                if (strictIpPortSet.size() >= 4) break;
                if (!routedConnection.isMyPushProxy()) continue;
                strictIpPortSet.add(routedConnection);
            }
            return strictIpPortSet;
        }
        return Collections.emptySet();
    }

    @Override
    public boolean sendTCPConnectBackRequests() {
        int n = 0;
        ArrayList<RoutedConnection> arrayList = new ArrayList<RoutedConnection>(this.getInitializedConnections());
        Collections.shuffle(arrayList);
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            RoutedConnection routedConnection = (RoutedConnection)object.next();
            if (routedConnection.getConnectionCapabilities().remoteHostSupportsTCPRedirect() >= 0) continue;
            object.remove();
        }
        if (arrayList.size() == 1) {
            object = (RoutedConnection)arrayList.get(0);
            for (int i = 0; i < 3; ++i) {
                TCPConnectBackVendorMessage tCPConnectBackVendorMessage = new TCPConnectBackVendorMessage(this.networkManager.getPort());
                object.send(tCPConnectBackVendorMessage);
                ++n;
            }
        } else {
            object = new TCPConnectBackVendorMessage(this.networkManager.getPort());
            for (RoutedConnection routedConnection : arrayList) {
                if (n < 5) {
                    routedConnection.send((Message)object);
                    ++n;
                    continue;
                }
                break;
            }
        }
        return n > 0;
    }

    @Override
    public boolean sendUDPConnectBackRequests(GUID gUID) {
        int n = 0;
        UDPConnectBackVendorMessage uDPConnectBackVendorMessage = new UDPConnectBackVendorMessage(this.networkManager.getPort(), gUID);
        ArrayList<RoutedConnection> arrayList = new ArrayList<RoutedConnection>(this.getInitializedConnections());
        Collections.shuffle(arrayList);
        for (RoutedConnection routedConnection : arrayList) {
            if (n >= 5) break;
            if (routedConnection.getConnectionCapabilities().remoteHostSupportsUDPConnectBack() < 0) continue;
            routedConnection.send(uDPConnectBackVendorMessage);
            ++n;
        }
        return n > 0;
    }

    @Override
    public void updateQueryStatus(QueryStatusResponse queryStatusResponse) {
        if (this.isShieldedLeaf()) {
            for (RoutedConnection routedConnection : this.getInitializedConnections()) {
                if (routedConnection.getConnectionCapabilities().remoteHostSupportsLeafGuidance() < 0) continue;
                routedConnection.send(queryStatusResponse);
            }
        }
    }

    @Override
    public Endpoint getConnectedGUESSUltrapeer() {
        for (RoutedConnection routedConnection : this._initializedConnections) {
            if (!routedConnection.getConnectionCapabilities().isSupernodeConnection() || !routedConnection.getConnectionCapabilities().isGUESSUltrapeer()) continue;
            return new Endpoint(routedConnection.getInetAddress().getAddress(), routedConnection.getPort());
        }
        return null;
    }

    @Override
    public List<RoutedConnection> getConnectedGUESSUltrapeers() {
        ArrayList<RoutedConnection> arrayList = new ArrayList<RoutedConnection>();
        for (RoutedConnection routedConnection : this._initializedConnections) {
            if (!routedConnection.getConnectionCapabilities().isSupernodeConnection() || !routedConnection.getConnectionCapabilities().isGUESSUltrapeer()) continue;
            arrayList.add(routedConnection);
        }
        return arrayList;
    }

    private void connectionInitializing(RoutedConnection routedConnection) {
        ArrayList<RoutedConnection> arrayList = new ArrayList<RoutedConnection>(this._connections);
        arrayList.add(routedConnection);
        this._connections = Collections.unmodifiableList(arrayList);
        try {
            int n = NetworkUtils.getClassC(InetAddress.getByName(routedConnection.getAddress()));
            List<Endpoint> list = this.classCNetworks.get(n);
            if (list == null) {
                this.classCNetworks.put(n, new ArrayList());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Override
    public void connectionInitializingIncoming(RoutedConnection routedConnection) {
        this.connectionInitializing(routedConnection);
    }

    @Override
    public boolean connectionInitialized(RoutedConnection routedConnection) {
        if (this._connections.contains(routedConnection)) {
            if (!this.allowInitializedConnection(routedConnection)) {
                this.removeInternal(routedConnection);
                return false;
            }
            if (!routedConnection.getConnectionCapabilities().isSupernodeClientConnection()) {
                ArrayList<RoutedConnection> arrayList = new ArrayList<RoutedConnection>(this._initializedConnections);
                arrayList.add(routedConnection);
                this._initializedConnections = Collections.unmodifiableList(arrayList);
                if (routedConnection.getConnectionCapabilities().isClientSupernodeConnection()) {
                    this.killPeerConnections();
                    ++this._shieldedConnections;
                }
                if (!routedConnection.getConnectionCapabilities().isLimeWire()) {
                    ++this._nonLimeWirePeers;
                }
                if (this.checkLocale(routedConnection.getLocalePref())) {
                    ++this._localeMatchingPeers;
                }
            } else {
                ArrayList<RoutedConnection> arrayList = new ArrayList<RoutedConnection>(this._initializedClientConnections);
                arrayList.add(routedConnection);
                this._initializedClientConnections = Collections.unmodifiableList(arrayList);
                if (!routedConnection.getConnectionCapabilities().isLimeWire()) {
                    ++this._nonLimeWireLeaves;
                }
            }
            routedConnection.sendPostInitializeMessages();
            this.sendInitialPingRequest(routedConnection);
            return true;
        }
        return false;
    }

    private boolean allowInitializedConnection(RoutedConnection routedConnection) {
        if (!(!this.isShieldedLeaf() && this.isSupernode() || routedConnection.getConnectionCapabilities().isClientSupernodeConnection())) {
            return false;
        }
        List<RoutedConnection> list = this.getConnections();
        int n = routedConnection.getListeningPort();
        String string = routedConnection.getAddress();
        for (int i = 0; i < list.size(); ++i) {
            RoutedConnection routedConnection2 = list.get(i);
            if (routedConnection2 == routedConnection || ConnectionSettings.ALLOW_DUPLICATE.getValue() || !string.equals(routedConnection2.getAddress())) continue;
            int n2 = routedConnection2.getListeningPort();
            if (n != -1 && n != 0 && n2 != -1 && n2 != 0 && n2 != n) continue;
            return false;
        }
        return this.allowConnection(routedConnection.getConnectionCapabilities().getHeadersRead()).isAcceptable();
    }

    private void killPeerConnections() {
        List<RoutedConnection> list = this._initializedConnections;
        for (RoutedConnection routedConnection : list) {
            if (!routedConnection.getConnectionCapabilities().isSupernodeSupernodeConnection()) continue;
            this.removeInternal(routedConnection);
        }
    }

    @Override
    public void sendUpdatedCapabilities() {
        for (RoutedConnection routedConnection : this.getInitializedConnections()) {
            routedConnection.sendUpdatedCapabilities();
        }
        for (RoutedConnection routedConnection : this.getInitializedClientConnections()) {
            routedConnection.sendUpdatedCapabilities();
        }
    }

    @Override
    public synchronized void disconnect(boolean bl) {
        if (this._disconnectTime == 0L) {
            long l = this.getCurrentAverageUptime();
            int n = Math.max(1, ApplicationSettings.TOTAL_CONNECTIONS.getValue() + 1);
            long l2 = l * (long)n;
            ApplicationSettings.TOTAL_CONNECTION_TIME.setValue(l2);
            ApplicationSettings.TOTAL_CONNECTIONS.setValue(n);
            ApplicationSettings.AVERAGE_CONNECTION_TIME.setValue(l);
        }
        this._disconnectTime = System.currentTimeMillis();
        this._connectTime = Long.MAX_VALUE;
        this._preferredConnections = 0;
        this.adjustConnectionFetchers();
        for (RoutedConnection routedConnection : this.getConnections()) {
            this.remove(routedConnection);
            if (!routedConnection.getConnectionCapabilities().isSupernodeConnection()) continue;
            ExtendedEndpoint extendedEndpoint = new ExtendedEndpoint(routedConnection.getInetAddress().getHostAddress(), routedConnection.getPort(), routedConnection.getLocalePref());
            extendedEndpoint.setTLSCapable(routedConnection.isTLSCapable());
            this.hostCatcher.get().add((Endpoint)extendedEndpoint, true);
        }
        if (!bl) {
            this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEvent.EventType.DISCONNECTED, null));
        }
    }

    @Override
    public synchronized long getCurrentAverageUptime() {
        long l = 0L;
        long l2 = System.currentTimeMillis();
        long l3 = Math.max(0L, l2 - this._connectTime);
        int n = ApplicationSettings.TOTAL_CONNECTIONS.getValue();
        if (l3 != 0L) {
            ++n;
        }
        long l4 = Math.max(0L, ApplicationSettings.TOTAL_CONNECTION_TIME.getValue() + l3);
        l = l4 / (long)Math.max(1, n);
        return l;
    }

    @Override
    public synchronized void connect() {
        this._disconnectTime = 0L;
        this._connectTime = System.currentTimeMillis();
        if (this.isConnected() || this.hostCatcher == null) {
            return;
        }
        this._connectionAttempts = 0;
        this._lastConnectionCheck = 0L;
        this._lastSuccessfulConnect = 0L;
        this.numTCPConnectBacksLeft = 10;
        this.numUDPConnectBacksLeft = 15;
        this.hostCatcher.get().expire();
        this.setPreferredConnections();
        this.hostCatcher.get().sendUDPPings();
    }

    private void sendInitialPingRequest(RoutedConnection routedConnection) {
        if (routedConnection.getConnectionCapabilities().supportsPongCaching()) {
            return;
        }
        PingRequest pingRequest = this.getNumInitializedConnections() >= this._preferredConnections ? this.pingRequestFactory.createPingRequest((byte)1) : this.pingRequestFactory.createPingRequest((byte)4);
        routedConnection.send(pingRequest);
    }

    private void removeInternal(RoutedConnection routedConnection) {
        List<Object> list;
        int n;
        if (!routedConnection.getConnectionCapabilities().isSupernodeClientConnection()) {
            n = this._initializedConnections.indexOf(routedConnection);
            if (n != -1) {
                list = new ArrayList<RoutedConnection>();
                list.addAll(this._initializedConnections);
                list.remove(routedConnection);
                this._initializedConnections = Collections.unmodifiableList(list);
                if (routedConnection.getConnectionCapabilities().isClientSupernodeConnection()) {
                    --this._shieldedConnections;
                }
                if (!routedConnection.getConnectionCapabilities().isLimeWire()) {
                    --this._nonLimeWirePeers;
                }
                if (this.checkLocale(routedConnection.getLocalePref())) {
                    --this._localeMatchingPeers;
                }
            }
        } else {
            n = this._initializedClientConnections.indexOf(routedConnection);
            if (n != -1) {
                list = new ArrayList();
                list.addAll(this._initializedClientConnections);
                list.remove(routedConnection);
                this._initializedClientConnections = Collections.unmodifiableList(list);
                if (!routedConnection.getConnectionCapabilities().isLimeWire()) {
                    --this._nonLimeWireLeaves;
                }
            }
        }
        n = this._connections.indexOf(routedConnection);
        if (n != -1) {
            list = new ArrayList<RoutedConnection>(this._connections);
            list.remove(routedConnection);
            this._connections = Collections.unmodifiableList(list);
        }
        try {
            list = this.classCNetworks.remove(NetworkUtils.getClassC(InetAddress.getByName(routedConnection.getAddress())));
            if (list != null) {
                for (Endpoint endpoint : list) {
                    this.hostCatcher.get().add(endpoint, false);
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        routedConnection.close();
        this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEvent.EventType.CONNECTION_CLOSED, routedConnection));
        this.queryUnicaster.get().purgeQuery(routedConnection);
    }

    private synchronized void stabilizeConnections() {
        while (this.getNumInitializedConnections() > this._preferredConnections) {
            RoutedConnection routedConnection = null;
            for (RoutedConnection routedConnection2 : this._initializedConnections) {
                if (!routedConnection2.getConnectionCapabilities().isLimeWire()) {
                    routedConnection = routedConnection2;
                    break;
                }
                if (routedConnection != null && routedConnection2.getConnectionTime() <= routedConnection.getConnectionTime()) continue;
                routedConnection = routedConnection2;
            }
            if (routedConnection == null) continue;
            this.remove(routedConnection);
        }
        this.adjustConnectionFetchers();
    }

    private void adjustConnectionFetchers() {
        ConnectionFetcher connectionFetcher;
        int n;
        int n2;
        if (ConnectionSettings.USE_LOCALE_PREF.getValue()) {
            this.startDedicatedLocaleFetcher();
        }
        int n3 = this.getNumInitializedConnections();
        int n4 = this._preferredConnections - n3;
        if (!this.networkManager.acceptedIncomingConnection() && !this.isActiveSupernode()) {
            n2 = 3;
        } else if (!this.isSupernode() || this.getNumUltrapeerConnections() == 0) {
            n2 = 3;
        } else if (n4 > 10) {
            n2 = 2;
        } else {
            n2 = 1;
            n4 = (int)((float)n4 - (5.0f + ConnectionSettings.MIN_NON_LIME_PEERS.getValue() * (float)this._preferredConnections));
        }
        int n5 = Math.min(10, n2 * n4) - this._fetchers.size() - this._initializingFetchedConnections.size();
        List list = Collections.emptyList();
        if (n5 > 0) {
            list = new ArrayList(n5);
            for (n5 = Math.min(n5, this.socketsManager.getNumAllowedSockets()); n5 > 0; --n5) {
                ConnectionFetcher connectionFetcher2 = new ConnectionFetcher();
                list.add(connectionFetcher2);
            }
            this._fetchers.addAll(list);
            this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEvent.EventType.CONNECTING, null));
        }
        int n6 = this._fetchers.size();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (n5 < 0 && n6 > 0) {
            ConnectionFetcher connectionFetcher3 = this._fetchers.remove(--n6);
            ++n5;
            arrayList.add(connectionFetcher3);
        }
        int n7 = this._initializingFetchedConnections.size();
        while (n5 < 0 && n7 > 0) {
            RoutedConnection routedConnection = this._initializingFetchedConnections.remove(--n7);
            ++n5;
            arrayList.add(routedConnection);
        }
        for (n = list.size() - 1; n >= 0; --n) {
            connectionFetcher = (ConnectionFetcher)list.remove(n);
            connectionFetcher.connect();
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            connectionFetcher = arrayList.remove(n);
            if (connectionFetcher instanceof ConnectionFetcher) {
                connectionFetcher.stopConnecting();
                continue;
            }
            this.removeInternal((RoutedConnection)((Object)connectionFetcher));
        }
    }

    private void startDedicatedLocaleFetcher() {
        if (this.connectionServices.isShieldedLeaf() && this._needPref && !this._needPrefInterrupterScheduled && this._dedicatedPrefFetcher == null) {
            this._dedicatedPrefFetcher = new ConnectionFetcher(true);
            this._dedicatedPrefFetcher.connect();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ConnectionManagerImpl connectionManagerImpl = ConnectionManagerImpl.this;
                    synchronized (connectionManagerImpl) {
                        ConnectionManagerImpl.this._needPref = false;
                        if (ConnectionManagerImpl.this._dedicatedPrefFetcher == null) {
                            return;
                        }
                        ConnectionManagerImpl.this._dedicatedPrefFetcher.stopConnecting();
                        ConnectionManagerImpl.this._dedicatedPrefFetcher = null;
                    }
                }
            };
            this._needPrefInterrupterScheduled = true;
            this.backgroundExecutor.schedule(runnable, 15000L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFetchedConnection(RoutedConnection routedConnection, ConnectionFetcher connectionFetcher) {
        ConnectionManagerImpl connectionManagerImpl = this;
        synchronized (connectionManagerImpl) {
            if (connectionFetcher.isPrematurelyStopped()) {
                connectionFetcher.finish();
                return;
            }
            this._initializingFetchedConnections.add(routedConnection);
            if (connectionFetcher == this._dedicatedPrefFetcher) {
                this._dedicatedPrefFetcher = null;
            } else {
                this._fetchers.remove(connectionFetcher);
            }
            this.connectionInitializing(routedConnection);
        }
        this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEvent.EventType.CONNECTION_INITIALIZING, routedConnection));
        try {
            routedConnection.initialize(connectionFetcher);
        }
        catch (IOException iOException) {
            this.cleanupBrokenFetchedConnection(routedConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupBrokenFetchedConnection(RoutedConnection routedConnection) {
        ConnectionManagerImpl connectionManagerImpl = this;
        synchronized (connectionManagerImpl) {
            this._initializingFetchedConnections.remove(routedConnection);
            this.removeInternal(routedConnection);
            this.adjustConnectionFetchers();
        }
        this.processConnectionHeaders(routedConnection);
    }

    private void processConnectionHeaders(Connection connection) {
        if (!connection.getConnectionCapabilities().receivedHeaders()) {
            return;
        }
        Properties properties = connection.getConnectionCapabilities().getHeadersRead().props();
        if (properties == null) {
            return;
        }
        this.updateHostCache(connection.getConnectionCapabilities().getHeadersRead());
        String string = properties.getProperty("Listen-IP");
        if (string == null) {
            string = properties.getProperty("X-My-Address");
        }
        if (string != null && !connection.isOutgoing()) {
            int n = string.indexOf(58);
            if (n == -1) {
                return;
            }
            if (++n > string.length()) {
                return;
            }
            try {
                int n2 = Integer.parseInt(string.substring(n).trim());
                if (NetworkUtils.isValidPort(n2)) {
                    connection.setListeningPort(n2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean allowLeafDemotion() {
        ++this._leafTries;
        if (UltrapeerSettings.FORCE_ULTRAPEER_MODE.getValue() || this.isActiveSupernode()) {
            return false;
        }
        return !this.nodeAssigner.get().isTooGoodUltrapeerToPassUp() || this._leafTries >= this._demotionLimit;
    }

    @Override
    public void tryToBecomeAnUltrapeer(int n) {
        if (this.isSupernode()) {
            return;
        }
        this._demotionLimit = n;
        this._leafTries = 0;
        this.disconnect(true);
        this.connect();
    }

    private void updateHostCache(HandshakeResponse handshakeResponse) {
        if (!handshakeResponse.hasXTryUltrapeers()) {
            return;
        }
        String string = handshakeResponse.getXTryUltrapeers();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            try {
                arrayList.add(new Endpoint(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.hostCatcher.get().add(ConnectionSettings.FILTER_CLASS_C.getValue() ? NetworkUtils.filterOnePerClassC(arrayList) : arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeExternallyGeneratedConnection(RoutedConnection routedConnection, GnetConnectObserver gnetConnectObserver) throws IOException {
        if (routedConnection.isOutgoing()) {
            ConnectionManagerImpl connectionManagerImpl = this;
            synchronized (connectionManagerImpl) {
                this.connectionInitializing(routedConnection);
                this.adjustConnectionFetchers();
            }
            this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEvent.EventType.CONNECTION_INITIALIZING, routedConnection));
        }
        try {
            routedConnection.initialize(gnetConnectObserver);
        }
        catch (IOException iOException) {
            this.cleanupBrokenExternallyGeneratedConnection(routedConnection);
            throw iOException;
        }
    }

    private void cleanupBrokenExternallyGeneratedConnection(RoutedConnection routedConnection) {
        this.remove(routedConnection);
        this.processConnectionHeaders(routedConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeInitializeExternallyGeneratedConnection(RoutedConnection routedConnection) throws IOException {
        this.processConnectionHeaders(routedConnection);
        if (!routedConnection.isOutgoing() && !this.allowConnection(routedConnection).isAcceptable()) {
            throw new IOException("No space for connection");
        }
        if (!routedConnection.isOutgoing()) {
            ConnectionManagerImpl connectionManagerImpl = this;
            synchronized (connectionManagerImpl) {
                this.connectionInitializingIncoming(routedConnection);
                this.adjustConnectionFetchers();
            }
            this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEvent.EventType.CONNECTION_INITIALIZING, routedConnection));
        }
        return this.completeConnectionInitialization(routedConnection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeConnectionInitialization(RoutedConnection routedConnection, boolean bl) {
        ConnectionManagerImpl connectionManagerImpl = this;
        synchronized (connectionManagerImpl) {
            boolean bl2;
            if (bl) {
                this._initializingFetchedConnections.remove(routedConnection);
            }
            if (bl2 = this.connectionInitialized(routedConnection)) {
                this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEvent.EventType.CONNECTION_INITIALIZED, routedConnection));
                this.setPreferredConnections();
                if (this._initializedConnections.size() >= this.getPreferredConnectionCount()) {
                    this._lastFullConnectTime = System.currentTimeMillis();
                    this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEvent.EventType.CONNECTED, routedConnection));
                }
            }
            return bl2;
        }
    }

    @Override
    public int getPreferredConnectionCount() {
        return this._preferredConnections;
    }

    @Override
    public boolean isConnectionIdle() {
        return this._preferredConnections == ConnectionSettings.IDLE_CONNECTIONS.getValue();
    }

    private void setPreferredConnections() {
        if (!ConnectionSettings.ALLOW_WHILE_DISCONNECTED.getValue() && this._disconnectTime != 0L) {
            return;
        }
        int n = this._preferredConnections;
        this._preferredConnections = this.isSupernode() ? ConnectionSettings.NUM_CONNECTIONS.getValue() : (this.isIdle() ? ConnectionSettings.IDLE_CONNECTIONS.getValue() : 5);
        if (n != this._preferredConnections) {
            this.stabilizeConnections();
        }
    }

    private boolean isIdle() {
        return SystemUtils.getIdleTime() >= 1800000L;
    }

    private void startConnection(RoutedConnection routedConnection) throws IOException {
        if (routedConnection.getConnectionCapabilities().isGUESSUltrapeer()) {
            this.queryUnicaster.get().addUnicastEndpoint(routedConnection.getInetAddress(), routedConnection.getPort());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looping for messages with conn: " + routedConnection);
        }
        routedConnection.startMessaging();
    }

    @Override
    public void noInternetConnection() {
        this.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEvent.EventType.NO_INTERNET));
        if (this._automaticallyConnecting) {
            return;
        }
        this.disconnect(false);
        this.backgroundExecutor.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                if (ConnectionManagerImpl.this._automaticConnectTime < ConnectionManagerImpl.this._disconnectTime) {
                    return;
                }
                if (!ConnectionManagerImpl.this.connectionServices.isConnected()) {
                    ConnectionManagerImpl.this.connect();
                }
            }
        }, 10000L, 120000L, TimeUnit.MILLISECONDS);
        this._automaticConnectTime = System.currentTimeMillis();
        this._automaticallyConnecting = true;
        this.recoverHosts();
    }

    private synchronized void recoverHosts() {
        if (this.hostCatcher != null && this.hostCatcher.get().getNumHosts() < 100) {
            this.hostCatcher.get().recoverHosts();
        }
    }

    private boolean checkLocale(String string) {
        if (string == null) {
            string = ApplicationSettings.DEFAULT_LOCALE.getValue();
        }
        return ApplicationSettings.LANGUAGE.getValue().equals(string);
    }

    @Override
    public void addEventListener(ConnectionLifecycleListener connectionLifecycleListener) {
        if (connectionLifecycleListener == null) {
            throw new NullPointerException("ConnectionLifecycleListener is null");
        }
        if (!this.connectionLifeCycleListeners.addIfAbsent(connectionLifecycleListener)) {
            throw new IllegalArgumentException("Listener " + connectionLifecycleListener + " already registered");
        }
    }

    @Override
    public void dispatchEvent(ConnectionLifecycleEvent connectionLifecycleEvent) {
        for (ConnectionLifecycleListener connectionLifecycleListener : this.connectionLifeCycleListeners) {
            connectionLifecycleListener.handleConnectionLifecycleEvent(connectionLifecycleEvent);
        }
    }

    @Override
    public void removeEventListener(ConnectionLifecycleListener connectionLifecycleListener) {
        this.connectionLifeCycleListeners.remove(connectionLifecycleListener);
    }

    @Override
    public int countConnectionsWithNMessages(int n) {
        int n2 = 0;
        for (RoutedConnection routedConnection : this.getInitializedConnections()) {
            int n3 = routedConnection.getConnectionMessageStatistics().getNumMessagesSent();
            if ((n3 += routedConnection.getConnectionMessageStatistics().getNumMessagesReceived()) <= n) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public int getActiveConnectionMessages() {
        int n = 0;
        for (RoutedConnection routedConnection : this.getInitializedConnections()) {
            n += routedConnection.getConnectionMessageStatistics().getNumMessagesSent();
            n += routedConnection.getConnectionMessageStatistics().getNumMessagesReceived();
        }
        return n;
    }

    @Override
    public boolean canSendConnectBack(Message.Network network) {
        if (network == Message.Network.TCP) {
            return this.numTCPConnectBacksLeft > 0;
        }
        if (network == Message.Network.UDP) {
            return this.numUDPConnectBacksLeft > 0;
        }
        return false;
    }

    @Override
    public void connectBackSent(Message.Network network) {
        if (network == Message.Network.TCP) {
            --this.numTCPConnectBacksLeft;
        } else if (network == Message.Network.UDP) {
            --this.numUDPConnectBacksLeft;
        } else {
            throw new IllegalArgumentException("which network?");
        }
    }

    private class LegacyConnectionStats
    implements Inspectable {
        private final boolean leaf;

        private LegacyConnectionStats(boolean bl) {
            this.leaf = bl;
        }

        public Object inspect() {
            List<RoutedConnection> list = ConnectionManagerImpl.this.getConnections();
            HashMap<String, Object> hashMap = new HashMap<String, Object>(list.size() * 2);
            for (RoutedConnection routedConnection : list) {
                if (ConnectionManagerImpl.this.isSupernode() && (this.leaf && routedConnection.getConnectionCapabilities().isSupernodeConnection() || !this.leaf && routedConnection.getConnectionCapabilities().isSupernodeClientConnection())) continue;
                hashMap.put(routedConnection.getAddress() + ":" + routedConnection.getPort(), ((Inspectable)((Object)routedConnection)).inspect());
            }
            return hashMap;
        }
    }

    private class ConnectionFetcher
    implements GnetConnectObserver,
    HostCatcher.EndpointObserver {
        private final boolean _pref;
        private volatile RoutedConnection connection;
        private volatile Endpoint endpoint;
        private volatile boolean stoppedEarly = false;

        public ConnectionFetcher() {
            this(false);
        }

        public ConnectionFetcher(boolean bl) {
            this._pref = bl;
        }

        IpPort getIpPort() {
            if (this.connection != null) {
                return this.connection;
            }
            if (this.endpoint != null) {
                return this.endpoint;
            }
            return null;
        }

        public void connect() {
            ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).getAnEndpoint(this);
        }

        public void stopConnecting() {
            this.stoppedEarly = true;
            ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).removeEndpointObserver(this);
        }

        public boolean isPrematurelyStopped() {
            return this.stoppedEarly;
        }

        public void finish() {
        }

        private boolean isConnectableHost(IpPort ipPort) {
            return ((IPFilter)ConnectionManagerImpl.this.ipFilter.get()).allow(ipPort.getAddress()) && !ConnectionManagerImpl.this.isConnectedTo(ipPort.getAddress()) && !ConnectionManagerImpl.this.isConnectingTo(ipPort);
        }

        public void handleEndpoint(Endpoint endpoint) {
            assert (endpoint != null);
            while (!this.isConnectableHost(endpoint) || ConnectionManagerImpl.this.attemptClassC(endpoint)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring unconnectable host: " + endpoint);
                }
                if ((endpoint = ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).getAnEndpointImmediate(this)) != null) continue;
                LOG.debug("No hosts available, waiting on a new one...");
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting fetch for connectable host: " + endpoint);
            }
            this.endpoint = endpoint;
            SocketsManager.ConnectType connectType = this.endpoint.isTLSCapable() && SSLSettings.isOutgoingTLSEnabled() ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN;
            this.connection = ConnectionManagerImpl.this.managedConnectionFactory.createRoutedConnection(this.endpoint.getAddress(), this.endpoint.getPort(), connectType);
            this.connection.setLocalePreferencing(this._pref);
            this.doConnectionCheck();
            ConnectionManagerImpl.this._connectionAttempts++;
            ConnectionManagerImpl.this.initializeFetchedConnection(this.connection, this);
        }

        public void handleConnect() {
            boolean bl = ConnectionManagerImpl.this.completeConnectionInitialization(this.connection, true);
            ConnectionManagerImpl.this.processConnectionHeaders(this.connection);
            ConnectionManagerImpl.this._lastSuccessfulConnect = System.currentTimeMillis();
            ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).doneWithConnect(this.endpoint, true);
            if (this._pref) {
                ConnectionManagerImpl.this._needPref = false;
            }
            try {
                if (bl) {
                    ConnectionManagerImpl.this.startConnection(this.connection);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void shutdown() {
            ConnectionManagerImpl.this.cleanupBrokenFetchedConnection(this.connection);
            ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).doneWithConnect(this.endpoint, false);
            ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).expireHost(this.endpoint);
        }

        public void handleBadHandshake() {
            this.shutdown();
        }

        public void handleNoGnutellaOk(int n, String string) {
            ConnectionManagerImpl.this.cleanupBrokenFetchedConnection(this.connection);
            ConnectionManagerImpl.this._lastSuccessfulConnect = System.currentTimeMillis();
            if (n == 577) {
                ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).add(this.endpoint, true, this.connection.getLocalePref());
            } else {
                ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).doneWithConnect(this.endpoint, true);
                ((HostCatcher)ConnectionManagerImpl.this.hostCatcher.get()).putHostOnProbation(this.endpoint);
            }
        }

        private void doConnectionCheck() {
            long l = System.currentTimeMillis();
            if (!ConnectionManagerImpl.this.isConnected() && ConnectionManagerImpl.this._connectionAttempts > 40 && l - ConnectionManagerImpl.this._lastSuccessfulConnect > 4000L && l - ConnectionManagerImpl.this._lastConnectionCheck > 3600000L) {
                ConnectionManagerImpl.this._connectionAttempts = 0;
                ConnectionManagerImpl.this._lastConnectionCheck = l;
                LOG.debug("checking for live connection");
                ConnectionManagerImpl.this.connectionCheckerManager.checkForLiveConnection();
            }
        }
    }

    private class IncomingGNetObserver
    implements GnetConnectObserver {
        private final RoutedConnection connection;

        IncomingGNetObserver(RoutedConnection routedConnection) {
            this.connection = routedConnection;
        }

        public void handleConnect() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Completing IncomingGNetObserver.handleConnect for: " + this.connection);
            }
            try {
                if (ConnectionManagerImpl.this.completeInitializeExternallyGeneratedConnection(this.connection)) {
                    ConnectionManagerImpl.this.startConnection(this.connection);
                }
            }
            catch (IOException iOException) {
                LOG.warn("Failed to complete initialization", iOException);
            }
        }

        public void handleBadHandshake() {
            this.shutdown();
        }

        public void handleNoGnutellaOk(int n, String string) {
            this.shutdown();
        }

        public void shutdown() {
            LOG.debug("Shutting down IncomingGNetobserver for: " + this.connection);
            ConnectionManagerImpl.this.cleanupBrokenExternallyGeneratedConnection(this.connection);
        }
    }
}

