/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.bittorrent.BTDownloader;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.TorrentFileSystem;
import com.limegroup.bittorrent.TorrentManager;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.CoreDownloaderFactory;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.MagnetDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.PushedSocketHandlerRegistry;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.ResumeDownloader;
import com.limegroup.gnutella.downloader.StoreDownloader;
import com.limegroup.gnutella.downloader.serial.BTMetaInfoMemento;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.DownloadSerializer;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.UpdateSettings;
import com.limegroup.gnutella.version.DownloadInformation;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.DualIterator;
import org.limewire.collection.MultiIterable;
import org.limewire.i18n.I18nMarker;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.service.MessageService;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DownloadManagerImpl
implements DownloadManager {
    private static final Log LOG = LogFactory.getLog(DownloadManagerImpl.class);
    private int SNAPSHOT_CHECKPOINT_TIME = 30000;
    private final List<CoreDownloader> active = new LinkedList<CoreDownloader>();
    private final List<CoreDownloader> waiting = new LinkedList<CoreDownloader>();
    private final MultiIterable<CoreDownloader> activeAndWaiting = new MultiIterable<CoreDownloader>((Iterable<CoreDownloader>)this.active, (Iterable<CoreDownloader>)this.waiting);
    private volatile boolean downloadsReadFromDisk = false;
    private int innetworkCount = 0;
    private int storeDownloadCount = 0;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private volatile float lastMeasuredBandwidth;
    private Runnable _waitingPump;
    private final NetworkManager networkManager;
    private final DownloadCallback innetworkCallback;
    private final Provider<DownloadCallback> downloadCallback;
    private final Provider<MessageRouter> messageRouter;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<TorrentManager> torrentManager;
    private final Provider<PushDownloadManager> pushDownloadManager;
    private final CoreDownloaderFactory coreDownloaderFactory;
    private final DownloadSerializer downloadSerializer;
    private final IncompleteFileManager incompleteFileManager;
    private final RemoteFileDescFactory remoteFileDescFactory;

    @Inject
    public DownloadManagerImpl(NetworkManager networkManager, @Named(value="inNetwork") DownloadCallback downloadCallback, Provider<DownloadCallback> provider, Provider<MessageRouter> provider2, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<TorrentManager> provider3, Provider<PushDownloadManager> provider4, CoreDownloaderFactory coreDownloaderFactory, DownloadSerializer downloadSerializer, IncompleteFileManager incompleteFileManager, RemoteFileDescFactory remoteFileDescFactory) {
        this.networkManager = networkManager;
        this.innetworkCallback = downloadCallback;
        this.downloadCallback = provider;
        this.messageRouter = provider2;
        this.backgroundExecutor = scheduledExecutorService;
        this.torrentManager = provider3;
        this.pushDownloadManager = provider4;
        this.coreDownloaderFactory = coreDownloaderFactory;
        this.downloadSerializer = downloadSerializer;
        this.incompleteFileManager = incompleteFileManager;
        this.remoteFileDescFactory = remoteFileDescFactory;
    }

    @Inject
    public void register(PushedSocketHandlerRegistry pushedSocketHandlerRegistry) {
        pushedSocketHandlerRegistry.register(this);
    }

    @Override
    public void initialize() {
        this.scheduleWaitingPump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNewDownloader(CoreDownloader coreDownloader) {
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            this.waiting.add(coreDownloader);
            coreDownloader.initialize();
            this.callback(coreDownloader).addDownload(coreDownloader);
        }
    }

    @Override
    public void loadSavedDownloadsAndScheduleWriting() {
        this.loadSavedDownloads();
        this.scheduleSnapshots();
    }

    public void loadSavedDownloads() {
        List<DownloadMemento> list;
        boolean bl = true;
        boolean bl2 = false;
        try {
            list = this.downloadSerializer.readFromDisk();
            if (list.isEmpty()) {
                bl = false;
            }
        }
        catch (IOException iOException) {
            list = Collections.emptyList();
        }
        for (DownloadMemento downloadMemento : list) {
            CoreDownloader coreDownloader = this.prepareMemento(downloadMemento);
            if (coreDownloader != null) {
                bl = false;
                this.addNewDownloader(coreDownloader);
                continue;
            }
            bl2 = true;
        }
        this.downloadsReadFromDisk = true;
        if (bl) {
            MessageService.showError(I18nMarker.marktr("Sorry, FrostWire couldn't read your old downloads.  You can restart them by going to your Library, viewing your 'Incomplete Files', and clicking to 'Resume' your downloads."));
        } else if (bl2) {
            MessageService.showError(I18nMarker.marktr("Sorry, FrostWire couldn't read some of your old downloads.  You can restart them by going to your Library, viewing your 'Incomplete Files', and clicking to 'Resume' your downloads."));
        }
    }

    public CoreDownloader prepareMemento(DownloadMemento downloadMemento) {
        try {
            return this.coreDownloaderFactory.createFromMemento(downloadMemento);
        }
        catch (InvalidDataException invalidDataException) {
            LOG.warn("Unable to read download from memento: " + downloadMemento, invalidDataException);
            return null;
        }
    }

    public void scheduleSnapshots() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (DownloadManagerImpl.this.downloadsInProgress() > 0) {
                    DownloadManagerImpl.this.writeSnapshot();
                }
            }
        };
        this.backgroundExecutor.scheduleWithFixedDelay(runnable, this.SNAPSHOT_CHECKPOINT_TIME, this.SNAPSHOT_CHECKPOINT_TIME, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSnapshot() {
        ArrayList<DownloadMemento> arrayList;
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            arrayList = new ArrayList<DownloadMemento>(this.active.size() + this.waiting.size());
            for (CoreDownloader coreDownloader : this.activeAndWaiting) {
                arrayList.add(coreDownloader.toMemento());
            }
        }
        this.downloadSerializer.writeToDisk(arrayList);
    }

    @Override
    public boolean isSavedDownloadsLoaded() {
        return this.downloadsReadFromDisk;
    }

    @Override
    public synchronized boolean hasInNetworkDownload() {
        if (this.innetworkCount > 0) {
            return true;
        }
        Iterator<CoreDownloader> iterator = this.waiting.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getDownloadType() != DownloaderType.INNETWORK) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void killDownloadersNotListed(Collection<? extends DownloadInformation> collection) {
        if (collection == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(collection.size());
        for (DownloadInformation object2 : collection) {
            hashSet.add(object2.getUpdateURN().httpStringValue());
        }
        Object object = new DualIterator<CoreDownloader>(this.waiting.iterator(), this.active.iterator());
        while (object.hasNext()) {
            CoreDownloader coreDownloader = (CoreDownloader)((Object)object.next());
            if (coreDownloader.getDownloadType() != DownloaderType.INNETWORK || hashSet.contains(coreDownloader.getSha1Urn().httpStringValue())) continue;
            coreDownloader.stop();
        }
        object = UpdateSettings.FAILED_UPDATES.getValue();
        object.retainAll(hashSet);
        UpdateSettings.FAILED_UPDATES.setValue((Set<String>)object);
    }

    PushDownloadManager getPushManager() {
        return this.pushDownloadManager.get();
    }

    private synchronized boolean handleIncomingPush(String string, int n, byte[] byArray, Socket socket) {
        boolean bl = false;
        for (CoreDownloader coreDownloader : this.activeAndWaiting) {
            ManagedDownloader managedDownloader;
            if (!(coreDownloader instanceof ManagedDownloader) || !(managedDownloader = (ManagedDownloader)coreDownloader).acceptDownload(string, socket, n, byArray)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean acceptPushedSocket(String string, int n, byte[] byArray, Socket socket) {
        return this.handleIncomingPush(string, n, byArray, socket);
    }

    public void scheduleWaitingPump() {
        if (this._waitingPump != null) {
            return;
        }
        this._waitingPump = new Runnable(){

            public void run() {
                DownloadManagerImpl.this.pumpDownloads();
            }
        };
        this.backgroundExecutor.scheduleWithFixedDelay(this._waitingPump, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    protected synchronized void pumpDownloads() {
        int n = 1;
        Iterator<CoreDownloader> iterator = this.waiting.iterator();
        while (iterator.hasNext()) {
            CoreDownloader coreDownloader = iterator.next();
            if (coreDownloader.isAlive()) continue;
            if (coreDownloader.shouldBeRemoved()) {
                iterator.remove();
                this.cleanupCompletedDownload(coreDownloader, false);
                continue;
            }
            if (this.storeDownloadCount == 0 && coreDownloader.getDownloadType() == DownloaderType.STORE) {
                iterator.remove();
                ++this.storeDownloadCount;
                this.active.add(coreDownloader);
                coreDownloader.startDownload();
                continue;
            }
            if (this.hasFreeSlot() && coreDownloader.shouldBeRestarted() && coreDownloader.getDownloadType() != DownloaderType.STORE) {
                iterator.remove();
                if (coreDownloader.getDownloadType() == DownloaderType.INNETWORK) {
                    ++this.innetworkCount;
                }
                this.active.add(coreDownloader);
                coreDownloader.startDownload();
                continue;
            }
            if (coreDownloader.isQueuable()) {
                coreDownloader.setInactivePriority(n++);
            }
            coreDownloader.handleInactivity();
        }
    }

    @Override
    public boolean isIncomplete(URN uRN) {
        return this.incompleteFileManager.getFileForUrn(uRN) != null;
    }

    @Override
    public boolean isActivelyDownloading(URN uRN) {
        Downloader downloader = this.getDownloaderForURN(uRN);
        if (downloader == null) {
            return false;
        }
        switch (downloader.getState()) {
            case QUEUED: 
            case BUSY: 
            case ABORTED: 
            case GAVE_UP: 
            case DISK_PROBLEM: 
            case CORRUPT_FILE: 
            case REMOTE_QUEUED: 
            case WAITING_FOR_USER: {
                return false;
            }
        }
        return true;
    }

    @Override
    public IncompleteFileManager getIncompleteFileManager() {
        return this.incompleteFileManager;
    }

    @Override
    public synchronized int downloadsInProgress() {
        return this.active.size() + this.waiting.size();
    }

    @Override
    public synchronized int getNumIndividualDownloaders() {
        int n = 0;
        for (CoreDownloader coreDownloader : this.active) {
            if (!(coreDownloader instanceof ManagedDownloader)) continue;
            ManagedDownloader managedDownloader = (ManagedDownloader)coreDownloader;
            n += managedDownloader.getNumDownloaders();
        }
        return n;
    }

    @Override
    public synchronized int getNumActiveDownloads() {
        return this.active.size() - this.innetworkCount - this.storeDownloadCount;
    }

    @Override
    public synchronized int getNumWaitingDownloads() {
        return this.waiting.size();
    }

    @Override
    public synchronized Downloader getDownloaderForURN(URN uRN) {
        for (CoreDownloader coreDownloader : this.activeAndWaiting) {
            if (coreDownloader.getSha1Urn() == null || !uRN.equals(coreDownloader.getSha1Urn())) continue;
            return coreDownloader;
        }
        return null;
    }

    public synchronized Downloader getDownloaderForURNString(String string) {
        for (CoreDownloader coreDownloader : this.activeAndWaiting) {
            if (coreDownloader.getSha1Urn() == null || !string.equals(coreDownloader.getSha1Urn().toString())) continue;
            return coreDownloader;
        }
        return null;
    }

    @Override
    public synchronized Downloader getDownloaderForIncompleteFile(File file) {
        for (CoreDownloader coreDownloader : this.activeAndWaiting) {
            if (!coreDownloader.conflictsWithIncompleteFile(file)) continue;
            return coreDownloader;
        }
        return null;
    }

    @Override
    public synchronized boolean isGuidForQueryDownloading(GUID gUID) {
        for (CoreDownloader coreDownloader : this.activeAndWaiting) {
            GUID gUID2 = coreDownloader.getQueryGUID();
            if (gUID2 == null || !gUID2.equals(gUID)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAllDownloads() {
        ArrayList<CoreDownloader> arrayList;
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            arrayList = new ArrayList<CoreDownloader>(this.active.size() + this.waiting.size());
            arrayList.addAll(this.active);
            arrayList.addAll(this.waiting);
            this.active.clear();
            this.waiting.clear();
        }
        for (Downloader downloader : arrayList) {
            downloader.stop();
        }
    }

    @Override
    public synchronized Downloader download(RemoteFileDesc[] remoteFileDescArray, List<? extends RemoteFileDesc> list, GUID gUID, boolean bl, File file, String string) throws SaveLocationException {
        String string2 = this.getFileName(remoteFileDescArray, string);
        if (this.conflicts(remoteFileDescArray, new File(file, string2))) {
            throw new SaveLocationException(10, new File(string2 != null ? string2 : ""));
        }
        this.incompleteFileManager.purge();
        ManagedDownloader managedDownloader = this.coreDownloaderFactory.createManagedDownloader(remoteFileDescArray, gUID, file, string, bl);
        this.initializeDownload(managedDownloader);
        managedDownloader.addDownload(list, false);
        return managedDownloader;
    }

    @Override
    public synchronized Downloader download(MagnetOptions magnetOptions, boolean bl, File file, String string) throws IllegalArgumentException, SaveLocationException {
        if (!magnetOptions.isDownloadable()) {
            throw new IllegalArgumentException("magnet not downloadable");
        }
        this.incompleteFileManager.purge();
        if (string == null) {
            string = magnetOptions.getFileNameForSaving();
        }
        if (this.conflicts(magnetOptions.getSHA1Urn(), 0L, new File(file, string))) {
            throw new SaveLocationException(10, new File(string));
        }
        MagnetDownloader magnetDownloader = this.coreDownloaderFactory.createMagnetDownloader(magnetOptions, bl, file, string);
        this.initializeDownload(magnetDownloader);
        return magnetDownloader;
    }

    @Override
    public synchronized Downloader downloadFromStore(RemoteFileDesc remoteFileDesc, boolean bl, File file, String string) throws IllegalArgumentException, SaveLocationException {
        this.incompleteFileManager.purge();
        if (this.conflicts(remoteFileDesc.getSHA1Urn(), 0L, new File(file, string))) {
            throw new SaveLocationException(10, new File(string));
        }
        StoreDownloader storeDownloader = this.coreDownloaderFactory.createStoreDownloader(remoteFileDesc, file, string, bl);
        this.initializeDownload(storeDownloader);
        return storeDownloader;
    }

    @Override
    public synchronized Downloader download(File file) throws CantResumeException, SaveLocationException {
        if (this.conflictsWithIncompleteFile(file)) {
            throw new SaveLocationException(10, file);
        }
        if (IncompleteFileManager.isTorrentFolder(file)) {
            return this.resumeTorrentDownload(file);
        }
        this.incompleteFileManager.purge();
        ResumeDownloader resumeDownloader = null;
        try {
            file = FileUtils.getCanonicalFile(file);
            String string = IncompleteFileManager.getCompletedName(file);
            long l = IncompleteFileManager.getCompletedSize(file);
            resumeDownloader = this.coreDownloaderFactory.createResumeDownloader(file, string, l);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CantResumeException(file.getName());
        }
        catch (IOException iOException) {
            throw new CantResumeException(file.getName());
        }
        this.initializeDownload(resumeDownloader);
        return resumeDownloader;
    }

    private Downloader resumeTorrentDownload(File file) throws CantResumeException, SaveLocationException {
        Object throwable;
        File file2 = null;
        for (File invalidDataException : file.listFiles()) {
            if (!invalidDataException.getName().startsWith(".dat")) continue;
            file2 = invalidDataException;
            break;
        }
        String string = IncompleteFileManager.getCompletedName(file);
        if (file2 == null) {
            throw new CantResumeException(string);
        }
        BTMetaInfoMemento bTMetaInfoMemento = null;
        try {
            throwable = FileUtils.readObject(file2.getAbsolutePath());
            bTMetaInfoMemento = (BTMetaInfoMemento)throwable;
        }
        catch (Throwable throwable2) {
            throw new CantResumeException(string);
        }
        try {
            throwable = new BTMetaInfo(bTMetaInfoMemento);
        }
        catch (InvalidDataException invalidDataException) {
            throw new CantResumeException(string);
        }
        Downloader downloader = this.downloadTorrent((BTMetaInfo)throwable, false);
        if (downloader.isResumable()) {
            downloader.resume();
        }
        return downloader;
    }

    @Override
    public synchronized Downloader download(DownloadInformation downloadInformation, long l) throws SaveLocationException {
        File file = SharingUtils.PREFERENCE_SHARE;
        file.mkdirs();
        File file2 = new File(file, downloadInformation.getUpdateFileName());
        if (this.conflicts(downloadInformation.getUpdateURN(), (int)downloadInformation.getSize(), file2)) {
            throw new SaveLocationException(10, file2);
        }
        this.incompleteFileManager.purge();
        InNetworkDownloader inNetworkDownloader = this.coreDownloaderFactory.createInNetworkDownloader(downloadInformation, file, l);
        this.initializeDownload(inNetworkDownloader);
        return inNetworkDownloader;
    }

    @Override
    public synchronized Downloader downloadTorrent(BTMetaInfo bTMetaInfo, boolean bl) throws SaveLocationException {
        TorrentFileSystem torrentFileSystem = bTMetaInfo.getFileSystem();
        this.checkActiveAndWaiting(bTMetaInfo.getURN(), torrentFileSystem);
        if (!bl) {
            this.checkTargetLocation(torrentFileSystem, bl);
        } else {
            this.torrentManager.get().killTorrentForFile(torrentFileSystem.getCompleteFile());
        }
        BTDownloader bTDownloader = this.coreDownloaderFactory.createBTDownloader(bTMetaInfo);
        bTDownloader.setOverwrite(bl);
        this.initializeDownload(bTDownloader);
        return bTDownloader;
    }

    private void checkTargetLocation(TorrentFileSystem torrentFileSystem, boolean bl) throws SaveLocationException {
        for (File file : torrentFileSystem.getFilesAndFolders()) {
            if (!file.exists()) continue;
            throw new SaveLocationException(5, file);
        }
    }

    private void checkActiveAndWaiting(URN uRN, TorrentFileSystem torrentFileSystem) throws SaveLocationException {
        for (CoreDownloader coreDownloader : this.activeAndWaiting) {
            if (uRN.equals(coreDownloader.getSha1Urn())) {
                throw new SaveLocationException(10, torrentFileSystem.getCompleteFile());
            }
            for (File file : torrentFileSystem.getFilesAndFolders()) {
                if (!coreDownloader.conflictsSaveFile(file)) continue;
                throw new SaveLocationException(6, file);
            }
        }
    }

    private void initializeDownload(CoreDownloader coreDownloader) {
        coreDownloader.initialize();
        this.waiting.add(coreDownloader);
        this.callback(coreDownloader).addDownload(coreDownloader);
        this.backgroundExecutor.execute(new Runnable(){

            public void run() {
                DownloadManagerImpl.this.writeSnapshot();
            }
        });
    }

    private DownloadCallback callback(Downloader downloader) {
        return downloader instanceof InNetworkDownloader ? this.innetworkCallback : this.downloadCallback.get();
    }

    private boolean conflicts(RemoteFileDesc[] remoteFileDescArray, File ... fileArray) {
        URN uRN = null;
        for (int i = 0; i < remoteFileDescArray.length && uRN == null; ++i) {
            uRN = remoteFileDescArray[0].getSHA1Urn();
        }
        return this.conflicts(uRN, remoteFileDescArray[0].getSize(), fileArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean conflicts(URN uRN, long l, File ... fileArray) {
        if (uRN == null && l == 0L) {
            return false;
        }
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            for (CoreDownloader coreDownloader : this.activeAndWaiting) {
                if (!coreDownloader.conflicts(uRN, l, fileArray)) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public synchronized boolean isSaveLocationTaken(File file) {
        for (CoreDownloader coreDownloader : this.activeAndWaiting) {
            if (!coreDownloader.conflictsSaveFile(file)) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean conflictsWithIncompleteFile(File file) {
        for (CoreDownloader coreDownloader : this.activeAndWaiting) {
            if (!coreDownloader.conflictsWithIncompleteFile(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleQueryReply(QueryReply queryReply) {
        HostData hostData;
        List<Response> list;
        if (queryReply.calculateQualityOfService(!this.networkManager.acceptedIncomingConnection(), this.networkManager) < 1) {
            return;
        }
        try {
            list = queryReply.getResultsAsList();
            hostData = queryReply.getHostData();
        }
        catch (BadPacketException badPacketException) {
            return;
        }
        this.addDownloadWithResponses(list, hostData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDownloadWithResponses(List<? extends Response> list, HostData hostData) {
        if (list == null) {
            throw new NullPointerException("null responses");
        }
        if (hostData == null) {
            throw new NullPointerException("null hostdata");
        }
        ArrayList<CoreDownloader> arrayList = new ArrayList<CoreDownloader>(this.active.size() + this.waiting.size());
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            arrayList.addAll(this.active);
            arrayList.addAll(this.waiting);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        block3: for (Response response : list) {
            RemoteFileDesc remoteFileDesc = response.toRemoteFileDesc(hostData, this.remoteFileDescFactory);
            for (CoreDownloader coreDownloader : arrayList) {
                ManagedDownloader managedDownloader;
                if (!(coreDownloader instanceof ManagedDownloader) || !(managedDownloader = (ManagedDownloader)coreDownloader).addDownload(remoteFileDesc, true)) continue;
                for (IpPort ipPort : response.getLocations()) {
                    managedDownloader.addDownload(this.remoteFileDescFactory.createRemoteFileDesc(remoteFileDesc, ipPort), false);
                }
                continue block3;
            }
        }
    }

    private boolean hasFreeSlot() {
        return this.active.size() - this.innetworkCount - this.storeDownloadCount < DownloadSettings.MAX_SIM_DOWNLOAD.getValue();
    }

    @Override
    public synchronized void remove(CoreDownloader coreDownloader, boolean bl) {
        boolean bl2 = this.active.remove(coreDownloader);
        if (coreDownloader.getDownloadType() == DownloaderType.INNETWORK) {
            --this.innetworkCount;
        }
        if (coreDownloader.getDownloadType() == DownloaderType.STORE && bl2) {
            --this.storeDownloadCount;
        }
        this.waiting.remove(coreDownloader);
        if (bl) {
            this.cleanupCompletedDownload(coreDownloader, true);
        } else {
            this.waiting.add(coreDownloader);
        }
    }

    @Override
    public synchronized void bumpPriority(Downloader downloader, boolean bl, int n) {
        CoreDownloader coreDownloader = (CoreDownloader)downloader;
        int n2 = this.waiting.indexOf(coreDownloader);
        if (n2 == -1) {
            return;
        }
        if (bl && n2 != 0) {
            this.waiting.remove(n2);
            if (n > n2) {
                n = n2;
            }
            if (n != 0) {
                this.waiting.add(n2 - n, coreDownloader);
            } else {
                this.waiting.add(0, coreDownloader);
            }
        } else if (!bl && n2 != this.waiting.size() - 1) {
            this.waiting.remove(n2);
            if (n != 0) {
                if ((n += n2) > this.waiting.size()) {
                    n = this.waiting.size();
                }
                this.waiting.add(n, coreDownloader);
            } else {
                this.waiting.add(coreDownloader);
            }
        }
    }

    private void cleanupCompletedDownload(CoreDownloader coreDownloader, boolean bl) {
        coreDownloader.finish();
        if (coreDownloader.getQueryGUID() != null) {
            this.messageRouter.get().downloadFinished(coreDownloader.getQueryGUID());
        }
        this.callback(coreDownloader).removeDownload(coreDownloader);
        if (bl) {
            this.writeSnapshot();
        }
        if (this.active.isEmpty() && this.waiting.isEmpty()) {
            this.callback(coreDownloader).downloadsComplete();
        }
    }

    @Override
    public void sendQuery(QueryRequest queryRequest) {
        this.messageRouter.get().sendDynamicQuery(queryRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void measureBandwidth() {
        ArrayList<CoreDownloader> arrayList;
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            arrayList = new ArrayList<CoreDownloader>(this.active);
        }
        float f = 0.0f;
        boolean bl = false;
        for (CoreDownloader coreDownloader : arrayList) {
            if (coreDownloader instanceof InNetworkDownloader) continue;
            bl = true;
            coreDownloader.measureBandwidth();
            f += coreDownloader.getAverageBandwidth();
        }
        if (bl) {
            DownloadManagerImpl downloadManagerImpl2 = this;
            synchronized (downloadManagerImpl2) {
                this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + f) / (float)(++this.numMeasures);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getMeasuredBandwidth() {
        ArrayList<CoreDownloader> arrayList;
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            arrayList = new ArrayList<CoreDownloader>(this.active);
        }
        float f = 0.0f;
        for (CoreDownloader coreDownloader : arrayList) {
            if (coreDownloader instanceof InNetworkDownloader) continue;
            float f2 = 0.0f;
            try {
                f2 = coreDownloader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f2 = 0.0f;
            }
            f += f2;
        }
        this.lastMeasuredBandwidth = f;
        return f;
    }

    @Override
    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    @Override
    public float getLastMeasuredBandwidth() {
        return this.lastMeasuredBandwidth;
    }

    private String getFileName(RemoteFileDesc[] remoteFileDescArray, String string) {
        for (int i = 0; i < remoteFileDescArray.length && string == null; ++i) {
            string = remoteFileDescArray[i].getFileName();
        }
        return string;
    }

    @Override
    public final Iterable<CoreDownloader> getAllDownloaders() {
        return this.activeAndWaiting;
    }

    @Override
    public final CoreDownloaderFactory getCoreDownloaderFactory() {
        return this.coreDownloaderFactory;
    }
}

