/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.FileManagerController;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.library.LibraryData;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.licenses.LicenseType;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.routing.HashFunction;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.settings.DHTSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Comparators;
import org.limewire.collection.Function;
import org.limewire.collection.IntSet;
import org.limewire.collection.MultiCollection;
import org.limewire.collection.MultiIterator;
import org.limewire.collection.StringTrie;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectableForSize;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionPoint;
import org.limewire.setting.StringArraySetting;
import org.limewire.statistic.StatsUtils;
import org.limewire.util.ByteOrder;
import org.limewire.util.FileUtils;
import org.limewire.util.I18NConvert;
import org.limewire.util.RPNParser;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileManagerImpl
implements FileManager {
    private static final Log LOG = LogFactory.getLog(FileManagerImpl.class);
    private static final ExecutorService LOADER = ExecutorsHelper.newProcessingQueue("FileManagerLoader");
    private static final int STORE_FILEDESC_INDEX = Integer.MAX_VALUE;
    private static long QRP_DELAY = (LimeWireUtils.isBetaRelease() ? 1 : 60) * 60 * 1000;
    private volatile CopyOnWriteArrayList<FileEventListener> eventListeners = new CopyOnWriteArrayList();
    private final LibraryData _data = new LibraryData();
    private List<FileDesc> _files;
    @InspectablePrimitive(value="total size of shared files")
    private long _filesSize;
    @InspectablePrimitive(value="number of shared files")
    private int _numFiles;
    @InspectablePrimitive(value="number of pending files")
    private int _numPendingFiles;
    @InspectablePrimitive(value="number of incomplete files")
    private int _numIncompleteFiles;
    @InspectablePrimitive(value="number force-shared files")
    private int _numForcedFiles;
    private Map<File, FileDesc> _fileToFileDescMap;
    @InspectableForSize(value="size of keyword trie")
    private StringTrie<IntSet> _keywordTrie;
    @InspectableForSize(value="size of incomplete keyword trie")
    private StringTrie<IntSet> _incompleteKeywordTrie;
    private Map<URN, IntSet> _urnMap;
    private static Set<String> _extensions;
    @InspectableForSize(value="number completely shared directories")
    private Set<File> _completelySharedDirectories;
    @InspectableForSize(value="number incompletely shared files")
    private IntSet _incompletesShared;
    private Set<URN> _requestingValidation = Collections.synchronizedSet(new HashSet());
    @InspectableForSize(value="number of transiently shared files")
    private Set<File> _transientSharedFiles = new HashSet<File>();
    private Map<File, FileDesc> _storeToFileDescMap;
    @InspectableForSize(value="number of directories for the store")
    private Set<File> _storeDirectories;
    @InspectableForSize(value="number of individually shared files")
    private Collection<File> _individualSharedFiles;
    @InspectablePrimitive(value="filemanager revision")
    protected volatile int _revision = 0;
    @InspectablePrimitive(value="revision that finished loading")
    private volatile int _pendingFinished = -1;
    private volatile int _updatingFinished = -1;
    @InspectablePrimitive(value="filemanager currently updating")
    private volatile boolean _isUpdating = false;
    private volatile int _loadingFinished = -1;
    protected volatile boolean shutdown;
    private final FileFilter SHAREABLE_FILE_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return FileManagerImpl.this.isFileShareable(file);
        }
    };
    private static final FileFilter DIRECTORY_FILTER;
    private static final FileEventListener EMPTY_CALLBACK;
    protected static QueryRouteTable _queryRouteTable;
    protected static volatile boolean _needRebuild;
    private final QRPUpdater qrpUpdater = new QRPUpdater();
    private final RareFileDefinition rareDefinition;
    protected final FileManagerController fileManagerController;
    private static final Response[] EMPTY_RESPONSES;

    private static final boolean isDelimiter(char c) {
        switch (c) {
            case ' ': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case '\\': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    @Inject
    public FileManagerImpl(FileManagerController fileManagerController) {
        this.fileManagerController = fileManagerController;
        this.rareDefinition = new RareFileDefinition();
        this.resetVariables();
    }

    private void resetVariables() {
        this._filesSize = 0L;
        this._numFiles = 0;
        this._numIncompleteFiles = 0;
        this._numPendingFiles = 0;
        this._numForcedFiles = 0;
        this._files = new ArrayList<FileDesc>();
        this._keywordTrie = new StringTrie(true);
        this._incompleteKeywordTrie = new StringTrie(true);
        this._urnMap = new HashMap<URN, IntSet>();
        _extensions = new HashSet<String>();
        this._completelySharedDirectories = new HashSet<File>();
        this._incompletesShared = new IntSet();
        this._fileToFileDescMap = new HashMap<File, FileDesc>();
        this._individualSharedFiles = Collections.synchronizedCollection(new MultiCollection<File>((Collection<File>)this._transientSharedFiles, (Collection<File>)this._data.SPECIAL_FILES_TO_SHARE));
        this._storeToFileDescMap = new HashMap<File, FileDesc>();
        this._storeDirectories = new HashSet<File>();
    }

    @Override
    public void start() {
        this._data.clean();
        this.cleanIndividualFiles();
        this.loadSettings();
        this.fileManagerController.addSimppListener(this.qrpUpdater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAndWait(long l) throws InterruptedException, TimeoutException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        FileEventListener fileEventListener = new FileEventListener(){

            public void handleFileEvent(FileManagerEvent fileManagerEvent) {
                if (fileManagerEvent.getType() == FileManagerEvent.Type.FILEMANAGER_LOADED) {
                    countDownLatch.countDown();
                }
            }
        };
        try {
            this.addFileEventListener(fileEventListener);
            this.start();
            if (!countDownLatch.await(l, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Initialization of FileManager did not complete within " + l + " ms");
            }
        }
        finally {
            this.removeFileEventListener(fileEventListener);
        }
    }

    @Override
    public void stop() {
        this.save();
        this.fileManagerController.removeSimppListener(this.qrpUpdater);
        this.shutdown = true;
    }

    protected void save() {
        this._data.save();
        this.fileManagerController.save();
    }

    @Override
    public int getSize() {
        return ByteOrder.long2int(this._filesSize);
    }

    @Override
    public int getNumFiles() {
        return this._numFiles - this._numForcedFiles;
    }

    @Override
    public int getNumStoreFiles() {
        return this._storeToFileDescMap.size();
    }

    @Override
    public int getNumIncompleteFiles() {
        return this._numIncompleteFiles;
    }

    @Override
    public int getNumPendingFiles() {
        return this._numPendingFiles;
    }

    @Override
    public int getNumForcedFiles() {
        return this._numForcedFiles;
    }

    @Override
    public synchronized FileDesc get(int n) {
        return this._files.get(n);
    }

    @Override
    public synchronized boolean isValidIndex(int n) {
        return n >= 0 && n < this._files.size();
    }

    @Override
    public synchronized URN getURNForFile(File file) {
        FileDesc fileDesc = this.getFileDescForFile(file);
        if (fileDesc != null) {
            return fileDesc.getSHA1Urn();
        }
        return null;
    }

    @Override
    public synchronized FileDesc getFileDescForFile(File file) {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return null;
        }
        if (this._fileToFileDescMap.containsKey(file)) {
            return this._fileToFileDescMap.get(file);
        }
        return this._storeToFileDescMap.get(file);
    }

    @Override
    public synchronized boolean isUrnShared(URN uRN) {
        FileDesc fileDesc = this.getFileDescForUrn(uRN);
        return fileDesc != null && !(fileDesc instanceof IncompleteFileDesc);
    }

    @Override
    public synchronized FileDesc getFileDescForUrn(URN uRN) {
        if (!uRN.isSHA1()) {
            throw new IllegalArgumentException();
        }
        IntSet intSet = this._urnMap.get(uRN);
        if (intSet == null) {
            return null;
        }
        IntSet.IntSetIterator intSetIterator = intSet.iterator();
        FileDesc fileDesc = null;
        while (intSetIterator.hasNext() && (fileDesc == null || fileDesc instanceof IncompleteFileDesc)) {
            int n = intSetIterator.next();
            fileDesc = this._files.get(n);
        }
        return fileDesc;
    }

    @Override
    public synchronized FileDesc[] getIncompleteFileDescriptors() {
        if (this._incompletesShared == null) {
            return null;
        }
        FileDesc[] fileDescArray = new FileDesc[this._incompletesShared.size()];
        IntSet.IntSetIterator intSetIterator = this._incompletesShared.iterator();
        int n = 0;
        while (intSetIterator.hasNext()) {
            FileDesc fileDesc = this._files.get(intSetIterator.next());
            assert (fileDesc != null) : "Directory has null entry";
            fileDescArray[n] = fileDesc;
            ++n;
        }
        return fileDescArray;
    }

    @Override
    public synchronized FileDesc[] getAllSharedFileDescriptors() {
        FileDesc[] fileDescArray = new FileDesc[this._fileToFileDescMap.size()];
        fileDescArray = this._fileToFileDescMap.values().toArray(fileDescArray);
        return fileDescArray;
    }

    @Override
    public synchronized List<FileDesc> getSharedFilesInDirectory(File file) {
        if (file == null) {
            throw new NullPointerException("null directory");
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
        ArrayList<FileDesc> arrayList = new ArrayList<FileDesc>();
        for (FileDesc fileDesc : this._fileToFileDescMap.values()) {
            if (!file.equals(fileDesc.getFile().getParentFile())) continue;
            arrayList.add(fileDesc);
        }
        return arrayList;
    }

    @Override
    public void loadSettings() {
        final int n = ++this._revision;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting new library revision: " + n);
        }
        LOADER.execute(new Runnable(){

            public void run() {
                FileManagerImpl.this.loadStarted(n);
                FileManagerImpl.this.loadSettingsInternal(n);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSettingsAndWait(long l) throws InterruptedException, TimeoutException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        FileEventListener fileEventListener = new FileEventListener(){

            public void handleFileEvent(FileManagerEvent fileManagerEvent) {
                if (fileManagerEvent.getType() == FileManagerEvent.Type.FILEMANAGER_LOADED) {
                    countDownLatch.countDown();
                }
            }
        };
        try {
            this.addFileEventListener(fileEventListener);
            this.loadSettings();
            if (!countDownLatch.await(l, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Loading of FileManager settings did not complete within " + l + " ms");
            }
        }
        finally {
            this.removeFileEventListener(fileEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadWithNewDirectories(Set<? extends File> set, Set<File> set2) {
        SharingSettings.DIRECTORIES_TO_SHARE.setValue(set);
        Set<File> set3 = this._data.DIRECTORIES_NOT_TO_SHARE;
        synchronized (set3) {
            this._data.DIRECTORIES_NOT_TO_SHARE.clear();
            this._data.DIRECTORIES_NOT_TO_SHARE.addAll(FileManagerImpl.canonicalize(set2));
            this._storeDirectories.clear();
            this._storeDirectories.add(SharingSettings.getSaveLWSDirectory());
        }
        this.loadSettings();
    }

    protected void loadStarted(int n) {
        this.fileManagerController.loadStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToFinish() {
        int n;
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            if (this._pendingFinished != this._updatingFinished || this._pendingFinished != this._revision || this._loadingFinished >= this._revision) {
                return;
            }
            n = this._loadingFinished = this._revision;
        }
        this.loadFinished(n);
    }

    protected void loadFinished(int n) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished loading revision: " + n);
        }
        this.trim();
        this.fileManagerController.loadFinished();
        this.save();
        this.fileManagerController.loadFinishedPostSave();
        this.dispatchFileEvent(new FileManagerEvent(this, FileManagerEvent.Type.FILEMANAGER_LOADED));
    }

    @Override
    public boolean isLoadFinished() {
        return this._loadingFinished == this._revision;
    }

    @Override
    public boolean isUpdating() {
        return this._isUpdating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettingsInternal(int n) {
        File[] fileArray;
        Object object;
        Object object2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading Library Revision: " + n);
        }
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            this.resetVariables();
            for (String string : object2 = StringArraySetting.decode(SharingSettings.EXTENSIONS_TO_SHARE.getValue().toLowerCase())) {
                _extensions.add(string);
            }
            if (SharingSettings.EXTENSIONS_LIST_CUSTOM.getValue().length() > 0) {
                object = StringArraySetting.decode(SharingSettings.EXTENSIONS_LIST_CUSTOM.getValue());
                String[] stringArray = object;
                int n2 = stringArray.length;
                for (int i = 0; i < n2; ++i) {
                    String string = stringArray[i];
                    _extensions.add(string);
                }
            }
            if (SharingSettings.DISABLE_SENSITIVE.getValue()) {
                for (String string : SharingSettings.getDefaultDisabledExtensions()) {
                    _extensions.remove(string);
                }
            }
            if (SharingSettings.EXTENSIONS_LIST_UNSHARED.getValue().length() > 0) {
                object = StringArraySetting.decode(SharingSettings.EXTENSIONS_LIST_UNSHARED.getValue());
                for (String string : object) {
                    _extensions.remove(string);
                }
            }
            fileArray = SharingSettings.DIRECTORIES_TO_SHARE.getValueAsArray();
            Arrays.sort(fileArray, new Comparator<File>(){

                @Override
                public int compare(File file, File file2) {
                    return file.toString().length() - file2.toString().length();
                }
            });
        }
        this.fileManagerController.fileManagerLoading();
        this.dispatchFileEvent(new FileManagerEvent(this, FileManagerEvent.Type.FILEMANAGER_LOADING));
        this.updateSharedDirectories(SharingUtils.PROGRAM_SHARE, null, n);
        this.updateSharedDirectories(SharingUtils.PREFERENCE_SHARE, null, n);
        this._isUpdating = true;
        for (int i = 0; i < fileArray.length && this._revision == n; ++i) {
            this.updateSharedDirectories(fileArray[i], null, n);
        }
        Collection<File> collection = this._individualSharedFiles;
        object = collection;
        synchronized (object) {
            object2 = new ArrayList<File>(collection);
        }
        object = ((ArrayList)object2).iterator();
        while (object.hasNext()) {
            File file = (File)object.next();
            if (this._revision != n) break;
            this.addFileIfSharedOrStore(file, EMPTY_DOCUMENTS, true, this._revision, null, AddType.ADD_SHARE);
        }
        this._isUpdating = false;
        this.trim();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished queueing shared files for revision: " + n);
        }
        object = this;
        synchronized (object) {
            this._updatingFinished = n;
            if (this._numPendingFiles == 0) {
                this._pendingFinished = n;
            }
        }
        this.tryToFinish();
    }

    private void updateSharedDirectories(File file, File file2, int n) {
        this.updateSharedDirectories(file, file, file2, n, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSharedDirectories(File file, File file2, File file3, int n, int n2) {
        try {
            file2 = FileUtils.getCanonicalFile(file2);
        }
        catch (IOException iOException) {
            return;
        }
        if (!file2.exists()) {
            return;
        }
        if (!this.isFolderShareable(file2, true)) {
            return;
        }
        if (SharingUtils.isSensitiveDirectory(file2)) {
            if (this._data.SENSITIVE_DIRECTORIES_NOT_TO_SHARE.contains(file2)) {
                return;
            }
            if (!this._data.SENSITIVE_DIRECTORIES_VALIDATED.contains(file2) && !this.fileManagerController.warnAboutSharingSensitiveDirectory(file2)) {
                return;
            }
        }
        if (this._revision != n) {
            return;
        }
        boolean bl = SharingUtils.isForcedShareDirectory(file2);
        File[] fileArray = this;
        synchronized (this) {
            if (this._completelySharedDirectories.contains(file2)) {
                // ** MonitorExit[var7_8] (shouldn't be in output)
                return;
            }
            if (!this._storeDirectories.contains(file2)) {
                this._completelySharedDirectories.add(file2);
            }
            if (!bl) {
                this.dispatchFileEvent(new FileManagerEvent((FileManager)this, FileManagerEvent.Type.ADD_FOLDER, file, n2, file2, file3));
            }
            // ** MonitorExit[var7_8] (shouldn't be in output)
            fileArray = file2.listFiles(this.SHAREABLE_FILE_FILTER);
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length && this._revision == n; ++i) {
                this.addFileIfSharedOrStore(fileArray[i], EMPTY_DOCUMENTS, true, this._revision, null, AddType.ADD_SHARE);
            }
            if (this._revision != n) {
                return;
            }
            if (bl) {
                return;
            }
            File[] fileArray2 = file2.listFiles(DIRECTORY_FILTER);
            if (fileArray2 != null) {
                for (int i = 0; i < fileArray2.length && this._revision == n; ++i) {
                    super.updateSharedDirectories(file, fileArray2[i], file2, n, n2 + 1);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStoreDirectories(File file, File file2, int n) {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (this._revision != n) {
            return;
        }
        File[] fileArray = this;
        synchronized (this) {
            if (this._storeDirectories.contains(file)) {
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return;
            }
            this._storeDirectories.add(file);
            this.dispatchFileEvent(new FileManagerEvent((FileManager)this, FileManagerEvent.Type.ADD_STORE_FOLDER, file, file2));
            // ** MonitorExit[var4_5] (shouldn't be in output)
            fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length && this._revision == n; ++i) {
                this.addFileIfSharedOrStore(fileArray[i], EMPTY_DOCUMENTS, true, this._revision, null, AddType.ADD_STORE);
            }
            if (this._revision != n) {
                return;
            }
            File[] fileArray2 = file.listFiles(DIRECTORY_FILTER);
            if (fileArray2 != null) {
                for (int i = 0; i < fileArray2.length && this._revision == n; ++i) {
                    super.updateStoreDirectories(fileArray2[i], file, n);
                }
            }
            return;
        }
    }

    @Override
    public void removeFolderIfShared(File file) {
        this._isUpdating = true;
        this.removeFolderIfShared(file, null);
        this._isUpdating = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void removeFolderIfShared(File file, File file2) {
        if (!file.isDirectory() && file.exists()) {
            throw new IllegalArgumentException("Expected a directory, but given: " + file);
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File[] fileArray = this;
        synchronized (this) {
            boolean bl;
            boolean bl2 = this._completelySharedDirectories.contains(file);
            // ** MonitorExit[var4_5] (shouldn't be in output)
            if (!bl2) return;
            if (file2 != null && SharingSettings.DIRECTORIES_TO_SHARE.contains(file)) {
                return;
            }
            if (file2 == null && (!(bl = SharingSettings.DIRECTORIES_TO_SHARE.remove(file)) || this.isFolderShared(file.getParentFile()))) {
                this._data.DIRECTORIES_NOT_TO_SHARE.add(file);
            }
            File[] fileArray2 = this;
            synchronized (this) {
                this._completelySharedDirectories.remove(file);
                // ** MonitorExit[var4_7] (shouldn't be in output)
                fileArray2 = file.listFiles();
                if (fileArray2 != null) {
                    for (int i = 0; i < fileArray2.length; ++i) {
                        File file3 = fileArray2[i];
                        if (file3.isDirectory()) {
                            this.removeFolderIfShared(file3, file);
                            continue;
                        }
                        if (!file3.isFile() || this._individualSharedFiles.contains(file3)) continue;
                        if (this.removeFileIfShared(file3) == null) {
                            this.fileManagerController.clearPendingShare(file3);
                        }
                        if (!this.isStoreFile(file3)) continue;
                        this._data.SPECIAL_STORE_FILES.remove(file3);
                    }
                }
                this.dispatchFileEvent(new FileManagerEvent((FileManager)this, FileManagerEvent.Type.REMOVE_FOLDER, file));
                return;
            }
        }
    }

    @Override
    public void addSharedFolders(Set<File> set, Set<File> set2) {
        if (set.isEmpty()) {
            throw new IllegalArgumentException("Only blacklisting without sharing, not allowed");
        }
        this._data.DIRECTORIES_NOT_TO_SHARE.addAll(FileManagerImpl.canonicalize(set2));
        for (File file : set) {
            this.addSharedFolder(file);
        }
    }

    private static Set<File> canonicalize(Set<File> set) {
        HashSet<File> hashSet = new HashSet(set.size());
        try {
            for (File file : set) {
                hashSet.add(FileUtils.getCanonicalFile(file));
            }
        }
        catch (IOException iOException) {
            hashSet = set;
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<File> getFolderNotToShare() {
        Set<File> set = this._data.DIRECTORIES_NOT_TO_SHARE;
        synchronized (set) {
            return new HashSet<File>(this._data.DIRECTORIES_NOT_TO_SHARE);
        }
    }

    @Override
    public boolean addSharedFolder(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Expected a directory, but given: " + file);
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.isFolderShareable(file, false)) {
            return false;
        }
        this._data.DIRECTORIES_NOT_TO_SHARE.remove(file);
        if (!this.isFolderShared(file.getParentFile())) {
            SharingSettings.DIRECTORIES_TO_SHARE.add(file);
        }
        this._isUpdating = true;
        this.updateSharedDirectories(file, null, this._revision);
        this._isUpdating = false;
        return true;
    }

    @Override
    public void addFileAlways(File file) {
        this.addFileAlways(file, EMPTY_DOCUMENTS, null);
    }

    @Override
    public void addFileAlways(File file, FileEventListener fileEventListener) {
        this.addFileAlways(file, EMPTY_DOCUMENTS, fileEventListener);
    }

    @Override
    public void addFileAlways(File file, List<? extends LimeXMLDocument> list) {
        this.addFileAlways(file, list, null);
    }

    @Override
    public void addFileAlways(File file, List<? extends LimeXMLDocument> list, FileEventListener fileEventListener) {
        this._data.FILES_NOT_TO_SHARE.remove(file);
        if (!this.isFileShareable(file)) {
            this._data.SPECIAL_FILES_TO_SHARE.add(file);
        }
        this.addFileIfSharedOrStore(file, list, true, this._revision, fileEventListener, AddType.ADD_SHARE);
    }

    @Override
    public void addFileForSession(File file) {
        this.addFileForSession(file, null);
    }

    @Override
    public void addFileForSession(File file, FileEventListener fileEventListener) {
        this._data.FILES_NOT_TO_SHARE.remove(file);
        if (!this.isFileShareable(file)) {
            this._transientSharedFiles.add(file);
        }
        this.addFileIfSharedOrStore(file, EMPTY_DOCUMENTS, true, this._revision, fileEventListener, AddType.ADD_SHARE);
    }

    @Override
    public void addFileIfShared(File file) {
        this.addFileIfSharedOrStore(file, EMPTY_DOCUMENTS, true, this._revision, null, AddType.ADD_SHARE);
    }

    @Override
    public void addFileIfShared(File file, FileEventListener fileEventListener) {
        this.addFileIfSharedOrStore(file, EMPTY_DOCUMENTS, true, this._revision, fileEventListener, AddType.ADD_SHARE);
    }

    @Override
    public void addFileIfShared(File file, List<? extends LimeXMLDocument> list) {
        this.addFileIfSharedOrStore(file, list, true, this._revision, null, AddType.ADD_SHARE);
    }

    @Override
    public void addFileIfShared(File file, List<? extends LimeXMLDocument> list, FileEventListener fileEventListener) {
        this.addFileIfSharedOrStore(file, list, true, this._revision, fileEventListener, AddType.ADD_SHARE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileIfSharedOrStore(File file, List<? extends LimeXMLDocument> list, boolean bl, int n, FileEventListener fileEventListener, AddType addType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to load store or shared file: " + file);
        }
        if (fileEventListener == null) {
            fileEventListener = EMPTY_CALLBACK;
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            fileEventListener.handleFileEvent(new FileManagerEvent((FileManager)this, addType.getFailureType(), file));
            return;
        }
        if (!this.isFileShareable(file) && !this.isFileLocatedStoreDirectory(file)) {
            this._individualSharedFiles.remove(file);
            fileEventListener.handleFileEvent(new FileManagerEvent((FileManager)this, addType.getFailureType(), file));
            return;
        }
        if (this.isStoreFile(file)) {
            return;
        }
        if (this.isFileShared(file)) {
            fileEventListener.handleFileEvent(new FileManagerEvent((FileManager)this, FileManagerEvent.Type.ALREADY_SHARED_FILE, file));
            return;
        }
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            if (n != this._revision) {
                fileEventListener.handleFileEvent(new FileManagerEvent((FileManager)this, addType.getFailureType(), file));
                return;
            }
            ++this._numPendingFiles;
            this._pendingFinished = -1;
        }
        this.fileManagerController.calculateAndCacheUrns(file, this.getNewUrnCallback(file, list, bl, n, fileEventListener, addType));
    }

    protected UrnCallback getNewUrnCallback(final File file, final List<? extends LimeXMLDocument> list, final boolean bl, final int n, final FileEventListener fileEventListener, final AddType addType) {
        return new UrnCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void urnsCalculated(File file2, Set<? extends URN> set) {
                FileDesc fileDesc = null;
                FileManagerImpl fileManagerImpl = FileManagerImpl.this;
                synchronized (fileManagerImpl) {
                    if (n != FileManagerImpl.this._revision) {
                        LOG.warn("Revisions changed, dropping share.");
                        fileEventListener.handleFileEvent(new FileManagerEvent((FileManager)FileManagerImpl.this, addType.getFailureType(), file));
                        return;
                    }
                    FileManagerImpl.this._numPendingFiles--;
                    if (!set.isEmpty()) {
                        int n2 = FileManagerImpl.this._files.size();
                        fileDesc = FileManagerImpl.this.createFileDesc(file, set, n2);
                    }
                }
                if (fileDesc == null) {
                    fileEventListener.handleFileEvent(new FileManagerEvent((FileManager)FileManagerImpl.this, addType.getFailureType(), file));
                    return;
                }
                FileManagerImpl.this.loadFile(fileDesc, file, list, set);
                if (FileManagerImpl.this.isStoreXML(fileDesc.getXMLDocument())) {
                    FileManagerImpl.this.addStoreFile(fileDesc, file, set, addType, bl, fileEventListener);
                } else if (addType == AddType.ADD_SHARE) {
                    FileManagerImpl.this.addSharedFile(file, fileDesc, set, addType, bl, fileEventListener);
                }
                boolean bl2 = false;
                8 var5_7 = this;
                synchronized (var5_7) {
                    if (FileManagerImpl.this._numPendingFiles == 0) {
                        FileManagerImpl.this._pendingFinished = n;
                        bl2 = true;
                    }
                }
                if (bl2) {
                    FileManagerImpl.this.tryToFinish();
                }
            }

            @Override
            public boolean isOwner(Object object) {
                return object == FileManagerImpl.this.fileManagerController;
            }
        };
    }

    protected void loadFile(FileDesc fileDesc, File file, List<? extends LimeXMLDocument> list, Set<? extends URN> set) {
    }

    private synchronized void addStoreFile(FileDesc fileDesc, File file, Set<? extends URN> set, AddType addType, boolean bl, FileEventListener fileEventListener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sharing file: " + file);
        }
        if (addType == AddType.ADD_SHARE) {
            this._data.SPECIAL_STORE_FILES.add(file);
        }
        FileDesc fileDesc2 = this.createFileDesc(file, set, Integer.MAX_VALUE);
        if (fileDesc.getXMLDocument() != null) {
            fileDesc2.addLimeXMLDocument(fileDesc.getXMLDocument());
        }
        this._storeToFileDescMap.put(file, fileDesc2);
        FileManagerEvent fileManagerEvent = new FileManagerEvent((FileManager)this, FileManagerEvent.Type.ADD_STORE_FILE, fileDesc2);
        if (bl) {
            this.dispatchFileEvent(fileManagerEvent);
        }
        fileEventListener.handleFileEvent(fileManagerEvent);
    }

    private synchronized void addSharedFile(File file, FileDesc fileDesc, Set<? extends URN> set, AddType addType, boolean bl, FileEventListener fileEventListener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sharing file: " + file);
        }
        if (fileDesc.getIndex() != this._files.size()) {
            LimeXMLDocument limeXMLDocument = fileDesc.getXMLDocument();
            fileDesc = this.createFileDesc(file, set, this._files.size());
            if (limeXMLDocument != null) {
                fileDesc.addLimeXMLDocument(limeXMLDocument);
            }
        }
        long l = file.length();
        this._filesSize += l;
        this._files.add(fileDesc);
        this._fileToFileDescMap.put(file, fileDesc);
        ++this._numFiles;
        File file2 = file.getParentFile();
        assert (file2 != null) : "Null parent to \"" + file + "\"";
        if (SharingUtils.isForcedShareDirectory(file2)) {
            ++this._numForcedFiles;
        }
        this.loadKeywords(this._keywordTrie, fileDesc);
        if (!SharingUtils.isForcedShare(file)) {
            this.fileManagerController.fileAdded(file, fileDesc.getSHA1Urn());
        }
        this.updateUrnIndex(fileDesc);
        _needRebuild = true;
        FileManagerEvent fileManagerEvent = new FileManagerEvent((FileManager)this, addType.getSuccessType(), fileDesc);
        if (bl) {
            this.dispatchFileEvent(fileManagerEvent);
        }
        fileEventListener.handleFileEvent(fileManagerEvent);
    }

    private void loadKeywords(StringTrie<IntSet> stringTrie, FileDesc fileDesc) {
        String[] stringArray = FileManagerImpl.extractKeywords(fileDesc);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            IntSet intSet = stringTrie.get(string);
            if (intSet == null) {
                intSet = new IntSet();
                stringTrie.add(string, intSet);
            }
            intSet.add(fileDesc.getIndex());
        }
    }

    private FileDesc createFileDesc(File file, Set<? extends URN> set, int n) {
        FileDesc fileDesc = new FileDesc(file, set, n);
        ContentResponseData contentResponseData = this.fileManagerController.getResponseDataFor(fileDesc.getSHA1Urn());
        if (contentResponseData != null && !contentResponseData.isOK()) {
            return null;
        }
        return fileDesc;
    }

    @Override
    public synchronized FileDesc stopSharingFile(File file) {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return null;
        }
        boolean bl = this._individualSharedFiles.remove(file);
        FileDesc fileDesc = this.removeFileIfShared(file);
        if (fileDesc == null) {
            this.fileManagerController.clearPendingShare(file);
        } else {
            file = fileDesc.getFile();
            if (!bl) {
                this._data.FILES_NOT_TO_SHARE.add(file);
            }
        }
        return fileDesc;
    }

    @Override
    public synchronized FileDesc removeFileIfShared(File file) {
        return this.removeFileIfShared(file, true);
    }

    protected synchronized FileDesc removeFileIfShared(File file, boolean bl) {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return null;
        }
        FileDesc fileDesc = this._fileToFileDescMap.get(file);
        if (fileDesc == null) {
            return null;
        }
        int n = fileDesc.getIndex();
        assert (this._files.get(n).getFile().equals(file)) : "invariant broken!";
        this._files.set(n, null);
        this._fileToFileDescMap.remove(file);
        _needRebuild = true;
        if (fileDesc instanceof IncompleteFileDesc) {
            this.removeUrnIndex(fileDesc, false);
            this.removeKeywords(this._incompleteKeywordTrie, fileDesc);
            --this._numIncompleteFiles;
            boolean bl2 = this._incompletesShared.remove(n);
            assert (bl2) : "File " + n + " not found in " + this._incompletesShared;
            if (bl) {
                FileManagerEvent fileManagerEvent = new FileManagerEvent((FileManager)this, FileManagerEvent.Type.REMOVE_FILE, fileDesc);
                this.dispatchFileEvent(fileManagerEvent);
            }
            return fileDesc;
        }
        --this._numFiles;
        this._filesSize -= fileDesc.getFileSize();
        File file2 = file.getParentFile();
        if (SharingUtils.isForcedShareDirectory(file2)) {
            bl = false;
            --this._numForcedFiles;
        }
        this.removeKeywords(this._keywordTrie, fileDesc);
        this.removeUrnIndex(fileDesc, true);
        if (bl) {
            FileManagerEvent fileManagerEvent = new FileManagerEvent((FileManager)this, FileManagerEvent.Type.REMOVE_FILE, fileDesc);
            this.dispatchFileEvent(fileManagerEvent);
        }
        return fileDesc;
    }

    private void removeKeywords(StringTrie<IntSet> stringTrie, FileDesc fileDesc) {
        String[] stringArray = FileManagerImpl.extractKeywords(fileDesc);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            IntSet intSet = stringTrie.get(string);
            if (intSet == null) continue;
            intSet.remove(fileDesc.getIndex());
            if (intSet.size() != 0) continue;
            stringTrie.remove(string);
        }
    }

    protected synchronized FileDesc removeStoreFile(File file, boolean bl) {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return null;
        }
        FileDesc fileDesc = this._storeToFileDescMap.get(file);
        if (fileDesc == null) {
            return null;
        }
        this._data.SPECIAL_STORE_FILES.remove(file);
        this._storeToFileDescMap.remove(file);
        if (bl) {
            FileManagerEvent fileManagerEvent = new FileManagerEvent((FileManager)this, FileManagerEvent.Type.REMOVE_STORE_FILE, fileDesc);
            this.dispatchFileEvent(fileManagerEvent);
        }
        return fileDesc;
    }

    @Override
    public synchronized void addIncompleteFile(File file, Set<? extends URN> set, String string, long l, VerifyingFile verifyingFile) {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return;
        }
        for (URN hTTPHeaderValue2 : set) {
            IntSet intSet;
            if (!hTTPHeaderValue2.isSHA1() || (intSet = this._urnMap.get(hTTPHeaderValue2)) == null) continue;
            IntSet.IntSetIterator intSetIterator = intSet.iterator();
            while (intSetIterator.hasNext()) {
                String string2;
                String string3;
                int n = intSetIterator.next();
                FileDesc fileDesc = this._files.get(n);
                if (fileDesc == null || !(string3 = file.getAbsolutePath()).equals(string2 = fileDesc.getFile().getAbsolutePath())) continue;
                return;
            }
        }
        int n = this._files.size();
        this._incompletesShared.add(n);
        IncompleteFileDesc incompleteFileDesc = new IncompleteFileDesc(file, set, n, string, l, verifyingFile);
        this._files.add(incompleteFileDesc);
        this._fileToFileDescMap.put(file, incompleteFileDesc);
        this.fileURNSUpdated(incompleteFileDesc);
        ++this._numIncompleteFiles;
        _needRebuild = true;
        this.dispatchFileEvent(new FileManagerEvent((FileManager)this, FileManagerEvent.Type.ADD_FILE, incompleteFileDesc));
    }

    @Override
    public abstract void fileChanged(File var1);

    @Override
    public void validate(final FileDesc fileDesc) {
        if (this._requestingValidation.add(fileDesc.getSHA1Urn())) {
            this.fileManagerController.requestValidation(fileDesc.getSHA1Urn(), new ContentResponseObserver(){

                public void handleResponse(URN uRN, ContentResponseData contentResponseData) {
                    FileManagerImpl.this._requestingValidation.remove(fileDesc.getSHA1Urn());
                    if (contentResponseData != null && !contentResponseData.isOK()) {
                        FileManagerImpl.this.removeFileIfShared(fileDesc.getFile());
                    }
                }
            });
        }
    }

    @Override
    public synchronized void fileURNSUpdated(FileDesc fileDesc) {
        this.updateUrnIndex(fileDesc);
        if (fileDesc instanceof IncompleteFileDesc) {
            IncompleteFileDesc incompleteFileDesc = (IncompleteFileDesc)fileDesc;
            if (SharingSettings.ALLOW_PARTIAL_SHARING.getValue() && SharingSettings.LOAD_PARTIAL_KEYWORDS.getValue() && incompleteFileDesc.hasUrnsAndPartialData()) {
                this.loadKeywords(this._incompleteKeywordTrie, fileDesc);
                _needRebuild = true;
            }
        }
    }

    private synchronized void updateUrnIndex(FileDesc fileDesc) {
        for (URN uRN : fileDesc.getUrns()) {
            if (!uRN.isSHA1()) continue;
            IntSet intSet = this._urnMap.get(uRN);
            if (intSet == null) {
                intSet = new IntSet();
                this._urnMap.put(uRN, intSet);
            }
            intSet.add(fileDesc.getIndex());
        }
    }

    private static String[] extractKeywords(FileDesc fileDesc) {
        return StringUtils.split(I18NConvert.instance().getNorm(fileDesc.getPath()), " -._+/*()\\,");
    }

    private synchronized void removeUrnIndex(FileDesc fileDesc, boolean bl) {
        for (URN uRN : fileDesc.getUrns()) {
            if (!uRN.isSHA1()) continue;
            IntSet intSet = this._urnMap.get(uRN);
            if (intSet == null) {
                assert (fileDesc instanceof IncompleteFileDesc);
                return;
            }
            intSet.remove(fileDesc.getIndex());
            if (intSet.size() != 0 || !bl) continue;
            this.fileManagerController.lastUrnRemoved(uRN);
            this._urnMap.remove(uRN);
        }
    }

    @Override
    public void renameFileIfSharedOrStore(File file, File file2) {
        this.renameFileIfSharedOrStore(file, file2, null);
    }

    @Override
    public synchronized void renameFileIfSharedOrStore(File file, File file2, final FileEventListener fileEventListener) {
        FileDesc fileDesc = this.getFileDescForFile(file);
        if (fileDesc == null) {
            FileManagerEvent fileManagerEvent = new FileManagerEvent((FileManager)this, FileManagerEvent.Type.ADD_FAILED_FILE, file);
            this.dispatchFileEvent(fileManagerEvent);
            if (fileEventListener != null) {
                fileEventListener.handleFileEvent(fileManagerEvent);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to rename: " + file + " to: " + file2);
        }
        LinkedList<LimeXMLDocument> linkedList = new LinkedList<LimeXMLDocument>(fileDesc.getLimeXMLDocuments());
        if (fileDesc.getIndex() != Integer.MAX_VALUE) {
            final FileDesc fileDesc2 = this.removeFileIfShared(file, false);
            assert (fileDesc2 == fileDesc) : "invariant broken.";
            if (this._data.SPECIAL_FILES_TO_SHARE.remove(file) && !this.isFileInCompletelySharedDirectory(file2)) {
                this._data.SPECIAL_FILES_TO_SHARE.add(file2);
            }
            this.fileManagerController.addUrns(file2, fileDesc2.getUrns());
            this.addFileIfSharedOrStore(file2, linkedList, false, this._revision, new FileEventListener(){

                public void handleFileEvent(FileManagerEvent fileManagerEvent) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Add of newFile returned callback: " + fileManagerEvent);
                    }
                    FileManagerEvent fileManagerEvent2 = null;
                    if (fileManagerEvent.isAddEvent()) {
                        FileDesc fileDesc = fileManagerEvent.getFileDescs()[0];
                        fileManagerEvent2 = new FileManagerEvent((FileManager)FileManagerImpl.this, FileManagerEvent.Type.RENAME_FILE, fileDesc2, fileDesc);
                    } else {
                        fileManagerEvent2 = new FileManagerEvent((FileManager)FileManagerImpl.this, FileManagerEvent.Type.REMOVE_FILE, fileDesc2);
                    }
                    FileManagerImpl.this.dispatchFileEvent(fileManagerEvent2);
                    if (fileEventListener != null) {
                        fileEventListener.handleFileEvent(fileManagerEvent2);
                    }
                }
            }, AddType.ADD_SHARE);
        } else {
            final FileDesc fileDesc3 = this.removeStoreFile(file, false);
            assert (fileDesc3 == fileDesc) : "invariant broken.";
            if (this._data.SPECIAL_STORE_FILES.remove(file)) {
                this._data.SPECIAL_STORE_FILES.add(file2);
            }
            this.fileManagerController.addUrns(file2, fileDesc3.getUrns());
            this.addFileIfSharedOrStore(file2, linkedList, false, this._revision, new FileEventListener(){

                public void handleFileEvent(FileManagerEvent fileManagerEvent) {
                    FileManagerEvent fileManagerEvent2 = null;
                    if (fileManagerEvent.isAddStoreEvent()) {
                        FileDesc fileDesc = fileManagerEvent.getFileDescs()[0];
                        fileManagerEvent2 = new FileManagerEvent((FileManager)FileManagerImpl.this, FileManagerEvent.Type.RENAME_FILE, fileDesc3, fileDesc);
                    } else {
                        fileManagerEvent2 = new FileManagerEvent((FileManager)FileManagerImpl.this, FileManagerEvent.Type.REMOVE_STORE_FILE, fileDesc3);
                    }
                    FileManagerImpl.this.dispatchFileEvent(fileManagerEvent2);
                    if (fileEventListener != null) {
                        fileEventListener.handleFileEvent(fileManagerEvent2);
                    }
                }
            }, AddType.ADD_STORE);
        }
    }

    private synchronized void trim() {
        this._keywordTrie.trim(new Function<IntSet, IntSet>(){

            @Override
            public IntSet apply(IntSet intSet) {
                intSet.trim();
                return intSet;
            }
        });
    }

    @Override
    public void validateSensitiveFile(File file) {
        this._data.SENSITIVE_DIRECTORIES_VALIDATED.add(file);
        this._data.SENSITIVE_DIRECTORIES_NOT_TO_SHARE.remove(file);
    }

    @Override
    public void invalidateSensitiveFile(File file) {
        this._data.SENSITIVE_DIRECTORIES_VALIDATED.remove(file);
        this._data.SENSITIVE_DIRECTORIES_NOT_TO_SHARE.add(file);
        SharingSettings.DIRECTORIES_TO_SHARE.remove(file);
    }

    @Override
    public boolean hasIndividualFiles() {
        return !this._data.SPECIAL_FILES_TO_SHARE.isEmpty();
    }

    @Override
    public boolean hasIndividualStoreFiles() {
        return !this._data.SPECIAL_STORE_FILES.isEmpty();
    }

    @Override
    public boolean hasApplicationSharedFiles() {
        File[] fileArray = SharingUtils.APPLICATION_SPECIAL_SHARE.listFiles();
        if (fileArray == null) {
            return false;
        }
        for (File file : fileArray) {
            if (!this.isFileShared(file)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] getIndividualFiles() {
        Set<File> set;
        Set<File> set2 = set = this._data.SPECIAL_FILES_TO_SHARE;
        synchronized (set2) {
            ArrayList<File> arrayList = new ArrayList<File>(set.size());
            for (File file : set) {
                if (!file.exists()) continue;
                arrayList.add(file);
            }
            if (arrayList.isEmpty()) {
                return new File[0];
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] getIndividualStoreFiles() {
        Set<File> set;
        Set<File> set2 = set = this._data.SPECIAL_STORE_FILES;
        synchronized (set2) {
            ArrayList<File> arrayList = new ArrayList<File>(set.size());
            for (File file : set) {
                if (!file.exists()) continue;
                arrayList.add(file);
            }
            if (arrayList.isEmpty()) {
                return new File[0];
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
    }

    @Override
    public boolean isIndividualStore(File file) {
        return this._data.SPECIAL_STORE_FILES.contains(file);
    }

    @Override
    public boolean isIndividualShare(File file) {
        return this._data.SPECIAL_FILES_TO_SHARE.contains(file) && SharingUtils.isFilePhysicallyShareable(file) && !SharingUtils.isApplicationSpecialShare(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanIndividualFiles() {
        Set<File> set;
        Set<File> set2 = set = this._data.SPECIAL_FILES_TO_SHARE;
        synchronized (set2) {
            Iterator<File> iterator = set.iterator();
            while (iterator.hasNext()) {
                File file = iterator.next();
                if (SharingUtils.isFilePhysicallyShareable(file)) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public synchronized boolean isFileShared(File file) {
        if (file == null) {
            return false;
        }
        return this._fileToFileDescMap.get(file) != null;
    }

    @Override
    public boolean isRareFile(FileDesc fileDesc) {
        return this.rareDefinition.evaluate(fileDesc);
    }

    private static boolean hasShareableExtension(File file) {
        if (file == null) {
            return false;
        }
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        return _extensions.contains(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFileInCompletelySharedDirectory(File file) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            return false;
        }
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            return this._completelySharedDirectories.contains(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFolderShared(File file) {
        if (file == null) {
            return false;
        }
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            return this._completelySharedDirectories.contains(file);
        }
    }

    @Override
    public boolean isStoreFile(File file) {
        return this._storeToFileDescMap.containsKey(file) || this._storeDirectories.contains(file);
    }

    private boolean isFileShareable(File file) {
        if (!SharingUtils.isFilePhysicallyShareable(file)) {
            return false;
        }
        if (this._individualSharedFiles.contains(file)) {
            return true;
        }
        if (this._data.FILES_NOT_TO_SHARE.contains(file)) {
            return false;
        }
        if (this.isFileInCompletelySharedDirectory(file)) {
            if (file.getName().toUpperCase().startsWith("LIMEWIRE")) {
                return true;
            }
            return FileManagerImpl.hasShareableExtension(file);
        }
        return false;
    }

    private boolean isFileLocatedStoreDirectory(File file) {
        return this._storeDirectories.contains(file.getParentFile());
    }

    private boolean isStoreXML(LimeXMLDocument limeXMLDocument) {
        return limeXMLDocument != null && limeXMLDocument.getLicenseString() != null && limeXMLDocument.getLicenseString().equals(LicenseType.LIMEWIRE_STORE_PURCHASE.name());
    }

    @Override
    public boolean isStoreDirectory(File file) {
        return this._storeDirectories.contains(file);
    }

    @Override
    public boolean isFolderShareable(File file, boolean bl) {
        String string;
        String string2;
        if (!file.isDirectory() || !file.canRead()) {
            return false;
        }
        if (file.equals(SharingSettings.INCOMPLETE_DIRECTORY.getValue())) {
            return false;
        }
        if (SharingUtils.isApplicationSpecialShareDirectory(file)) {
            return false;
        }
        if (bl && this._data.DIRECTORIES_NOT_TO_SHARE.contains(file)) {
            return false;
        }
        File[] fileArray = File.listRoots();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!file.equals(fileArray[i])) continue;
                return false;
            }
        }
        if ((string2 = file.getName().toLowerCase(Locale.US)).equals("cookies")) {
            return false;
        }
        return !string2.equals("low") || (string = file.getParent()) == null || !string.toLowerCase(Locale.US).equals("cookies");
    }

    @Override
    public synchronized QueryRouteTable getQRT() {
        if (_needRebuild) {
            this.qrpUpdater.cancelRebuild();
            this.buildQRT();
            _needRebuild = false;
        }
        QueryRouteTable queryRouteTable = new QueryRouteTable(_queryRouteTable.getSize());
        queryRouteTable.addAll(_queryRouteTable);
        return queryRouteTable;
    }

    protected synchronized void buildQRT() {
        _queryRouteTable = new QueryRouteTable();
        if (SearchSettings.PUBLISH_LIME_KEYWORDS.getBoolean()) {
            for (String string : SearchSettings.LIME_QRP_ENTRIES.getValue()) {
                _queryRouteTable.addIndivisible(string);
            }
        }
        Object[] objectArray = this.getAllSharedFileDescriptors();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof IncompleteFileDesc) {
                IncompleteFileDesc incompleteFileDesc;
                if (!SharingSettings.ALLOW_PARTIAL_SHARING.getValue() || !SharingSettings.PUBLISH_PARTIAL_QRP.getValue() || !(incompleteFileDesc = (IncompleteFileDesc)objectArray[i]).hasUrnsAndPartialData()) continue;
                _queryRouteTable.add(incompleteFileDesc.getFileName());
                continue;
            }
            _queryRouteTable.add(((FileDesc)objectArray[i]).getPath());
        }
    }

    @Override
    public synchronized Response[] query(QueryRequest queryRequest) {
        String string = queryRequest.getQuery();
        boolean bl = this.shouldIncludeXMLInResponse(queryRequest);
        if (queryRequest.isWhatIsNewRequest()) {
            return this.respondToWhatIsNewRequest(queryRequest, bl);
        }
        if (string.equals("    ") || string.equals("*.*")) {
            return this.respondToIndexingQuery(bl);
        }
        string = this._keywordTrie.canonicalCase(string);
        IntSet intSet = this.search(string, null, queryRequest.desiresPartialResults());
        if (queryRequest.getQueryUrns().size() > 0) {
            intSet = this.urnSearch(queryRequest.getQueryUrns(), intSet);
        }
        if (intSet == null) {
            return EMPTY_RESPONSES;
        }
        LinkedList<Response> linkedList = new LinkedList<Response>();
        MediaType.Aggregator aggregator = MediaType.getAggregator(queryRequest);
        LimeXMLDocument limeXMLDocument = queryRequest.getRichQuery();
        IntSet.IntSetIterator intSetIterator = intSet.iterator();
        while (intSetIterator.hasNext()) {
            int n = intSetIterator.next();
            FileDesc fileDesc = this._files.get(n);
            assert (fileDesc != null) : "unexpected null in FileManager for query:\n" + queryRequest;
            if (aggregator != null && !aggregator.allow(fileDesc.getFileName())) continue;
            fileDesc.incrementHitCount();
            this.fileManagerController.handleSharedFileUpdate(fileDesc.getFile());
            Response response = this.fileManagerController.createResponse(fileDesc);
            if (bl) {
                this.addXMLToResponse(response, fileDesc);
                if (limeXMLDocument != null && response.getDocument() != null && !this.isValidXMLMatch(response, limeXMLDocument)) continue;
            }
            linkedList.add(response);
        }
        if (linkedList.size() == 0) {
            return EMPTY_RESPONSES;
        }
        return linkedList.toArray(new Response[linkedList.size()]);
    }

    private Response[] respondToWhatIsNewRequest(QueryRequest queryRequest, boolean bl) {
        List<URN> list = this.fileManagerController.getNewestUrns(queryRequest, 3);
        if (list.size() == 0) {
            return EMPTY_RESPONSES;
        }
        Response[] responseArray = new Response[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            URN uRN = list.get(i);
            FileDesc fileDesc = this.getFileDescForUrn(uRN);
            if (fileDesc == null || fileDesc instanceof IncompleteFileDesc) {
                throw new RuntimeException("Bad Rep - No IFDs allowed!");
            }
            Response response = this.fileManagerController.createResponse(fileDesc);
            if (bl) {
                this.addXMLToResponse(response, fileDesc);
            }
            responseArray[i] = response;
        }
        return responseArray;
    }

    private Response[] respondToIndexingQuery(boolean bl) {
        if (this._numFiles == 0) {
            return EMPTY_RESPONSES;
        }
        Response[] responseArray = new Response[this._numFiles - this._numForcedFiles];
        int n = 0;
        for (int i = 0; i < this._files.size(); ++i) {
            FileDesc fileDesc = this._files.get(i);
            if (fileDesc == null || fileDesc instanceof IncompleteFileDesc || SharingUtils.isForcedShare(fileDesc)) continue;
            assert (n < responseArray.length) : "_numFiles is too small";
            responseArray[n] = this.fileManagerController.createResponse(fileDesc);
            if (bl) {
                this.addXMLToResponse(responseArray[n], fileDesc);
            }
            ++n;
        }
        assert (n == responseArray.length) : "_numFiles is too large";
        return responseArray;
    }

    protected abstract boolean shouldIncludeXMLInResponse(QueryRequest var1);

    protected abstract void addXMLToResponse(Response var1, FileDesc var2);

    protected abstract boolean isValidXMLMatch(Response var1, LimeXMLDocument var2);

    protected IntSet search(String string, IntSet intSet, boolean bl) {
        IntSet intSet2 = intSet;
        int n = 0;
        while (n < string.length()) {
            int n2;
            if (FileManagerImpl.isDelimiter(string.charAt(n))) {
                ++n;
                continue;
            }
            for (n2 = n + 1; n2 < string.length() && !FileManagerImpl.isDelimiter(string.charAt(n2)); ++n2) {
            }
            Iterator<IntSet> iterator = this._keywordTrie.getPrefixedBy(string, n, n2);
            if (SharingSettings.ALLOW_PARTIAL_SHARING.getValue() && SharingSettings.ALLOW_PARTIAL_RESPONSES.getValue() && bl) {
                iterator = new MultiIterator<IntSet>(iterator, this._incompleteKeywordTrie.getPrefixedBy(string, n, n2));
            }
            if (iterator.hasNext()) {
                IntSet intSet3 = null;
                while (iterator.hasNext()) {
                    IntSet intSet4 = iterator.next();
                    if (intSet3 == null) {
                        if (n == 0 && n2 == string.length() && !iterator.hasNext()) {
                            return intSet4;
                        }
                        intSet3 = new IntSet();
                    }
                    intSet3.addAll(intSet4);
                }
                if (intSet2 == null) {
                    intSet2 = intSet3;
                } else {
                    intSet2.retainAll(intSet3);
                }
            } else {
                return null;
            }
            if (intSet2.size() == 0) {
                return null;
            }
            n = n2;
        }
        if (intSet2 == null || intSet2.size() == 0) {
            return null;
        }
        return intSet2;
    }

    private synchronized IntSet urnSearch(Iterable<URN> iterable, IntSet intSet) {
        IntSet intSet2 = intSet;
        for (URN uRN : iterable) {
            IntSet intSet3 = this._urnMap.get(uRN);
            if (intSet3 == null) continue;
            IntSet.IntSetIterator intSetIterator = intSet3.iterator();
            while (intSetIterator.hasNext()) {
                FileDesc fileDesc = this._files.get(intSetIterator.next());
                if (fileDesc == null || fileDesc instanceof IncompleteFileDesc || !fileDesc.containsUrn(uRN)) continue;
                if (intSet2 == null) {
                    intSet2 = new IntSet();
                }
                intSet2.add(fileDesc.getIndex());
            }
        }
        return intSet2;
    }

    @Override
    public boolean isFileApplicationShared(String string) {
        File file = new File(SharingUtils.APPLICATION_SPECIAL_SHARE, string);
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return false;
        }
        return this.isFileShared(file);
    }

    @Override
    public void addFileEventListener(FileEventListener fileEventListener) {
        if (fileEventListener == null) {
            throw new NullPointerException("FileEventListener is null");
        }
        this.eventListeners.addIfAbsent(fileEventListener);
    }

    @Override
    public void removeFileEventListener(FileEventListener fileEventListener) {
        if (fileEventListener == null) {
            throw new NullPointerException("FileEventListener is null");
        }
        this.eventListeners.remove(fileEventListener);
    }

    protected void dispatchFileEvent(FileManagerEvent fileManagerEvent) {
        for (FileEventListener fileEventListener : this.eventListeners) {
            fileEventListener.handleFileEvent(fileManagerEvent);
        }
    }

    @Override
    public Iterator<Response> getIndexingIterator(final boolean bl) {
        return new Iterator<Response>(){
            int startRevision;
            int index;
            Response preview;
            {
                this.startRevision = FileManagerImpl.this._revision;
                this.index = 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean preview() {
                assert (this.preview == null);
                if (FileManagerImpl.this._revision != this.startRevision) {
                    return false;
                }
                FileManagerImpl fileManagerImpl = FileManagerImpl.this;
                synchronized (fileManagerImpl) {
                    while (this.index < FileManagerImpl.this._files.size()) {
                        FileDesc fileDesc = (FileDesc)FileManagerImpl.this._files.get(this.index);
                        ++this.index;
                        if (fileDesc == null || fileDesc instanceof IncompleteFileDesc || SharingUtils.isForcedShare(fileDesc)) continue;
                        this.preview = FileManagerImpl.this.fileManagerController.createResponse(fileDesc);
                        if (bl) {
                            FileManagerImpl.this.addXMLToResponse(this.preview, fileDesc);
                        }
                        return true;
                    }
                    return false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (FileManagerImpl.this._revision != this.startRevision) {
                    return false;
                }
                if (this.preview != null) {
                    FileManagerImpl fileManagerImpl = FileManagerImpl.this;
                    synchronized (fileManagerImpl) {
                        if (FileManagerImpl.this._files.get(this.index - 1) == null) {
                            this.preview = null;
                        }
                    }
                }
                return this.preview != null || this.preview();
            }

            @Override
            public Response next() {
                if (this.hasNext()) {
                    Response response = this.preview;
                    this.preview = null;
                    return response;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        DIRECTORY_FILTER = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        EMPTY_CALLBACK = new FileEventListener(){

            public void handleFileEvent(FileManagerEvent fileManagerEvent) {
            }
        };
        _needRebuild = true;
        EMPTY_RESPONSES = new Response[0];
    }

    private class RareFileDefinition
    implements SimppListener {
        private RPNParser parser;

        RareFileDefinition() {
            this.simppUpdated(0);
            FileManagerImpl.this.fileManagerController.addSimppListener(this);
        }

        public synchronized void simppUpdated(int n) {
            this.parser = new RPNParser(DHTSettings.RARE_FILE_DEFINITION.getValue());
        }

        private synchronized boolean evaluate(FileDesc fileDesc) {
            try {
                return this.parser.evaluate(fileDesc);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
    }

    private class FDInspectable
    implements Inspectable {
        private final boolean nonZero;

        FDInspectable(boolean bl) {
            this.nonZero = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object inspect() {
            int n;
            Object object;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("ver", 2);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            ArrayList<Double> arrayList4 = new ArrayList<Double>();
            ArrayList<Double> arrayList5 = new ArrayList<Double>();
            ArrayList<Double> arrayList6 = new ArrayList<Double>();
            ArrayList<Double> arrayList7 = new ArrayList<Double>();
            ArrayList<Double> arrayList8 = new ArrayList<Double>();
            ArrayList<Double> arrayList9 = new ArrayList<Double>();
            ArrayList<Double> arrayList10 = new ArrayList<Double>();
            TreeMap<Integer, FileDesc> treeMap = new TreeMap<Integer, FileDesc>(Comparators.inverseIntegerComparator());
            TreeMap<Integer, FileDesc> treeMap2 = new TreeMap<Integer, FileDesc>(Comparators.inverseIntegerComparator());
            TreeMap<Integer, FileDesc> treeMap3 = new TreeMap<Integer, FileDesc>(Comparators.inverseIntegerComparator());
            TreeMap<Integer, FileDesc> treeMap4 = new TreeMap<Integer, FileDesc>(Comparators.inverseIntegerComparator());
            Object object2 = FileManagerImpl.this;
            synchronized (object2) {
                object = FileManagerImpl.this.getAllSharedFileDescriptors();
                arrayList.ensureCapacity(((FileDesc[])object).length);
                arrayList2.ensureCapacity(((FileDesc[])object).length);
                int n2 = 0;
                int n3 = 0;
                for (int i = 0; i < ((FileDesc[])object).length; ++i) {
                    if (object[i] instanceof IncompleteFileDesc) continue;
                    ++n3;
                    if (FileManagerImpl.this.isRareFile(object[i])) {
                        ++n2;
                    }
                    int n4 = FileManagerImpl.this.fileManagerController.getAlternateLocationCount(object[i].getSHA1Urn());
                    if (!this.nonZero || n4 > 0) {
                        arrayList4.add(Double.valueOf(n4));
                        treeMap3.put(n4, object[i]);
                    }
                    int n5 = object[i].getHitCount();
                    if (!this.nonZero || n5 > 0) {
                        arrayList.add(Double.valueOf(n5));
                        treeMap.put(n5, object[i]);
                    }
                    int n6 = object[i].getAttemptedUploads();
                    if (!this.nonZero || n6 > 0) {
                        arrayList2.add(Double.valueOf(n6));
                        treeMap2.put(n6, object[i]);
                    }
                    n = object[i].getCompletedUploads();
                    if (!this.nonZero || n > 0) {
                        arrayList3.add(Double.valueOf(n6));
                        treeMap4.put(n, object[i]);
                    }
                    double d = HashFunction.getPrefixes(HashFunction.keywords(object[i].getPath())).length;
                    arrayList5.add(d);
                    if (this.nonZero) continue;
                    int n7 = arrayList.size() - 1;
                    arrayList8.add(arrayList.get(n7) - arrayList2.get(n7));
                    arrayList6.add(arrayList4.get(n7) - arrayList.get(n7));
                    arrayList7.add(arrayList4.get(n7) - arrayList2.get(n7));
                    arrayList9.add(arrayList.get(n7) - d);
                    arrayList10.add(arrayList2.get(n7) - arrayList3.get(n7));
                }
                hashMap.put("rare", Double.doubleToLongBits((double)n2 / (double)n3));
            }
            hashMap.put("hits", StatsUtils.quickStatsDouble(arrayList).getMap());
            hashMap.put("hitsh", StatsUtils.getHistogram(arrayList, 10));
            hashMap.put("ups", StatsUtils.quickStatsDouble(arrayList2).getMap());
            hashMap.put("upsh", StatsUtils.getHistogram(arrayList2, 10));
            hashMap.put("cups", StatsUtils.quickStatsDouble(arrayList3).getMap());
            hashMap.put("cupsh", StatsUtils.getHistogram(arrayList3, 10));
            hashMap.put("alts", StatsUtils.quickStatsDouble(arrayList4).getMap());
            hashMap.put("altsh", StatsUtils.getHistogram(arrayList4, 10));
            hashMap.put("kw", StatsUtils.quickStatsDouble(arrayList5).getMap());
            hashMap.put("kwh", StatsUtils.getHistogram(arrayList5, 10));
            hashMap.put("hut", StatsUtils.quickStatsDouble(arrayList8).getTTestMap());
            hashMap.put("aht", StatsUtils.quickStatsDouble(arrayList6).getTTestMap());
            hashMap.put("aut", StatsUtils.quickStatsDouble(arrayList7).getTTestMap());
            hashMap.put("hkt", StatsUtils.quickStatsDouble(arrayList9).getTTestMap());
            hashMap.put("ucut", StatsUtils.quickStatsDouble(arrayList10).getTTestMap());
            object2 = new QueryRouteTable();
            object = new QueryRouteTable();
            QueryRouteTable queryRouteTable = new QueryRouteTable();
            QueryRouteTable queryRouteTable2 = new QueryRouteTable();
            Iterator iterator = treeMap.values().iterator();
            Iterator iterator2 = treeMap2.values().iterator();
            Iterator iterator3 = treeMap4.values().iterator();
            Iterator iterator4 = treeMap3.values().iterator();
            for (n = 0; n < 10; ++n) {
                if (iterator.hasNext()) {
                    ((QueryRouteTable)object2).add(((FileDesc)iterator.next()).getPath());
                }
                if (iterator2.hasNext()) {
                    ((QueryRouteTable)object).add(((FileDesc)iterator2.next()).getPath());
                }
                if (iterator4.hasNext()) {
                    queryRouteTable2.add(((FileDesc)iterator4.next()).getPath());
                }
                if (!iterator3.hasNext()) continue;
                queryRouteTable.add(((FileDesc)iterator3.next()).getPath());
            }
            hashMap.put("hitsq", ((QueryRouteTable)object2).getRawDump());
            hashMap.put("upsq", ((QueryRouteTable)object).getRawDump());
            hashMap.put("cupsq", queryRouteTable.getRawDump());
            hashMap.put("altsq", queryRouteTable2.getRawDump());
            return hashMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @InspectableContainer
    private class FMInspectables {
        private static final int VERSION = 2;
        @InspectionPoint(value="FileManager QRP info")
        public final Inspectable QRP = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
                FMInspectables.this.addVersion(hashMap);
                FileManagerImpl fileManagerImpl = FileManagerImpl.this;
                synchronized (fileManagerImpl) {
                    hashMap.put("qrt", FileManagerImpl.this.getQRT().getRawDump());
                }
                return hashMap;
            }
        };
        @InspectionPoint(value="FileManager h/u/a stats")
        public final Inspectable FDS = new FDInspectable(false);
        @InspectionPoint(value="FileManager h/u/a stats > 0")
        public final Inspectable FDSNZ = new FDInspectable(true);
        @InspectionPoint(value="FileManager custom criteria")
        public final Inspectable CUSTOM = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("ver", 1);
                hashMap.put("crit", MessageSettings.CUSTOM_FD_CRITERIA.getValueAsString());
                int n = 0;
                int n2 = 0;
                try {
                    RPNParser rPNParser = new RPNParser(MessageSettings.CUSTOM_FD_CRITERIA.getValue());
                    FileManagerImpl fileManagerImpl = FileManagerImpl.this;
                    synchronized (fileManagerImpl) {
                        for (FileDesc fileDesc : FileManagerImpl.this.getAllSharedFileDescriptors()) {
                            ++n;
                            if (!rPNParser.evaluate(fileDesc)) continue;
                            ++n2;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    hashMap.put("error", illegalArgumentException.toString());
                    return hashMap;
                }
                hashMap.put("match", n2);
                hashMap.put("total", n);
                return hashMap;
            }
        };

        private FMInspectables() {
        }

        private void addVersion(Map<String, Object> map) {
            map.put("ver", 2);
        }
    }

    private class QRPUpdater
    implements SimppListener {
        private boolean buildInProgress;
        private final Set<String> qrpWords = new HashSet<String>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QRPUpdater() {
            QRPUpdater qRPUpdater = this;
            synchronized (qRPUpdater) {
                for (String string : SearchSettings.LIME_QRP_ENTRIES.getValue()) {
                    this.qrpWords.add(string);
                }
            }
        }

        public synchronized void simppUpdated(int n) {
            if (this.buildInProgress) {
                return;
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : SearchSettings.LIME_QRP_ENTRIES.getValue()) {
                hashSet.add(string);
            }
            if (hashSet.containsAll(this.qrpWords) && this.qrpWords.containsAll(hashSet)) {
                return;
            }
            this.qrpWords.clear();
            this.qrpWords.addAll(hashSet);
            this.buildInProgress = true;
            FileManagerImpl.this.fileManagerController.scheduleWithFixedDelay(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    QRPUpdater qRPUpdater = QRPUpdater.this;
                    synchronized (qRPUpdater) {
                        if (!QRPUpdater.this.buildInProgress) {
                            return;
                        }
                        QRPUpdater.this.buildInProgress = false;
                        _needRebuild = true;
                    }
                }
            }, (int)(Math.random() * (double)QRP_DELAY), 0, TimeUnit.MILLISECONDS);
        }

        public synchronized void cancelRebuild() {
            this.buildInProgress = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AddType {
        ADD_SHARE(FileManagerEvent.Type.ADD_FILE, FileManagerEvent.Type.ADD_FAILED_FILE),
        ADD_STORE(FileManagerEvent.Type.ADD_STORE_FILE, FileManagerEvent.Type.ADD_STORE_FAILED_FILE);

        private final FileManagerEvent.Type success;
        private final FileManagerEvent.Type failure;

        private AddType(FileManagerEvent.Type type, FileManagerEvent.Type type2) {
            this.success = type;
            this.failure = type2;
        }

        public FileManagerEvent.Type getSuccessType() {
            return this.success;
        }

        public FileManagerEvent.Type getFailureType() {
            return this.failure;
        }
    }
}

