/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GuidMap;
import com.limegroup.gnutella.GuidMapManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@Singleton
class GuidMapManagerImpl
implements GuidMapManager {
    private static long EXPIRE_POLL_TIME = 120000L;
    private static long TIMED_GUID_LIFETIME = 600000L;
    private List<GuidMapImpl> toExpire = new LinkedList<GuidMapImpl>();
    private boolean scheduled = false;
    private final ScheduledExecutorService backgroundExecutor;

    @Inject
    public GuidMapManagerImpl(@Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService) {
        this.backgroundExecutor = scheduledExecutorService;
    }

    public GuidMap getMap() {
        return new GuidMapImpl();
    }

    public synchronized void removeMap(GuidMap guidMap) {
        this.toExpire.remove(guidMap);
    }

    private synchronized void addMapToExpire(GuidMapImpl guidMapImpl) {
        if (!this.scheduled) {
            this.backgroundExecutor.scheduleWithFixedDelay(new GuidExpirer(), 0L, EXPIRE_POLL_TIME, TimeUnit.MILLISECONDS);
            this.scheduled = true;
        }
        this.toExpire.add(guidMapImpl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GuidMapImpl
    implements GuidMap {
        private Map<GUID.TimedGUID, GUID> map;

        private GuidMapImpl() {
        }

        public String toString() {
            return "impl, map: " + this.map;
        }

        Map<GUID.TimedGUID, GUID> getMap() {
            return this.map;
        }

        @Override
        public void addMapping(byte[] byArray, byte[] byArray2) {
            this.addMapping(byArray, byArray2, TIMED_GUID_LIFETIME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addMapping(byte[] byArray, byte[] byArray2, long l) {
            boolean bl = false;
            GuidMapImpl guidMapImpl = this;
            synchronized (guidMapImpl) {
                if (this.map == null) {
                    this.map = new HashMap<GUID.TimedGUID, GUID>();
                    bl = true;
                }
                GUID.TimedGUID timedGUID = new GUID.TimedGUID(new GUID(byArray2), l);
                this.map.put(timedGUID, new GUID(byArray));
            }
            if (bl) {
                GuidMapManagerImpl.this.addMapToExpire(this);
            }
        }

        @Override
        public synchronized byte[] getOriginalGUID(byte[] byArray) {
            GUID.TimedGUID timedGUID;
            GUID gUID;
            if (this.map != null && (gUID = this.map.get(timedGUID = new GUID.TimedGUID(new GUID(byArray), 0L))) != null) {
                return gUID.bytes();
            }
            return null;
        }

        @Override
        public synchronized GUID getNewGUID(GUID gUID) {
            if (this.map != null) {
                for (Map.Entry<GUID.TimedGUID, GUID> entry : this.map.entrySet()) {
                    if (!entry.getValue().equals(gUID)) continue;
                    return entry.getKey().getGUID();
                }
            }
            return null;
        }
    }

    private class GuidExpirer
    implements Runnable {
        private GuidExpirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            GuidMapManagerImpl guidMapManagerImpl = GuidMapManagerImpl.this;
            synchronized (guidMapManagerImpl) {
                Iterator iterator = GuidMapManagerImpl.this.toExpire.iterator();
                while (iterator.hasNext()) {
                    GuidMapImpl guidMapImpl;
                    GuidMapImpl guidMapImpl2 = guidMapImpl = (GuidMapImpl)iterator.next();
                    synchronized (guidMapImpl2) {
                        long l = System.currentTimeMillis();
                        Map<GUID.TimedGUID, GUID> map = guidMapImpl.getMap();
                        Iterator<GUID.TimedGUID> iterator2 = map.keySet().iterator();
                        while (iterator2.hasNext()) {
                            if (!iterator2.next().shouldExpire(l)) continue;
                            iterator2.remove();
                        }
                    }
                }
            }
        }
    }
}

