/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.messages.Message;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.limewire.inspection.InspectionPoint;

@Singleton
public class MessageDispatcher {
    private final Executor DISPATCH;
    private final MessageRouter messageRouter;
    @InspectionPoint(value="routed messages")
    private final Message.MessageCounter messageCounter = new Message.MessageCounter(30);

    @Inject
    public MessageDispatcher(MessageRouter messageRouter, @Named(value="messageExecutor") Executor executor) {
        this.messageRouter = messageRouter;
        this.DISPATCH = executor;
    }

    public void dispatch(Runnable runnable) {
        this.DISPATCH.execute(runnable);
    }

    public void dispatchUDP(Message message, InetSocketAddress inetSocketAddress) {
        this.DISPATCH.execute(new UDPDispatch(this.messageRouter, message, inetSocketAddress, this.messageCounter));
    }

    public void dispatchMulticast(Message message, InetSocketAddress inetSocketAddress) {
        this.DISPATCH.execute(new MulticastDispatch(this.messageRouter, message, inetSocketAddress, this.messageCounter));
    }

    public void dispatchTCP(Message message, RoutedConnection routedConnection) {
        this.DISPATCH.execute(new TCPDispatch(this.messageRouter, message, routedConnection, this.messageCounter));
    }

    private static class TCPDispatch
    extends Dispatch {
        private final RoutedConnection conn;

        TCPDispatch(MessageRouter messageRouter, Message message, RoutedConnection routedConnection, Message.MessageCounter messageCounter) {
            super(messageRouter, message, messageCounter);
            this.conn = routedConnection;
        }

        protected void dispatch() {
            this.messageRouter.handleMessage(this.m, this.conn);
        }
    }

    private static class MulticastDispatch
    extends Dispatch {
        private final InetSocketAddress addr;

        MulticastDispatch(MessageRouter messageRouter, Message message, InetSocketAddress inetSocketAddress, Message.MessageCounter messageCounter) {
            super(messageRouter, message, messageCounter);
            this.addr = inetSocketAddress;
        }

        protected void dispatch() {
            this.messageRouter.handleMulticastMessage(this.m, this.addr);
        }
    }

    private static class UDPDispatch
    extends Dispatch {
        private final InetSocketAddress addr;

        UDPDispatch(MessageRouter messageRouter, Message message, InetSocketAddress inetSocketAddress, Message.MessageCounter messageCounter) {
            super(messageRouter, message, messageCounter);
            this.addr = inetSocketAddress;
        }

        protected void dispatch() {
            this.messageRouter.handleUDPMessage(this.m, this.addr);
        }
    }

    private static abstract class Dispatch
    implements Runnable {
        protected final MessageRouter messageRouter;
        protected final Message m;
        protected final Message.MessageCounter counter;

        Dispatch(MessageRouter messageRouter, Message message, Message.MessageCounter messageCounter) {
            this.messageRouter = messageRouter;
            this.m = message;
            this.counter = messageCounter;
        }

        public void run() {
            this.counter.countMessage(this.m);
            this.dispatch();
        }

        protected abstract void dispatch();
    }
}

