/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.BypassedResultsCache;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GuidMap;
import com.limegroup.gnutella.GuidMapManager;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.MessageHandlerBinder;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouteTable;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.connection.Connection;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.ConnectionLifecycleListener;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.messagehandlers.DualMessageHandler;
import com.limegroup.gnutella.messagehandlers.InspectionRequestHandler;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messagehandlers.OOBHandler;
import com.limegroup.gnutella.messagehandlers.UDPCrawlerPingHandler;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingReplyFactory;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.messages.StaticMessages;
import com.limegroup.gnutella.messages.vendor.ContentResponse;
import com.limegroup.gnutella.messages.vendor.DHTContactsMessage;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.messages.vendor.HeadPongFactory;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.InspectionRequest;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.messages.vendor.SimppRequestVM;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UpdateRequest;
import com.limegroup.gnutella.messages.vendor.UpdateResponse;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.search.QueryHandlerFactory;
import com.limegroup.gnutella.search.ResultCounter;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.version.UpdateHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Buffer;
import org.limewire.collection.FixedsizeHashMap;
import org.limewire.collection.NoMoreStorageException;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.ManagedThread;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;
import org.limewire.service.ErrorService;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.util.Base32;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageRouterImpl
implements MessageRouter {
    private static final Log LOG = LogFactory.getLog(MessageRouterImpl.class);
    private static final int OLD_CONNECTIONS_TO_USE = 15;
    protected byte[] _clientGUID;
    private int MAX_ROUTE_TABLE_SIZE = 50000;
    @InspectionPoint(value="ping routing table dump")
    private RouteTable _pingRouteTable = new RouteTable(120, this.MAX_ROUTE_TABLE_SIZE);
    @InspectionPoint(value="query routing table dump")
    private RouteTable _queryRouteTable = new RouteTable(300, this.MAX_ROUTE_TABLE_SIZE);
    @InspectionPoint(value="push routing table dump")
    private RouteTable _pushRouteTable = new RouteTable(420, this.MAX_ROUTE_TABLE_SIZE);
    @InspectionPoint(value="headpong routing table dump")
    private RouteTable _headPongRouteTable = new RouteTable(10, this.MAX_ROUTE_TABLE_SIZE);
    private static final long CLEAR_TIME = 30000L;
    private static final long OOB_SESSION_EXPIRE_TIME = 120000L;
    private static final long HOPS_FLOW_INTERVAL = 15000L;
    public static final int MAX_BUFFERED_REPLIES = 250;
    private int maxBufferedReplies = 250;
    private final Map<GUID.TimedGUID, QueryResponseBundle> _outOfBandReplies = new Hashtable<GUID.TimedGUID, QueryResponseBundle>();
    private final BypassedResultsCache _bypassedResultsCache;
    private static final FixedsizeHashMap<String, String> _udpConnectBacks = new FixedsizeHashMap(200);
    private static final int MAX_UDP_CONNECTBACK_FORWARDS = 5;
    private static final FixedsizeHashMap<String, String> _tcpConnectBacks = new FixedsizeHashMap(200);
    private static final int MAX_TCP_CONNECTBACK_FORWARDS = 5;
    private static final ExecutorService TCP_CONNECT_BACKER = ExecutorsHelper.newProcessingQueue("TCPConnectBack");
    private final QRPPropagator QRP_PROPAGATOR = new QRPPropagator();
    private QueryRouteTable _lastQueryRouteTable;
    private static final int HIGH_HOPS_RESPONSE_LIMIT = 10;
    private static final long TIMED_GUID_LIFETIME = 25000L;
    private volatile Map<byte[], List<MessageListener>> _messageListeners = Collections.emptyMap();
    private final Object MESSAGE_LISTENER_LOCK = new Object();
    private long _lastQueryKeyTime;
    private ConcurrentMap<Class<? extends Message>, MessageHandler> messageHandlers = new ConcurrentHashMap<Class<? extends Message>, MessageHandler>(30, 0.75f, 3);
    private ConcurrentMap<Class<? extends Message>, MessageHandler> udpMessageHandlers = new ConcurrentHashMap<Class<? extends Message>, MessageHandler>(15, 0.75f, 3);
    private ConcurrentMap<Class<? extends Message>, MessageHandler> multicastMessageHandlers = new ConcurrentHashMap<Class<? extends Message>, MessageHandler>(5, 0.75f, 3);
    private static final long MULTICAST_GUID_EXPIRE_TIME = 60000L;
    private static final int UDP_REPLY_CACHE_TIME = 60000;
    @InspectionPoint(value="guid tracker")
    private final GUIDTracker guidTracker = new GUIDTracker();
    @InspectionPoint(value="dropped replies")
    private final DroppedReplyCounter droppedReplyCounter = new DroppedReplyCounter();
    @InspectionPoint(value="duplicate queries")
    private final DuplicateQueryCounter duplicateQueryCounter = new DuplicateQueryCounter();
    protected final NetworkManager networkManager;
    protected final QueryRequestFactory queryRequestFactory;
    protected final QueryHandlerFactory queryHandlerFactory;
    protected final OnDemandUnicaster onDemandUnicaster;
    protected final HeadPongFactory headPongFactory;
    protected final PingReplyFactory pingReplyFactory;
    protected final ConnectionManager connectionManager;
    protected final ReplyHandler forMeReplyHandler;
    protected final QueryUnicaster queryUnicaster;
    protected final FileManager fileManager;
    protected final ContentManager contentManager;
    protected final DHTManager dhtManager;
    protected final UploadManager uploadManager;
    protected final DownloadManager downloadManager;
    protected final UDPService udpService;
    protected final SearchResultHandler searchResultHandler;
    protected final SocketsManager socketsManager;
    protected final HostCatcher hostCatcher;
    protected final QueryReplyFactory queryReplyFactory;
    protected final StaticMessages staticMessages;
    protected final Provider<MessageDispatcher> messageDispatcher;
    protected final MulticastService multicastService;
    protected final QueryDispatcher queryDispatcher;
    protected final Provider<ActivityCallback> activityCallback;
    protected final ConnectionServices connectionServices;
    protected final ScheduledExecutorService backgroundExecutor;
    protected final Provider<PongCacher> pongCacher;
    protected final Provider<SimppManager> simppManager;
    protected final Provider<UpdateHandler> updateHandler;
    protected final UDPReplyHandlerCache udpReplyHandlerCache;
    protected final GuidMap multicastGuidMap;
    private final Provider<InspectionRequestHandler> inspectionRequestHandlerFactory;
    private final Provider<UDPCrawlerPingHandler> udpCrawlerPingHandlerFactory;
    private final Provider<OOBHandler> oobHandlerFactory;
    private final Provider<MACCalculatorRepositoryManager> MACCalculatorRepositoryManager;
    private final PingRequestFactory pingRequestFactory;
    private final MessageHandlerBinder messageHandlerBinder;
    private final ConnectionListener connectionListener = new ConnectionListener();

    @Inject
    protected MessageRouterImpl(NetworkManager networkManager, QueryRequestFactory queryRequestFactory, QueryHandlerFactory queryHandlerFactory, OnDemandUnicaster onDemandUnicaster, HeadPongFactory headPongFactory, PingReplyFactory pingReplyFactory, ConnectionManager connectionManager, @Named(value="forMeReplyHandler") ReplyHandler replyHandler, QueryUnicaster queryUnicaster, FileManager fileManager, ContentManager contentManager, DHTManager dHTManager, UploadManager uploadManager, DownloadManager downloadManager, UDPService uDPService, SearchResultHandler searchResultHandler, SocketsManager socketsManager, HostCatcher hostCatcher, QueryReplyFactory queryReplyFactory, StaticMessages staticMessages, Provider<MessageDispatcher> provider, MulticastService multicastService, QueryDispatcher queryDispatcher, Provider<ActivityCallback> provider2, ConnectionServices connectionServices, ApplicationServices applicationServices, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<PongCacher> provider3, Provider<SimppManager> provider4, Provider<UpdateHandler> provider5, GuidMapManager guidMapManager, UDPReplyHandlerCache uDPReplyHandlerCache, Provider<InspectionRequestHandler> provider6, Provider<UDPCrawlerPingHandler> provider7, PingRequestFactory pingRequestFactory, MessageHandlerBinder messageHandlerBinder, Provider<OOBHandler> provider8, Provider<MACCalculatorRepositoryManager> provider9) {
        this.networkManager = networkManager;
        this.queryRequestFactory = queryRequestFactory;
        this.queryHandlerFactory = queryHandlerFactory;
        this.onDemandUnicaster = onDemandUnicaster;
        this.headPongFactory = headPongFactory;
        this.pingReplyFactory = pingReplyFactory;
        this.connectionManager = connectionManager;
        this.forMeReplyHandler = replyHandler;
        this.queryUnicaster = queryUnicaster;
        this.fileManager = fileManager;
        this.contentManager = contentManager;
        this.dhtManager = dHTManager;
        this.uploadManager = uploadManager;
        this.downloadManager = downloadManager;
        this.udpService = uDPService;
        this.searchResultHandler = searchResultHandler;
        this.socketsManager = socketsManager;
        this.hostCatcher = hostCatcher;
        this.queryReplyFactory = queryReplyFactory;
        this.staticMessages = staticMessages;
        this.messageDispatcher = provider;
        this.multicastService = multicastService;
        this.queryDispatcher = queryDispatcher;
        this.activityCallback = provider2;
        this.connectionServices = connectionServices;
        this.backgroundExecutor = scheduledExecutorService;
        this.pongCacher = provider3;
        this.simppManager = provider4;
        this.updateHandler = provider5;
        this.udpCrawlerPingHandlerFactory = provider7;
        this.pingRequestFactory = pingRequestFactory;
        this.messageHandlerBinder = messageHandlerBinder;
        this.multicastGuidMap = guidMapManager.getMap();
        this.udpReplyHandlerCache = uDPReplyHandlerCache;
        this.inspectionRequestHandlerFactory = provider6;
        this.oobHandlerFactory = provider8;
        this.MACCalculatorRepositoryManager = provider9;
        this._clientGUID = applicationServices.getMyGUID();
        this._bypassedResultsCache = new BypassedResultsCache(provider2, downloadManager);
    }

    private boolean setHandler(ConcurrentMap<Class<? extends Message>, MessageHandler> concurrentMap, Class<? extends Message> clazz, MessageHandler messageHandler) {
        if (messageHandler != null) {
            MessageHandler messageHandler2 = concurrentMap.put(clazz, messageHandler);
            if (messageHandler2 != null) {
                LOG.warn("Ejecting old handler: " + messageHandler2 + " for clazz: " + clazz);
            }
            return true;
        }
        return concurrentMap.remove(clazz) != null;
    }

    private void addHandler(ConcurrentMap<Class<? extends Message>, MessageHandler> concurrentMap, Class<? extends Message> clazz, MessageHandler messageHandler) {
        MessageHandler messageHandler2 = (MessageHandler)concurrentMap.get(clazz);
        if (messageHandler2 != null) {
            DualMessageHandler dualMessageHandler;
            while (!concurrentMap.replace(clazz, messageHandler2, dualMessageHandler = new DualMessageHandler(messageHandler, messageHandler2))) {
                messageHandler2 = (MessageHandler)concurrentMap.get(clazz);
                dualMessageHandler = new DualMessageHandler(messageHandler, messageHandler2);
            }
        } else {
            this.setHandler(concurrentMap, clazz, messageHandler);
        }
    }

    @Override
    public void setMessageHandler(Class<? extends Message> clazz, MessageHandler messageHandler) {
        this.setHandler(this.messageHandlers, clazz, messageHandler);
    }

    @Override
    public void addMessageHandler(Class<? extends Message> clazz, MessageHandler messageHandler) {
        this.addHandler(this.messageHandlers, clazz, messageHandler);
    }

    @Override
    public MessageHandler getMessageHandler(Class<? extends Message> clazz) {
        return (MessageHandler)this.messageHandlers.get(clazz);
    }

    @Override
    public void setUDPMessageHandler(Class<? extends Message> clazz, MessageHandler messageHandler) {
        this.setHandler(this.udpMessageHandlers, clazz, messageHandler);
    }

    @Override
    public void addUDPMessageHandler(Class<? extends Message> clazz, MessageHandler messageHandler) {
        this.addHandler(this.udpMessageHandlers, clazz, messageHandler);
    }

    @Override
    public MessageHandler getUDPMessageHandler(Class<? extends Message> clazz) {
        return (MessageHandler)this.udpMessageHandlers.get(clazz);
    }

    @Override
    public void setMulticastMessageHandler(Class<? extends Message> clazz, MessageHandler messageHandler) {
        this.setHandler(this.multicastMessageHandlers, clazz, messageHandler);
    }

    @Override
    public void addMulticastMessageHandler(Class<? extends Message> clazz, MessageHandler messageHandler) {
        this.addHandler(this.multicastMessageHandlers, clazz, messageHandler);
    }

    @Override
    public MessageHandler getMulticastMessageHandler(Class<? extends Message> clazz) {
        return (MessageHandler)this.multicastMessageHandlers.get(clazz);
    }

    @Override
    public void start() {
        this.connectionManager.addEventListener(this.connectionListener);
        this.QRP_PROPAGATOR.start();
        this.backgroundExecutor.scheduleWithFixedDelay(new Expirer(), 30000L, 30000L, TimeUnit.MILLISECONDS);
        this.backgroundExecutor.scheduleWithFixedDelay(new ConnectBackExpirer(), 300000L, 300000L, TimeUnit.MILLISECONDS);
        this.backgroundExecutor.scheduleWithFixedDelay(new HopsFlowManager(this.uploadManager, this.connectionManager), 150000L, 15000L, TimeUnit.MILLISECONDS);
        this.backgroundExecutor.scheduleWithFixedDelay(new UDPReplyCleaner(), 60000L, 60000L, TimeUnit.MILLISECONDS);
        OOBHandler oOBHandler = this.oobHandlerFactory.get();
        this.backgroundExecutor.scheduleWithFixedDelay(oOBHandler, 30000L, 30000L, TimeUnit.MILLISECONDS);
        InspectionRequestHandler inspectionRequestHandler = this.inspectionRequestHandlerFactory.get();
        this.messageHandlerBinder.bind(this);
        this.setMessageHandler(PingRequest.class, new PingRequestHandler());
        this.setMessageHandler(PingReply.class, new PingReplyHandler());
        this.setMessageHandler(QueryRequest.class, new QueryRequestHandler());
        this.setMessageHandler(QueryReply.class, new QueryReplyHandler());
        this.setMessageHandler(ResetTableMessage.class, new ResetTableHandler());
        this.setMessageHandler(PatchTableMessage.class, new PatchTableHandler());
        this.setMessageHandler(TCPConnectBackVendorMessage.class, new TCPConnectBackHandler());
        this.setMessageHandler(UDPConnectBackVendorMessage.class, new UDPConnectBackHandler());
        this.setMessageHandler(TCPConnectBackRedirect.class, new TCPConnectBackRedirectHandler());
        this.setMessageHandler(UDPConnectBackRedirect.class, new UDPConnectBackRedirectHandler());
        this.setMessageHandler(PushProxyRequest.class, new PushProxyRequestHandler());
        this.setMessageHandler(QueryStatusResponse.class, new QueryStatusResponseHandler());
        this.setMessageHandler(HeadPing.class, new HeadPingHandler());
        this.setMessageHandler(SimppRequestVM.class, new SimppRequestVMHandler());
        this.setMessageHandler(SimppVM.class, new SimppVMHandler());
        this.setMessageHandler(UpdateRequest.class, new UpdateRequestHandler());
        this.setMessageHandler(UpdateResponse.class, new UpdateResponseHandler());
        this.setMessageHandler(HeadPong.class, new HeadPongHandler());
        this.setMessageHandler(DHTContactsMessage.class, new DHTContactsMessageHandler());
        this.setMessageHandler(VendorMessage.class, new VendorMessageHandler());
        this.setMessageHandler(InspectionRequest.class, inspectionRequestHandler);
        this.setUDPMessageHandler(QueryRequest.class, new UDPQueryRequestHandler());
        this.setUDPMessageHandler(QueryReply.class, new UDPQueryReplyHandler(oOBHandler));
        this.setUDPMessageHandler(PingRequest.class, new UDPPingRequestHandler());
        this.setUDPMessageHandler(PingReply.class, new UDPPingReplyHandler());
        this.setUDPMessageHandler(LimeACKVendorMessage.class, new UDPLimeACKVendorMessageHandler());
        this.setUDPMessageHandler(ReplyNumberVendorMessage.class, oOBHandler);
        this.setUDPMessageHandler(UDPCrawlerPing.class, this.udpCrawlerPingHandlerFactory.get());
        this.setUDPMessageHandler(HeadPing.class, new UDPHeadPingHandler());
        this.setUDPMessageHandler(UpdateRequest.class, new UDPUpdateRequestHandler());
        this.setUDPMessageHandler(ContentResponse.class, new UDPContentResponseHandler());
        this.setUDPMessageHandler(InspectionRequest.class, inspectionRequestHandler);
        this.setMulticastMessageHandler(QueryRequest.class, new MulticastQueryRequestHandler());
        this.setMulticastMessageHandler(PingRequest.class, new MulticastPingRequestHandler());
    }

    @Override
    public void stop() {
        this.connectionManager.removeEventListener(this.connectionListener);
    }

    @Override
    public void originateQueryGUID(byte[] byArray) {
        this._queryRouteTable.routeReply(byArray, this.forMeReplyHandler);
    }

    @Override
    public void queryKilled(GUID gUID) throws IllegalArgumentException {
        if (gUID == null) {
            throw new IllegalArgumentException("Input GUID is null!");
        }
        this._bypassedResultsCache.queryKilled(gUID);
    }

    @Override
    public void downloadFinished(GUID gUID) throws IllegalArgumentException {
        if (gUID == null) {
            throw new IllegalArgumentException("Input GUID is null!");
        }
        this._bypassedResultsCache.downloadFinished(gUID);
    }

    @Override
    public Set<GUESSEndpoint> getQueryLocs(GUID gUID) {
        return this._bypassedResultsCache.getQueryLocs(gUID);
    }

    @Override
    public String getPingRouteTableDump() {
        return this._pingRouteTable.toString();
    }

    @Override
    public String getQueryRouteTableDump() {
        return this._queryRouteTable.toString();
    }

    @Override
    public String getPushRouteTableDump() {
        return this._pushRouteTable.toString();
    }

    private void removeConnection(ReplyHandler replyHandler) {
        this.queryDispatcher.removeReplyHandler(replyHandler);
        this._pingRouteTable.removeReplyHandler(replyHandler);
        this._queryRouteTable.removeReplyHandler(replyHandler);
        this._pushRouteTable.removeReplyHandler(replyHandler);
        this._headPongRouteTable.removeReplyHandler(replyHandler);
    }

    @Override
    public void handleMessage(Message message, ReplyHandler replyHandler) {
        message.hop();
        MessageHandler messageHandler = this.getMessageHandler(message.getHandlerClass());
        if (messageHandler != null) {
            messageHandler.handleMessage(message, null, replyHandler);
        } else if (message instanceof VendorMessage && (messageHandler = this.getMessageHandler(VendorMessage.class)) != null) {
            messageHandler.handleMessage(message, null, replyHandler);
        }
        this.notifyMessageListener(message, replyHandler);
    }

    private final void notifyMessageListener(Message message, ReplyHandler replyHandler) {
        List<MessageListener> list = this._messageListeners.get(message.getGUID());
        if (list != null) {
            for (MessageListener messageListener : list) {
                messageListener.processMessage(message, replyHandler);
            }
        }
    }

    @Override
    public void handleUDPMessage(Message message, InetSocketAddress inetSocketAddress) {
        Object object;
        message.hop();
        if (message instanceof QueryReply && (object = (Object)this.multicastGuidMap.getOriginalGUID(message.getGUID())) != null) {
            message = this.queryReplyFactory.createQueryReply((byte[])object, (QueryReply)message);
            ((QueryReply)message).setMulticastAllowed(true);
        }
        object = this.udpReplyHandlerCache.getUDPReplyHandler(inetSocketAddress);
        MessageHandler messageHandler = this.getUDPMessageHandler(message.getHandlerClass());
        if (messageHandler != null) {
            messageHandler.handleMessage(message, inetSocketAddress, (ReplyHandler)object);
        } else if (message instanceof VendorMessage && (messageHandler = this.getUDPMessageHandler(VendorMessage.class)) != null) {
            messageHandler.handleMessage(message, inetSocketAddress, (ReplyHandler)object);
        }
        this.notifyMessageListener(message, (ReplyHandler)object);
    }

    @Override
    public void handleMulticastMessage(Message message, InetSocketAddress inetSocketAddress) {
        if (message.getTTL() > 1) {
            return;
        }
        message.hop();
        if (NetworkUtils.isLocalAddress(inetSocketAddress.getAddress()) && !ConnectionSettings.ALLOW_MULTICAST_LOOPBACK.getValue()) {
            return;
        }
        ReplyHandler replyHandler = this.udpReplyHandlerCache.getUDPReplyHandler(inetSocketAddress);
        MessageHandler messageHandler = this.getMulticastMessageHandler(message.getHandlerClass());
        if (messageHandler != null) {
            messageHandler.handleMessage(message, inetSocketAddress, replyHandler);
        } else if (message instanceof VendorMessage && (messageHandler = this.getMulticastMessageHandler(VendorMessage.class)) != null) {
            messageHandler.handleMessage(message, inetSocketAddress, replyHandler);
        }
        this.notifyMessageListener(message, replyHandler);
    }

    protected boolean hasValidQueryKey(InetAddress inetAddress, int n, QueryRequest queryRequest) {
        AddressSecurityToken addressSecurityToken = queryRequest.getQueryKey();
        if (addressSecurityToken == null) {
            return false;
        }
        return addressSecurityToken.isFor(inetAddress, n);
    }

    protected void sendAcknowledgement(InetSocketAddress inetSocketAddress, byte[] byArray) {
        PingReply pingReply;
        Endpoint endpoint = this.connectionManager.getConnectedGUESSUltrapeer();
        if (endpoint != null) {
            try {
                pingReply = this.pingReplyFactory.createGUESSReply(byArray, (byte)1, endpoint);
            }
            catch (UnknownHostException unknownHostException) {
                pingReply = this.createPingReply(byArray);
            }
        } else {
            pingReply = this.createPingReply(byArray);
        }
        if (pingReply == null) {
            return;
        }
        this.udpService.send(pingReply, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
    }

    private PingReply createPingReply(byte[] byArray) {
        GUESSEndpoint gUESSEndpoint = this.queryUnicaster.getUnicastEndpoint();
        if (gUESSEndpoint == null) {
            if (this.networkManager.isIpPortValid()) {
                return this.pingReplyFactory.create(byArray, (byte)1);
            }
            return null;
        }
        return this.pingReplyFactory.createGUESSReply(byArray, (byte)1, gUESSEndpoint.getPort(), gUESSEndpoint.getInetAddress().getAddress());
    }

    final void handlePingRequestPossibleDuplicate(PingRequest pingRequest, ReplyHandler replyHandler) {
        if (this._pingRouteTable.tryToRouteReply(pingRequest.getGUID(), replyHandler) != null) {
            this.handlePingRequest(pingRequest, replyHandler);
        }
    }

    final void handleUDPPingRequestPossibleDuplicate(PingRequest pingRequest, ReplyHandler replyHandler, InetSocketAddress inetSocketAddress) {
        if (this._pingRouteTable.tryToRouteReply(pingRequest.getGUID(), replyHandler) != null) {
            this.handleUDPPingRequest(pingRequest, replyHandler, inetSocketAddress);
        }
    }

    final void handleQueryRequestPossibleDuplicate(QueryRequest queryRequest, ReplyHandler replyHandler) {
        boolean bl = queryRequest.getTTL() == 0 && (queryRequest.getHops() == 1 || queryRequest.getHops() == 2);
        ResultCounter resultCounter = this._queryRouteTable.tryToRouteReply(queryRequest.getGUID(), replyHandler);
        if (resultCounter != null) {
            if (bl) {
                this._queryRouteTable.setTTL(resultCounter, (byte)1);
            }
            this.handleQueryRequest(queryRequest, replyHandler, resultCounter, true);
        } else if (!bl) {
            if (this.wasProbeQuery(queryRequest)) {
                this.handleQueryRequest(queryRequest, replyHandler, resultCounter, false);
            } else {
                this.tallyDupQuery(queryRequest);
            }
        } else if (bl) {
            this.tallyDupQuery(queryRequest);
        }
    }

    private boolean wasProbeQuery(QueryRequest queryRequest) {
        return queryRequest.getTTL() > 0 && this._queryRouteTable.getAndSetTTL(queryRequest.getGUID(), (byte)1, (byte)(queryRequest.getTTL() + 1));
    }

    private void tallyDupQuery(QueryRequest queryRequest) {
        this.duplicateQueryCounter.duplicateQuery(queryRequest);
    }

    final boolean handleUDPQueryRequestPossibleDuplicate(QueryRequest queryRequest, ReplyHandler replyHandler) {
        ResultCounter resultCounter = this._queryRouteTable.tryToRouteReply(queryRequest.getGUID(), replyHandler);
        if (resultCounter != null) {
            this.handleQueryRequest(queryRequest, replyHandler, resultCounter, true);
            return true;
        }
        return false;
    }

    private final void handlePingRequest(PingRequest pingRequest, ReplyHandler replyHandler) {
        if (pingRequest.isHeartbeat() || replyHandler.allowNewPings()) {
            this.respondToPingRequest(pingRequest, replyHandler);
        }
    }

    protected void handleUDPPingRequest(PingRequest pingRequest, ReplyHandler replyHandler, InetSocketAddress inetSocketAddress) {
        if (pingRequest.isQueryKeyRequest()) {
            this.sendQueryKeyPong(pingRequest, inetSocketAddress);
        } else {
            this.respondToUDPPingRequest(pingRequest, inetSocketAddress, replyHandler);
        }
    }

    protected void sendQueryKeyPong(PingRequest pingRequest, InetSocketAddress inetSocketAddress) {
        long l = System.currentTimeMillis();
        if (l - this._lastQueryKeyTime < (long)SearchSettings.QUERY_KEY_DELAY.getValue()) {
            return;
        }
        this._lastQueryKeyTime = l;
        InetAddress inetAddress = inetSocketAddress.getAddress();
        int n = inetSocketAddress.getPort();
        AddressSecurityToken addressSecurityToken = new AddressSecurityToken(inetAddress, n, this.MACCalculatorRepositoryManager.get());
        PingReply pingReply = this.pingReplyFactory.createQueryKeyReply(pingRequest.getGUID(), (byte)1, addressSecurityToken);
        this.udpService.send(pingReply, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
    }

    protected void handleUDPPingReply(PingReply pingReply, ReplyHandler replyHandler, InetAddress inetAddress, int n) {
        if (pingReply.getQueryKey() != null) {
            this.onDemandUnicaster.handleQueryKeyPong(pingReply);
            return;
        }
        if (pingReply.getPort() != n || !pingReply.getInetAddress().equals(inetAddress)) {
            return;
        }
        this.handlePingReply(pingReply, replyHandler);
    }

    protected void handleQueryRequest(QueryRequest queryRequest, ReplyHandler replyHandler, ResultCounter resultCounter, boolean bl) {
        if (!replyHandler.isPersonalSpam(queryRequest)) {
            this.activityCallback.get().handleQueryString(queryRequest.getQuery());
        }
        this.updateMessage(queryRequest, replyHandler);
        if (replyHandler.isSupernodeClientConnection() && resultCounter != null) {
            if (queryRequest.desiresOutOfBandReplies()) {
                String string = replyHandler.getInetAddress().getHostAddress();
                String string2 = NetworkUtils.ip2string(this.networkManager.getAddress());
                if (!(queryRequest.getReplyAddress().equals(string) || queryRequest.getReplyAddress().equals(string2) && this.networkManager.isOOBCapable())) {
                    return;
                }
            }
            bl = false;
            this.respondToQueryRequest(queryRequest, this._clientGUID, replyHandler);
            this.multicastQueryRequest(queryRequest);
            if (replyHandler.isGoodLeaf()) {
                this.sendDynamicQuery(this.queryHandlerFactory.createHandlerForNewLeaf(queryRequest, replyHandler, resultCounter), replyHandler);
            } else {
                this.sendDynamicQuery(this.queryHandlerFactory.createHandlerForOldLeaf(queryRequest, replyHandler, resultCounter), replyHandler);
            }
        } else if (queryRequest.getTTL() > 0 && this.connectionServices.isSupernode()) {
            if (replyHandler.isGoodUltrapeer()) {
                this.forwardQueryToUltrapeers(queryRequest, replyHandler);
            } else {
                this.forwardLimitedQueryToUltrapeers(queryRequest, replyHandler);
            }
        }
        if (bl) {
            this.forwardQueryRequestToLeaves(queryRequest, replyHandler);
            if (!(!queryRequest.isFirewalledSource() || this.networkManager.acceptedIncomingConnection() || queryRequest.canDoFirewalledTransfer() && this.networkManager.canDoFWT())) {
                return;
            }
            this.respondToQueryRequest(queryRequest, this._clientGUID, replyHandler);
        }
    }

    protected void handleLimeACKMessage(LimeACKVendorMessage limeACKVendorMessage, InetSocketAddress inetSocketAddress) {
        GUID.TimedGUID timedGUID = new GUID.TimedGUID(new GUID(limeACKVendorMessage.getGUID()), 25000L);
        QueryResponseBundle queryResponseBundle = this._outOfBandReplies.remove(timedGUID);
        SecurityToken securityToken = limeACKVendorMessage.getSecurityToken();
        if (queryResponseBundle != null && limeACKVendorMessage.getNumResults() > 0) {
            Iterable<QueryReply> iterable;
            InetAddress inetAddress = inetSocketAddress.getAddress();
            int n = inetSocketAddress.getPort();
            if (limeACKVendorMessage.getNumResults() < queryResponseBundle._responses.length) {
                Response[] responseArray = new Response[limeACKVendorMessage.getNumResults()];
                System.arraycopy(queryResponseBundle._responses, 0, responseArray, 0, responseArray.length);
                iterable = this.responsesToQueryReplies(responseArray, queryResponseBundle._query, 1, securityToken);
            } else {
                iterable = this.responsesToQueryReplies(queryResponseBundle._responses, queryResponseBundle._query, 1, securityToken);
            }
            for (QueryReply queryReply : iterable) {
                this.udpService.send(queryReply, inetAddress, n);
            }
        }
    }

    @Override
    public boolean addBypassedSource(ReplyNumberVendorMessage replyNumberVendorMessage, ReplyHandler replyHandler) {
        if (!replyNumberVendorMessage.canReceiveUnsolicited()) {
            return false;
        }
        GUESSEndpoint gUESSEndpoint = new GUESSEndpoint(replyHandler.getInetAddress(), replyHandler.getPort());
        return this._bypassedResultsCache.addBypassedSource(new GUID(replyNumberVendorMessage.getGUID()), gUESSEndpoint);
    }

    @Override
    public boolean addBypassedSource(QueryReply queryReply, ReplyHandler replyHandler) {
        try {
            if (queryReply.getHostData().isFirewalled()) {
                return false;
            }
        }
        catch (BadPacketException badPacketException) {
            return false;
        }
        GUESSEndpoint gUESSEndpoint = new GUESSEndpoint(replyHandler.getInetAddress(), replyHandler.getPort());
        return this._bypassedResultsCache.addBypassedSource(new GUID(queryReply.getGUID()), gUESSEndpoint);
    }

    @Override
    public int getNumOOBToRequest(ReplyNumberVendorMessage replyNumberVendorMessage) {
        GUID gUID = new GUID(replyNumberVendorMessage.getGUID());
        int n = this.searchResultHandler.getNumResultsForQuery(gUID);
        if (n < 0) {
            n = this.queryDispatcher.getLeafResultsForQuery(gUID);
        }
        if (n < 0 || n > 150) {
            return -1;
        }
        return replyNumberVendorMessage.getNumResults();
    }

    @Override
    public boolean isQueryAlive(GUID gUID) {
        return this._queryRouteTable.getReplyHandler(gUID.bytes()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean bufferResponsesForLaterDelivery(QueryRequest queryRequest, Response[] responseArray) {
        Map<GUID.TimedGUID, QueryResponseBundle> map = this._outOfBandReplies;
        synchronized (map) {
            if (this._outOfBandReplies.size() < this.maxBufferedReplies) {
                GUID.TimedGUID timedGUID = new GUID.TimedGUID(new GUID(queryRequest.getGUID()), 25000L);
                this._outOfBandReplies.put(timedGUID, new QueryResponseBundle(queryRequest, responseArray));
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean isHostUnicastQueried(GUID gUID, IpPort ipPort) {
        return this.onDemandUnicaster.isHostQueriedForGUID(gUID, ipPort);
    }

    protected void handleUDPConnectBackRequest(UDPConnectBackVendorMessage uDPConnectBackVendorMessage, Connection connection) {
        GUID gUID = uDPConnectBackVendorMessage.getConnectBackGUID();
        int n = uDPConnectBackVendorMessage.getConnectBackPort();
        InetAddress inetAddress = connection.getInetAddress();
        UDPConnectBackRedirect uDPConnectBackRedirect = new UDPConnectBackRedirect(gUID, inetAddress, n);
        int n2 = 0;
        ArrayList<RoutedConnection> arrayList = new ArrayList<RoutedConnection>(this.connectionManager.getInitializedConnections());
        Collections.shuffle(arrayList);
        for (RoutedConnection routedConnection : arrayList) {
            if (n2 >= 5) break;
            if (routedConnection == connection || routedConnection.getConnectionCapabilities().remoteHostSupportsUDPRedirect() < 0) continue;
            routedConnection.send(uDPConnectBackRedirect);
            ++n2;
        }
    }

    protected void handleUDPConnectBackRedirect(UDPConnectBackRedirect uDPConnectBackRedirect, Connection connection) {
        if (!connection.getConnectionCapabilities().isSupernodeSupernodeConnection()) {
            return;
        }
        GUID gUID = uDPConnectBackRedirect.getConnectBackGUID();
        int n = uDPConnectBackRedirect.getConnectBackPort();
        InetAddress inetAddress = uDPConnectBackRedirect.getConnectBackAddress();
        Endpoint endpoint = new Endpoint(inetAddress.getAddress(), n);
        if (this.connectionManager.isConnectedTo(endpoint.getAddress())) {
            return;
        }
        String string = inetAddress.getHostAddress();
        if (!this.shouldServiceRedirect(_udpConnectBacks, string)) {
            return;
        }
        UDPService.mutateGUID(gUID.bytes(), inetAddress, n);
        PingRequest pingRequest = this.pingRequestFactory.createPingRequest(gUID.bytes(), (byte)1, (byte)0);
        this.udpService.send(pingRequest, inetAddress, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldServiceRedirect(FixedsizeHashMap<String, String> fixedsizeHashMap, String string) {
        FixedsizeHashMap<String, String> fixedsizeHashMap2 = fixedsizeHashMap;
        synchronized (fixedsizeHashMap2) {
            String string2 = fixedsizeHashMap.get(string);
            if (string2 == null) {
                try {
                    fixedsizeHashMap.put(string, string);
                    return true;
                }
                catch (NoMoreStorageException noMoreStorageException) {
                    return false;
                }
            }
            return false;
        }
    }

    protected void handleTCPConnectBackRequest(TCPConnectBackVendorMessage tCPConnectBackVendorMessage, Connection connection) {
        int n = tCPConnectBackVendorMessage.getConnectBackPort();
        InetAddress inetAddress = connection.getInetAddress();
        TCPConnectBackRedirect tCPConnectBackRedirect = new TCPConnectBackRedirect(inetAddress, n);
        int n2 = 0;
        ArrayList<RoutedConnection> arrayList = new ArrayList<RoutedConnection>(this.connectionManager.getInitializedConnections());
        Collections.shuffle(arrayList);
        for (RoutedConnection routedConnection : arrayList) {
            if (n2 >= 5) break;
            if (routedConnection == connection || routedConnection.getConnectionCapabilities().remoteHostSupportsTCPRedirect() < 0) continue;
            routedConnection.send(tCPConnectBackRedirect);
            ++n2;
        }
    }

    protected void handleTCPConnectBackRedirect(TCPConnectBackRedirect tCPConnectBackRedirect, Connection connection) {
        if (!connection.getConnectionCapabilities().isSupernodeSupernodeConnection()) {
            return;
        }
        final int n = tCPConnectBackRedirect.getConnectBackPort();
        final String string = tCPConnectBackRedirect.getConnectBackAddress().getHostAddress();
        Endpoint endpoint = new Endpoint(string, n);
        if (this.connectionManager.isConnectedTo(endpoint.getAddress())) {
            return;
        }
        if (!this.shouldServiceRedirect(_tcpConnectBacks, string)) {
            return;
        }
        TCP_CONNECT_BACKER.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Socket socket = null;
                try {
                    try {
                        socket = MessageRouterImpl.this.socketsManager.connect(new InetSocketAddress(string, n), 6000, SocketsManager.ConnectType.TLS);
                        socket.setSoTimeout(6000);
                        OutputStream outputStream = socket.getOutputStream();
                        outputStream.write("CONNECT BACK\r\n\r\n".getBytes());
                        outputStream.flush();
                    }
                    catch (IOException iOException) {
                        IOUtils.close(socket);
                        socket = MessageRouterImpl.this.socketsManager.connect(new InetSocketAddress(string, n), 12000, SocketsManager.ConnectType.PLAIN);
                        socket.setSoTimeout(12000);
                        OutputStream outputStream = socket.getOutputStream();
                        outputStream.write("CONNECT BACK\r\n\r\n".getBytes());
                        outputStream.flush();
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Succesful connectback to: " + string);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.warn("Interrupted connectback", interruptedException);
                    }
                    IOUtils.close(socket);
                }
                catch (IOException iOException) {
                    LOG.warn("IOX during connectback", iOException);
                }
                finally {
                    IOUtils.close(socket);
                }
            }
        });
    }

    protected void handlePushProxyRequest(PushProxyRequest pushProxyRequest, RoutedConnection routedConnection) {
        if (routedConnection.isSupernodeClientConnection() && this.networkManager.isIpPortValid()) {
            String string = NetworkUtils.ip2string(this.networkManager.getAddress());
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                ErrorService.error(unknownHostException);
            }
            PushProxyAcknowledgement pushProxyAcknowledgement = new PushProxyAcknowledgement(inetAddress, this.networkManager.getPort(), pushProxyRequest.getClientGUID());
            routedConnection.send(pushProxyAcknowledgement);
            this._pushRouteTable.routeReply(pushProxyRequest.getClientGUID().bytes(), routedConnection);
            routedConnection.setPushProxyFor(true);
        }
    }

    protected void handleQueryStatus(QueryStatusResponse queryStatusResponse, RoutedConnection routedConnection) {
        if (!routedConnection.isSupernodeClientConnection()) {
            return;
        }
        GUID gUID = queryStatusResponse.getQueryGUID();
        int n = queryStatusResponse.getNumResults();
        this.queryDispatcher.updateLeafResultsForQuery(gUID, n);
    }

    @Override
    public void sendPingRequest(PingRequest pingRequest, RoutedConnection routedConnection) {
        if (pingRequest == null) {
            throw new NullPointerException("null ping");
        }
        if (routedConnection == null) {
            throw new NullPointerException("null connection");
        }
        this._pingRouteTable.routeReply(pingRequest.getGUID(), this.forMeReplyHandler);
        routedConnection.send(pingRequest);
    }

    @Override
    public void sendQueryRequest(QueryRequest queryRequest, RoutedConnection routedConnection) {
        if (queryRequest == null) {
            throw new NullPointerException("null query");
        }
        if (routedConnection == null) {
            throw new NullPointerException("null connection");
        }
        this._queryRouteTable.routeReply(queryRequest.getGUID(), this.forMeReplyHandler);
        routedConnection.send(queryRequest);
    }

    @Override
    public void broadcastPingRequest(PingRequest pingRequest) {
        if (pingRequest == null) {
            throw new NullPointerException("null ping");
        }
        this._pingRouteTable.routeReply(pingRequest.getGUID(), this.forMeReplyHandler);
        this.broadcastPingRequest(pingRequest, this.forMeReplyHandler, this.connectionManager);
    }

    @Override
    public void sendDynamicQuery(QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new NullPointerException("null QueryHandler");
        }
        ResultCounter resultCounter = this._queryRouteTable.routeReply(queryRequest.getGUID(), this.forMeReplyHandler);
        if (this.connectionServices.isSupernode()) {
            this.sendDynamicQuery(this.queryHandlerFactory.createHandlerForMe(queryRequest, resultCounter), this.forMeReplyHandler);
        } else {
            this.originateLeafQuery(queryRequest);
        }
        this.originateMulticastQuery(queryRequest);
    }

    protected void originateMulticastQuery(QueryRequest queryRequest) {
        byte[] byArray = GUID.makeGuid();
        QueryRequest queryRequest2 = this.queryRequestFactory.createMulticastQuery(byArray, queryRequest);
        this.multicastGuidMap.addMapping(queryRequest.getGUID(), byArray, 60000L);
        this.multicastQueryRequest(queryRequest2);
    }

    private void sendDynamicQuery(QueryHandler queryHandler, ReplyHandler replyHandler) {
        if (queryHandler == null) {
            throw new NullPointerException("null QueryHandler");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        this.queryDispatcher.addQuery(queryHandler);
    }

    private void broadcastPingRequest(PingRequest pingRequest, ReplyHandler replyHandler, ConnectionManager connectionManager) {
        List<RoutedConnection> list = connectionManager.getInitializedConnections();
        int n = list.size();
        boolean bl = false;
        if (n > 3) {
            bl = true;
        }
        for (int i = 0; i < n; ++i) {
            RoutedConnection routedConnection = list.get(i);
            if (!routedConnection.isStable() || replyHandler != this.forMeReplyHandler && (routedConnection == replyHandler || routedConnection.getConnectionCapabilities().isClientSupernodeConnection())) continue;
            double d = routedConnection.supportsPongCaching() ? 0.7 : 0.9;
            if (bl && Math.random() < d) continue;
            routedConnection.send(pingRequest);
        }
    }

    @Override
    public final void forwardQueryRequestToLeaves(QueryRequest queryRequest, ReplyHandler replyHandler) {
        RoutedConnection routedConnection;
        int n;
        if (!this.connectionServices.isSupernode()) {
            return;
        }
        List<RoutedConnection> list = this.connectionManager.getInitializedClientConnections();
        List<RoutedConnection> list2 = new ArrayList<RoutedConnection>();
        for (n = 0; n < list.size(); ++n) {
            routedConnection = list.get(n);
            if (routedConnection == replyHandler || !routedConnection.shouldForwardQuery(queryRequest)) continue;
            list2.add(routedConnection);
        }
        if (list.size() > 8 && (double)list2.size() / (double)list.size() > 0.8) {
            n = (int)Math.floor(Math.random() * (double)list2.size() * 0.75);
            list2 = list2.subList(n, n + list2.size() / 4);
        }
        for (n = 0; n < list2.size(); ++n) {
            routedConnection = (RoutedConnection)list2.get(n);
            routedConnection.send(queryRequest);
        }
    }

    private boolean sendRoutedQueryToHost(QueryRequest queryRequest, RoutedConnection routedConnection, ReplyHandler replyHandler) {
        if (routedConnection.shouldForwardQuery(queryRequest)) {
            routedConnection.send(queryRequest);
            return true;
        }
        return false;
    }

    protected void unicastQueryRequest(QueryRequest queryRequest, ReplyHandler replyHandler) {
        queryRequest.setTTL((byte)1);
        this.queryUnicaster.addQuery(queryRequest, replyHandler);
    }

    protected void multicastQueryRequest(QueryRequest queryRequest) {
        queryRequest.setTTL((byte)1);
        this.multicastService.send(queryRequest);
    }

    void forwardQueryToUltrapeers(QueryRequest queryRequest, ReplyHandler replyHandler) {
        List<RoutedConnection> list = this.connectionManager.getInitializedConnections();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            RoutedConnection routedConnection = list.get(i);
            this.forwardQueryToUltrapeer(queryRequest, replyHandler, routedConnection);
        }
    }

    void forwardLimitedQueryToUltrapeers(QueryRequest queryRequest, ReplyHandler replyHandler) {
        List<RoutedConnection> list = this.connectionManager.getInitializedConnections();
        int n = list.size();
        int n2 = 15;
        for (int i = 0; i < n && n2 != 0; ++i) {
            RoutedConnection routedConnection = list.get(i);
            if (routedConnection.isGoodUltrapeer() && n - i > n2) continue;
            this.forwardQueryToUltrapeer(queryRequest, replyHandler, routedConnection);
            --n2;
        }
    }

    void forwardQueryToUltrapeer(QueryRequest queryRequest, ReplyHandler replyHandler, RoutedConnection routedConnection) {
        boolean bl;
        if (routedConnection == replyHandler) {
            return;
        }
        if (routedConnection.getConnectionCapabilities().isClientSupernodeConnection()) {
            return;
        }
        if (queryRequest.isFeatureQuery() && !routedConnection.getConnectionCapabilities().getRemoteHostSupportsFeatureQueries()) {
            return;
        }
        boolean bl2 = bl = queryRequest.getTTL() == 1;
        if (bl && routedConnection.isUltrapeerQueryRoutingConnection()) {
            this.sendRoutedQueryToHost(queryRequest, routedConnection, replyHandler);
        } else {
            routedConnection.send(queryRequest);
        }
    }

    void originateLeafQuery(QueryRequest queryRequest) {
        List<RoutedConnection> list = this.connectionManager.getInitializedConnections();
        int n = queryRequest.isWhatIsNewRequest() ? 2 : 3;
        int n2 = !queryRequest.isWhatIsNewRequest() ? 0 : (int)Math.floor(Math.random() * (double)(list.size() - 1));
        int n3 = Math.min(n, list.size());
        boolean bl = queryRequest.desiresOutOfBandReplies();
        for (int i = n2; i < n2 + n3; ++i) {
            RoutedConnection routedConnection = list.get(i);
            QueryRequest queryRequest2 = queryRequest;
            if (bl && routedConnection.getConnectionCapabilities().remoteHostSupportsLeafGuidance() < 0) {
                queryRequest2 = this.queryRequestFactory.unmarkOOBQuery(queryRequest);
            }
            routedConnection.originateQuery(queryRequest2);
        }
    }

    @Override
    public boolean originateQuery(QueryRequest queryRequest, RoutedConnection routedConnection) {
        if (queryRequest == null) {
            throw new NullPointerException("null query");
        }
        if (routedConnection == null) {
            throw new NullPointerException("null connection");
        }
        if (queryRequest.isFeatureQuery() && !routedConnection.getConnectionCapabilities().getRemoteHostSupportsFeatureQueries()) {
            return false;
        }
        routedConnection.originateQuery(queryRequest);
        return true;
    }

    protected abstract void respondToPingRequest(PingRequest var1, ReplyHandler var2);

    protected abstract void respondToUDPPingRequest(PingRequest var1, InetSocketAddress var2, ReplyHandler var3);

    protected abstract boolean respondToQueryRequest(QueryRequest var1, byte[] var2, ReplyHandler var3);

    protected void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        ReplyHandler replyHandler2;
        boolean bl = this.hostCatcher.add(pingReply);
        if (bl && !pingReply.isUDPHostCache()) {
            this.pongCacher.get().addPong(pingReply);
        }
        if ((replyHandler2 = this._pingRouteTable.getReplyHandler(pingReply.getGUID())) != null) {
            replyHandler2.handlePingReply(pingReply, replyHandler);
        } else {
            replyHandler.countDroppedMessage();
        }
        boolean bl2 = pingReply.supportsUnicast();
        if (bl && (pingReply.isUltrapeer() || bl2)) {
            List<RoutedConnection> list = this.connectionManager.getInitializedClientConnections();
            for (int i = 0; i < list.size(); ++i) {
                RoutedConnection routedConnection = list.get(i);
                assert (routedConnection != null) : "null c.";
                if (routedConnection == replyHandler || routedConnection == replyHandler2 || !routedConnection.allowNewPongs()) continue;
                routedConnection.handlePingReply(pingReply, replyHandler);
            }
        }
    }

    @Override
    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        if (queryReply == null) {
            throw new NullPointerException("null query reply");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        if (!this.altCountOk(queryReply)) {
            return;
        }
        RouteTable.ReplyRoutePair replyRoutePair = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getUniqueResultCount(), queryReply.getPartialResultCount(), ByteOrder.beb2int(queryReply.getIPBytes(), 0));
        if (replyRoutePair != null) {
            queryReply.setPriority(replyRoutePair.getBytesRouted());
            this._pushRouteTable.routeReply(queryReply.getClientGUID(), replyHandler);
            ReplyHandler replyHandler2 = replyRoutePair.getReplyHandler();
            this._queryRouteTable.countHopsTTLNet(queryReply);
            if (replyHandler2 == this.forMeReplyHandler) {
                this._queryRouteTable.timeStampResults(queryReply);
            }
            if (!this.shouldDropReply(replyRoutePair, replyHandler2, queryReply)) {
                replyHandler2.handleQueryReply(queryReply, replyHandler);
                this.queryUnicaster.handleQueryReply(queryReply);
            } else {
                replyHandler.countDroppedMessage();
            }
        } else {
            replyHandler.countDroppedMessage();
        }
    }

    private boolean altCountOk(QueryReply queryReply) {
        try {
            for (Response response : queryReply.getResultsAsList()) {
                if (response.getLocations().size() <= FilterSettings.MAX_ALTS_PER_RESPONSE.getValue()) continue;
                return false;
            }
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        return true;
    }

    private boolean shouldDropReply(RouteTable.ReplyRoutePair replyRoutePair, ReplyHandler replyHandler, QueryReply queryReply) {
        byte by = queryReply.getTTL();
        if (replyHandler == this.forMeReplyHandler) {
            return false;
        }
        if (by == 0) {
            this.droppedReplyCounter.dropTTL0();
            return true;
        }
        int n = replyRoutePair.getResultsRouted();
        if (n > 100) {
            this.droppedReplyCounter.tooManyResults((short)n);
            return true;
        }
        int n2 = replyRoutePair.getBytesRouted();
        if (by > 2 && n2 < 51200) {
            return false;
        }
        if (by == 1 && n2 < 204800) {
            return false;
        }
        if (by == 2 && n2 < 102400) {
            return false;
        }
        this.droppedReplyCounter.ttlByteDrop(by, n2);
        return true;
    }

    private void handleSimppRequest(SimppRequestVM simppRequestVM, ReplyHandler replyHandler) {
        if (simppRequestVM.getVersion() > 1) {
            return;
        }
        byte[] byArray = this.simppManager.get().getSimppBytes();
        if (byArray != null && byArray.length > 0) {
            SimppVM simppVM = new SimppVM(byArray);
            try {
                replyHandler.handleSimppVM(simppVM);
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private void handleSimppVM(SimppVM simppVM, ReplyHandler replyHandler) {
    }

    private void handleUpdateRequest(UpdateRequest updateRequest, ReplyHandler replyHandler) {
        byte[] byArray = this.updateHandler.get().getLatestBytes();
        if (byArray != null) {
            UpdateResponse updateResponse = UpdateResponse.createUpdateResponse(byArray, updateRequest);
            replyHandler.reply(updateResponse);
        }
    }

    private void handleContentResponse(ContentResponse contentResponse, ReplyHandler replyHandler) {
        this.contentManager.handleContentResponse(contentResponse);
    }

    private void handleUpdateResponse(UpdateResponse updateResponse, ReplyHandler replyHandler) {
        this.updateHandler.get().handleNewData(updateResponse.getUpdate(), replyHandler);
    }

    @Override
    public ReplyHandler getPushHandler(byte[] byArray) {
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(byArray);
        if (replyHandler != null) {
            return replyHandler;
        }
        if (Arrays.equals(this._clientGUID, byArray)) {
            return this.forMeReplyHandler;
        }
        return null;
    }

    protected void sendPingReply(PingReply pingReply, ReplyHandler replyHandler) {
        if (pingReply == null) {
            throw new NullPointerException("null pong");
        }
        if (replyHandler == null) {
            throw new NullPointerException("null reply handler");
        }
        replyHandler.handlePingReply(pingReply, null);
    }

    protected void sendQueryReply(QueryReply queryReply) throws IOException {
        if (queryReply == null) {
            throw new NullPointerException("null reply");
        }
        RouteTable.ReplyRoutePair replyRoutePair = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getResultCount(), queryReply.getPartialResultCount(), 0);
        if (replyRoutePair == null) {
            throw new IOException("no route for reply");
        }
        queryReply.setPriority(replyRoutePair.getBytesRouted());
        replyRoutePair.getReplyHandler().handleQueryReply(queryReply, null);
    }

    @Override
    public void sendPushRequest(PushRequest pushRequest) throws IOException {
        if (pushRequest == null) {
            throw new NullPointerException("null push");
        }
        ReplyHandler replyHandler = this.getPushHandler(pushRequest.getClientGUID());
        if (replyHandler == null) {
            throw new IOException("no route for push");
        }
        replyHandler.handlePushRequest(pushRequest, this.forMeReplyHandler);
    }

    @Override
    public void sendMulticastPushRequest(PushRequest pushRequest) {
        if (pushRequest == null) {
            throw new NullPointerException("null push");
        }
        assert (pushRequest.getTTL() == 1) : "multicast push ttl not 1";
        this.multicastService.send(pushRequest);
    }

    @Override
    public Iterable<QueryReply> responsesToQueryReplies(Response[] responseArray, QueryRequest queryRequest) {
        return this.responsesToQueryReplies(responseArray, queryRequest, 10, null);
    }

    Iterable<QueryReply> responsesToQueryReplies(Response[] responseArray, QueryRequest queryRequest, int n, SecurityToken securityToken) {
        int n2;
        Response[] responseArray2;
        int n3;
        LinkedList<QueryReply> linkedList = new LinkedList<QueryReply>();
        byte[] byArray = queryRequest.getGUID();
        byte by = (byte)(queryRequest.getHops() + 1);
        long l = this.uploadManager.measuredUploadSpeed();
        boolean bl = true;
        if (l == -1L) {
            l = ConnectionSettings.CONNECTION_SPEED.getValue();
            bl = false;
        }
        int n4 = responseArray.length;
        int n5 = 0;
        byte by2 = queryRequest.getHops();
        if (n > 1 && by2 > 2 && n4 > 10) {
            n3 = (int)(Math.random() * (double)n4) % (n4 - 10);
            responseArray2 = new Response[10];
            n2 = 0;
            while (n2 < 10) {
                responseArray2[n2] = responseArray[n3];
                ++n2;
                ++n3;
            }
            responseArray = responseArray2;
            n4 = responseArray.length;
        }
        while (n4 > 0) {
            boolean bl2;
            n3 = n4 < n ? n4 : n;
            if (n5 == 0 && n3 < n) {
                responseArray2 = responseArray;
            } else {
                responseArray2 = new Response[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    responseArray2[n2] = responseArray[n5];
                    ++n5;
                }
            }
            n4 -= n3;
            n2 = !this.uploadManager.mayBeServiceable() ? 1 : 0;
            boolean bl3 = this.uploadManager.hadSuccesfulUpload();
            boolean bl4 = queryRequest.isMulticast() && queryRequest.getTTL() + queryRequest.getHops() == 1;
            boolean bl5 = bl2 = queryRequest.canDoFirewalledTransfer() && this.networkManager.canDoFWT() && !this.networkManager.acceptedIncomingConnection();
            if (bl4) {
                by = 1;
            }
            List<QueryReply> list = this.createQueryReply(byArray, by, l, responseArray2, this._clientGUID, n2 != 0, bl3, bl, bl4, bl2, securityToken);
            linkedList.addAll(list);
        }
        return linkedList;
    }

    protected abstract List<QueryReply> createQueryReply(byte[] var1, byte var2, long var3, Response[] var5, byte[] var6, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11, SecurityToken var12);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResetTableMessage(ResetTableMessage resetTableMessage, RoutedConnection routedConnection) {
        if (!MessageRouterImpl.isQRPConnection(routedConnection)) {
            return;
        }
        Object object = routedConnection.getQRPLock();
        synchronized (object) {
            routedConnection.resetQueryRouteTable(resetTableMessage);
        }
        if (routedConnection.isLeafConnection()) {
            this._lastQueryRouteTable = this.createRouteTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePatchTableMessage(PatchTableMessage patchTableMessage, RoutedConnection routedConnection) {
        if (!MessageRouterImpl.isQRPConnection(routedConnection)) {
            return;
        }
        Object object = routedConnection.getQRPLock();
        synchronized (object) {
            routedConnection.patchQueryRouteTable(patchTableMessage);
        }
        if (routedConnection.isLeafConnection()) {
            this._lastQueryRouteTable = this.createRouteTable();
        }
    }

    private void updateMessage(QueryRequest queryRequest, ReplyHandler replyHandler) {
        Object object;
        if (SearchSettings.SEND_LIME_RESPONSES.getBoolean() && queryRequest.isQueryForLW() && this.staticMessages.getLimeReply() != null) {
            object = this.queryReplyFactory.createQueryReply(queryRequest.getGUID(), this.staticMessages.getLimeReply());
            object.setHops((byte)0);
            object.setTTL((byte)(queryRequest.getHops() + 1));
            try {
                this.sendQueryReply((QueryReply)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!(replyHandler instanceof Connection)) {
            return;
        }
        object = (Connection)((Object)replyHandler);
        QueryReply queryReply = this.staticMessages.getUpdateReply();
        if (queryRequest.getHops() == 1 && object.getConnectionCapabilities().isOldLimeWire() && queryReply != null) {
            QueryReply queryReply2 = this.queryReplyFactory.createQueryReply(queryRequest.getGUID(), queryReply);
            try {
                this.sendQueryReply(queryReply2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean isQRPConnection(Connection connection) {
        if (connection.getConnectionCapabilities().isSupernodeClientConnection()) {
            return true;
        }
        return connection.getConnectionCapabilities().isUltrapeerQueryRoutingConnection();
    }

    void forwardQueryRouteTables() {
        long l = System.currentTimeMillis();
        List<RoutedConnection> list = this.connectionManager.getInitializedConnections();
        QueryRouteTable queryRouteTable = null;
        List<RouteTableMessage> list2 = null;
        QueryRouteTable queryRouteTable2 = null;
        for (int i = 0; i < list.size(); ++i) {
            RoutedConnection routedConnection = list.get(i);
            if (!this.connectionServices.isSupernode() ? !routedConnection.getConnectionCapabilities().isClientSupernodeConnection() || !routedConnection.getConnectionCapabilities().isQueryRoutingEnabled() : !routedConnection.isUltrapeerQueryRoutingConnection()) continue;
            if (l < routedConnection.getRoutedConnectionStatistics().getNextQRPForwardTime()) continue;
            routedConnection.getRoutedConnectionStatistics().incrementNextQRPForwardTime(l);
            if (queryRouteTable == null) {
                this._lastQueryRouteTable = queryRouteTable = this.createRouteTable();
            }
            if (queryRouteTable2 == routedConnection.getRoutedConnectionStatistics().getQueryRouteTableSent()) {
                if (list2 == null) {
                    list2 = queryRouteTable.encode(queryRouteTable2, true);
                }
            } else {
                queryRouteTable2 = routedConnection.getRoutedConnectionStatistics().getQueryRouteTableSent();
                list2 = queryRouteTable.encode(queryRouteTable2, true);
            }
            if (!ConnectionSettings.SEND_QRP.getValue()) {
                return;
            }
            for (RouteTableMessage routeTableMessage : list2) {
                routedConnection.send(routeTableMessage);
            }
            routedConnection.getRoutedConnectionStatistics().setQueryRouteTableSent(queryRouteTable);
        }
    }

    @Override
    public QueryRouteTable getQueryRouteTable() {
        return this._lastQueryRouteTable;
    }

    QueryRouteTable createRouteTable() {
        QueryRouteTable queryRouteTable = this.fileManager.getQRT();
        if (this.connectionServices.isSupernode()) {
            this.addQueryRoutingEntriesForLeaves(queryRouteTable);
        }
        return queryRouteTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addQueryRoutingEntriesForLeaves(QueryRouteTable queryRouteTable) {
        List<RoutedConnection> list = this.connectionManager.getInitializedClientConnections();
        for (int i = 0; i < list.size(); ++i) {
            RoutedConnection routedConnection = list.get(i);
            Object object = routedConnection.getQRPLock();
            synchronized (object) {
                QueryRouteTable queryRouteTable2;
                if (!routedConnection.isBusyLeaf() && (queryRouteTable2 = routedConnection.getRoutedConnectionStatistics().getQueryRouteTableReceived()) != null) {
                    queryRouteTable.addAll(queryRouteTable2);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMessageListener(byte[] byArray, MessageListener messageListener) {
        messageListener.registered(byArray);
        Object object = this.MESSAGE_LISTENER_LOCK;
        synchronized (object) {
            TreeMap treeMap = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
            treeMap.putAll(this._messageListeners);
            ArrayList<MessageListener> arrayList = (ArrayList<MessageListener>)treeMap.get(byArray);
            if (arrayList == null) {
                arrayList = new ArrayList<MessageListener>(1);
                arrayList.add(messageListener);
            } else {
                ArrayList<MessageListener> arrayList2 = new ArrayList<MessageListener>(arrayList.size() + 1);
                arrayList2.addAll(arrayList);
                arrayList = arrayList2;
                arrayList.add(messageListener);
            }
            treeMap.put(byArray, Collections.unmodifiableList(arrayList));
            this._messageListeners = Collections.unmodifiableMap(treeMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMessageListener(byte[] byArray, MessageListener messageListener) {
        boolean bl = false;
        Object object = this.MESSAGE_LISTENER_LOCK;
        synchronized (object) {
            List<MessageListener> list = this._messageListeners.get(byArray);
            if (list != null && (list = new ArrayList<MessageListener>(list)).remove(messageListener)) {
                bl = true;
                TreeMap<byte[], List<MessageListener>> treeMap = new TreeMap<byte[], List<MessageListener>>(GUID.GUID_BYTE_COMPARATOR);
                treeMap.putAll(this._messageListeners);
                if (list.isEmpty()) {
                    treeMap.remove(byArray);
                } else {
                    treeMap.put(byArray, Collections.unmodifiableList(list));
                }
                this._messageListeners = Collections.unmodifiableMap(treeMap);
            }
        }
        if (bl) {
            messageListener.unregistered(byArray);
        }
    }

    private void handleHeadPing(HeadPing headPing, ReplyHandler replyHandler) {
        if (DownloadSettings.DROP_HEADPINGS.getValue()) {
            return;
        }
        GUID gUID = headPing.getClientGuid();
        ReplyHandler replyHandler2 = gUID != null ? this.getPushHandler(gUID.bytes()) : this.forMeReplyHandler;
        if (replyHandler2 == null) {
            return;
        }
        if (replyHandler2 instanceof ForMeReplyHandler) {
            HeadPong headPong = this.headPongFactory.create(headPing);
            replyHandler.reply(headPong);
        } else {
            this._headPongRouteTable.routeReply(headPing.getGUID(), replyHandler);
            if (!(replyHandler instanceof Connection) || ((Connection)((Object)replyHandler)).getConnectionCapabilities().supportsVMRouting()) {
                replyHandler2.reply(headPing);
            } else {
                replyHandler2.reply(new HeadPing(headPing));
            }
        }
    }

    Map<byte[], List<MessageListener>> getMessageListenerMap() {
        return this._messageListeners;
    }

    private void handleHeadPong(HeadPong headPong, ReplyHandler replyHandler) {
        ReplyHandler replyHandler2 = this._headPongRouteTable.getReplyHandler(headPong.getGUID());
        if (replyHandler2 != null && !(replyHandler2 instanceof ForMeReplyHandler)) {
            replyHandler2.reply(headPong);
            this._headPongRouteTable.removeReplyHandler(replyHandler2);
        }
    }

    private void handleDHTContactsMessage(DHTContactsMessage dHTContactsMessage, ReplyHandler replyHandler) {
        this.dhtManager.handleDHTContactsMessage(dHTContactsMessage);
    }

    @Override
    public void forwardInspectionRequestToLeaves(InspectionRequest inspectionRequest) {
        if (!this.connectionManager.isSupernode()) {
            return;
        }
        if (inspectionRequest.getReturnAddress() == null) {
            return;
        }
        for (RoutedConnection routedConnection : this.connectionManager.getInitializedClientConnections()) {
            if (routedConnection.getConnectionCapabilities().remoteHostSupportsInspections() < inspectionRequest.getVersion()) continue;
            routedConnection.send(inspectionRequest);
        }
    }

    RouteTable getPushRouteTable() {
        return this._pushRouteTable;
    }

    RouteTable getHeadPongRouteTable() {
        return this._headPongRouteTable;
    }

    Map<GUID.TimedGUID, QueryResponseBundle> getOutOfBandReplies() {
        return this._outOfBandReplies;
    }

    void setMaxBufferedReplies(int n) {
        this.maxBufferedReplies = n;
    }

    @Override
    public long getOOBExpireTime() {
        return 120000L;
    }

    private class ConnectionListener
    implements ConnectionLifecycleListener {
        private ConnectionListener() {
        }

        public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent connectionLifecycleEvent) {
            if (connectionLifecycleEvent.isConnectionClosedEvent()) {
                MessageRouterImpl.this.removeConnection(connectionLifecycleEvent.getConnection());
            }
        }
    }

    private static class DuplicateQueryCounter
    implements Inspectable {
        private final Buffer<Long> duplicateTimes = new Buffer(100);
        private final Buffer<Byte> duplicateHops = new Buffer(100);
        private final Buffer<Byte> duplicateTTLs = new Buffer(100);
        private long totalDropped;
        private final Buffer<GUID> lastNGUIDs = new Buffer(100);
        private final Map<GUID, Integer> counts = new HashMap<GUID, Integer>();
        private int highestEver;

        private DuplicateQueryCounter() {
        }

        public synchronized void duplicateQuery(QueryRequest queryRequest) {
            ++this.totalDropped;
            if (!LimeWireUtils.isBetaRelease()) {
                return;
            }
            this.duplicateTimes.add(System.currentTimeMillis());
            this.duplicateHops.add(queryRequest.getHops());
            this.duplicateTTLs.add(queryRequest.getTTL());
            GUID gUID = new GUID(queryRequest.getGUID());
            Integer n = this.counts.get(gUID);
            if (n != null) {
                Integer n2 = n;
                Integer n3 = n = Integer.valueOf(n + 1);
                this.highestEver = Math.max(this.highestEver, n);
                this.counts.put(gUID, n);
                return;
            }
            n = 1;
            this.counts.put(gUID, n);
            GUID gUID2 = this.lastNGUIDs.add(gUID);
            if (gUID2 != null) {
                this.counts.remove(gUID2);
            }
        }

        public synchronized Object inspect() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("total", this.totalDropped);
            hashMap.put("highest", this.highestEver);
            byte[] byArray = new byte[this.duplicateTTLs.getSize()];
            for (int i = 0; i < this.duplicateTTLs.getSize(); ++i) {
                byArray[i] = this.duplicateTTLs.get(i);
            }
            byte[] byArray2 = new byte[this.duplicateHops.getSize()];
            for (int i = 0; i < this.duplicateHops.getSize(); ++i) {
                byArray2[i] = this.duplicateHops.get(i);
            }
            byte[] byArray3 = new byte[this.duplicateTimes.getSize() * 8];
            for (int i = 0; i < this.duplicateTimes.getSize(); ++i) {
                ByteOrder.long2beb(this.duplicateTimes.get(i), byArray3, i * 8);
            }
            hashMap.put("ttls", byArray);
            hashMap.put("hops", byArray2);
            hashMap.put("times", byArray3);
            hashMap.put("hist", new HashMap<GUID, Integer>(this.counts));
            return hashMap;
        }
    }

    private static class DroppedReplyCounter
    implements Inspectable {
        private final Buffer<Short> tooManyResults = new Buffer(50);
        private final Buffer<Byte> ttls = new Buffer(50);
        private final Buffer<Integer> bytesRouted = new Buffer(50);
        private long totalDropped;
        private long droppedTTL0;

        private DroppedReplyCounter() {
        }

        public synchronized Object inspect() {
            byte[] byArray = new byte[this.tooManyResults.getSize() * 2];
            for (int i = 0; i < this.tooManyResults.getSize(); ++i) {
                ByteOrder.short2beb(this.tooManyResults.get(i), byArray, i * 2);
            }
            byte[] byArray2 = new byte[this.ttls.getSize()];
            for (int i = 0; i < this.ttls.getSize(); ++i) {
                byArray2[i] = this.ttls.get(i);
            }
            byte[] byArray3 = new byte[this.bytesRouted.getSize() * 4];
            for (int i = 0; i < this.bytesRouted.getSize(); ++i) {
                ByteOrder.int2beb((int)this.bytesRouted.get(i), byArray3, i * 4);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("tooMany", byArray);
            hashMap.put("ttls", byArray2);
            hashMap.put("bytes", byArray3);
            hashMap.put("total", this.totalDropped);
            hashMap.put("ttl0", this.droppedTTL0);
            return hashMap;
        }

        public synchronized void tooManyResults(short s) {
            if (!LimeWireUtils.isBetaRelease()) {
                return;
            }
            ++this.totalDropped;
            this.tooManyResults.add(s);
        }

        public synchronized void ttlByteDrop(byte by, int n) {
            if (!LimeWireUtils.isBetaRelease()) {
                return;
            }
            ++this.totalDropped;
            this.ttls.add(by);
            this.bytesRouted.add(n);
        }

        public synchronized void dropTTL0() {
            ++this.totalDropped;
            ++this.droppedTTL0;
        }
    }

    private class GUIDTracker
    implements Inspectable,
    MessageListener,
    SettingListener {
        private final List<Map<String, Object>> l = Collections.synchronizedList(new ArrayList());
        private volatile long start;
        private volatile byte[] lastGuid;

        public GUIDTracker() {
            MessageSettings.TRACKING_GUID.addSettingListener(this);
        }

        public Object inspect() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("start", this.start);
            if (this.lastGuid != null) {
                hashMap.put("guid", Base32.encode(this.lastGuid));
            }
            hashMap.put("messages", this.l);
            return hashMap;
        }

        public void processMessage(Message message, ReplyHandler replyHandler) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("ver", 1);
            hashMap.put("time", System.currentTimeMillis());
            hashMap.put("source", replyHandler.getInetAddress() + ":" + replyHandler.getPort());
            hashMap.put("type", message.getClass().getName());
            hashMap.put("hops", message.getHops());
            hashMap.put("ttl", message.getTTL());
            hashMap.put("net", (Object)message.getNetwork());
            hashMap.put("len", message.getLength());
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                message.writeQuickly(byteArrayOutputStream);
                hashMap.put("pay", byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.l.add(hashMap);
        }

        public void registered(final byte[] byArray) {
            this.start = System.currentTimeMillis();
            this.lastGuid = byArray;
            MessageRouterImpl.this.backgroundExecutor.schedule(new Runnable(){

                public void run() {
                    byte[] byArray2 = GUIDTracker.this.lastGuid;
                    if (byArray2 != null && Arrays.equals(byArray, byArray2)) {
                        MessageRouterImpl.this.unregisterMessageListener(byArray, GUIDTracker.this);
                    }
                }
            }, 600L, TimeUnit.SECONDS);
        }

        public void unregistered(byte[] byArray) {
            this.start = 0L;
            this.lastGuid = null;
            this.l.clear();
        }

        public void settingChanged(SettingEvent settingEvent) {
            String string;
            if (settingEvent.getEventType() != SettingEvent.EventType.VALUE_CHANGED || settingEvent.getSetting() != MessageSettings.TRACKING_GUID) {
                return;
            }
            byte[] byArray = this.lastGuid;
            if (byArray != null) {
                MessageRouterImpl.this.unregisterMessageListener(byArray, this);
            }
            if ((string = MessageSettings.TRACKING_GUID.getValue()).length() == 0) {
                return;
            }
            byte[] byArray2 = Base32.decode(string);
            MessageRouterImpl.this.registerMessageListener(byArray2, this);
        }
    }

    public class UDPQueryReplyHandler
    implements MessageHandler {
        private final OOBHandler oobHandler;

        public UDPQueryReplyHandler(OOBHandler oOBHandler) {
            this.oobHandler = oOBHandler;
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            QueryReply queryReply = (QueryReply)message;
            if (queryReply.isReplyToMulticastQuery() || MessageRouterImpl.this.isHostUnicastQueried(new GUID(queryReply.getGUID()), replyHandler)) {
                MessageRouterImpl.this.handleQueryReply(queryReply, replyHandler);
            } else {
                this.oobHandler.handleMessage(message, inetSocketAddress, replyHandler);
            }
        }
    }

    public class MulticastPingReplyHandler
    implements MessageHandler {
        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleUDPPingReply((PingReply)message, replyHandler, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
    }

    public class MulticastPingRequestHandler
    implements MessageHandler {
        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleUDPPingRequestPossibleDuplicate((PingRequest)message, replyHandler, inetSocketAddress);
        }
    }

    public class MulticastQueryReplyHandler
    implements MessageHandler {
        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleQueryReply((QueryReply)message, replyHandler);
        }
    }

    public class MulticastQueryRequestHandler
    implements MessageHandler {
        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)message, replyHandler);
        }
    }

    private class UDPContentResponseHandler
    implements MessageHandler {
        private UDPContentResponseHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleContentResponse((ContentResponse)message, replyHandler);
        }
    }

    private class UDPUpdateRequestHandler
    implements MessageHandler {
        private UDPUpdateRequestHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleUpdateRequest((UpdateRequest)message, replyHandler);
        }
    }

    private class UDPHeadPingHandler
    implements MessageHandler {
        private UDPHeadPingHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleHeadPing((HeadPing)message, replyHandler);
        }
    }

    private class UDPLimeACKVendorMessageHandler
    implements MessageHandler {
        private UDPLimeACKVendorMessageHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleLimeACKMessage((LimeACKVendorMessage)message, inetSocketAddress);
        }
    }

    private class UDPPingReplyHandler
    implements MessageHandler {
        private UDPPingReplyHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleUDPPingReply((PingReply)message, replyHandler, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
    }

    private class UDPPingRequestHandler
    implements MessageHandler {
        private UDPPingRequestHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleUDPPingRequestPossibleDuplicate((PingRequest)message, replyHandler, inetSocketAddress);
        }
    }

    private class UDPQueryRequestHandler
    implements MessageHandler {
        private UDPQueryRequestHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            int n;
            InetAddress inetAddress = inetSocketAddress.getAddress();
            if (MessageRouterImpl.this.hasValidQueryKey(inetAddress, n = inetSocketAddress.getPort(), (QueryRequest)message)) {
                MessageRouterImpl.this.sendAcknowledgement(inetSocketAddress, message.getGUID());
                MessageRouterImpl.this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)message, replyHandler);
            }
        }
    }

    public class VendorMessageHandler
    implements MessageHandler {
        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            Connection connection = (Connection)((Object)replyHandler);
            connection.handleVendorMessage((VendorMessage)message);
        }
    }

    private class DHTContactsMessageHandler
    implements MessageHandler {
        private DHTContactsMessageHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleDHTContactsMessage((DHTContactsMessage)message, replyHandler);
        }
    }

    private class HeadPongHandler
    implements MessageHandler {
        private HeadPongHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleHeadPong((HeadPong)message, replyHandler);
        }
    }

    private class UpdateResponseHandler
    implements MessageHandler {
        private UpdateResponseHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleUpdateResponse((UpdateResponse)message, replyHandler);
        }
    }

    private class UpdateRequestHandler
    implements MessageHandler {
        private UpdateRequestHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleUpdateRequest((UpdateRequest)message, replyHandler);
        }
    }

    private class SimppVMHandler
    implements MessageHandler {
        private SimppVMHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
        }
    }

    private class SimppRequestVMHandler
    implements MessageHandler {
        private SimppRequestVMHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
        }
    }

    private class HeadPingHandler
    implements MessageHandler {
        private HeadPingHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleHeadPing((HeadPing)message, replyHandler);
        }
    }

    private class QueryStatusResponseHandler
    implements MessageHandler {
        private QueryStatusResponseHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleQueryStatus((QueryStatusResponse)message, (RoutedConnection)replyHandler);
        }
    }

    private class PushProxyRequestHandler
    implements MessageHandler {
        private PushProxyRequestHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handlePushProxyRequest((PushProxyRequest)message, (RoutedConnection)replyHandler);
        }
    }

    private class UDPConnectBackRedirectHandler
    implements MessageHandler {
        private UDPConnectBackRedirectHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleUDPConnectBackRedirect((UDPConnectBackRedirect)message, (RoutedConnection)replyHandler);
        }
    }

    private class TCPConnectBackRedirectHandler
    implements MessageHandler {
        private TCPConnectBackRedirectHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleTCPConnectBackRedirect((TCPConnectBackRedirect)message, (RoutedConnection)replyHandler);
        }
    }

    private class UDPConnectBackHandler
    implements MessageHandler {
        private UDPConnectBackHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleUDPConnectBackRequest((UDPConnectBackVendorMessage)message, (RoutedConnection)replyHandler);
        }
    }

    private class TCPConnectBackHandler
    implements MessageHandler {
        private TCPConnectBackHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleTCPConnectBackRequest((TCPConnectBackVendorMessage)message, (RoutedConnection)replyHandler);
        }
    }

    private class PatchTableHandler
    implements MessageHandler {
        private PatchTableHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handlePatchTableMessage((PatchTableMessage)message, (RoutedConnection)replyHandler);
        }
    }

    private class ResetTableHandler
    implements MessageHandler {
        private ResetTableHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleResetTableMessage((ResetTableMessage)message, (RoutedConnection)replyHandler);
        }
    }

    private class QueryReplyHandler
    implements MessageHandler {
        private QueryReplyHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            QueryReply queryReply = (QueryReply)message;
            MessageRouterImpl.this.handleQueryReply(queryReply, replyHandler);
        }
    }

    private class QueryRequestHandler
    implements MessageHandler {
        private QueryRequestHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handleQueryRequestPossibleDuplicate((QueryRequest)message, (RoutedConnection)replyHandler);
        }
    }

    private class PingReplyHandler
    implements MessageHandler {
        private PingReplyHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handlePingReply((PingReply)message, replyHandler);
        }
    }

    private class PingRequestHandler
    implements MessageHandler {
        private PingRequestHandler() {
        }

        public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
            MessageRouterImpl.this.handlePingRequestPossibleDuplicate((PingRequest)message, replyHandler);
        }
    }

    private static class HopsFlowManager
    implements Runnable {
        private final UploadManager uploadManager;
        private final ConnectionManager connectionManager;
        private static final byte BUSY_HOPS_FLOW = 0;
        private static final byte FREE_HOPS_FLOW = 5;
        private static boolean _oldBusyState = false;

        public HopsFlowManager(UploadManager uploadManager, ConnectionManager connectionManager) {
            this.uploadManager = uploadManager;
            this.connectionManager = connectionManager;
        }

        public void run() {
            if (this.connectionManager.isSupernode()) {
                return;
            }
            boolean bl = !this.uploadManager.mayBeServiceable();
            List<RoutedConnection> list = this.connectionManager.getInitializedConnections();
            HopsFlowVendorMessage hopsFlowVendorMessage = new HopsFlowVendorMessage(bl ? (byte)0 : 5);
            if (bl == _oldBusyState) {
                for (int i = 0; i < list.size(); ++i) {
                    RoutedConnection routedConnection = list.get(i);
                    if (routedConnection == null || !((double)routedConnection.getConnectionTime() + 18750.0 > (double)System.currentTimeMillis()) || !routedConnection.getConnectionCapabilities().isClientSupernodeConnection()) continue;
                    routedConnection.send(hopsFlowVendorMessage);
                }
            } else {
                _oldBusyState = bl;
                for (int i = 0; i < list.size(); ++i) {
                    RoutedConnection routedConnection = list.get(i);
                    if (routedConnection == null || !routedConnection.getConnectionCapabilities().isClientSupernodeConnection()) continue;
                    routedConnection.send(hopsFlowVendorMessage);
                }
            }
        }
    }

    static class ConnectBackExpirer
    implements Runnable {
        ConnectBackExpirer() {
        }

        public void run() {
            _tcpConnectBacks.clear();
            _udpConnectBacks.clear();
        }
    }

    private class Expirer
    implements Runnable {
        private Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HashSet<GUID.TimedGUID> hashSet = new HashSet<GUID.TimedGUID>();
            Map map = MessageRouterImpl.this._outOfBandReplies;
            synchronized (map) {
                long l = System.currentTimeMillis();
                for (GUID.TimedGUID timedGUID : MessageRouterImpl.this._outOfBandReplies.keySet()) {
                    if (timedGUID == null || !timedGUID.shouldExpire(l)) continue;
                    hashSet.add(timedGUID);
                }
                for (GUID.TimedGUID timedGUID : hashSet) {
                    MessageRouterImpl.this._outOfBandReplies.remove(timedGUID);
                }
            }
        }
    }

    private class UDPReplyCleaner
    implements Runnable {
        private UDPReplyCleaner() {
        }

        public void run() {
            MessageRouterImpl.this.messageDispatcher.get().dispatch(new Runnable(){

                public void run() {
                    MessageRouterImpl.this.udpReplyHandlerCache.clear();
                }
            });
        }
    }

    private static class QueryResponseBundle {
        public final QueryRequest _query;
        public final Response[] _responses;

        public QueryResponseBundle(QueryRequest queryRequest, Response[] responseArray) {
            this._query = queryRequest;
            this._responses = responseArray;
        }
    }

    private class QRPPropagator
    extends ManagedThread {
        public QRPPropagator() {
            this.setName("QRPPropagator");
            this.setDaemon(true);
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(10000L);
                    MessageRouterImpl.this.forwardQueryRouteTables();
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
                return;
            }
        }
    }
}

