/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.limewire.collection.BitNumbers;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushEndpoint
implements HTTPHeaderValue,
IpPort {
    public static final int HEADER_SIZE = 17;
    public static final int PROXY_SIZE = 6;
    public static final byte PLAIN = 0;
    public static final byte PPTLS_BINARY = -128;
    static final byte SIZE_MASK = 7;
    static final byte FWT_VERSION_MASK = 24;
    static final byte FEATURES_MASK = -32;
    public static final String PPTLS_HTTP = "pptls";
    public static final int MAX_PROXIES = 4;
    private final byte[] _clientGUID;
    private GUID _guid;
    private final int _features;
    private final int _fwtVersion;
    private Set<? extends IpPort> _proxies;
    private final IpPort _externalAddr;
    private final PushEndpointCache pushEndpointCache;
    private final NetworkInstanceUtils networkInstanceUtils;

    public PushEndpoint(byte[] byArray, Set<? extends IpPort> set, byte by, int n, IpPort ipPort, PushEndpointCache pushEndpointCache, NetworkInstanceUtils networkInstanceUtils) {
        this.pushEndpointCache = pushEndpointCache;
        this.networkInstanceUtils = networkInstanceUtils;
        this._features = by & 0xFFFFFFE0 | n << 3;
        this._fwtVersion = n;
        this._clientGUID = byArray;
        this._guid = new GUID(this._clientGUID);
        this._proxies = set != null ? (set instanceof IpPortSet ? Collections.unmodifiableSet(set) : Collections.unmodifiableSet(new IpPortSet((Collection<? extends IpPort>)set))) : Collections.emptySet();
        this._externalAddr = ipPort;
    }

    public byte[] toBytes(boolean bl) {
        Set<? extends IpPort> set = this.getProxies();
        int n = PushEndpoint.getSizeBytes(set, bl);
        IpPort ipPort = this.getValidExternalAddress();
        int n2 = this.supportsFWTVersion();
        if (ipPort != null && n2 > 0) {
            n += 6;
        }
        byte[] byArray = new byte[n];
        this.toBytes(byArray, 0, set, ipPort, n2, bl);
        return byArray;
    }

    public void toBytes(byte[] byArray, int n, boolean bl) {
        this.toBytes(byArray, n, this.getProxies(), this.getValidExternalAddress(), this.supportsFWTVersion(), bl);
    }

    private void toBytes(byte[] byArray, int n, Set<? extends IpPort> set, IpPort ipPort, int n2, boolean bl) {
        int n3;
        int n4 = PushEndpoint.getSizeBytes(set, bl);
        if (ipPort != null) {
            if (n2 > 0) {
                n4 += 6;
            }
        } else {
            n2 = 0;
        }
        if (byArray.length - n < n4) {
            throw new IllegalArgumentException("target array too small");
        }
        int n5 = n;
        byArray[n] = (byte)(Math.min(4, set.size()) | this.getFeatures() | n2 << 3);
        System.arraycopy(this._clientGUID, 0, byArray, ++n, 16);
        n += 16;
        if (ipPort != null && n2 > 0) {
            byte[] byArray2 = ipPort.getInetAddress().getAddress();
            n3 = ipPort.getPort();
            System.arraycopy(byArray2, 0, byArray, n, 4);
            ByteOrder.short2leb((short)n3, byArray, n += 4);
            n += 2;
        }
        int n6 = n;
        n3 = 0;
        if (bl) {
            for (IpPort object2 : set) {
                if (n3 >= 4) break;
                if (object2 instanceof Connectable && ((Connectable)object2).isTLSCapable()) {
                    ++n;
                    break;
                }
                ++n3;
            }
        }
        n3 = 0;
        Object object3 = set.iterator();
        while (object3.hasNext()) {
            IpPort ipPort2 = object3.next();
            if (n3 >= 4) break;
            byte[] byArray2 = ipPort2.getInetAddress().getAddress();
            short s = (short)ipPort2.getPort();
            System.arraycopy(byArray2, 0, byArray, n, 4);
            ByteOrder.short2leb(s, byArray, n += 4);
            n += 2;
            ++n3;
        }
        Object object = object3 = bl ? HTTPHeaderUtils.getTLSIndices(set, Math.min(set.size(), 4)) : BitNumbers.EMPTY_BN;
        if (!((BitNumbers)object3).isEmpty()) {
            byte[] byArray3 = ((BitNumbers)object3).toByteArray();
            assert (byArray3.length == 1);
            byArray[n6] = byArray3[0];
            int n7 = n5;
            byArray[n7] = (byte)(byArray[n7] | 0xFFFFFF80);
        } else {
            int n8 = n5;
            byArray[n8] = (byte)(byArray[n8] & 0x7F);
        }
    }

    protected IpPort getValidExternalAddress() {
        IpPort ipPort = this.getIpPort();
        if (ipPort == null || !this.networkInstanceUtils.isValidExternalIpPort(ipPort)) {
            return null;
        }
        assert (!ipPort.getAddress().equals("1.1.1.1")) : "bogus ip address leaked, field is " + this._externalAddr + " cache contains " + this.pushEndpointCache.getCached(this._guid);
        return ipPort;
    }

    public byte[] getClientGUID() {
        return this._clientGUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<? extends IpPort> getProxies() {
        Object object = this;
        synchronized (object) {
            if (this._proxies != null) {
                return this._proxies;
            }
        }
        object = this.pushEndpointCache.getCached(this._guid);
        if (object == null) {
            return Collections.emptySet();
        }
        return object.getProxies();
    }

    public static int getSizeBytes(Set<? extends IpPort> set, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            int n = 0;
            for (IpPort ipPort : set) {
                if (n >= 4) break;
                if (ipPort instanceof ConnectableImpl && ((Connectable)ipPort).isTLSCapable()) {
                    bl2 = true;
                    break;
                }
                ++n;
            }
        }
        return 17 + (bl2 ? 1 : 0) + Math.min(set.size(), 4) * 6;
    }

    public int supportsFWTVersion() {
        PushEndpointCache.CachedPushEndpoint cachedPushEndpoint = this.pushEndpointCache.getCached(this._guid);
        int n = cachedPushEndpoint == null ? this._fwtVersion : cachedPushEndpoint.getFWTVersion();
        return n;
    }

    public int hashCode() {
        return this._guid.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof PushEndpoint)) {
            return false;
        }
        PushEndpoint pushEndpoint = (PushEndpoint)object;
        return this._guid.equals(pushEndpoint._guid);
    }

    public String toString() {
        String string = "PE [FEATURES:" + this.getFeatures() + ", FWT Version:" + this.supportsFWTVersion() + ", GUID:" + this._guid + ", address: " + this.getAddress() + ":" + this.getPort() + ", proxies:{ ";
        for (IpPort ipPort : this.getProxies()) {
            string = string + ipPort.getInetAddress() + ":" + ipPort.getPort() + " ";
        }
        string = string + "}]";
        return string;
    }

    @Override
    public String httpStringValue() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(this._guid.toHexString()).append(";");
        int n = this.supportsFWTVersion();
        if (n != 0) {
            stringBuilder.append("fwt").append("/").append(n).append(";");
            object = this.getValidExternalAddress();
            if (object != null) {
                String string = this.getAddress();
                int n2 = this.getPort();
                if (!string.equals("1.1.1.1") && NetworkUtils.isValidPort(n2)) {
                    stringBuilder.append(n2).append(":").append(string).append(";");
                }
            }
        }
        if (!(object = this.getProxies()).isEmpty()) {
            stringBuilder.append(HTTPHeaderUtils.encodePushProxies(object, ";", 4));
        } else {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public byte getFeatures() {
        PushEndpointCache.CachedPushEndpoint cachedPushEndpoint = this.pushEndpointCache.getCached(this._guid);
        int n = cachedPushEndpoint == null ? this._features : cachedPushEndpoint.getFeatures();
        return (byte)(n & 0xFFFFFFE0);
    }

    private IpPort getIpPort() {
        PushEndpointCache.CachedPushEndpoint cachedPushEndpoint = this.pushEndpointCache.getCached(this._guid);
        return cachedPushEndpoint == null || cachedPushEndpoint.getIpPort() == null ? this._externalAddr : cachedPushEndpoint.getIpPort();
    }

    @Override
    public String getAddress() {
        IpPort ipPort = this.getIpPort();
        return ipPort != null ? ipPort.getAddress() : "1.1.1.1";
    }

    @Override
    public InetAddress getInetAddress() {
        IpPort ipPort = this.getIpPort();
        return ipPort != null ? ipPort.getInetAddress() : null;
    }

    @Override
    public int getPort() {
        IpPort ipPort = this.getIpPort();
        return ipPort != null ? ipPort.getPort() : 6346;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        IpPort ipPort = this.getIpPort();
        return ipPort != null ? ipPort.getInetSocketAddress() : null;
    }

    public boolean isLocal() {
        return false;
    }

    public synchronized void updateProxies(boolean bl) {
        this._guid = this.pushEndpointCache.updateProxiesFor(this._guid, this, bl);
        this._proxies = null;
    }

    public PushEndpoint createClone() {
        return new PushEndpoint(this._guid.bytes(), this.getProxies(), this.getFeatures(), this.supportsFWTVersion(), this.getIpPort(), this.pushEndpointCache, this.networkInstanceUtils);
    }
}

