/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Singleton;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.limewire.collection.ForgetfulHashMap;
import org.limewire.collection.MultiIterable;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ResponseVerifierImpl
implements ResponseVerifier {
    private ForgetfulHashMap<GUID, RequestData> mapper = new ForgetfulHashMap(15);
    private static final String DELIMITERS = "+ ";
    private static final long Mandragore_SIZE = 8192L;

    @Override
    public synchronized void record(QueryRequest queryRequest) {
        this.record(queryRequest, null);
    }

    @Override
    public synchronized void record(QueryRequest queryRequest, MediaType mediaType) {
        byte[] byArray = queryRequest.getGUID();
        this.mapper.put(new GUID(byArray), new RequestData(queryRequest.getQuery(), queryRequest.getRichQuery(), mediaType, queryRequest.isWhatIsNewRequest()));
    }

    @Override
    public synchronized boolean matchesQuery(byte[] byArray, Response response) {
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData == null || requestData.queryWords == null) {
            return false;
        }
        if (requestData.whatIsNew) {
            return true;
        }
        int n = FilterSettings.MIN_MATCHING_WORDS.getValue();
        if (ResponseVerifierImpl.score(requestData.queryWords, response.getName()) > n) {
            return true;
        }
        LimeXMLDocument limeXMLDocument = response.getDocument();
        if (limeXMLDocument != null) {
            for (String string : new MultiIterable<String>((Iterable<String>)limeXMLDocument.getKeyWords(), (Iterable<String>)limeXMLDocument.getKeyWordsIndivisible())) {
                if (ResponseVerifierImpl.score(requestData.queryWords, string) <= n) continue;
                return true;
            }
        }
        return false;
    }

    public static int score(String string, LimeXMLDocument limeXMLDocument, RemoteFileDesc remoteFileDesc) {
        return ResponseVerifierImpl.score(ResponseVerifierImpl.getSearchTerms(string, limeXMLDocument), remoteFileDesc.getFileName());
    }

    public static int score(List<String> list, String string) {
        int n = 0;
        int n2 = list.size();
        if (n2 == 0) {
            return 100;
        }
        for (int i = 0; i < n2; ++i) {
            String string2 = list.get(i);
            if (!StringUtils.contains(string, string2, true)) continue;
            ++n;
        }
        return (int)(100.0f * ((float)n / (float)n2));
    }

    @Override
    public boolean matchesType(byte[] byArray, Response response) {
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData == null || requestData.type == null) {
            return true;
        }
        String string = response.getName();
        return requestData.type.matches(string);
    }

    @Override
    public boolean isMandragoreWorm(byte[] byArray, Response response) {
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData == null) {
            return false;
        }
        return response.getSize() == 8192L && response.getName().equals(requestData.query + ".exe");
    }

    public String toString() {
        return this.mapper.toString();
    }

    private static List<String> getSearchTerms(String string, LimeXMLDocument limeXMLDocument) {
        String[] stringArray = null;
        HashSet<String> hashSet = new HashSet<String>();
        stringArray = StringUtils.split(string.toLowerCase(), DELIMITERS);
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        List<String> list = null;
        if (limeXMLDocument != null) {
            list = limeXMLDocument.getKeyWords();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String string2 = list.remove(0);
                hashSet.add(string2.toLowerCase());
            }
        }
        return Collections.unmodifiableList(new ArrayList(hashSet));
    }

    private static class RequestData {
        final String query;
        final LimeXMLDocument richQuery;
        final List<String> queryWords;
        final MediaType type;
        final boolean whatIsNew;

        RequestData(String string, MediaType mediaType) {
            this(string, null, mediaType, false);
        }

        RequestData(String string, LimeXMLDocument limeXMLDocument, MediaType mediaType, boolean bl) {
            this.query = string;
            this.richQuery = limeXMLDocument;
            this.queryWords = ResponseVerifierImpl.getSearchTerms(string, limeXMLDocument);
            this.type = mediaType;
            this.whatIsNew = bl;
        }

        public boolean xmlQuery() {
            return this.richQuery != null;
        }
    }
}

