/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.UDPService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SelfEndpoint
extends PushEndpoint {
    private final NetworkManager networkManager;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<UDPService> udpService;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    SelfEndpoint(NetworkManager networkManager, ApplicationServices applicationServices, Provider<ConnectionManager> provider, Provider<UDPService> provider2, NetworkInstanceUtils networkInstanceUtils) {
        super(applicationServices.getMyGUID(), IpPort.EMPTY_SET, (byte)0, 1, null, null, networkInstanceUtils);
        this.networkManager = networkManager;
        this.connectionManager = provider;
        this.udpService = provider2;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public Set<? extends IpPort> getProxies() {
        return this.connectionManager.get().getPushProxies();
    }

    @Override
    public byte getFeatures() {
        return 0;
    }

    @Override
    public int supportsFWTVersion() {
        return this.networkManager.supportsFWTVersion();
    }

    @Override
    public String getAddress() {
        byte[] byArray = this.networkManager.getExternalAddress();
        if (NetworkUtils.isValidAddress(byArray) && !this.networkInstanceUtils.isPrivateAddress(byArray)) {
            return NetworkUtils.ip2string(byArray);
        }
        return "1.1.1.1";
    }

    @Override
    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Override
    public int getPort() {
        if (this.networkManager.canDoFWT() && !this.networkManager.acceptedIncomingConnection()) {
            return this.udpService.get().getStableUDPPort();
        }
        return this.networkManager.getPort();
    }

    @Override
    protected IpPort getValidExternalAddress() {
        try {
            String string = this.getAddress();
            int n = this.getPort();
            if (string.equals("1.1.1.1") || !NetworkUtils.isValidPort(n)) {
                return null;
            }
            return new IpPortImpl(string, this.getPort());
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Override
    public boolean isLocal() {
        return true;
    }
}

