/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.SpamServices;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.SpamFilterFactory;
import com.limegroup.gnutella.settings.FilterSettings;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import org.limewire.collection.Comparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SpamServicesImpl
implements SpamServices {
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<IPFilter> ipFilter;
    private final SpamFilterFactory spamFilterFactory;
    private final UDPReplyHandlerCache udpReplyHandlerCache;

    @Inject
    public SpamServicesImpl(Provider<ConnectionManager> provider, Provider<IPFilter> provider2, SpamFilterFactory spamFilterFactory, UDPReplyHandlerCache uDPReplyHandlerCache) {
        this.connectionManager = provider;
        this.ipFilter = provider2;
        this.spamFilterFactory = spamFilterFactory;
        this.udpReplyHandlerCache = uDPReplyHandlerCache;
    }

    @Override
    public void adjustSpamFilters() {
        this.udpReplyHandlerCache.setPersonalFilter(this.spamFilterFactory.createPersonalFilter());
        for (RoutedConnection routedConnection : this.connectionManager.get().getConnections()) {
            if (this.ipFilter.get().allow(routedConnection.getAddress())) {
                routedConnection.setPersonalFilter(this.spamFilterFactory.createPersonalFilter());
                routedConnection.setRouteFilter(this.spamFilterFactory.createRouteFilter());
                continue;
            }
            routedConnection.close();
        }
    }

    @Override
    public void reloadIPFilter() {
        this.ipFilter.get().refreshHosts(new IPFilter.IPFilterCallback(){

            public void ipFiltersLoaded() {
                SpamServicesImpl.this.adjustSpamFilters();
            }
        });
    }

    @Override
    public boolean isAllowed(InetAddress inetAddress) {
        return this.ipFilter.get().allow(inetAddress.getAddress());
    }

    @Override
    public void blockHost(String string) {
        String[] stringArray = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        Arrays.sort(stringArray, Comparators.stringComparator());
        if (Arrays.binarySearch(stringArray, string, Comparators.stringComparator()) < 0) {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string;
            FilterSettings.BLACK_LISTED_IP_ADDRESSES.setValue(stringArray2);
            this.reloadIPFilter();
        }
    }

    @Override
    public void unblockHost(String string) {
        String[] stringArray = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        List<String> list = Arrays.asList(stringArray);
        if (list.remove(string)) {
            FilterSettings.BLACK_LISTED_IP_ADDRESSES.setValue(list.toArray(new String[0]));
            this.reloadIPFilter();
        }
    }
}

