/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.DataUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.limewire.io.NetworkUtils;

public final class UDPReplyHandler
implements ReplyHandler {
    private final InetSocketAddress addr;
    private final SpamFilter personalFilter;
    private final UDPService udpService;

    UDPReplyHandler(InetSocketAddress inetSocketAddress, SpamFilter spamFilter, UDPService uDPService) {
        this.udpService = uDPService;
        if (!NetworkUtils.isValidSocketAddress(inetSocketAddress)) {
            throw new IllegalArgumentException("invalid addr: " + inetSocketAddress);
        }
        this.addr = inetSocketAddress;
        this.personalFilter = spamFilter;
    }

    UDPReplyHandler(InetAddress inetAddress, int n, SpamFilter spamFilter, UDPService uDPService) {
        this(new InetSocketAddress(inetAddress, n), spamFilter, uDPService);
    }

    public void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        this.udpService.send((Message)pingReply, this.addr);
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        this.udpService.send((Message)queryReply, this.addr);
    }

    public void handlePushRequest(PushRequest pushRequest, ReplyHandler replyHandler) {
        this.udpService.send((Message)pushRequest, this.addr);
    }

    public void countDroppedMessage() {
    }

    public boolean isPersonalSpam(Message message) {
        return !this.personalFilter.allow(message);
    }

    public boolean isOpen() {
        return true;
    }

    public int getNumMessagesReceived() {
        return 0;
    }

    public boolean isOutgoing() {
        return false;
    }

    public boolean isKillable() {
        return false;
    }

    public boolean isSupernodeClientConnection() {
        return false;
    }

    public boolean isLeafConnection() {
        return false;
    }

    public boolean isHighDegreeConnection() {
        return false;
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return false;
    }

    public boolean isGoodUltrapeer() {
        return false;
    }

    public boolean isGoodLeaf() {
        return false;
    }

    public boolean supportsPongCaching() {
        return false;
    }

    public boolean allowNewPings() {
        return true;
    }

    public void handleSimppVM(SimppVM simppVM) {
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.addr;
    }

    public InetAddress getInetAddress() {
        return this.addr.getAddress();
    }

    public String getAddress() {
        return this.addr.getAddress().getHostAddress();
    }

    public boolean isStable() {
        return false;
    }

    public String getLocalePref() {
        return ApplicationSettings.DEFAULT_LOCALE.getValue();
    }

    public String toString() {
        return this.addr.toString();
    }

    public void handleUDPCrawlerPong(UDPCrawlerPong uDPCrawlerPong) {
        this.udpService.send((Message)uDPCrawlerPong, this.addr);
    }

    public void reply(Message message) {
        this.udpService.send(message, this.addr);
    }

    public int getPort() {
        return this.addr.getPort();
    }

    public byte[] getClientGUID() {
        return DataUtils.EMPTY_GUID;
    }
}

