/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.UPnPListener;
import com.limegroup.gnutella.UPnPManagerConfiguration;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.device.DeviceChangeListener;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.NetworkUtils;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.lifecycle.ServiceStage;
import org.limewire.service.ErrorService;

@Singleton
public class UPnPManager
implements Service {
    private static final Log LOG = LogFactory.getLog(UPnPManager.class);
    private static final String ROUTER_DEVICE = "urn:schemas-upnp-org:device:InternetGatewayDevice:1";
    private static final String WAN_DEVICE = "urn:schemas-upnp-org:device:WANDevice:1";
    private static final String WANCON_DEVICE = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private static final String SERVICE_TYPE = "urn:schemas-upnp-org:service:WANIPConnection:1";
    private static final String TCP_PREFIX = "LimeTCP";
    private static final String UDP_PREFIX = "LimeUDP";
    private String _guidSuffix;
    private volatile Device _router;
    private volatile org.cybergarage.upnp.Service _service;
    private volatile Mapping _tcp;
    private volatile Mapping _udp;
    private final Object DEVICE_LOCK = new Object();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ControlPoint controlPoint;
    private final CopyOnWriteArrayList<UPnPListener> listeners = new CopyOnWriteArrayList();
    private final UPnPManagerConfiguration configuration;
    @InspectablePrimitive(value="upnp manager creation time")
    private final long creationTime = System.currentTimeMillis();
    @InspectablePrimitive(value="upnp manager start time")
    private volatile long startTime;
    @InspectablePrimitive(value="upnp manager device found time")
    private volatile long deviceFoundTime;
    @InspectionPoint(value="upnp stats")
    private final Inspectable UPnPStats = new Inspectable(){

        public Object inspect() {
            if (!UPnPManager.this.isNATPresent()) {
                return "N/A";
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", UPnPManager.this._router.getFriendlyName());
            if (UPnPManager.this.mappingsExist()) {
                hashMap.put("mappings", true);
            }
            return hashMap;
        }
    };

    @Inject
    UPnPManager(UPnPManagerConfiguration uPnPManagerConfiguration) {
        this.configuration = uPnPManagerConfiguration;
        this.controlPoint = new ControlPoint();
    }

    public void addListener(UPnPListener uPnPListener) {
        this.listeners.add(uPnPListener);
    }

    private void notifyListeners() {
        for (UPnPListener uPnPListener : this.listeners) {
            uPnPListener.natFound();
        }
    }

    @Inject
    void register(ServiceRegistry serviceRegistry) {
        serviceRegistry.register(this).in(ServiceStage.VERY_LATE);
    }

    public void initialize() {
    }

    public String getServiceName() {
        return "UPnPManager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!ConnectionSettings.DISABLE_UPNP.getValue() && !this.started.getAndSet(true)) {
            this.startTime = System.currentTimeMillis();
            LOG.debug("Starting UPnP Manager.");
            this.controlPoint.addDeviceChangeListener(new DeviceListener());
            Object object = this.DEVICE_LOCK;
            synchronized (object) {
                try {
                    this.controlPoint.start();
                }
                catch (Exception exception) {
                    this.configuration.setEnabled(false);
                    ErrorService.error(exception);
                }
            }
        }
    }

    public void stop() {
        this.controlPoint.stop();
    }

    public boolean isNATPresent() {
        return this._router != null && this._service != null;
    }

    public boolean mappingsExist() {
        return this._tcp != null || this._udp != null;
    }

    public InetAddress getNATAddress() throws UnknownHostException {
        if (!this.isNATPresent()) {
            return null;
        }
        Action action = this.getActionFromService(this._service, "GetExternalIPAddress");
        if (action == null) {
            LOG.debug("Couldn't find GetExternalIPAddress action!");
            return null;
        }
        if (!action.postControlAction()) {
            LOG.debug("couldn't get our external address");
            return null;
        }
        Argument argument = action.getOutputArgumentList().getArgument("NewExternalIPAddress");
        return InetAddress.getByName(argument.getValue());
    }

    private void discoverService() {
        for (Device device : this._router.getDeviceList()) {
            if (!device.getDeviceType().equals(WAN_DEVICE)) continue;
            DeviceList deviceList = device.getDeviceList();
            if (LOG.isDebugEnabled()) {
                LOG.debug("found " + device.getDeviceType() + ", size: " + deviceList.size() + ", on: " + device.getFriendlyName());
            }
            for (int i = 0; i < device.getDeviceList().size(); ++i) {
                Device device2 = deviceList.getDevice(i);
                if (!device2.getDeviceType().equals(WANCON_DEVICE)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("found " + device2.getDeviceType() + ", on: " + device2.getFriendlyName());
                }
                this._service = device2.getService(SERVICE_TYPE);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mapPort(int n, byte[] byArray) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Attempting to map port: " + n);
        }
        Random random = null;
        String string = NetworkUtils.ip2string(byArray);
        int n2 = n;
        Mapping mapping = new Mapping("", n, string, n2, "UDP", UDP_PREFIX + this.getGUIDSuffix());
        int n3 = 20;
        while (!this.addMapping(mapping) && n3 >= 0) {
            --n3;
            if (random == null) {
                random = new Random();
            }
            n = random.nextInt(50000) + 2000;
            mapping = new Mapping("", n, string, n2, "UDP", UDP_PREFIX + this.getGUIDSuffix());
        }
        if (n3 < 0) {
            LOG.debug("couldn't map a port :(");
            return 0;
        }
        Mapping mapping2 = new Mapping("", n, string, n2, "TCP", TCP_PREFIX + this.getGUIDSuffix());
        if (!this.addMapping(mapping2)) {
            LOG.debug(" couldn't map tcp to whatever udp was mapped. leaving udp around...");
            mapping2 = null;
        }
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            this._tcp = mapping2;
            this._udp = mapping;
        }
        ThreadExecutor.startThread(new StaleCleaner(), "Stale Mapping Cleaner");
        return n;
    }

    private Action getActionFromService(org.cybergarage.upnp.Service service, String string) {
        Action action = service.getAction(string);
        if (action != null) {
            return action;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Couldn't find action: " + string + ", from direct lookup");
        }
        for (Object e : this._service.getActionList()) {
            if (!(e instanceof Action) || (action = (Action)e).getName() == null || !string.equals(action.getName().trim())) continue;
            return action;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Couldn't find action: " + string + " after iterating");
        }
        return null;
    }

    private boolean addMapping(Mapping mapping) {
        Action action;
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding " + mapping);
        }
        if ((action = this.getActionFromService(this._service, "AddPortMapping")) == null) {
            return false;
        }
        action.setArgumentValue("NewRemoteHost", mapping._externalAddress);
        action.setArgumentValue("NewExternalPort", mapping._externalPort);
        action.setArgumentValue("NewInternalClient", mapping._internalAddress);
        action.setArgumentValue("NewInternalPort", mapping._internalPort);
        action.setArgumentValue("NewProtocol", mapping._protocol);
        action.setArgumentValue("NewPortMappingDescription", mapping._description);
        action.setArgumentValue("NewEnabled", "1");
        action.setArgumentValue("NewLeaseDuration", 0);
        boolean bl = action.postControlAction();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Post succeeded: " + bl);
        }
        return bl;
    }

    private boolean removeMapping(Mapping mapping) {
        Action action;
        if (LOG.isDebugEnabled()) {
            LOG.debug("removing " + mapping);
        }
        if ((action = this.getActionFromService(this._service, "DeletePortMapping")) == null) {
            LOG.debug("Couldn't find DeletePortMapping action!");
            return false;
        }
        action.setArgumentValue("NewRemoteHost", mapping._externalAddress);
        action.setArgumentValue("NewExternalPort", mapping._externalPort);
        action.setArgumentValue("NewProtocol", mapping._protocol);
        boolean bl = action.postControlAction();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Remove succeeded: " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMappings() {
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            LOG.debug("start cleaning");
            if (this._tcp != null) {
                this.removeMapping(this._tcp);
            }
            if (this._udp != null) {
                this.removeMapping(this._udp);
            }
            LOG.debug("done cleaning");
        }
    }

    public void finalize() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGUIDSuffix() {
        Object object = this.DEVICE_LOCK;
        synchronized (object) {
            if (this._guidSuffix == null) {
                this._guidSuffix = this.configuration.getClientID();
            }
            return this._guidSuffix;
        }
    }

    private class StaleCleaner
    implements Runnable {
        private StaleCleaner() {
        }

        private String list(List list) {
            String string = "";
            for (Argument argument : list) {
                string = string + argument.getName() + "->" + argument.getValue() + ", ";
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.debug("Looking for stale mappings...");
            HashSet<Mapping> hashSet = new HashSet<Mapping>();
            Action action = UPnPManager.this.getActionFromService(UPnPManager.this._service, "GetGenericPortMappingEntry");
            if (action == null) {
                LOG.debug("Couldn't find GetGenericPortMappingEntry action!");
                return;
            }
            try {
                int n = 0;
                while (true) {
                    action.setArgumentValue("NewPortMappingIndex", n);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Stale Iteration: " + n + ", generic.input: " + this.list(action.getInputArgumentList()) + ", generic.output: " + this.list(action.getOutputArgumentList()));
                    }
                    if (action.postControlAction()) {
                        hashSet.add(new Mapping(action.getArgumentValue("NewRemoteHost"), action.getArgumentValue("NewExternalPort"), action.getArgumentValue("NewInternalClient"), action.getArgumentValue("NewInternalPort"), action.getArgumentValue("NewProtocol"), action.getArgumentValue("NewPortMappingDescription")));
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("NFE reading mappings!", numberFormatException);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stale cleaner found " + hashSet.size() + " total mappings");
            }
            for (Mapping mapping : hashSet) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Analyzing: " + mapping);
                }
                if (mapping._description == null || mapping._internalAddress == null || !mapping._description.equals(UPnPManager.TCP_PREFIX + UPnPManager.this.getGUIDSuffix()) && !mapping._description.equals(UPnPManager.UDP_PREFIX + UPnPManager.this.getGUIDSuffix())) continue;
                Object object = UPnPManager.this.DEVICE_LOCK;
                synchronized (object) {
                    if (UPnPManager.this._udp != null && mapping._externalPort == ((UPnPManager)UPnPManager.this)._udp._externalPort && mapping._internalAddress.equals(((UPnPManager)UPnPManager.this)._udp._internalAddress) && mapping._internalPort == ((UPnPManager)UPnPManager.this)._udp._internalPort) {
                        continue;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("mapping " + mapping + " appears to be stale");
                }
                UPnPManager.this.removeMapping(mapping);
            }
        }
    }

    private static final class Mapping {
        public final String _externalAddress;
        public final int _externalPort;
        public final String _internalAddress;
        public final int _internalPort;
        public final String _protocol;
        public final String _description;

        public Mapping(String string, String string2, String string3, String string4, String string5, String string6) throws NumberFormatException {
            this._externalAddress = string;
            this._externalPort = Integer.parseInt(string2);
            this._internalAddress = string3;
            this._internalPort = Integer.parseInt(string4);
            this._protocol = string5;
            this._description = string6;
        }

        public Mapping(String string, int n, String string2, int n2, String string3, String string4) {
            if (!NetworkUtils.isValidPort(n) || !NetworkUtils.isValidPort(n2)) {
                throw new IllegalArgumentException();
            }
            this._externalAddress = string;
            this._externalPort = n;
            this._internalAddress = string2;
            this._internalPort = n2;
            this._protocol = string3;
            this._description = string4;
        }

        public String toString() {
            return this._externalAddress + ":" + this._externalPort + "->" + this._internalAddress + ":" + this._internalPort + "@" + this._protocol + " desc: " + this._description;
        }
    }

    private class DeviceListener
    implements DeviceChangeListener {
        private DeviceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deviceAdded(Device device) {
            if (UPnPManager.this.isNATPresent()) {
                return;
            }
            UPnPManager.this.deviceFoundTime = System.currentTimeMillis();
            Object object = UPnPManager.this.DEVICE_LOCK;
            synchronized (object) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Device added: " + device.getFriendlyName());
                }
                if (device.getDeviceType().equals(UPnPManager.ROUTER_DEVICE) && device.isRootDevice()) {
                    UPnPManager.this._router = device;
                }
                if (UPnPManager.this._router != null) {
                    UPnPManager.this.discoverService();
                    if (UPnPManager.this._service == null) {
                        LOG.debug("couldn't find service");
                        UPnPManager.this._router = null;
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Found service, router: " + UPnPManager.this._router.getFriendlyName() + ", service: " + UPnPManager.this._service);
                        }
                        UPnPManager.this.stop();
                    }
                } else {
                    LOG.debug("didn't get router device");
                }
            }
            if (UPnPManager.this.isNATPresent()) {
                UPnPManager.this.notifyListeners();
            }
        }

        public void deviceRemoved(Device device) {
        }
    }
}

