/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Singleton;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.UrnSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.io.IOUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.ConverterObjectInputStream;
import org.limewire.util.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class UrnCache {
    private static final Log LOG = LogFactory.getLog(UrnCache.class);
    private static final File URN_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.cache");
    private static final File URN_CACHE_BACKUP_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.bak");
    private final ExecutorService QUEUE = ExecutorsHelper.newProcessingQueue("Hasher");
    private Map<File, List<UrnCallback>> pendingHashing = new HashMap<File, List<UrnCallback>>();
    private volatile boolean dirty = false;
    private final Future<Map<UrnSetKey, Set<URN>>> deserializer = this.QUEUE.submit(new Callable<Map<UrnSetKey, Set<URN>>>(){

        @Override
        public Map<UrnSetKey, Set<URN>> call() {
            Map map = UrnCache.createMap();
            UrnCache.this.dirty = UrnCache.scanAndRemoveOldEntries(map);
            return map;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateAndCacheUrns(File file, UrnCallback urnCallback) {
        Set<URN> set;
        UrnCache urnCache = this;
        synchronized (urnCache) {
            set = this.getUrns(file);
            if (set.isEmpty()) {
                List<UrnCallback> list;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding: " + file + " to be hashed.");
                }
                if ((list = this.pendingHashing.get(file)) == null) {
                    list = new ArrayList<UrnCallback>(1);
                    this.pendingHashing.put(file, list);
                }
                list.add(urnCallback);
                this.QUEUE.execute(new Processor(file));
            }
        }
        if (!set.isEmpty()) {
            urnCallback.urnsCalculated(file, set);
        }
    }

    public synchronized void clearPendingHashes(Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing all pending hashes owned by: " + object);
        }
        Iterator<List<UrnCallback>> iterator = this.pendingHashing.values().iterator();
        while (iterator.hasNext()) {
            List<UrnCallback> list = iterator.next();
            for (int i = list.size() - 1; i >= 0; --i) {
                UrnCallback urnCallback = list.get(i);
                if (!urnCallback.isOwner(object)) continue;
                list.remove(i);
            }
            if (!list.isEmpty()) continue;
            iterator.remove();
        }
    }

    public synchronized void clearPendingHashesFor(File file, Object object) {
        List<UrnCallback> list;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing all pending hashes for: " + file + ", owned by: " + object);
        }
        if ((list = this.pendingHashing.get(file)) != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                UrnCallback urnCallback = list.get(i);
                if (!urnCallback.isOwner(object)) continue;
                list.remove(i);
            }
            if (list.isEmpty()) {
                this.pendingHashing.remove(file);
            }
        }
    }

    public Set<URN> calculateUrns(File file) throws IOException, InterruptedException {
        return URN.createSHA1AndTTRootUrns(file);
    }

    public synchronized Set<URN> getUrns(File file) {
        if (file.lastModified() == 0L) {
            return Collections.emptySet();
        }
        UrnSetKey urnSetKey = new UrnSetKey(file);
        Set<URN> set = this.getUrnMap().get(urnSetKey);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public synchronized void removeUrns(File file) {
        UrnSetKey urnSetKey = new UrnSetKey(file);
        this.getUrnMap().remove(urnSetKey);
        this.dirty = true;
    }

    public synchronized void addUrns(File file, Set<? extends URN> set) {
        UrnSetKey urnSetKey = new UrnSetKey(file);
        this.getUrnMap().put(urnSetKey, Collections.unmodifiableSet(set));
        this.dirty = true;
    }

    private static Map createMap() {
        HashMap hashMap = UrnCache.readMap(URN_CACHE_FILE);
        if (hashMap == null) {
            hashMap = UrnCache.readMap(URN_CACHE_BACKUP_FILE);
        }
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map readMap(File file) {
        Map map;
        if (!file.exists()) {
            return null;
        }
        ConverterObjectInputStream converterObjectInputStream = null;
        try {
            converterObjectInputStream = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            map = (Map)converterObjectInputStream.readObject();
        }
        catch (Throwable throwable) {
            Map map2;
            try {
                LOG.error("Unable to read UrnCache", throwable);
                map2 = null;
            }
            catch (Throwable throwable2) {
                IOUtils.close(converterObjectInputStream);
                throw throwable2;
            }
            IOUtils.close(converterObjectInputStream);
            return map2;
        }
        IOUtils.close(converterObjectInputStream);
        return map;
    }

    private static boolean scanAndRemoveOldEntries(Map<Object, Object> map) {
        boolean bl = false;
        Iterator<Map.Entry<Object, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (!(entry.getKey() instanceof UrnSetKey)) {
                iterator.remove();
                bl = true;
                continue;
            }
            UrnSetKey urnSetKey = (UrnSetKey)entry.getKey();
            File file = new File(urnSetKey._path);
            if (!file.exists() || file.lastModified() != urnSetKey._modTime) {
                bl = true;
                iterator.remove();
                continue;
            }
            if (!(entry.getValue() instanceof Set)) {
                iterator.remove();
                bl = true;
                continue;
            }
            Set<URN> set = GenericsUtils.scanForSet(entry.getValue(), URN.class, GenericsUtils.ScanMode.NEW_COPY_REMOVED, UrnSet.class);
            if (set.isEmpty()) {
                iterator.remove();
                bl = true;
                continue;
            }
            if (set == entry.getValue()) continue;
            bl = true;
            entry.setValue(Collections.unmodifiableSet(set));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistCache() {
        this.getUrnMap();
        if (!this.dirty) {
            return;
        }
        URN_CACHE_FILE.renameTo(URN_CACHE_BACKUP_FILE);
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(URN_CACHE_FILE)));
            objectOutputStream.writeObject(this.getUrnMap());
            objectOutputStream.flush();
            IOUtils.close(objectOutputStream);
        }
        catch (IOException iOException) {
            LOG.error("Unable to persist cache", iOException);
        }
        finally {
            IOUtils.close(objectOutputStream);
        }
        this.dirty = false;
    }

    private Map<UrnSetKey, Set<URN>> getUrnMap() {
        boolean bl = Thread.interrupted();
        while (true) {
            try {
                Map<UrnSetKey, Set<URN>> map = this.deserializer.get();
                return map;
            }
            catch (InterruptedException interruptedException) {
                try {
                    bl = true;
                    continue;
                }
                catch (ExecutionException executionException) {
                    throw new RuntimeException(executionException);
                }
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class UrnSetKey
    implements Serializable {
        static final long serialVersionUID = -7183232365833531645L;
        transient long _modTime;
        transient String _path;
        transient int _hashCode;

        UrnSetKey(File file) {
            this._modTime = file.lastModified();
            this._path = file.getAbsolutePath();
            this._hashCode = this.calculateHashCode();
        }

        int calculateHashCode() {
            int n = 17;
            n = n * 37 + (int)(this._modTime ^ this._modTime >>> 32);
            n = n * 37 + this._path.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof UrnSetKey)) {
                return false;
            }
            UrnSetKey urnSetKey = (UrnSetKey)object;
            return this._modTime == urnSetKey._modTime && this._path.equals(urnSetKey._path);
        }

        public int hashCode() {
            return this._hashCode;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeLong(this._modTime);
            objectOutputStream.writeObject(this._path);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this._modTime = objectInputStream.readLong();
            this._path = (String)objectInputStream.readObject();
            this._hashCode = this.calculateHashCode();
        }
    }

    private class Processor
    implements Runnable {
        private final File file;

        Processor(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Set<URN> set;
            List list;
            UrnCache urnCache = UrnCache.this;
            synchronized (urnCache) {
                list = (List)UrnCache.this.pendingHashing.remove(this.file);
                set = UrnCache.this.getUrns(this.file);
            }
            if (list != null && !list.isEmpty()) {
                if (set.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Hashing file: " + this.file);
                    }
                    try {
                        set = UrnCache.this.calculateUrns(this.file);
                        UrnCache.this.addUrns(this.file, set);
                    }
                    catch (IOException iOException) {
                        LOG.warn("Unable to calculate URNs", iOException);
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.warn("Unable to calculate URNs", interruptedException);
                    }
                }
                for (int i = 0; i < list.size(); ++i) {
                    ((UrnCallback)list.get(i)).urnsCalculated(this.file, set);
                }
            }
        }
    }
}

