/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.util.DataUtils;
import java.io.IOException;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortForSelf;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.service.ErrorService;

public class DirectAltLoc
extends AlternateLocation {
    public static final String TLS_IDX = "tls=";
    private final IpPort _node;
    protected volatile boolean _demoted = false;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final IpPortForSelf ipPortForSelf;

    protected DirectAltLoc(IpPort ipPort, URN uRN, NetworkInstanceUtils networkInstanceUtils, IpPortForSelf ipPortForSelf) throws IOException {
        super(uRN);
        this.networkInstanceUtils = networkInstanceUtils;
        this.ipPortForSelf = ipPortForSelf;
        if (!networkInstanceUtils.isValidExternalIpPort(ipPort)) {
            throw new IOException("not a valid external address:port in direct altloc " + ipPort);
        }
        this._node = ipPort;
        if (this._node == ipPortForSelf) {
            this.hashCode = ipPortForSelf.hashCode();
        }
    }

    protected String generateHTTPString() {
        String string = this._node.getInetAddress().getHostAddress();
        if (this._node.getPort() != 6346) {
            string = string + ":" + this._node.getPort();
        }
        return string;
    }

    public RemoteFileDesc createRemoteFileDesc(long l, RemoteFileDescFactory remoteFileDescFactory) {
        UrnSet urnSet = new UrnSet(this.getSHA1Urn());
        int n = 3;
        RemoteFileDesc remoteFileDesc = remoteFileDescFactory.createRemoteFileDesc(this._node.getAddress(), this._node.getPort(), 0L, "/uri-res/N2R?" + this.SHA1_URN, l, DataUtils.EMPTY_GUID, 1000, true, n, false, null, urnSet, false, false, "ALT", null, -1L, this._node instanceof Connectable ? ((Connectable)this._node).isTLSCapable() : false);
        return remoteFileDesc;
    }

    public synchronized AlternateLocation createClone() {
        DirectAltLoc directAltLoc = null;
        try {
            directAltLoc = new DirectAltLoc(this._node, this.SHA1_URN, this.networkInstanceUtils, this.ipPortForSelf);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return null;
        }
        directAltLoc._demoted = this._demoted;
        directAltLoc._count = this._count;
        return directAltLoc;
    }

    public boolean isMe() {
        return this.networkInstanceUtils.isMe(this._node);
    }

    public IpPort getHost() {
        return this._node;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DirectAltLoc)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DirectAltLoc directAltLoc = (DirectAltLoc)object;
        if (this._node == directAltLoc._node) {
            return true;
        }
        return this._node.getInetAddress().equals(directAltLoc._node.getInetAddress()) && this._node.getPort() == directAltLoc._node.getPort();
    }

    synchronized void demote() {
        this._demoted = true;
    }

    synchronized void promote() {
        this._demoted = false;
    }

    public synchronized boolean isDemoted() {
        return this._demoted;
    }

    public int compareTo(AlternateLocation alternateLocation) {
        if (this == alternateLocation) {
            return 0;
        }
        int n = super.compareTo(alternateLocation);
        if (!(alternateLocation instanceof DirectAltLoc)) {
            if (n != 0) {
                return n;
            }
            return -1;
        }
        DirectAltLoc directAltLoc = (DirectAltLoc)alternateLocation;
        if (this._demoted != directAltLoc._demoted) {
            if (this._demoted) {
                return 1;
            }
            return -1;
        }
        if (n != 0) {
            return n;
        }
        if (this._node == directAltLoc._node) {
            return 0;
        }
        n = this._node.getAddress().compareTo(directAltLoc._node.getAddress());
        if (n != 0) {
            return n;
        }
        n = this._node.getPort() - directAltLoc._node.getPort();
        return n;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = super.hashCode();
            n = 37 * n + this._node.getAddress().hashCode();
            this.hashCode = n = 37 * n + this._node.getPort();
        }
        return this.hashCode;
    }

    public String toString() {
        return this._node + "," + this._count + "," + this._demoted;
    }
}

