/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.auth.ContentResponseData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.CommonUtils;
import org.limewire.util.GenericsUtils;

class ContentCache {
    private static final Log LOG = LogFactory.getLog(ContentCache.class);
    private static final long EXPIRY_TIME = 604800000L;
    private final File CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "responses.cache");
    private Map<URN, ContentResponseData> responses = new HashMap<URN, ContentResponseData>();
    private boolean dirty = false;

    ContentCache() {
    }

    synchronized int getSize() {
        return this.responses.size();
    }

    synchronized boolean hasResponseFor(URN uRN) {
        return this.responses.containsKey(uRN);
    }

    synchronized void addResponse(URN uRN, ContentResponseData contentResponseData) {
        this.responses.put(uRN, contentResponseData);
        this.dirty = true;
    }

    synchronized ContentResponseData getResponse(URN uRN) {
        return this.responses.get(uRN);
    }

    synchronized void initialize() {
        this.dirty = false;
        this.deserialize();
    }

    synchronized void writeToDisk() {
        if (this.dirty) {
            this.persistCache();
        }
        this.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deserialize() {
        long l = System.currentTimeMillis() - 604800000L;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.CACHE_FILE)));
            Map map = (Map)objectInputStream.readObject();
            Map<URN, ContentResponseData> map2 = GenericsUtils.scanForMap(map, URN.class, ContentResponseData.class, GenericsUtils.ScanMode.REMOVE);
            if (map2.size() != map.size()) {
                this.dirty = true;
            }
            Iterator<ContentResponseData> iterator = map2.values().iterator();
            while (iterator.hasNext()) {
                ContentResponseData contentResponseData = iterator.next();
                if (contentResponseData.getCreationTime() >= l) continue;
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Removing old response [" + contentResponseData + "]");
                }
                iterator.remove();
                this.dirty = true;
            }
            this.responses = map2;
        }
        catch (Throwable throwable) {
            try {
                this.dirty = true;
                LOG.error("Can't read responses", throwable);
            }
            catch (Throwable throwable2) {
                IOUtils.close(objectInputStream);
                if (this.responses == null) {
                    this.responses = new HashMap<URN, ContentResponseData>();
                }
                throw throwable2;
            }
            IOUtils.close(objectInputStream);
            if (this.responses == null) {
                this.responses = new HashMap<URN, ContentResponseData>();
            }
        }
        IOUtils.close(objectInputStream);
        if (this.responses == null) {
            this.responses = new HashMap<URN, ContentResponseData>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistCache() {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.CACHE_FILE)));
            objectOutputStream.writeObject(this.responses);
            objectOutputStream.flush();
            IOUtils.close(objectOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        finally {
            IOUtils.close(objectOutputStream);
        }
    }
}

