/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.DownloadServices;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.i18n.I18nMarker;
import org.limewire.io.ByteReader;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;
import org.limewire.service.ErrorService;
import org.limewire.service.MessageService;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ExternalControl {
    private static final Log LOG = LogFactory.getLog(ExternalControl.class);
    private final String LOCALHOST = "127.0.0.1";
    private boolean initialized = false;
    private volatile String enqueuedRequest = null;
    private final DownloadServices downloadServices;
    private final Provider<ActivityCallback> activityCallback;
    private final SocketsManager socketsManager;

    @Inject
    public ExternalControl(DownloadServices downloadServices, Provider<ActivityCallback> provider, SocketsManager socketsManager) {
        this.downloadServices = downloadServices;
        this.activityCallback = provider;
        this.socketsManager = socketsManager;
    }

    public String preprocessArgs(String[] stringArray) {
        LOG.trace("enter proprocessArgs");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public void checkForActiveLimeWire() {
        if (this.testForLimeWire(null)) {
            System.exit(0);
        }
    }

    public void checkForActiveLimeWire(String string) {
        if ((OSUtils.isWindows() || OSUtils.isLinux()) && this.testForLimeWire(string)) {
            System.exit(0);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void enqueueControlRequest(String string) {
        LOG.trace("enter enqueueControlRequest");
        this.enqueuedRequest = string;
    }

    public void runQueuedControlRequest() {
        System.out.println("ExternalControl.runQueuedControlRequest() - " + this.enqueuedRequest);
        this.initialized = true;
        if (this.enqueuedRequest != null) {
            String string = this.enqueuedRequest;
            this.enqueuedRequest = null;
            if (this.isTorrentMagnetRequest(string)) {
                System.out.println("ExternalControl.runQueuedControlRequest() handleTorrentMagnetRequest() - " + string);
                this.handleTorrentMagnetRequest(string);
            } else if (this.isTorrentRequest(string)) {
                System.out.println("ExternalControl.runQueuedControlRequest() handleTorrentRequest() - " + string);
                this.handleTorrentRequest(string);
            } else {
                System.out.println("ExternalControl.runQueuedControlRequest() handleMagnetRequest() - " + string);
                this.handleMagnetRequest(string);
            }
        }
    }

    private boolean isTorrentMagnetRequest(String string) {
        return string.startsWith("magnet:?xt=urn:btih");
    }

    private void handleTorrentMagnetRequest(String string) {
        LOG.trace("enter handleTorrentMagnetRequest");
        ActivityCallback activityCallback = this.restoreApplication();
        activityCallback.handleTorrentMagnet(string);
    }

    private boolean isTorrentRequest(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.trim().toLowerCase()).endsWith(".torrent") && !string.startsWith("magnet:");
    }

    public void handleMagnetRequest(String string) {
        LOG.trace("enter handleMagnetRequest");
        if (this.isTorrentMagnetRequest(string)) {
            System.out.println("ExternalControl.handleMagnetRequest(" + string + ") -> handleTorrentMagnetRequest()");
            this.handleTorrentMagnetRequest(string);
            return;
        }
        ActivityCallback activityCallback = this.restoreApplication();
        MagnetOptions[] magnetOptionsArray = MagnetOptions.parseMagnet(string);
        if (magnetOptionsArray.length == 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Invalid magnet, ignoring: " + string);
            }
            return;
        }
        if (!activityCallback.handleMagnets(magnetOptionsArray)) {
            this.downloadMagnet(magnetOptionsArray);
        }
    }

    private ActivityCallback restoreApplication() {
        this.activityCallback.get().restoreApplication();
        this.activityCallback.get().showDownloads();
        return this.activityCallback.get();
    }

    private void handleTorrentRequest(String string) {
        LOG.trace("enter handleTorrentRequest");
        ActivityCallback activityCallback = this.restoreApplication();
        File file = new File(string.trim());
        activityCallback.handleTorrent(file);
    }

    public void downloadMagnet(MagnetOptions[] magnetOptionsArray) {
        int n;
        if (LOG.isDebugEnabled()) {
            for (n = 0; n < magnetOptionsArray.length; ++n) {
                LOG.debug("Kicking off downloader for option " + n + " " + magnetOptionsArray[n]);
            }
        }
        for (n = 0; n < magnetOptionsArray.length; ++n) {
            Object object;
            MagnetOptions magnetOptions = magnetOptionsArray[n];
            if (LOG.isDebugEnabled()) {
                object = magnetOptions.getSHA1Urn();
                LOG.debug("Processing magnet with params:\nurn [" + object + "]\n" + "options [" + magnetOptions + "]");
            }
            object = magnetOptions.getErrorMessage();
            if (!magnetOptions.isDownloadable()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Invalid magnet: " + magnetOptions);
                }
                object = object != null ? object : magnetOptions.toString();
                MessageService.showFormattedError(I18nMarker.marktr("Could not process bad MAGNET link {0}"), object);
                return;
            }
            if (object != null) {
                MessageService.showError(I18nMarker.marktr("One or more URLs in the MAGNET link were invalid. Your file may not download correctly."));
            }
            try {
                this.downloadServices.download(magnetOptions, false);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorService.error(illegalArgumentException);
                continue;
            }
            catch (SaveLocationException saveLocationException) {
                if (saveLocationException.getErrorCode() == 5) {
                    MessageService.showFormattedError(I18nMarker.marktr("You have already downloaded {0}"), saveLocationException.getFile().getName());
                    continue;
                }
                if (saveLocationException.getErrorCode() != 10) continue;
                MessageService.showFormattedError(I18nMarker.marktr("You are already downloading this file to {0}"), saveLocationException.getFile().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireControlThread(Socket socket, boolean bl) {
        LOG.trace("enter fireControl");
        Thread.currentThread().setName("IncomingControlThread");
        try {
            if (!NetworkUtils.isLocalHost(socket)) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Invalid control request from: " + socket.getInetAddress().getHostAddress());
                }
                return;
            }
            socket.setSoTimeout(8000);
            ByteReader byteReader = new ByteReader(socket.getInputStream());
            String string = byteReader.readLine();
            socket.setSoTimeout(0);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            String string2 = CommonUtils.getUserName() + "\r\n";
            byte[] byArray = string2.getBytes();
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            if (this.isTorrentMagnetRequest(string)) {
                this.handleTorrentMagnetRequest(string);
            } else if (bl) {
                this.handleMagnetRequest(string);
            } else {
                this.handleTorrentRequest(string);
            }
        }
        catch (IOException iOException) {
            LOG.warn("Exception while responding to control request", iOException);
        }
        finally {
            IOUtils.close(socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testForLimeWire(String string) {
        String string2;
        Socket socket = null;
        int n = ConnectionSettings.PORT.getValue();
        String string3 = string2 = this.isTorrentRequest(string) ? "TORRENT" : "MAGNET";
        if (!NetworkUtils.isValidPort(n)) {
            ConnectionSettings.PORT.revertToDefault();
            n = ConnectionSettings.PORT.getValue();
        }
        try {
            socket = this.socketsManager.connect(new InetSocketAddress("127.0.0.1", n), 1000);
            InputStream inputStream = socket.getInputStream();
            socket.setSoTimeout(1000);
            ByteReader byteReader = new ByteReader(inputStream);
            OutputStream outputStream = socket.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(string2 + " " + string + " ");
            bufferedWriter.write("\r\n");
            bufferedWriter.flush();
            String string4 = byteReader.readLine();
            boolean bl = string4 != null && string4.startsWith(CommonUtils.getUserName());
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

