/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.google.inject.Inject;
import com.limegroup.gnutella.bugs.LocalClientInfo;
import com.limegroup.gnutella.bugs.ServletAccessor;
import com.limegroup.gnutella.bugs.SessionInfo;
import com.limegroup.gnutella.gui.LocalClientInfoFactory;
import com.limegroup.gnutella.gui.LocalClientInfoFactoryImpl;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.SplashWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.limewire.inject.Providers;

public final class FatalBugManager {
    @Inject
    private static volatile LocalClientInfoFactory localClientInfoFactory;

    private FatalBugManager() {
    }

    public static void handleFatalBug(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        throwable.printStackTrace();
        LocalClientInfoFactory localClientInfoFactory = FatalBugManager.localClientInfoFactory;
        if (localClientInfoFactory == null) {
            localClientInfoFactory = new LocalClientInfoFactoryImpl(Providers.of(new FatalSessionInfo()));
        }
        LocalClientInfo localClientInfo = localClientInfoFactory.createLocalClientInfo(throwable, Thread.currentThread().getName(), null, true);
        FatalBugManager.reviewBug(localClientInfo);
    }

    private static String warning() {
        return "You are using FrostWire. www.frostwire.com";
    }

    public static void reviewBug(final LocalClientInfo localClientInfo) {
        final JDialog jDialog = new JDialog();
        jDialog.setTitle("Fatal Error");
        Dimension dimension = new Dimension(100, 300);
        jDialog.setSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        MultiLineLabel multiLineLabel = new MultiLineLabel(FatalBugManager.warning() + "\n\n" + "FrostWire has encountered a fatal internal error and will now exit. " + "This is generally caused by a corrupted installation.  Please try " + "downloading and installing FrostWire again.\n\n" + "To aid with debugging, please click 'Send' to notify FrostWire about the problem. " + "If desired, you can click 'Review' to look at the information that will be sent. " + "If the problem persists, please visit www.frostwire.com and click the 'Support' " + "link.\n\n" + "Thank You.", 400);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(multiLineLabel);
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton("Send");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FatalBugManager.sendToServlet(localClientInfo);
                jDialog.dispose();
                System.exit(1);
            }
        });
        JButton jButton2 = new JButton("Review");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextArea jTextArea = new JTextArea(localClientInfo.toBugReport());
                jTextArea.setColumns(50);
                jTextArea.setEditable(false);
                jTextArea.selectAll();
                jTextArea.copy();
                jTextArea.setCaretPosition(0);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                jScrollPane.setBorder(BorderFactory.createEtchedBorder());
                jScrollPane.setPreferredSize(new Dimension(500, 200));
                FatalBugManager.showMessage(jDialog, jScrollPane);
            }
        });
        JButton jButton3 = new JButton("Discard");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
                System.exit(1);
            }
        });
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension3 = jDialog.getSize();
        jDialog.setLocation((dimension2.width - dimension3.width) / 2, (dimension2.height - dimension3.height) / 2);
        jDialog.setVisible(true);
        try {
            SplashWindow.instance().setVisible(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        jDialog.toFront();
    }

    private static void sendToServlet(LocalClientInfo localClientInfo) {
        new ServletAccessor().getRemoteBugInfo(localClientInfo);
    }

    private static void showMessage(Component component, Component component2) {
        JOptionPane.showMessageDialog(component, component2, "Fatal Error - Review", 1);
    }

    private static class FatalSessionInfo
    implements SessionInfo {
        private FatalSessionInfo() {
        }

        public boolean acceptedIncomingConnection() {
            return false;
        }

        public boolean canReceiveSolicited() {
            return false;
        }

        public long getByteBufferCacheSize() {
            return 0L;
        }

        public long getContentResponsesSize() {
            return 0L;
        }

        public long getCreationCacheSize() {
            return 0L;
        }

        public long getCurrentUptime() {
            return 0L;
        }

        public long getDiskControllerByteCacheSize() {
            return 0L;
        }

        public int getDiskControllerQueueSize() {
            return 0;
        }

        public long getDiskControllerVerifyingCacheSize() {
            return 0L;
        }

        public int getNumIndividualDownloaders() {
            return 0;
        }

        public int getNumLeafToUltrapeerConnections() {
            return 0;
        }

        public int getNumOldConnections() {
            return 0;
        }

        public int getNumUltrapeerToLeafConnections() {
            return 0;
        }

        public int getNumUltrapeerToUltrapeerConnections() {
            return 0;
        }

        public int getNumWaitingDownloads() {
            return 0;
        }

        public int getNumberOfPendingTimeouts() {
            return 0;
        }

        public int getNumberOfWaitingSockets() {
            return 0;
        }

        public int getPort() {
            return 0;
        }

        public boolean isGUESSCapable() {
            return false;
        }
    }
}

