/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.connection.Connection;
import com.limegroup.gnutella.connection.ConnectionBandwidthStatistics;
import com.limegroup.gnutella.connection.ConnectionBandwidthStatisticsImpl;
import com.limegroup.gnutella.connection.ConnectionCapabilities;
import com.limegroup.gnutella.connection.ConnectionCapabilitiesImpl;
import com.limegroup.gnutella.connection.SimpleProtocolBandwidthTracker;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.Handshaker;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.messages.vendor.HeaderUpdateVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;
import org.limewire.nio.ssl.SSLUtils;
import org.limewire.setting.StringSetting;

public abstract class AbstractConnection
implements Connection {
    private final Object pingLock = new Object();
    private final Object pongLock = new Object();
    private final SocketsManager.ConnectType connectType;
    private final String host;
    private final byte[] hostBytes;
    private volatile int port;
    protected volatile Socket socket;
    private final boolean outgoing;
    private volatile byte softMax;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile long nextPingTime = Long.MIN_VALUE;
    private volatile long nextPongTime = Long.MIN_VALUE;
    private final CapabilitiesVMFactory capabilitiesVMFactory;
    private final MessagesSupportedVendorMessage supportedVendorMessage;
    private final ConnectionCapabilities connectionCapabilities;
    private final ConnectionBandwidthStatistics connectionBandwidthStatistics;
    private volatile long connectionTime;
    private final NetworkManager networkManager;
    private final Acceptor acceptor;
    private final SimpleProtocolBandwidthTracker simpleProtocolBandwidthTracker;
    protected volatile byte[] myIp;
    protected static final IOException CONNECTION_CLOSED = new IOException("connection closed");
    private final NetworkInstanceUtils networkInstanceUtils;

    AbstractConnection(String string, int n, SocketsManager.ConnectType connectType, CapabilitiesVMFactory capabilitiesVMFactory, MessagesSupportedVendorMessage messagesSupportedVendorMessage, NetworkManager networkManager, Acceptor acceptor, NetworkInstanceUtils networkInstanceUtils) {
        this(string, n, connectType, null, capabilitiesVMFactory, messagesSupportedVendorMessage, networkManager, acceptor, networkInstanceUtils);
    }

    AbstractConnection(Socket socket, CapabilitiesVMFactory capabilitiesVMFactory, MessagesSupportedVendorMessage messagesSupportedVendorMessage, NetworkManager networkManager, Acceptor acceptor, NetworkInstanceUtils networkInstanceUtils) {
        this(socket.getInetAddress().getHostAddress(), socket.getPort(), SSLUtils.isTLSEnabled(socket) ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN, socket, capabilitiesVMFactory, messagesSupportedVendorMessage, networkManager, acceptor, networkInstanceUtils);
    }

    private AbstractConnection(String string, int n, SocketsManager.ConnectType connectType, Socket socket, CapabilitiesVMFactory capabilitiesVMFactory, MessagesSupportedVendorMessage messagesSupportedVendorMessage, NetworkManager networkManager, Acceptor acceptor, NetworkInstanceUtils networkInstanceUtils) {
        if (string == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("illegal port: " + n);
        }
        this.host = string;
        this.port = n;
        this.outgoing = socket == null;
        this.connectType = connectType;
        this.socket = socket;
        this.capabilitiesVMFactory = capabilitiesVMFactory;
        this.supportedVendorMessage = messagesSupportedVendorMessage;
        this.connectionCapabilities = new ConnectionCapabilitiesImpl();
        this.connectionBandwidthStatistics = new ConnectionBandwidthStatisticsImpl();
        this.networkManager = networkManager;
        this.acceptor = acceptor;
        this.simpleProtocolBandwidthTracker = new SimpleProtocolBandwidthTracker();
        this.networkInstanceUtils = networkInstanceUtils;
        byte[] byArray = null;
        try {
            byArray = InetAddress.getByName(this.getAddress()).getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.hostBytes = byArray;
        if (!this.outgoing) {
            this.connectionBandwidthStatistics.setTlsOption(SSLUtils.isTLSEnabled(socket), SSLUtils.getSSLBandwidthTracker(socket));
        }
        this.connectionBandwidthStatistics.setRawBandwidthTracker(this.simpleProtocolBandwidthTracker);
    }

    public void sendPostInitializeMessages() {
        try {
            if (this.getConnectionCapabilities().getHeadersRead().supportsVendorMessages() > 0.0f) {
                this.send(this.supportedVendorMessage);
                this.send(this.capabilitiesVMFactory.getCapabilitiesVM());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendUpdatedCapabilities() {
        try {
            if (this.getConnectionCapabilities().getHeadersRead().supportsVendorMessages() > 0.0f) {
                this.send(this.capabilitiesVMFactory.getCapabilitiesVM());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleVendorMessage(VendorMessage vendorMessage) {
        if (vendorMessage instanceof MessagesSupportedVendorMessage) {
            this.getConnectionCapabilities().setMessagesSupportedVendorMessage((MessagesSupportedVendorMessage)vendorMessage);
        } else if (vendorMessage instanceof CapabilitiesVM) {
            this.getConnectionCapabilities().setCapabilitiesVendorMessage((CapabilitiesVM)vendorMessage);
        } else if (vendorMessage instanceof HeaderUpdateVendorMessage) {
            HeaderUpdateVendorMessage headerUpdateVendorMessage = (HeaderUpdateVendorMessage)vendorMessage;
            Properties properties = this.getConnectionCapabilities().getHeadersRead().props();
            properties.putAll((Map<?, ?>)headerUpdateVendorMessage.getProperties());
            this.setHeaders(HandshakeResponse.createResponse(properties), null);
        }
    }

    protected void setHeaders(HandshakeResponse handshakeResponse, HandshakeResponse handshakeResponse2) {
        if (handshakeResponse != null) {
            this.getConnectionCapabilities().setHeadersRead(handshakeResponse);
        }
        if (handshakeResponse2 != null) {
            this.getConnectionCapabilities().setHeadersWritten(handshakeResponse2);
        }
    }

    public boolean isOutgoing() {
        return this.outgoing;
    }

    public String getAddress() {
        return this.host;
    }

    public byte[] getAddressBytes() {
        return this.hostBytes;
    }

    public int getPort() {
        return this.port;
    }

    public int getListeningPort() {
        if (this.isOutgoing()) {
            if (this.socket == null) {
                return -1;
            }
            return this.socket.getPort();
        }
        return this.getConnectionCapabilities().getHeadersRead().getListeningPort();
    }

    public void setListeningPort(int n) {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        this.port = n;
    }

    public InetSocketAddress getInetSocketAddress() throws IllegalStateException {
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public InetAddress getInetAddress() throws IllegalStateException {
        if (this.socket == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.socket.getInetAddress();
    }

    public Socket getSocket() throws IllegalStateException {
        if (this.socket == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.socket;
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
        this.getConnectionBandwidthStatistics().setTlsOption(SSLUtils.isTLSEnabled(socket), SSLUtils.getSSLBandwidthTracker(socket));
    }

    public boolean isStable() {
        return this.isStable(System.currentTimeMillis());
    }

    public boolean isStable(long l) {
        return (l - this.getConnectionTime()) / 1000L > 5L;
    }

    public String getPropertyWritten(String string) {
        return this.getConnectionCapabilities().getHeadersWritten().props().getProperty(string);
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    public long getConnectionTime() {
        return this.connectionTime;
    }

    protected SocketsManager.ConnectType getConnectType() {
        return this.connectType;
    }

    public final void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        IOUtils.close(this.socket);
        this.closeImpl();
    }

    protected abstract void closeImpl();

    public boolean isWriteDeflated() {
        return this.getConnectionCapabilities().getHeadersWritten().isDeflateEnabled();
    }

    public boolean isReadDeflated() {
        return this.getConnectionCapabilities().getHeadersRead().isDeflateEnabled();
    }

    public boolean isTLSCapable() {
        if (!this.getConnectionCapabilities().isCapabilitiesVmSet() && this.isTLSEncoded()) {
            return true;
        }
        return this.getConnectionCapabilities().getCapability(ConnectionCapabilities.Capability.TLS) >= 1;
    }

    public boolean isTLSEncoded() {
        return this.connectType == SocketsManager.ConnectType.TLS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowNewPings() {
        Object object = this.pingLock;
        synchronized (object) {
            long l = System.currentTimeMillis();
            if (!this.isStable(l)) {
                return false;
            }
            if (l < this.nextPingTime) {
                return false;
            }
            this.nextPingTime = System.currentTimeMillis() + 2500L;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowNewPongs() {
        Object object = this.pongLock;
        synchronized (object) {
            long l = System.currentTimeMillis();
            if (!this.isStable(l)) {
                return false;
            }
            if (l < this.nextPongTime) {
                return false;
            }
            int n = l - this.getConnectionTime() < 10000L ? 300 : 12000;
            this.nextPongTime = l + (long)n;
            return true;
        }
    }

    protected void processReadMessage(Message message) {
        this.simpleProtocolBandwidthTracker.addRead(message.getTotalLength());
    }

    protected void processWrittenMessage(Message message) {
        this.simpleProtocolBandwidthTracker.addWritten(message.getTotalLength());
    }

    protected void initializeHandshake() throws IOException {
        if (!this.isOpen()) {
            IOUtils.close(this.getSocket());
            throw CONNECTION_CLOSED;
        }
        InetAddress inetAddress = this.getSocket().getLocalAddress();
        if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && this.getSocket().getInetAddress().equals(inetAddress) && this.getPort() == ConnectionSettings.PORT.getValue()) {
            throw new IOException("Connection to self");
        }
        this.acceptor.setAddress(inetAddress);
    }

    protected byte getSoftMax() {
        return this.softMax;
    }

    protected void handshakeInitialized(Handshaker handshaker) {
        this.setHeaders(handshaker.getReadHeaders(), handshaker.getWrittenHeaders());
        this.connectionTime = System.currentTimeMillis();
        this.softMax = ConnectionSettings.SOFT_MAX.getValue();
        if (this.getConnectionCapabilities().isGoodUltrapeer() || this.getConnectionCapabilities().isGoodLeaf()) {
            this.softMax = (byte)(this.softMax + 1);
        }
        this.updateAddress(handshaker.getReadHeaders());
    }

    private void updateAddress(HandshakeResponse handshakeResponse) {
        String string = handshakeResponse.getProperty("Remote-IP");
        if (string == null) {
            return;
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        if (!NetworkUtils.isValidAddress(inetAddress) || this.networkInstanceUtils.isPrivateAddress(inetAddress)) {
            return;
        }
        this.myIp = inetAddress.getAddress();
        if (ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            StringSetting stringSetting = ConnectionSettings.FORCED_IP_ADDRESS_STRING;
            if (!string.equals(stringSetting.getValue())) {
                stringSetting.setValue(string);
                this.networkManager.addressChanged();
            }
        } else if (!NetworkUtils.isValidAddress(this.networkManager.getAddress())) {
            this.acceptor.setAddress(inetAddress);
        }
        this.acceptor.setExternalAddress(inetAddress);
    }

    public void handleSimppVM(SimppVM simppVM) throws IOException {
        this.send(simppVM);
    }

    public String toString() {
        return "CONNECTION: host=" + this.host + " port=" + this.port;
    }

    public String getLocalePref() {
        return this.getConnectionCapabilities().getHeadersRead().getLocalePref();
    }

    public ConnectionCapabilities getConnectionCapabilities() {
        return this.connectionCapabilities;
    }

    public ConnectionBandwidthStatistics getConnectionBandwidthStatistics() {
        return this.connectionBandwidthStatistics;
    }
}

