/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.dht.DHTBootstrapper;
import com.limegroup.gnutella.dht.DHTNodeFetcher;
import com.limegroup.gnutella.dht.DHTNodeFetcherFactory;
import com.limegroup.gnutella.messages.PingRequestFactory;
import java.util.concurrent.ScheduledExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DHTNodeFetcherFactoryImpl
implements DHTNodeFetcherFactory {
    private final ConnectionServices connectionServices;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<HostCatcher> hostCatcher;
    private final Provider<UDPPinger> udpPingerFactory;
    private final PingRequestFactory pingRequestFactory;

    @Inject
    public DHTNodeFetcherFactoryImpl(ConnectionServices connectionServices, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<HostCatcher> provider, Provider<UDPPinger> provider2, PingRequestFactory pingRequestFactory) {
        this.connectionServices = connectionServices;
        this.backgroundExecutor = scheduledExecutorService;
        this.hostCatcher = provider;
        this.udpPingerFactory = provider2;
        this.pingRequestFactory = pingRequestFactory;
    }

    @Override
    public DHTNodeFetcher createNodeFetcher(DHTBootstrapper dHTBootstrapper) {
        return new DHTNodeFetcher(dHTBootstrapper, this.connectionServices, this.hostCatcher, this.backgroundExecutor, this.udpPingerFactory, this.pingRequestFactory);
    }
}

