/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.AbstractDHTController;
import com.limegroup.gnutella.dht.DHTControllerFacade;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.PassiveDHTNodeRouteTable;
import com.limegroup.gnutella.settings.DHTSettings;
import com.limegroup.gnutella.util.EventDispatcher;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.io.SecureInputStream;
import org.limewire.io.SecureOutputStream;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.MojitoFactory;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PassiveDHTNodeController
extends AbstractDHTController {
    private static final File FILE = new File(CommonUtils.getUserSettingsDir(), "passive.mojito");
    private PassiveDHTNodeRouteTable routeTable;

    PassiveDHTNodeController(Vendor vendor, Version version, EventDispatcher<DHTEvent, DHTEventListener> eventDispatcher, DHTControllerFacade dHTControllerFacade) {
        super(vendor, version, eventDispatcher, DHTManager.DHTMode.PASSIVE, dHTControllerFacade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MojitoDHT createMojitoDHT(Vendor vendor, Version version) {
        MojitoDHT mojitoDHT = MojitoFactory.createFirewalledDHT("PassiveUltrapeerDHT", vendor, version);
        this.routeTable = new PassiveDHTNodeRouteTable(mojitoDHT);
        mojitoDHT.setRouteTable(this.routeTable);
        if (DHTSettings.PERSIST_PASSIVE_DHT_ROUTETABLE.getValue() && FILE.exists() && FILE.isFile()) {
            ObjectInputStream objectInputStream;
            block7: {
                objectInputStream = null;
                try {
                    objectInputStream = new ObjectInputStream(new BufferedInputStream(new SecureInputStream(new FileInputStream(FILE))));
                    int n = objectInputStream.readInt();
                    if (n < this.getRouteTableVersion()) break block7;
                    Contact contact = null;
                    while ((contact = (Contact)objectInputStream.readObject()) != null) {
                        this.routeTable.add(contact);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.LOG.error("Throwable", throwable);
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        IOUtils.close(objectInputStream);
                    }
                }
            }
            IOUtils.close(objectInputStream);
        }
        return mojitoDHT;
    }

    protected void addLeafDHTNode(String string, int n) {
        if (!this.isRunning()) {
            return;
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        this.addActiveDHTNode(inetSocketAddress, false);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Adding host: " + inetSocketAddress + " to leaf dht nodes");
        }
        this.routeTable.addLeafDHTNode(string, n);
    }

    protected SocketAddress removeLeafDHTNode(String string, int n) {
        if (!this.isRunning()) {
            return null;
        }
        SocketAddress socketAddress = this.routeTable.removeLeafDHTNode(string, n);
        if (this.LOG.isDebugEnabled() && socketAddress != null) {
            this.LOG.debug("Removed host: " + socketAddress + " from leaf dht nodes");
        }
        return socketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void stop() {
        Collection<Contact> collection;
        if (!this.isRunning()) {
            return;
        }
        super.stop();
        if (DHTSettings.PERSIST_PASSIVE_DHT_ROUTETABLE.getValue() && (collection = this.routeTable.getActiveContacts()).size() >= 2) {
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new SecureOutputStream(new FileOutputStream(FILE))));
                objectOutputStream.writeInt(this.getRouteTableVersion());
                collection = ContactUtils.sort(collection, DHTSettings.MAX_PERSISTED_NODES.getValue());
                KUID kUID = this.getMojitoDHT().getLocalNodeID();
                for (Contact contact : collection) {
                    if (contact.getNodeID().equals(kUID)) continue;
                    objectOutputStream.writeObject(contact);
                }
                objectOutputStream.writeObject(null);
                objectOutputStream.flush();
            }
            catch (IOException iOException) {
                IOUtils.close(objectOutputStream);
                catch (Throwable throwable) {
                    IOUtils.close(objectOutputStream);
                    throw throwable;
                }
            }
            IOUtils.close(objectOutputStream);
        }
    }

    @Override
    public List<IpPort> getActiveDHTNodes(int n) {
        if (!this.isRunning() || !this.getMojitoDHT().isBootstrapped()) {
            return Collections.emptyList();
        }
        return this.getMRSNodes(n, true);
    }

    @Override
    public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent connectionLifecycleEvent) {
        RoutedConnection routedConnection = connectionLifecycleEvent.getConnection();
        if (routedConnection == null) {
            return;
        }
        String string = routedConnection.getAddress();
        int n = routedConnection.getPort();
        if (connectionLifecycleEvent.isConnectionClosedEvent()) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Got a connection closed event for connection: " + routedConnection);
            }
            this.removeLeafDHTNode(string, n);
        } else if (connectionLifecycleEvent.isConnectionCapabilitiesEvent()) {
            if (routedConnection.getConnectionCapabilities().remostHostIsActiveDHTNode() > -1) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Connection is active dht node: " + routedConnection);
                }
                this.addLeafDHTNode(string, n);
            } else if (routedConnection.getConnectionCapabilities().remostHostIsPassiveDHTNode() > -1) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Connection is passive dht node: " + routedConnection);
                }
                this.addPassiveDHTNode(new InetSocketAddress(string, n));
            } else {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Connection is node not connected to the DHT network: " + routedConnection);
                }
                this.removeLeafDHTNode(string, n);
            }
        }
    }
}

