/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.concurrent.DHTExecutorService;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.concurrent.DHTFutureListener;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.routing.Bucket;
import org.limewire.mojito.routing.ClassfulNetworkCounter;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PassiveDHTNodeRouteTable
implements RouteTable {
    private static final Log LOG = LogFactory.getLog(PassiveDHTNodeRouteTable.class);
    private final MojitoDHT dht;
    private final RouteTable delegate;
    private final Map<SocketAddress, KUID> leafDHTNodes = new HashMap<SocketAddress, KUID>();

    public PassiveDHTNodeRouteTable(MojitoDHT mojitoDHT) {
        assert (mojitoDHT.isFirewalled());
        this.dht = mojitoDHT;
        this.delegate = mojitoDHT.getRouteTable();
    }

    public void addLeafDHTNode(String string, int n) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pinging leaf: " + string + ": " + n);
        }
        final InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        DHTFuture<PingResult> dHTFuture = this.dht.ping(inetSocketAddress);
        DHTFutureAdapter<PingResult> dHTFutureAdapter = new DHTFutureAdapter<PingResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleFutureSuccess(PingResult pingResult) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ping succeeded to: " + pingResult);
                }
                Contact contact = pingResult.getContact();
                PassiveDHTNodeRouteTable passiveDHTNodeRouteTable = PassiveDHTNodeRouteTable.this;
                synchronized (passiveDHTNodeRouteTable) {
                    KUID kUID = PassiveDHTNodeRouteTable.this.leafDHTNodes.put(inetSocketAddress, contact.getNodeID());
                    if (kUID == null || !kUID.equals(contact.getNodeID())) {
                        contact.setTimeStamp(0x7FFFFFFFFFFFFFFEL);
                        PassiveDHTNodeRouteTable.this.add(contact);
                    }
                }
            }

            @Override
            public void handleExecutionException(ExecutionException executionException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ping failed to: " + inetSocketAddress, executionException);
                }
            }
        };
        dHTFuture.addDHTFutureListener((DHTFutureListener<PingResult>)dHTFutureAdapter);
    }

    public synchronized SocketAddress removeLeafDHTNode(String string, int n) {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        KUID kUID = this.leafDHTNodes.remove(inetSocketAddress);
        if (kUID != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removed leaf: " + string + ": " + n);
            }
            this.removeAndReplaceWithMRSCachedContact(kUID);
            return inetSocketAddress;
        }
        return null;
    }

    private synchronized void removeAndReplaceWithMRSCachedContact(KUID kUID) {
        Bucket bucket = this.getBucket(kUID);
        boolean bl = bucket.removeActiveContact(kUID);
        if (bl) {
            if (bucket.getCacheSize() > 0) {
                ClassfulNetworkCounter classfulNetworkCounter = bucket.getClassfulNetworkCounter();
                Contact contact = null;
                while ((contact = bucket.getMostRecentlySeenCachedContact()) != null) {
                    bl = bucket.removeCachedContact(contact.getNodeID());
                    assert (bl);
                    if (classfulNetworkCounter != null && !classfulNetworkCounter.isOkayToAdd(contact)) continue;
                    bucket.addActiveContact(contact);
                    break;
                }
            }
        } else {
            bucket.removeCachedContact(kUID);
        }
    }

    public synchronized boolean hasDHTLeaves() {
        return !this.leafDHTNodes.isEmpty();
    }

    public synchronized Set<SocketAddress> getDHTLeaves() {
        return Collections.unmodifiableSet(this.leafDHTNodes.keySet());
    }

    @Override
    public synchronized void add(Contact contact) {
        this.delegate.add(contact);
    }

    @Override
    public synchronized void addRouteTableListener(RouteTable.RouteTableListener routeTableListener) {
        this.delegate.addRouteTableListener(routeTableListener);
    }

    @Override
    public synchronized void removeRouteTableListener(RouteTable.RouteTableListener routeTableListener) {
        this.delegate.removeRouteTableListener(routeTableListener);
    }

    @Override
    public synchronized Contact get(KUID kUID) {
        return this.delegate.get(kUID);
    }

    @Override
    public synchronized Collection<Contact> getActiveContacts() {
        return this.delegate.getActiveContacts();
    }

    @Override
    public synchronized Bucket getBucket(KUID kUID) {
        return this.delegate.getBucket(kUID);
    }

    @Override
    public synchronized Collection<Bucket> getBuckets() {
        return this.delegate.getBuckets();
    }

    @Override
    public synchronized Collection<Contact> getCachedContacts() {
        return this.delegate.getCachedContacts();
    }

    @Override
    public synchronized Collection<Contact> getContacts() {
        return this.delegate.getContacts();
    }

    @Override
    public synchronized Contact getLocalNode() {
        return this.delegate.getLocalNode();
    }

    @Override
    public synchronized Collection<KUID> getRefreshIDs(boolean bl) {
        return this.delegate.getRefreshIDs(bl);
    }

    @Override
    public synchronized void handleFailure(KUID kUID, SocketAddress socketAddress) {
        this.delegate.handleFailure(kUID, socketAddress);
    }

    @Override
    public synchronized boolean isLocalNode(Contact contact) {
        return this.delegate.isLocalNode(contact);
    }

    @Override
    public synchronized void purge(long l) {
        this.delegate.purge(l);
    }

    @Override
    public synchronized void purge(RouteTable.PurgeMode purgeMode, RouteTable.PurgeMode ... purgeModeArray) {
        this.delegate.purge(purgeMode, purgeModeArray);
    }

    @Override
    public synchronized Contact select(KUID kUID) {
        return this.delegate.select(kUID);
    }

    @Override
    public synchronized Collection<Contact> select(KUID kUID, int n, RouteTable.SelectMode selectMode) {
        return this.delegate.select(kUID, n, selectMode);
    }

    @Override
    public synchronized void setContactPinger(RouteTable.ContactPinger contactPinger) {
        this.delegate.setContactPinger(contactPinger);
    }

    @Override
    public synchronized void setNotifier(DHTExecutorService dHTExecutorService) {
        this.delegate.setNotifier(dHTExecutorService);
    }

    @Override
    public synchronized int size() {
        return this.delegate.size();
    }

    @Override
    public synchronized void clear() {
        this.delegate.clear();
    }

    public synchronized String toString() {
        return "Passive RouteTable: " + this.delegate.toString();
    }
}

