/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.dht.db.PushProxiesValue;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Set;
import org.limewire.collection.BitNumbers;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.routing.Version;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPushProxiesValue
implements PushProxiesValue {
    public static final DHTValueType PUSH_PROXIES = DHTValueType.valueOf("Gnutella Push Proxy", "PROX");
    public static final Version VERSION = Version.valueOf(0);
    static final String CLIENT_ID = "client-id";
    static final String FWT_VERSION = "fwt-version";
    static final String FEATURES = "features";
    static final String PORT = "port";
    static final String PROXIES = "proxies";
    static final String TLS = "tls";
    private final Version version;

    public AbstractPushProxiesValue(Version version) {
        this.version = version;
    }

    @Override
    public DHTValueType getValueType() {
        return PUSH_PROXIES;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public int size() {
        return this.getValue().length;
    }

    @Override
    public abstract byte[] getGUID();

    @Override
    public abstract int getPort();

    @Override
    public abstract byte getFeatures();

    @Override
    public abstract int getFwtVersion();

    @Override
    public abstract Set<? extends IpPort> getPushProxies();

    @Override
    public abstract BitNumbers getTLSInfo();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GUID=").append(new GUID(this.getGUID())).append("\n");
        stringBuilder.append("Features=").append(this.getFeatures()).append("\n");
        stringBuilder.append("FWTVersion=").append(this.getFwtVersion()).append("\n");
        stringBuilder.append("PushProxies=").append(this.getPushProxies()).append("\n");
        return stringBuilder.toString();
    }

    protected static byte[] serialize(PushProxiesValue pushProxiesValue) {
        GGEP gGEP = new GGEP();
        gGEP.put(CLIENT_ID, pushProxiesValue.getGUID());
        gGEP.put(FEATURES, (int)pushProxiesValue.getFeatures());
        gGEP.put(FWT_VERSION, pushProxiesValue.getFwtVersion());
        byte[] byArray = new byte[2];
        ByteOrder.short2beb((short)pushProxiesValue.getPort(), byArray, 0);
        gGEP.put(PORT, byArray);
        try {
            Set<? extends IpPort> set = pushProxiesValue.getPushProxies();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (IpPort ipPort : set) {
                byte[] byArray2 = NetworkUtils.getBytes(ipPort);
                assert (byArray2.length == 6 || byArray2.length == 18);
                byteArrayOutputStream.write(byArray2.length);
                byteArrayOutputStream.write(byArray2);
            }
            byteArrayOutputStream.close();
            gGEP.put(PROXIES, byteArrayOutputStream.toByteArray());
            if (!pushProxiesValue.getTLSInfo().isEmpty()) {
                gGEP.put(TLS, pushProxiesValue.getTLSInfo().toByteArray());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return gGEP.toByteArray();
    }

    static BitNumbers getNumbersFromProxies(Set<? extends IpPort> set) {
        return BitNumbers.synchronizedBitNumbers(HTTPHeaderUtils.getTLSIndices(set));
    }
}

