/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.AbstractAltLocValue;
import com.limegroup.gnutella.dht.db.AbstractPushProxiesValue;
import com.limegroup.gnutella.dht.db.AltLocSearchListener;
import com.limegroup.gnutella.dht.db.AltLocValue;
import com.limegroup.gnutella.dht.db.PushProxiesValue;
import com.limegroup.gnutella.dht.util.KUIDUtils;
import com.limegroup.gnutella.settings.DHTSettings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.nio.observer.Shutdownable;

@Singleton
public class AltLocFinder {
    private static final Log LOG = LogFactory.getLog(AltLocFinder.class);
    private final DHTManager manager;
    private final AlternateLocationFactory alternateLocationFactory;
    private final PushEndpointFactory pushEndpointFactory;
    private final AltLocManager altLocManager;

    @Inject
    public AltLocFinder(DHTManager dHTManager, AlternateLocationFactory alternateLocationFactory, AltLocManager altLocManager, PushEndpointFactory pushEndpointFactory) {
        this.manager = dHTManager;
        this.alternateLocationFactory = alternateLocationFactory;
        this.altLocManager = altLocManager;
        this.pushEndpointFactory = pushEndpointFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shutdownable findAltLocs(URN uRN, AltLocSearchListener altLocSearchListener) {
        if (uRN == null) {
            return null;
        }
        DHTManager dHTManager = this.manager;
        synchronized (dHTManager) {
            MojitoDHT mojitoDHT = this.manager.getMojitoDHT();
            if (mojitoDHT == null || !mojitoDHT.isBootstrapped()) {
                return null;
            }
            KUID kUID = KUIDUtils.toKUID(uRN);
            EntityKey entityKey = EntityKey.createEntityKey(kUID, AbstractAltLocValue.ALT_LOC);
            final DHTFuture<FindValueResult> dHTFuture = mojitoDHT.get(entityKey);
            dHTFuture.addDHTFutureListener(new AltLocsHandler(mojitoDHT, uRN, kUID, altLocSearchListener));
            return new Shutdownable(){

                public void shutdown() {
                    dHTFuture.cancel(true);
                }
            };
        }
    }

    public boolean findPushAltLocs(GUID gUID, URN uRN) {
        return this.findPushAltLocs(gUID, uRN, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findPushAltLocs(GUID gUID, URN uRN, DHTValueEntity dHTValueEntity, AltLocSearchListener altLocSearchListener) {
        if (gUID == null || uRN == null) {
            return false;
        }
        DHTManager dHTManager = this.manager;
        synchronized (dHTManager) {
            MojitoDHT mojitoDHT = this.manager.getMojitoDHT();
            if (mojitoDHT == null || !mojitoDHT.isBootstrapped()) {
                return false;
            }
            KUID kUID = KUIDUtils.toKUID(gUID);
            EntityKey entityKey = EntityKey.createEntityKey(kUID, AbstractPushProxiesValue.PUSH_PROXIES);
            DHTFuture<FindValueResult> dHTFuture = mojitoDHT.get(entityKey);
            dHTFuture.addDHTFutureListener(new PushAltLocsHandler(mojitoDHT, gUID, uRN, kUID, dHTValueEntity, altLocSearchListener));
            return true;
        }
    }

    private class PushAltLocsHandler
    extends AbstractResultHandler {
        private final GUID guid;
        private final DHTValueEntity altLocEntity;

        private PushAltLocsHandler(MojitoDHT mojitoDHT, GUID gUID, URN uRN, KUID kUID, DHTValueEntity dHTValueEntity, AltLocSearchListener altLocSearchListener) {
            super(mojitoDHT, uRN, kUID, altLocSearchListener, AbstractPushProxiesValue.PUSH_PROXIES);
            this.guid = gUID;
            this.altLocEntity = dHTValueEntity;
        }

        protected boolean handleDHTValueEntity(DHTValueEntity dHTValueEntity) {
            DHTValue dHTValue = dHTValueEntity.getValue();
            if (!(dHTValue instanceof PushProxiesValue)) {
                return false;
            }
            Contact contact = dHTValueEntity.getCreator();
            InetAddress inetAddress = ((InetSocketAddress)contact.getContactAddress()).getAddress();
            PushProxiesValue pushProxiesValue = (PushProxiesValue)dHTValue;
            if (this.altLocEntity != null && !contact.equals(this.altLocEntity.getCreator())) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Creator of " + this.altLocEntity + " and found " + dHTValueEntity + " do not match!");
                }
                return false;
            }
            byte[] byArray = this.guid.bytes();
            if (!Arrays.equals(byArray, pushProxiesValue.getGUID())) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("The AltLoc and PushProxy GUIDs do not match!");
                }
                return false;
            }
            Set<? extends IpPort> set = pushProxiesValue.getPushProxies();
            byte by = pushProxiesValue.getFeatures();
            int n = pushProxiesValue.getFwtVersion();
            IpPortImpl ipPortImpl = new IpPortImpl(inetAddress, pushProxiesValue.getPort());
            PushEndpoint pushEndpoint = AltLocFinder.this.pushEndpointFactory.createPushEndpoint(byArray, set, by, n, ipPortImpl);
            try {
                AlternateLocation alternateLocation = AltLocFinder.this.alternateLocationFactory.createPushAltLoc(pushEndpoint, this.urn);
                AltLocFinder.this.altLocManager.add(alternateLocation, this);
                return true;
            }
            catch (IOException iOException) {
                LOG.error("IOException", iOException);
                return false;
            }
        }
    }

    private class AltLocsHandler
    extends AbstractResultHandler {
        private AltLocsHandler(MojitoDHT mojitoDHT, URN uRN, KUID kUID, AltLocSearchListener altLocSearchListener) {
            super(mojitoDHT, uRN, kUID, altLocSearchListener, AbstractAltLocValue.ALT_LOC);
        }

        protected boolean handleDHTValueEntity(DHTValueEntity dHTValueEntity) {
            DHTValue dHTValue = dHTValueEntity.getValue();
            if (!(dHTValue instanceof AltLocValue)) {
                return false;
            }
            AltLocValue altLocValue = (AltLocValue)dHTValue;
            if (altLocValue.isFirewalled()) {
                if (DHTSettings.ENABLE_PUSH_PROXY_QUERIES.getValue()) {
                    GUID gUID = new GUID(altLocValue.getGUID());
                    return AltLocFinder.this.findPushAltLocs(gUID, this.urn, dHTValueEntity, this.listener);
                }
            } else {
                Contact contact = dHTValueEntity.getCreator();
                InetAddress inetAddress = ((InetSocketAddress)contact.getContactAddress()).getAddress();
                IpPortImpl ipPortImpl = new IpPortImpl(inetAddress, altLocValue.getPort());
                ConnectableImpl connectableImpl = new ConnectableImpl(ipPortImpl, altLocValue.supportsTLS());
                long l = altLocValue.getFileSize();
                byte[] byArray = altLocValue.getRootHash();
                try {
                    AlternateLocation alternateLocation = AltLocFinder.this.alternateLocationFactory.createDirectDHTAltLoc(connectableImpl, this.urn, l, byArray);
                    AltLocFinder.this.altLocManager.add(alternateLocation, this);
                    return true;
                }
                catch (IOException iOException) {
                    LOG.error("IOException", iOException);
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractResultHandler
    extends DHTFutureAdapter<FindValueResult> {
        protected final MojitoDHT dht;
        protected final URN urn;
        protected final KUID key;
        protected final AltLocSearchListener listener;
        protected final DHTValueType valueType;

        private AbstractResultHandler(MojitoDHT mojitoDHT, URN uRN, KUID kUID, AltLocSearchListener altLocSearchListener, DHTValueType dHTValueType) {
            this.dht = mojitoDHT;
            this.urn = uRN;
            this.key = kUID;
            this.listener = altLocSearchListener;
            this.valueType = dHTValueType;
        }

        @Override
        public void handleFutureSuccess(FindValueResult findValueResult) {
            boolean bl = false;
            if (findValueResult.isSuccess()) {
                for (DHTValueEntity object : findValueResult.getEntities()) {
                    if (!this.handleDHTValueEntity(object)) continue;
                    bl = true;
                }
                for (EntityKey entityKey : findValueResult.getEntityKeys()) {
                    if (!entityKey.getDHTValueType().equals(this.valueType)) continue;
                    try {
                        DHTFuture<FindValueResult> interruptedException = this.dht.get(entityKey);
                        FindValueResult findValueResult2 = (FindValueResult)interruptedException.get();
                        if (!findValueResult2.isSuccess()) continue;
                        for (DHTValueEntity dHTValueEntity : findValueResult2.getEntities()) {
                            if (!this.handleDHTValueEntity(dHTValueEntity)) continue;
                            bl = true;
                        }
                    }
                    catch (ExecutionException executionException) {
                        LOG.error("ExecutionException", executionException);
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.error("InterruptedException", interruptedException);
                    }
                }
            }
            if (this.listener != null) {
                this.listener.handleAltLocSearchDone(bl);
            }
        }

        protected abstract boolean handleDHTValueEntity(DHTValueEntity var1);

        @Override
        public void handleCancellationException(CancellationException cancellationException) {
            LOG.error("CancellationException", cancellationException);
            if (this.listener != null) {
                this.listener.handleAltLocSearchDone(false);
            }
        }

        @Override
        public void handleExecutionException(ExecutionException executionException) {
            LOG.error("ExecutionException", executionException);
            if (this.listener != null) {
                this.listener.handleAltLocSearchDone(false);
            }
        }

        @Override
        public void handleInterruptedException(InterruptedException interruptedException) {
            LOG.error("InterruptedException", interruptedException);
            if (this.listener != null) {
                this.listener.handleAltLocSearchDone(false);
            }
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AbstractResultHandler)) {
                return false;
            }
            AbstractResultHandler abstractResultHandler = (AbstractResultHandler)object;
            return this.key.equals(abstractResultHandler.key) && this.valueType.equals(abstractResultHandler.valueType);
        }
    }
}

